/*
 * Decompiled with CFR 0.152.
 */
package Jim.Engine;

import Jim.Engine.JCore;
import Jim.Engine.JTool;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class JSprite {
    protected boolean Alive = false;
    protected int BeginAnmFrame;
    protected byte Dir;
    protected int EndAnmFrame;
    protected int Frame;
    private int FrameCount;
    private int FrameDelay;
    protected int Height;
    protected short LoopCount;
    protected int MaxFrame;
    public short MovePixel;
    public static final byte NORMAL = -1;
    protected byte OldDir;
    public int OldPosX = -1;
    public int OldPosY = -1;
    public byte OldState;
    protected int PosX;
    protected int PosY;
    private static int SpriteCount;
    protected byte State;
    public String StrWord = null;
    protected int Width;

    public JSprite() {
        ++SpriteCount;
    }

    public boolean anmFrame(int loopCount) {
        boolean finish = false;
        if (this.onTime()) {
            if (++this.Frame >= this.EndAnmFrame) {
                if (loopCount == -1) {
                    this.Frame = this.BeginAnmFrame;
                } else {
                    this.LoopCount = (short)(this.LoopCount + 1);
                    if (this.LoopCount >= loopCount) {
                        this.Frame = this.EndAnmFrame - 1;
                        finish = true;
                        this.LoopCount = 0;
                    } else {
                        this.Frame = this.BeginAnmFrame;
                    }
                }
            }
            this.setFrame(this.Frame);
        }
        return finish;
    }

    public void draw(Graphics g, Image img, int x, int y) {
        if (this.Alive) {
            JTool.drawClipImage(g, img, x, y, this.Frame, this.Width, this.Height);
        }
    }

    public void draw(Graphics g, Image img) {
        if (this.Alive) {
            JTool.drawClipImage(g, img, this.PosX, this.PosY, this.Frame, this.Width, this.Height);
        }
    }

    public void drawStrWord(Graphics g) {
        g.setColor(255, 255, 255);
        if (this.Alive && this.StrWord != null) {
            JTool.drawString(g, this.StrWord, this.PosX, this.PosY, (byte)0, null);
        }
    }

    public boolean getAlive() {
        return this.Alive;
    }

    public int getHeight() {
        return this.Height;
    }

    public int getPosX() {
        return this.PosX;
    }

    public int getPosY() {
        return this.PosY;
    }

    public byte getState() {
        return this.State;
    }

    public int getStrWidth() {
        if (this.StrWord != null) {
            return JCore.Font.stringWidth(this.StrWord);
        }
        return 0;
    }

    public int getWidth() {
        return this.Width;
    }

    public void move(byte dir) {
        this.setDir(dir);
        switch (this.Dir) {
            case 0: {
                this.PosY -= this.MovePixel;
                break;
            }
            case 1: {
                this.PosY += this.MovePixel;
                break;
            }
            case 2: {
                this.PosX -= this.MovePixel;
                break;
            }
            case 3: {
                this.PosX += this.MovePixel;
            }
        }
    }

    public boolean onTime() {
        if ((this.FrameCount += JCore.FpsTime) >= this.FrameDelay) {
            this.FrameCount = 0;
            return true;
        }
        return false;
    }

    public void set(int x, int y, int width, int height, int frame, int mframe) {
        this.Width = width;
        this.Height = height;
        this.FrameCount = 0;
        this.MaxFrame = mframe;
        if (this.MaxFrame == 0) {
            this.MaxFrame = 1;
        }
        this.Frame = frame;
        this.setFrameDelay(300);
        this.setFrameAnm(0, 2);
        this.setState((byte)-1);
        this.setDir((byte)-1);
        this.setAlive(true);
        this.setPos(x, y);
        this.LoopCount = 0;
    }

    public void setAlive(boolean alive) {
        this.Alive = alive;
    }

    public void setDir(byte dir) {
        this.OldDir = this.Dir;
        this.Dir = dir;
    }

    public void setFrame(int frame) {
        this.Frame = frame < this.MaxFrame ? frame : this.MaxFrame - 1;
    }

    public void setFrameAnm(int beginFrame, int endFrame) {
        this.BeginAnmFrame = beginFrame;
        this.EndAnmFrame = endFrame;
    }

    public void setFrameDelay(int delayTime) {
        this.FrameDelay = delayTime;
    }

    public void setMovePixel(short pixel) {
        this.MovePixel = pixel;
    }

    public void setPos(int x, int y) {
        this.OldPosX = this.PosX;
        this.OldPosY = this.PosY;
        this.PosX = x;
        this.PosY = y;
    }

    public void setState(byte state) {
        this.OldState = this.State;
        this.State = state;
    }

    public void setStrWord(String strWord) {
        this.StrWord = strWord;
    }
}

