/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Button;
import game.DisplayableCanvas;
import game.DrawString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class MainMenu {
    DrawString ds;
    DisplayableCanvas dc;
    int MENU_MODE;
    final byte SPLASH;
    final byte MAIN_MENU;
    final byte OPTIONS = (byte)2;
    final byte HELP = (byte)3;
    final byte ABOUT = (byte)4;
    final byte GAME_TYPE = (byte)5;
    final byte CHECK_SAMEPHONE = (byte)6;
    int WIDTH;
    int HEIGHT;
    Image imgLogo;
    Image imgSplash;
    Image imgMenuLogo;
    Image imgAboutLogo;
    Image imgSplashLogo;
    Font font = Font.getFont((int)0, (int)1, (int)16);
    boolean isContinue;
    boolean onoffs = true;
    boolean onoffv = true;
    Button butContinue;
    Button butNewGame;
    Button butOption;
    Button butHelp;
    Button butAbout;
    Button butExit;
    Button butSoundon;
    Button butSoundoff;
    Button butVibrateon;
    Button butVibrateoff;
    Button buttonHelpData;
    Button buttonHome;
    Image imgHelpText;
    Image imgUpArrow;
    Image imgDownArrow;
    int helpTextx = 110;
    int helpTexty = 70;
    int selectIndex = 1;
    byte optionIndex = 0;
    Button buttonSingleP;
    Button buttonMultiP;
    Button buttonNFC;
    Button buttonSamePhone;
    Image imgTopBorder;
    Image imgBottomBorder;
    Image imgHelpTitle;
    Image imgAboutTitle;
    Image imgOptiontitle;
    int dragy;
    RecordStore soundSettings;

    public MainMenu(DisplayableCanvas dc, DrawString ds) {
        this.SPLASH = 0;
        this.MAIN_MENU = 1;
        this.dc = dc;
        this.ds = ds;
        this.WIDTH = dc.WIDTH;
        this.HEIGHT = dc.HEIGHT;
    }

    public void resetSplash() {
        try {
            this.imgLogo = Image.createImage((String)"/res/menu/logo.png");
            this.imgSplash = Image.createImage((String)"/res/menu/splash.jpg");
            this.imgSplashLogo = Image.createImage((String)"/res/menu/splashlogo.png");
            this.imgTopBorder = Image.createImage((String)"/res/menu/bar_top.png");
            this.imgBottomBorder = Image.createImage((String)"/res/menu/bar_down.png");
        }
        catch (Exception io) {
            io.printStackTrace();
        }
        this.MENU_MODE = 0;
    }

    public void resetMainMenu() {
        if (this.butContinue == null) {
            this.butContinue = new Button(0, 0, "/res/menu/continue0.png", "/res/menu/continue1.png");
            this.butNewGame = new Button(0, 0, "/res/menu/play0.png", "/res/menu/play1.png");
            this.butOption = new Button(0, 0, "/res/menu/option0.png", "/res/menu/option1.png");
            this.butHelp = new Button(0, 0, "/res/menu/help0.png", "/res/menu/help1.png");
            this.butAbout = new Button(0, 0, "/res/menu/about0.png", "/res/menu/about1.png");
            this.butExit = new Button(0, 0, "/res/menu/exit0.png", "/res/menu/exit1.png");
            this.butSoundon = new Button(270, this.HEIGHT - 194 >> 1, "/res/menu/soundon0.png", "/res/menu/soundon1.png");
            this.butSoundoff = new Button(270, this.WIDTH - 211 >> 1, "/res/menu/soundoff0.png", "/res/menu/soundoff1.png");
            this.butVibrateon = new Button(this.butSoundon.x + 80, this.HEIGHT - 273 >> 1, "/res/menu/vibrateon0.png", "/res/menu/vibrateon1.png");
            this.butVibrateoff = new Button(this.butSoundon.x + 80, this.HEIGHT - 290 >> 1, "/res/menu/vibrateoff0.png", "/res/menu/vibrateoff1.png");
            this.buttonHome = new Button(280, 0, "/res/menu0.png", "/res/menu1.png");
            this.readSettings();
            this.butSoundon.setXY(110, this.HEIGHT - this.butSoundon.height >> 1);
            this.butSoundoff.setXY(110, this.HEIGHT - this.butSoundoff.height >> 1);
            this.butVibrateon.setXY(155, this.HEIGHT - this.butVibrateon.height >> 1);
            this.butVibrateoff.setXY(155, this.HEIGHT - this.butVibrateoff.height >> 1);
        }
        if (this.isContinue) {
            this.butContinue.setXY(155, this.HEIGHT - this.butContinue.height >> 1);
            this.butNewGame.setXY(this.butContinue.x + 26, this.HEIGHT - this.butNewGame.height >> 1);
            this.butOption.setXY(this.butNewGame.x + 26, this.HEIGHT - this.butOption.height >> 1);
            this.butHelp.setXY(this.butOption.x + 26, this.HEIGHT - this.butHelp.height >> 1);
            this.butAbout.setXY(this.butHelp.x + 26, this.HEIGHT - this.butAbout.height >> 1);
            this.butExit.setXY(this.butAbout.x + 26, this.HEIGHT - this.butExit.height >> 1);
        } else {
            this.butNewGame.setXY(155, this.HEIGHT - this.butNewGame.height >> 1);
            this.butOption.setXY(this.butNewGame.x + 30, this.HEIGHT - this.butOption.height >> 1);
            this.butHelp.setXY(this.butOption.x + 30, this.HEIGHT - this.butHelp.height >> 1);
            this.butAbout.setXY(this.butHelp.x + 30, this.HEIGHT - this.butAbout.height >> 1);
            this.butExit.setXY(this.butAbout.x + 30, this.HEIGHT - this.butExit.height >> 1);
        }
        this.MENU_MODE = 1;
    }

    public void resetOptions() {
        if (this.imgOptiontitle == null) {
            try {
                this.imgOptiontitle = Image.createImage((String)"/res/menu/optionTitle.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void resetHelp() {
        block5: {
            if (this.buttonHelpData == null) {
                try {
                    if (this.buttonHelpData != null) break block5;
                    try {
                        this.imgHelpText = this.dc.hasPointerEvents() ? Image.createImage((String)"/res/menu/helpText.png") : Image.createImage((String)"/res/menu/helpText1.png");
                        this.imgUpArrow = Image.createImage((String)"/res/menu/upArrow.png");
                        this.imgDownArrow = Image.createImage((String)"/res/menu/downArrow.png");
                        this.imgHelpTitle = Image.createImage((String)"/res/menu/HelpTitle.png");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.buttonHelpData = new Button(this.HEIGHT - this.imgHelpText.getHeight() >> 1, 10, this.imgHelpText.getHeight(), 414, -1, -1);
                    this.buttonHelpData.setMovable(true);
                    this.buttonHelpData.nameX = this.buttonHelpData.x;
                    this.buttonHelpData.nameY = this.buttonHelpData.y;
                    this.buttonHelpData.name = null;
                    this.buttonHelpData.imgButton = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.buttonHelpData.nameY = this.buttonHelpData.y;
    }

    public void resetAbout() {
        if (this.imgAboutLogo == null) {
            try {
                this.imgAboutLogo = Image.createImage((String)"/res/menu/aboutLogo.png");
                this.imgAboutTitle = Image.createImage((String)"/res/menu/AboutTitle.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void resetMode(int gameMode) {
        switch (gameMode) {
            case 0: {
                this.resetSplash();
                break;
            }
            case 1: {
                if (this.imgMenuLogo == null) {
                    try {
                        this.imgMenuLogo = Image.createImage((String)"/res/menu/menuLogo.png");
                        this.imgTopBorder = Image.createImage((String)"/res/menu/bar_top.png");
                        this.imgBottomBorder = Image.createImage((String)"/res/menu/bar_down.png");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.resetMainMenu();
                break;
            }
            case 2: {
                this.resetOptions();
                break;
            }
            case 3: {
                this.resetHelp();
                break;
            }
            case 4: {
                this.resetAbout();
                break;
            }
            case 5: {
                if (this.buttonSingleP != null) break;
                this.buttonSingleP = new Button(this.WIDTH - 282 >> 1, 265, "/res/menu/singleplayer0.png", "/res/menu/singleplayer1.png");
                this.buttonMultiP = new Button(this.WIDTH - 242 >> 1, 339, "/res/menu/multiplayer0.png", "/res/menu/multiplayer1.png");
                break;
            }
            case 6: {
                if (this.buttonNFC != null) break;
                this.buttonNFC = new Button(this.WIDTH - 253 >> 1, this.buttonSingleP.y - 30, "/res/menu/nfc0.png", "/res/menu/nfc1.png");
                this.buttonSamePhone = new Button(this.WIDTH - 243 >> 1, this.buttonMultiP.y + 15, "/res/menu/samephone0.png", "/res/menu/samephone1.png");
            }
        }
        this.MENU_MODE = gameMode;
        this.dc.resetAdSetXY();
    }

    protected void pointerPressed(int x, int y) {
        boolean result = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isContinue && (result = this.butContinue.isPressed(x, y))) {
                    this.selectIndex = 0;
                }
                if (result) break;
                result = this.butNewGame.isPressed(x, y);
                if (!result) {
                    result = this.butOption.isPressed(x, y);
                    if (!result) {
                        result = this.butHelp.isPressed(x, y);
                        if (!result) {
                            result = this.butAbout.isPressed(x, y);
                            if (!result) {
                                result = this.butExit.isPressed(x, y);
                                if (!result) break;
                                this.selectIndex = 5;
                                break;
                            }
                            this.selectIndex = 4;
                            break;
                        }
                        this.selectIndex = 3;
                        break;
                    }
                    this.selectIndex = 2;
                    break;
                }
                this.selectIndex = 1;
                break;
            }
            case 2: {
                if (this.onoffs) {
                    result = this.butSoundon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                } else {
                    result = this.butSoundoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 0;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                } else {
                    result = this.butVibrateoff.isPressed(x, y);
                    if (result) {
                        this.optionIndex = 1;
                    }
                }
                if (result) break;
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 3: {
                this.dragy = x;
                result = this.buttonHome.isPressed(x, y);
                if (result || y <= this.HEIGHT - 30 || y <= this.buttonHelpData.y || y >= this.buttonHelpData.y + this.buttonHelpData.height) break;
                this.buttonHelpData.touchY = y;
                break;
            }
            case 4: {
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 5: {
                result = this.buttonSingleP.isPressed(x, y);
                if (result || (result = this.buttonMultiP.isPressed(x, y))) break;
                result = this.buttonHome.isPressed(x, y);
                break;
            }
            case 6: {
                result = this.buttonNFC.isPressed(x, y);
                if (result || (result = this.buttonSamePhone.isPressed(x, y))) break;
                result = this.buttonHome.isPressed(x, y);
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        boolean result = false;
        switch (this.MENU_MODE) {
            case 0: {
                break;
            }
            case 1: {
                result = this.butExit.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                if (this.isContinue && (result = this.butContinue.isReleased(x, y))) {
                    this.selection();
                }
                if (result) break;
                result = this.butNewGame.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butOption.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butHelp.isReleased(x, y);
                if (result) {
                    this.selection();
                    break;
                }
                result = this.butAbout.isReleased(x, y);
                if (!result) break;
                this.selection();
                break;
            }
            case 2: {
                if (this.onoffs) {
                    result = this.butSoundon.isReleased(x, y);
                    if (result) {
                        this.onoffs = false;
                    }
                } else {
                    result = this.butSoundoff.isReleased(x, y);
                    if (result) {
                        this.onoffs = true;
                    }
                }
                if (this.onoffv) {
                    result = this.butVibrateon.isReleased(x, y);
                    if (result) {
                        this.onoffv = false;
                    }
                } else {
                    result = this.butVibrateoff.isReleased(x, y);
                    if (result) {
                        this.onoffv = true;
                    }
                }
                if (result || !(result = this.buttonHome.isReleased(x, y))) break;
                this.storeSettings();
                this.resetMainMenu();
                break;
            }
            case 3: {
                result = this.buttonHome.isReleased(x, y);
                if (result) {
                    this.helpTextx = 110;
                    this.helpTexty = 70;
                    this.MENU_MODE = 1;
                    break;
                }
                this.buttonHelpData.isReleased(x, y);
                break;
            }
            case 4: {
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.MENU_MODE = 1;
                break;
            }
            case 5: {
                result = this.buttonSingleP.isReleased(x, y);
                if (result) {
                    this.dc.isSinglePlayer = true;
                    this.dc.isSingleHandSet = false;
                    this.dc.initGame();
                    this.isContinue = true;
                    break;
                }
                result = this.buttonMultiP.isReleased(x, y);
                if (result) {
                    this.resetMode(6);
                    break;
                }
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.MENU_MODE = 1;
                break;
            }
            case 6: {
                result = this.buttonNFC.isReleased(x, y);
                if (result) {
                    this.dc.isSinglePlayer = false;
                    this.dc.isSingleHandSet = false;
                    this.isContinue = false;
                    break;
                }
                result = this.buttonSamePhone.isReleased(x, y);
                if (result) {
                    this.dc.isSinglePlayer = false;
                    this.dc.isSingleHandSet = true;
                    this.dc.initGame();
                    this.isContinue = true;
                    break;
                }
                result = this.buttonHome.isReleased(x, y);
                if (!result) break;
                this.MENU_MODE = 1;
            }
        }
    }

    private void selection() {
        switch (this.selectIndex) {
            case 0: {
                this.dc.getClass();
                this.dc.GAME_MODE = 5;
                break;
            }
            case 1: {
                this.dc.isSinglePlayer = true;
                this.dc.isSingleHandSet = false;
                this.dc.initGame();
                this.isContinue = true;
                break;
            }
            case 2: {
                this.resetMode(2);
                break;
            }
            case 3: {
                this.resetMode(3);
                break;
            }
            case 4: {
                this.resetMode(4);
                break;
            }
            case 5: {
                this.dc.midlet.exit();
                break;
            }
            case 6: {
                this.dc.onClickBannerAd();
            }
        }
    }

    public void input(int KEY) {
        if (KEY == this.dc.KEY_RIGHT_SOFT) {
            switch (this.MENU_MODE) {
                case 2: 
                case 4: {
                    this.resetMainMenu();
                    this.storeSettings();
                    break;
                }
                case 3: {
                    this.helpTextx = 110;
                    this.helpTexty = 70;
                    this.resetMainMenu();
                }
            }
        } else if (KEY == this.dc.KEY_LEFT_SOFT) {
            this.dc.KEY = 0;
        } else if (KEY != 49) {
            if (KEY == 50) {
                switch (this.MENU_MODE) {
                    case 1: {
                        if (this.isContinue) {
                            this.selectIndex = (this.selectIndex + ((this.dc.imgAd != null ? 7 : 6) - 1)) % (this.dc.imgAd != null ? 7 : 6);
                        } else {
                            --this.selectIndex;
                            if (this.selectIndex == 0) {
                                this.selectIndex = this.dc.imgAd != null ? 6 : 5;
                            } else if (this.selectIndex == 6) {
                                this.selectIndex = this.dc.imgAd != null ? 6 : 5;
                            }
                        }
                        this.dc.KEY = 0;
                        break;
                    }
                    case 2: {
                        if (this.optionIndex == 0) {
                            this.optionIndex = this.dc.imgAd != null ? (byte)2 : (byte)1;
                        } else if (this.optionIndex == 1) {
                            this.optionIndex = 0;
                        } else if (this.optionIndex == 2) {
                            this.optionIndex = 1;
                        }
                        this.dc.KEY = 0;
                        break;
                    }
                    case 3: {
                        if (this.helpTexty > 65) break;
                        this.helpTexty += 3;
                    }
                }
            } else if (KEY == 56) {
                switch (this.MENU_MODE) {
                    case 1: {
                        if (this.isContinue) {
                            this.selectIndex = (this.selectIndex + 1) % (this.dc.imgAd != null ? 7 : 6);
                        } else {
                            ++this.selectIndex;
                            if (this.selectIndex == (this.dc.imgAd != null ? 7 : 6)) {
                                this.selectIndex = 1;
                            }
                        }
                        this.dc.KEY = 0;
                        break;
                    }
                    case 2: {
                        this.optionIndex = this.optionIndex == 0 ? (byte)1 : (this.optionIndex == 1 ? (this.dc.imgAd != null ? (byte)2 : (byte)0) : (byte)0);
                        this.dc.KEY = 0;
                        break;
                    }
                    case 3: {
                        if (this.dc.hasPointerEvents()) {
                            if (this.helpTexty + this.imgHelpText.getHeight() < this.HEIGHT + 65 - 180) break;
                            this.helpTexty -= 3;
                            break;
                        }
                        if (this.helpTexty + this.imgHelpText.getHeight() < this.HEIGHT + 65 - 150) break;
                        this.helpTexty -= 3;
                    }
                }
            } else if (KEY == 53) {
                switch (this.MENU_MODE) {
                    case 1: {
                        this.selection();
                        break;
                    }
                    case 2: {
                        if (this.optionIndex == 0) {
                            this.onoffs = !this.onoffs;
                            break;
                        }
                        if (this.optionIndex != 1) break;
                        this.onoffv = !this.onoffv;
                    }
                }
                this.dc.KEY = 0;
            }
        }
    }

    public void storeSettings() {
        try {
            this.soundSettings = RecordStore.openRecordStore((String)"TennisSettings", (boolean)true);
            byte[] Byte = null;
            ByteArrayOutputStream bout = new ByteArrayOutputStream(60);
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeBoolean(this.onoffs);
            dout.writeBoolean(this.onoffv);
            dout.flush();
            dout.close();
            Byte = bout.toByteArray();
            dout.close();
            if (this.soundSettings.getNumRecords() > 0) {
                this.soundSettings.setRecord(1, Byte, 0, Byte.length);
            } else {
                this.soundSettings.addRecord(Byte, 0, Byte.length);
            }
            this.soundSettings.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSettings() {
        try {
            this.soundSettings = RecordStore.openRecordStore((String)"TennisSettings", (boolean)true);
            if (this.soundSettings.getNumRecords() > 0) {
                byte[] Byte = null;
                Byte = this.soundSettings.getRecord(1);
                DataInputStream din = new DataInputStream(new ByteArrayInputStream(Byte));
                this.onoffs = din.readBoolean();
                this.onoffv = din.readBoolean();
                din.close();
            } else {
                byte[] Byte = null;
                ByteArrayOutputStream bout = new ByteArrayOutputStream(60);
                DataOutputStream dout = new DataOutputStream(bout);
                this.onoffs = true;
                this.onoffv = true;
                dout.writeBoolean(this.onoffs);
                dout.writeBoolean(this.onoffv);
                dout.flush();
                dout.close();
                Byte = bout.toByteArray();
                dout.close();
                this.soundSettings.addRecord(Byte, 0, Byte.length);
            }
            this.soundSettings.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter <= 60) break;
                this.imgLogo = null;
                this.imgSplashLogo = null;
                this.resetMode(1);
                this.dc.refreshTheBannerAd();
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        switch (this.MENU_MODE) {
            case 0: {
                if (this.dc.counter < 40) {
                    g.setColor(0xFFFFFF);
                    g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                    g.drawImage(this.imgLogo, this.WIDTH >> 1, this.HEIGHT >> 1, 1 | 2);
                    break;
                }
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgTopBorder, 0, 1, 0x10 | 4);
                g.drawImage(this.imgBottomBorder, this.WIDTH - this.imgBottomBorder.getWidth(), this.HEIGHT - this.imgBottomBorder.getHeight(), 0x10 | 4);
                g.drawImage(this.imgSplashLogo, this.WIDTH - this.imgSplashLogo.getWidth() >> 1, this.HEIGHT - this.imgSplashLogo.getHeight() >> 1, 0x10 | 4);
                break;
            }
            case 1: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                if (this.isContinue) {
                    g.drawImage(this.imgMenuLogo, 100, this.HEIGHT - this.imgMenuLogo.getHeight() >> 1, 1 | 0x10);
                } else {
                    g.drawImage(this.imgMenuLogo, 100, this.HEIGHT - this.imgMenuLogo.getHeight() >> 1, 1 | 0x10);
                }
                if (this.isContinue) {
                    this.butContinue.paint(g);
                }
                this.butNewGame.paint(g);
                this.butOption.paint(g);
                this.butHelp.paint(g);
                this.butAbout.paint(g);
                this.butExit.paint(g);
                switch (this.selectIndex) {
                    case 0: {
                        if (!this.isContinue || this.butContinue.buttonState != 0) break;
                        this.butContinue.buttonState = 1;
                        this.butContinue.paint(g);
                        this.butContinue.buttonState = 0;
                        break;
                    }
                    case 1: {
                        if (this.butNewGame.buttonState != 0) break;
                        this.butNewGame.buttonState = 1;
                        this.butNewGame.paint(g);
                        this.butNewGame.buttonState = 0;
                        break;
                    }
                    case 2: {
                        if (this.butOption.buttonState != 0) break;
                        this.butOption.buttonState = 1;
                        this.butOption.paint(g);
                        this.butOption.buttonState = 0;
                        break;
                    }
                    case 3: {
                        if (this.butHelp.buttonState != 0) break;
                        this.butHelp.buttonState = 1;
                        this.butHelp.paint(g);
                        this.butHelp.buttonState = 0;
                        break;
                    }
                    case 4: {
                        if (this.butAbout.buttonState != 0) break;
                        this.butAbout.buttonState = 1;
                        this.butAbout.paint(g);
                        this.butAbout.buttonState = 0;
                        break;
                    }
                    case 5: {
                        if (this.butExit.buttonState != 0) break;
                        this.butExit.buttonState = 1;
                        this.butExit.paint(g);
                        this.butExit.buttonState = 0;
                    }
                }
                break;
            }
            case 2: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgOptiontitle, 55, 130, 0x10 | 4);
                if (this.onoffs) {
                    this.butSoundon.paint(g);
                } else {
                    this.butSoundoff.paint(g);
                }
                if (this.onoffv) {
                    this.butVibrateon.paint(g);
                } else {
                    this.butVibrateoff.paint(g);
                }
                if (this.optionIndex == 0) {
                    if (this.onoffs) {
                        if (this.butSoundon.buttonState == 0) {
                            this.butSoundon.buttonState = 1;
                            this.butSoundon.paint(g);
                            this.butSoundon.buttonState = 0;
                        }
                    } else if (this.butSoundoff.buttonState == 0) {
                        this.butSoundoff.buttonState = 1;
                        this.butSoundoff.paint(g);
                        this.butSoundoff.buttonState = 0;
                    }
                } else if (this.optionIndex == 1) {
                    if (this.onoffv) {
                        if (this.butVibrateon.buttonState == 0) {
                            this.butVibrateon.buttonState = 1;
                            this.butVibrateon.paint(g);
                            this.butVibrateon.buttonState = 0;
                        }
                    } else if (this.butVibrateoff.buttonState == 0) {
                        this.butVibrateoff.buttonState = 1;
                        this.butVibrateoff.paint(g);
                        this.butVibrateoff.buttonState = 0;
                    }
                }
                this.buttonHome.setXY(280, 0);
                this.buttonHome.paint(g);
                break;
            }
            case 3: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgHelpTitle, 15, 160, 0x10 | 4);
                if (this.helpTexty <= 65) {
                    g.drawImage(this.imgUpArrow, this.WIDTH - 30, this.HEIGHT - 48 - 80, 1 | 2);
                }
                if (this.dc.hasPointerEvents()) {
                    if (this.helpTexty + this.imgHelpText.getWidth() >= this.WIDTH + 70 - 85) {
                        g.drawImage(this.imgDownArrow, this.WIDTH - 30, this.HEIGHT - 31 - 80, 1 | 2);
                    }
                } else if (this.helpTexty + this.imgHelpText.getWidth() >= this.WIDTH + 70 - 55) {
                    g.drawImage(this.imgDownArrow, this.WIDTH - 30, this.HEIGHT - 31 - 80, 1 | 2);
                }
                this.buttonHome.setXY(280, 0);
                this.buttonHome.paint(g);
                g.setClip(50, 0, this.WIDTH - 100, this.HEIGHT);
                g.drawImage(this.imgHelpText, this.helpTexty + 180, this.helpTextx, 1 | 2);
                g.setClip(0, 0, this.WIDTH, this.HEIGHT);
                break;
            }
            case 4: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgAboutTitle, 55, this.HEIGHT - this.imgAboutTitle.getHeight() - 10, 0x10 | 4);
                if (this.imgAboutLogo != null) {
                    g.drawImage(this.imgAboutLogo, (this.WIDTH >> 1) + 20, this.HEIGHT >> 1, 1 | 2);
                }
                this.buttonHome.setXY(280, 0);
                this.buttonHome.paint(g);
                break;
            }
            case 5: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, this.WIDTH >> 1, 40, 1 | 2);
                this.buttonSingleP.paint(g);
                this.buttonMultiP.paint(g);
                this.buttonHome.paint(g);
                break;
            }
            case 6: {
                g.drawImage(this.imgSplash, 0, 0, 0x10 | 4);
                g.drawImage(this.imgMenuLogo, this.WIDTH >> 1, 40, 1 | 2);
                this.buttonNFC.paint(g);
                this.buttonSamePhone.paint(g);
                this.buttonHome.paint(g);
            }
        }
    }

    protected void pointerDragged(int x, int y) {
        if (this.MENU_MODE == 3) {
            if (this.buttonHelpData.isMovable && this.buttonHelpData.buttonState == 1) {
                this.buttonHelpData.nameY += y - this.buttonHelpData.touchX;
                this.buttonHelpData.touchY = y;
                if (this.buttonHelpData.nameY > this.buttonHelpData.y) {
                    this.buttonHelpData.nameY = this.buttonHelpData.y;
                } else if (this.buttonHelpData.nameY < this.buttonHelpData.y - (this.imgHelpText.getHeight() - this.buttonHelpData.height)) {
                    this.buttonHelpData.nameY = this.buttonHelpData.y - (this.imgHelpText.getHeight() - this.buttonHelpData.height);
                }
            }
            if (this.dragy > x && Math.abs(this.dragy - x) > 5) {
                this.input(56);
            } else if (this.dragy < x && Math.abs(this.dragy - x) > 5) {
                this.input(50);
            }
        }
    }
}

