/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class Board {
    private int humanI;
    private int humanJ;
    private int humanDirection;
    private boolean gameOver = false;
    private boolean notStarted = true;
    private int score = 0;
    private int speed = 50;
    private int status = 1;
    private Random rand = new Random();
    private int numberOfImages = 16;
    private int[] imageBank = new int[this.imagesInGame];
    private int[][] board = new int[this.cols][this.rows];
    private int[][] boardDisplay = new int[this.cols][this.rows];
    private int imagesInGame = 15;
    private int cols = 5;
    private int rows = 6;
    private int round = 0;
    String YOOHOO = "yoohoo.wav";
    String WAV = "";

    private void chooseImages() {
        int i;
        boolean done = true;
        for (i = 0; i < this.imagesInGame; ++i) {
            this.imageBank[i] = -1;
        }
        for (i = this.imagesInGame; i > 0; --i) {
            int tmp = this.rand.nextInt() % (this.numberOfImages + i - this.imagesInGame);
            if (tmp < 0) {
                tmp = -tmp;
            }
            int j = 0;
            block2: do {
                done = true;
                for (j = 0; j < this.imagesInGame; ++j) {
                    if (this.imageBank[j] != tmp) continue;
                    if (++tmp >= this.imagesInGame) {
                        tmp = 0;
                    }
                    done = false;
                    continue block2;
                }
            } while (!done);
            this.imageBank[i - 1] = tmp;
        }
    }

    private void shuffleImages() {
        int j;
        int i;
        for (i = 0; i < this.cols; ++i) {
            for (j = 0; j < this.rows; ++j) {
                this.board[i][j] = this.imageBank[(i + this.cols * j) / 2];
                this.boardDisplay[i][j] = 0;
            }
        }
        for (i = 0; i < this.cols; ++i) {
            for (j = 0; j < this.rows; ++j) {
                int i1 = this.rand.nextInt() % this.cols;
                int j1 = this.rand.nextInt() % this.rows;
                if (i1 < 0) {
                    i1 = -i1;
                }
                if (j1 < 0) {
                    j1 = -j1;
                }
                int tmp = this.board[i1][j1];
                this.board[i1][j1] = this.board[i][j];
                this.board[i][j] = tmp;
            }
        }
    }

    public void reset() {
        this.chooseImages();
        this.shuffleImages();
    }

    public void newGame() {
        this.humanI = 0;
        this.humanJ = 0;
        this.gameOver = false;
        this.humanDirection = 0;
        this.score = 0;
        this.speed = 50;
        this.round = 0;
        this.setStatus(2);
    }

    public void move() {
        this.notStarted = false;
        if (this.status == 2 || this.status == 22 || this.status == 23) {
            switch (this.humanDirection) {
                case 1: {
                    ++this.humanI;
                    break;
                }
                case 2: {
                    --this.humanI;
                    break;
                }
                case 3: {
                    --this.humanJ;
                    break;
                }
                case 4: {
                    ++this.humanJ;
                    break;
                }
                case 10: {
                    if (this.getStatus() == 2 && this.boardDisplay[this.humanI][this.humanJ] == 0) {
                        this.boardDisplay[this.humanI][this.humanJ] = 1;
                        this.setStatus(22);
                        break;
                    }
                    if (this.getStatus() == 22 && this.boardDisplay[this.humanI][this.humanJ] == 0) {
                        this.boardDisplay[this.humanI][this.humanJ] = 1;
                        if (this.checkCards() > 0) {
                            this.playWav(this.YOOHOO);
                        }
                        this.setStatus(23);
                        break;
                    }
                    if (this.getStatus() != 23) break;
                    this.score += this.checkCards();
                    if (this.checkCards() > 0) {
                        this.clearDisplayBoard(true);
                    } else {
                        this.clearDisplayBoard(false);
                    }
                    ++this.round;
                    if (!this.checkGameOver()) {
                        this.setStatus(2);
                        break;
                    }
                    this.setGameOver();
                    this.setStatus(13);
                    break;
                }
            }
        }
        if (this.humanJ < 0) {
            this.humanJ = this.rows - 1;
        }
        if (this.humanJ > this.rows - 1) {
            this.humanJ = 0;
        }
        if (this.humanI < 0) {
            this.humanI = this.cols - 1;
        }
        if (this.humanI > this.cols - 1) {
            this.humanI = 0;
        }
        this.setHumanDirection(0);
    }

    private int checkCards() {
        int tmp1 = -1;
        int tmp2 = -2;
        int cards = 0;
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                if (this.boardDisplay[i][j] <= -1) continue;
                ++cards;
                if (tmp1 == -1 && this.boardDisplay[i][j] == 1) {
                    tmp1 = this.board[i][j];
                    continue;
                }
                if (tmp2 != -2 || this.boardDisplay[i][j] != 1) continue;
                tmp2 = this.board[i][j];
            }
        }
        if (tmp1 == tmp2) {
            tmp1 = this.cols * this.rows + cards - this.round;
            if (tmp1 > this.cols * this.rows) {
                tmp1 = this.cols * this.rows;
            }
            if (tmp1 > 2) {
                return tmp1 * (tmp1 + 1);
            }
            return 2;
        }
        return 0;
    }

    private void clearDisplayBoard(boolean match) {
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                if (this.boardDisplay[i][j] != 1) continue;
                this.boardDisplay[i][j] = match ? -1 : 0;
            }
        }
    }

    private boolean checkGameOver() {
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                if (this.boardDisplay[i][j] <= -1) continue;
                return false;
            }
        }
        return true;
    }

    public int getHumanDirection() {
        return this.humanDirection;
    }

    public void setHumanDirection(int d) {
        this.humanDirection = d;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int s) {
        this.score = s;
    }

    public int getSpeed() {
        return this.speed;
    }

    public boolean isNotStarted() {
        return this.notStarted;
    }

    public int getHumanI() {
        return this.humanI;
    }

    public int getHumanJ() {
        return this.humanJ;
    }

    public void setHumanI(int i) {
        this.humanI = i;
    }

    public void setHumanJ(int j) {
        if (j >= 0 && j < this.rows) {
            this.humanJ = j;
        }
    }

    public void setStatus(int s) {
        this.status = s;
    }

    public int getStatus() {
        return this.status;
    }

    public void setSpeed(int s) {
        this.speed = s;
    }

    public void setGameOver() {
        this.gameOver = true;
    }

    private void playWav(String s) {
        this.WAV = s;
    }

    public void resetWav() {
        this.WAV = "";
    }

    public String getWav() {
        return this.WAV;
    }

    public boolean newRound() {
        return false;
    }

    private int minInt(int i, int j) {
        return i < j ? i : j;
    }

    public int getNumberOfImages() {
        return this.numberOfImages;
    }

    public int getCard(int i, int j) {
        return this.board[i][j];
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public int getBoardDisplay(int i, int j) {
        return this.boardDisplay[i][j];
    }
}

