/*
 * Decompiled with CFR 0.152.
 */
public class GameThread
extends Thread {
    boolean myShouldPause;
    static boolean myShouldStop;
    boolean myAlreadyStarted;
    MyGameCanvas myGameCanvas;
    static GameMIDlet myMIDlet;
    int gameTick = 0;
    int pauseBetweenGameTicks = 10;

    GameThread(MyGameCanvas MyGameCanvas2, GameMIDlet midLet) {
        this.myGameCanvas = MyGameCanvas2;
        myMIDlet = midLet;
    }

    void go() {
        if (!this.myAlreadyStarted) {
            this.myAlreadyStarted = true;
            this.start();
        } else {
            this.myShouldPause = !this.myShouldPause;
        }
    }

    void pause() {
        this.myShouldPause = true;
    }

    void requestStop() {
        this.myGameCanvas.newGame();
        this.pause();
    }

    public void run() {
        block24: {
            this.myGameCanvas.flushKeys();
            myShouldStop = false;
            this.myShouldPause = false;
            do {
                String str;
                if (myMIDlet.isSubmitHighscoreThreadOn() && (str = myMIDlet.getSubmitHighscoreThreadResult()) != "") {
                    myMIDlet.setSubmitHighscoreThreadOff();
                    try {
                        String[] str_a = this.split(str);
                        this.myGameCanvas.displayHighscoreSubmitResults(str_a[0]);
                        if (str_a.length > 2) {
                            this.myGameCanvas.setNewAd(str_a[1], str_a[2]);
                        }
                    }
                    catch (Exception ex) {
                        this.myGameCanvas.displayHighscoreSubmitResults(str);
                    }
                }
                if (this.myGameCanvas.isGameOver() && this.myGameCanvas.getStatus() == 2) {
                    this.myGameCanvas.removeInGameCommands();
                    if (myMIDlet.getMinimumHighscore() < this.myGameCanvas.getCash()) {
                        this.myGameCanvas.setStatus(5);
                        this.myGameCanvas.flushKeys();
                    } else {
                        this.myGameCanvas.displayMenu();
                        this.myGameCanvas.setStatus(4);
                        this.myGameCanvas.initGameOver();
                        this.myGameCanvas.flushKeys();
                    }
                }
                if (this.myGameCanvas.getStatus() == 13) {
                    this.myGameCanvas.initGameOver();
                    myMIDlet.setHighscoreForm(this.myGameCanvas.getCash());
                }
                if (myShouldStop) break block24;
                if (!this.myShouldPause) {
                    ++this.gameTick;
                    if (this.myGameCanvas.getSpeed() < this.gameTick * this.pauseBetweenGameTicks) {
                        this.myGameCanvas.checkKeys();
                        this.myGameCanvas.advance();
                        this.gameTick = 0;
                    }
                    try {
                        GameThread.sleep(this.pauseBetweenGameTicks);
                    }
                    catch (InterruptedException Ex) {
                        // empty catch block
                    }
                }
                if (this.myGameCanvas.getStatus() == 9) {
                    try {
                        this.myGameCanvas.displayHallOfFame();
                        myMIDlet.submitHighscore(0);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.myGameCanvas.getStatus() == 16) {
                    try {
                        this.myGameCanvas.displayHallOfFame();
                        myMIDlet.openRegistrationForm();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.myGameCanvas.getStatus() == 10) {
                    try {
                        myMIDlet.browseWapfrog();
                        this.myGameCanvas.setStatus(1);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.myGameCanvas.getStatus() != 20) continue;
                try {
                    myMIDlet.browseAd(this.myGameCanvas.getAdURL());
                    this.myGameCanvas.setStatus(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (this.myGameCanvas.getStatus() != 3);
            myMIDlet.closeMidlet();
        }
    }

    public void setGameOver() {
        this.myGameCanvas.setGameOver();
    }

    private String[] split(String original) {
        String separator = "|";
        String[] result = new String[3];
        int index = original.lastIndexOf(124);
        if (index > 0) {
            try {
                result[2] = original.substring(index + 1, original.length());
            }
            catch (Exception ex) {
                result[2] = "";
            }
            original = original.substring(0, index);
            index = original.lastIndexOf(124);
        }
        if (index > 0) {
            try {
                result[1] = original.substring(index + 1, original.length());
            }
            catch (Exception ex) {
                result[1] = "";
            }
            try {
                result[0] = original.substring(0, index);
            }
            catch (Exception ex) {
                result[0] = "";
            }
        }
        return result;
    }
}

