/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class MyGameCanvas
extends GameCanvas {
    Display myDisplay;
    Board myBoard;
    GameMenu myGameMenu;
    private ConfigParameters configParameters = new ConfigParameters();
    private ResourceManager rm = new ResourceManager("canvas", this.configParameters.get("language"));
    Image imageItem = null;
    Image cursorImage = null;
    Image upArrow = null;
    Image downArrow = null;
    Image upArrow16 = null;
    Image downArrow16 = null;
    Image logo48 = null;
    Image logo32 = null;
    Image logo16 = null;
    Image[] images16 = null;
    Image[] images32 = null;
    Image[] images48 = null;
    InputStream is = null;
    private boolean isRegistered = true;
    Highscore[] myHighscore = new Highscore[10];
    private int action = 0;
    static int BETUP = 1;
    static int BETDOWN = 2;
    static int currentLetterStart = 0;
    static int currentLetterStartTimer = 0;
    static int menuWidth = 0;
    static int fontSize = 0;
    static int prevKeyState = -1;
    static int height;
    static int width;
    static int maxLettersInLine;
    static String[] msgLine;
    static int msgLines;
    static int maxLinesInMessage;
    static int currentMsgLine;
    String msgTitle = this.rm.getString(1);
    static int prevStatus;
    static int sound;
    static boolean adSet;
    static String adText;
    static String adLink;
    private int registrationCounter = 100;
    private int checkKeyCode = -1;
    String MENUSOUND = "menu.wav";
    String ERROR = "error.wav";
    String SHUFFLE = "shufflingcards.wav";
    String CARDDEALT = "menu.wav";
    String YOOHOO = "yoohoo.wav";
    int pointerX = 0;
    int pointerY = 0;
    int gameClockTicks = 0;
    boolean pointerDisplay = false;
    boolean pointerClick = false;
    boolean pointerClickKey = false;
    boolean loadingFlag = true;
    public Command myHighscoreResetCommand;
    public Command myHighscoreSubmitCommand;
    public Command myHighscoreOkCommand;
    public Command myCancelCommand;
    public Command myOkCommand;
    public Command myResetOkCommand;
    public Command myExitCommand;
    public Command myPlayCommand;
    public Command myQuitCommand;
    public Command myPauseCommand;
    public Command myResumeCommand;
    public Command myAboutCommand;
    public Command myRegisterMemberCommand;
    public Command myAboutOkCommand;
    public Command myAboutBrowseCommand;
    public Command myFBFanBrowseCommand;

    public MyGameCanvas(Display d) {
        super(false);
        int i;
        this.myBoard = new Board();
        msgLine = new String[50];
        height = this.getHeight();
        width = this.getWidth();
        this.myDisplay = d;
        try {
            this.is = ((Object)((Object)this)).getClass().getResourceAsStream("/wapfrog.png");
            this.imageItem = Image.createImage((InputStream)this.is);
        }
        catch (IOException Ex) {
            // empty catch block
        }
        try {
            this.is = ((Object)((Object)this)).getClass().getResourceAsStream("/cursor.png");
            this.cursorImage = Image.createImage((InputStream)this.is);
        }
        catch (IOException Ex) {
            // empty catch block
        }
        try {
            this.is = ((Object)((Object)this)).getClass().getResourceAsStream("/arrow_up.png");
            this.upArrow = Image.createImage((InputStream)this.is);
        }
        catch (IOException Ex) {
            // empty catch block
        }
        try {
            this.is = ((Object)((Object)this)).getClass().getResourceAsStream("/arrow_down.png");
            this.downArrow = Image.createImage((InputStream)this.is);
        }
        catch (IOException Ex) {
            // empty catch block
        }
        try {
            this.is = ((Object)((Object)this)).getClass().getResourceAsStream("/arrow_up16.png");
            this.upArrow16 = Image.createImage((InputStream)this.is);
        }
        catch (IOException Ex) {
            // empty catch block
        }
        try {
            this.is = ((Object)((Object)this)).getClass().getResourceAsStream("/arrow_down16.png");
            this.downArrow16 = Image.createImage((InputStream)this.is);
        }
        catch (IOException Ex) {
            // empty catch block
        }
        try {
            this.is = ((Object)((Object)this)).getClass().getResourceAsStream("/logo48.png");
            this.logo48 = Image.createImage((InputStream)this.is);
        }
        catch (IOException Ex) {
            // empty catch block
        }
        try {
            this.is = ((Object)((Object)this)).getClass().getResourceAsStream("/logo32.png");
            this.logo32 = Image.createImage((InputStream)this.is);
        }
        catch (IOException Ex) {
            // empty catch block
        }
        try {
            this.is = ((Object)((Object)this)).getClass().getResourceAsStream("/logo16.png");
            this.logo16 = Image.createImage((InputStream)this.is);
        }
        catch (IOException Ex) {
            // empty catch block
        }
        this.images16 = new Image[this.myBoard.getNumberOfImages()];
        this.images32 = new Image[this.myBoard.getNumberOfImages()];
        this.images48 = new Image[this.myBoard.getNumberOfImages()];
        for (i = 0; i < this.myBoard.getNumberOfImages(); ++i) {
            try {
                this.is = ((Object)((Object)this)).getClass().getResourceAsStream("/img16_" + i + ".png");
                this.images16[i] = Image.createImage((InputStream)this.is);
            }
            catch (IOException Ex) {
                // empty catch block
            }
            try {
                this.is = ((Object)((Object)this)).getClass().getResourceAsStream("/img32_" + i + ".png");
                this.images32[i] = Image.createImage((InputStream)this.is);
            }
            catch (IOException Ex) {
                // empty catch block
            }
            try {
                this.is = ((Object)((Object)this)).getClass().getResourceAsStream("/img48_" + i + ".png");
                this.images48[i] = Image.createImage((InputStream)this.is);
                continue;
            }
            catch (IOException Ex) {
                // empty catch block
            }
        }
        for (i = 0; i < 10; ++i) {
            try {
                this.myHighscore[i] = new Highscore();
                this.myHighscore[i].setHighscore(this.rm.getString(2), 0);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.loadingFlag = true;
        this.repaint();
        this.loadingFlag = false;
        this.myBoard.setStatus(1);
        this.myBoard.setSpeed(0);
        this.myGameMenu = new GameMenu();
        this.readOptions();
    }

    void start() {
        this.myDisplay.setCurrent((Displayable)this);
        this.repaint();
    }

    protected void sizeChanged(int newWidth, int newHeight) {
        height = newHeight;
        width = newWidth;
        Font font = this.getGraphics().getFont();
        int fontHeight = font.getHeight();
        maxLinesInMessage = (height - this.imageItem.getHeight()) / (fontHeight + 2) - 1;
    }

    public void paint(Graphics g) {
        g.setClip(0, 0, width, height);
        if (this.loadingFlag) {
            this.paintLoading(g);
            return;
        }
        switch (this.myBoard.getStatus()) {
            case 1: {
                this.paintMenu(g);
                break;
            }
            case 6: {
                this.paintHallOfFame(g);
                break;
            }
            case 7: {
                this.paintHallOfFame(g);
                break;
            }
            case 8: {
                this.paintDialog(g);
                break;
            }
            default: {
                int x = 0;
                int y = 0;
                int w = width;
                int h = height;
                int cols = this.myBoard.getCols();
                int rows = this.myBoard.getRows();
                Font font = g.getFont();
                int fontHeight = font.getHeight();
                int s = (h - 2 * fontHeight) / rows;
                if (s > w / cols) {
                    s = w / cols;
                }
                int i = 0;
                int j = 0;
                int xStart = 1;
                g.setColor(0);
                g.fillRect(x - 1, y, w + 2, h);
                g.setColor(0xFFFFFF);
                String str = this.rm.getString(3) + ":";
                g.drawString(str, xStart, y, 20);
                str = String.valueOf(this.myBoard.getScore());
                int fontWidth = font.stringWidth(str);
                g.drawString(str, xStart + width - fontWidth, y, 20);
                for (i = 0; i < cols; ++i) {
                    for (j = 0; j < rows; ++j) {
                        if (this.pointerDisplay) {
                            if (this.pointerX > x + w / 2 - s * cols / 2 + i * s && this.pointerX < x + w / 2 - s * cols / 2 + i * s + s) {
                                this.myBoard.setHumanI(i);
                            }
                            if (this.pointerY > y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s && this.pointerY < y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s + s) {
                                this.myBoard.setHumanJ(j);
                            }
                        }
                        if (this.pointerClick) {
                            if (this.pointerX > x + w / 2 - s * cols / 2 + i * s && this.pointerX < x + w / 2 - s * cols / 2 + i * s + s) {
                                this.myBoard.setHumanI(i);
                            }
                            if (this.pointerY > y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s && this.pointerY < y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s + s) {
                                this.myBoard.setHumanJ(j);
                            }
                            this.pointerClickKey = true;
                            this.pointerClick = false;
                            this.checkKeys();
                            this.pointerClickKey = false;
                        }
                        if (this.myBoard.getHumanI() == i && this.myBoard.getHumanJ() == j) {
                            if (this.myBoard.getBoardDisplay(i, j) == 0 && this.gameClockTicks / 10 % 2 == 0) {
                                g.setColor(0xFAFA0F);
                                g.fillRoundRect(x + w / 2 - s * cols / 2 + i * s, y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s, s, s, s / 5, s / 5);
                            } else if (this.myBoard.getBoardDisplay(i, j) != 0) {
                                g.setColor(0xAEAEAE);
                                g.fillRoundRect(x + w / 2 - s * cols / 2 + i * s, y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s, s, s, s / 5, s / 5);
                            }
                        }
                        if (this.myBoard.getBoardDisplay(i, j) == 1) {
                            g.setColor(0xFFFFFF);
                            g.fillRoundRect(x + w / 2 - s * cols / 2 + i * s + 2, y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s + 2, s - 4, s - 4, s / 5, s / 5);
                        }
                        if (this.myBoard.getBoardDisplay(i, j) == 0) {
                            g.setColor(8040228);
                            g.fillRoundRect(x + w / 2 - s * cols / 2 + i * s + 2, y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s + 2, s - 4, s - 4, s / 5, s / 5);
                        }
                        if (this.myBoard.getBoardDisplay(i, j) == 0) {
                            if (s >= 48) {
                                g.drawImage(this.logo48, x + w / 2 - s * cols / 2 + i * s + s / 2 - 24, y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s + s / 2 - 24, 0);
                            } else if (s >= 32) {
                                g.drawImage(this.logo32, x + w / 2 - s * cols / 2 + i * s + s / 2 - 16, y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s + s / 2 - 16, 0);
                            } else {
                                g.drawImage(this.logo16, x + w / 2 - s * cols / 2 + i * s + s / 2 - 8, y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s + s / 2 - 8, 0);
                            }
                        }
                        if (this.myBoard.getBoardDisplay(i, j) != 1) continue;
                        if (s >= 48) {
                            g.drawImage(this.images48[this.myBoard.getCard(i, j)], x + w / 2 - s * cols / 2 + i * s + s / 2 - 24, y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s + s / 2 - 24, 0);
                            continue;
                        }
                        if (s >= 32 || this.myBoard.getStatus() == 23 || this.myBoard.getHumanI() == i && this.myBoard.getHumanJ() == j) {
                            g.drawImage(this.images32[this.myBoard.getCard(i, j)], x + w / 2 - s * cols / 2 + i * s + s / 2 - 16, y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s + s / 2 - 16, 0);
                            continue;
                        }
                        g.drawImage(this.images16[this.myBoard.getCard(i, j)], x + w / 2 - s * cols / 2 + i * s + s / 2 - 8, y + fontHeight + (h - 2 * fontHeight) / 2 - rows * s / 2 + j * s + s / 2 - 8, 0);
                    }
                }
                if (!this.myBoard.isGameOver()) break;
                g.setColor(0xFFFFFF);
                g.fillRect((w - x - font.stringWidth(this.rm.getString(4))) / 2 - 2, (h - y - fontHeight) / 2 + fontHeight * 1 - 1, font.stringWidth(this.rm.getString(4)) + 4, fontHeight + 2);
                g.fillRect((w - x - font.stringWidth(this.rm.getString(16))) / 2 - 2, (h - y - fontHeight) / 2 + fontHeight * 3 - 1, font.stringWidth(this.rm.getString(16)) + 4, fontHeight + 2);
                g.setColor(0);
                g.drawString(this.rm.getString(4), (w - x - font.stringWidth(this.rm.getString(4))) / 2, (h - y - fontHeight) / 2 + fontHeight * 1, 20);
                g.drawString(this.rm.getString(16), (w - x - font.stringWidth(this.rm.getString(16))) / 2, (h - y - fontHeight) / 2 + fontHeight * 3, 20);
            }
        }
    }

    public void paintLoading(Graphics g) {
        int x = 0;
        int y = 0;
        int w = width;
        int h = height;
        Font font = g.getFont();
        int fontHeight = font.getHeight();
        String str = "";
        int xStart = (w - x) / 2;
        g.setColor(0);
        g.fillRect(x, y, w, h);
        g.drawImage(this.imageItem, x + w / 2 - this.imageItem.getWidth() / 2, y, 0);
        int yStart = y + this.imageItem.getHeight();
        g.drawString(this.rm.getString(17) + "...", (w - x - font.stringWidth(this.rm.getString(17) + "...")) / 2, (h - y - fontHeight) / 2 + fontHeight * 1, 20);
        g.drawString(this.rm.getString(18) + "...", (w - x - font.stringWidth(this.rm.getString(17) + "...")) / 2, (h - y - fontHeight) / 2 + fontHeight * 3, 20);
    }

    public void paintMenu(Graphics g) {
        int yStart;
        int fontWidth;
        int i;
        int x = 0;
        int y = 0;
        int w = width;
        int h = height;
        Font font = g.getFont();
        int fontHeight = font.getHeight();
        String str = "";
        if (maxLettersInLine == 0) {
            g.setFont(Font.getFont((int)0, (int)1, (int)0));
            font = g.getFont();
            for (i = 1; i < 80; ++i) {
                if (font.stringWidth(str = str + "O") <= width - 10) continue;
                maxLettersInLine = i - 1;
                break;
            }
            maxLinesInMessage = (height - this.imageItem.getHeight()) / (fontHeight + 2) - 1;
        }
        int xStart = (w - x) / 2;
        g.setColor(0);
        g.fillRect(x, y, w, h);
        g.drawImage(this.imageItem, x + w / 2 - this.imageItem.getWidth() / 2, y, 0);
        if (!this.isRegistered) {
            str = this.rm.getString(19) + ", " + this.registrationCounter + " " + this.rm.getString(20);
            fontWidth = font.stringWidth(str);
            g.setColor(0);
            g.fillRect(x + w / 2 - fontWidth / 2, y + fontHeight, fontWidth, fontHeight);
            g.setColor(0xFFFFFF);
            g.drawString(str, x + w / 2 - fontWidth / 2, y + fontHeight, 20);
        }
        if ((yStart = h - (fontHeight + 2) * this.myGameMenu.getCount()) > this.imageItem.getHeight()) {
            yStart -= (yStart - this.imageItem.getHeight()) / 2;
        }
        if (yStart + this.myGameMenu.getSelected() * (fontHeight + 2) < 0) {
            yStart = 0;
        }
        for (i = 0; i < this.myGameMenu.getCount(); ++i) {
            str = this.myGameMenu.getItem(i);
            if (str.length() > maxLettersInLine) {
                if (currentLetterStart >= str.length()) {
                    currentLetterStart = 0;
                }
                try {
                    if (str.length() >= currentLetterStart + maxLettersInLine) {
                        if ((str = str.substring(currentLetterStart, currentLetterStart + maxLettersInLine)).lastIndexOf(32) > 0) {
                            str = str.substring(0, str.lastIndexOf(32));
                        }
                    } else {
                        str = str.substring(currentLetterStart, str.length());
                    }
                }
                catch (Exception ex) {
                    System.out.println("Exception (ad text length; " + currentLetterStart + ", " + (currentLetterStart + maxLettersInLine - 1) + ", " + str.length() + "); " + ex.toString());
                }
                if (++currentLetterStartTimer > 100) {
                    currentLetterStart += str.length();
                    currentLetterStartTimer = 0;
                }
            }
            g.setFont(Font.getFont((int)0, (int)1, (int)0));
            fontWidth = g.getFont().stringWidth(str);
            menuWidth = menuWidth < fontWidth ? fontWidth : menuWidth;
            xStart = (w - x) / 2 - fontWidth / 2;
            if (this.myGameMenu.getSelected() == i) {
                g.setColor(8040228);
                g.fillRect((w - x) / 2 - menuWidth / 2 - 5, yStart + i * (fontHeight + 2), menuWidth + 10, fontHeight);
                g.setColor(0xFFFFFF);
            } else {
                g.setColor(0xDDDDDD);
            }
            if (this.pointerDisplay && this.pointerX >= (w - x) / 2 - menuWidth / 2 - 5 && this.pointerX <= (w - x) / 2 - menuWidth / 2 - 5 + menuWidth + 10 && this.pointerY >= yStart + i * (fontHeight + 2) && this.pointerY <= yStart + i * (fontHeight + 2) + fontHeight) {
                this.myGameMenu.setSelected(i);
            }
            if (this.pointerClick && this.pointerX >= (w - x) / 2 - menuWidth / 2 - 5 && this.pointerX <= (w - x) / 2 - menuWidth / 2 - 5 + menuWidth + 10 && this.pointerY >= yStart + i * (fontHeight + 2) && this.pointerY <= yStart + i * (fontHeight + 2) + fontHeight) {
                this.myGameMenu.setSelected(i);
                this.pointerClickKey = true;
                this.pointerClick = false;
                this.checkKeys();
                this.pointerClickKey = false;
            }
            g.drawString(str, xStart, yStart + i * (fontHeight + 2), 20);
        }
    }

    public void paintHallOfFame(Graphics g) {
        int fontWidth;
        int x = 0;
        int y = 0;
        int w = width;
        int h = height;
        Font font = Font.getFont((int)0, (int)1, (int)fontSize);
        int fontHeight = font.getHeight();
        g.setFont(Font.getFont((int)0, (int)1, (int)0));
        int xStart = (w - x) / 2;
        g.setColor(0);
        g.fillRect(x, y, w, h);
        g.drawImage(this.imageItem, x + w / 2 - this.imageItem.getWidth() / 2, y, 0);
        int yStart = y + this.imageItem.getHeight();
        g.setFont(Font.getFont((int)0, (int)1, (int)0));
        g.setColor(8040228);
        g.fillRect(x, yStart, width, 1 + (maxLinesInMessage + 2) * fontHeight);
        if (currentMsgLine > 0) {
            g.drawImage(this.upArrow, width - this.upArrow.getWidth() - 2, yStart + fontHeight + 2, 0);
        }
        if (currentMsgLine <= msgLines - maxLinesInMessage - 2) {
            g.drawImage(this.downArrow, width - this.downArrow.getWidth() - 2, yStart + fontHeight * (maxLinesInMessage + 2) + 2 - this.downArrow.getHeight(), 0);
        }
        g.setColor(0);
        g.fillRect(x + 1, yStart + 1, width - 2, fontHeight + 2);
        g.setColor(0xFFFFFF);
        g.drawString(this.rm.getString(5), x + 5, yStart + 2, 20);
        for (int i = currentMsgLine; i < currentMsgLine + maxLinesInMessage + 1 && i < msgLines; ++i) {
            String numberStr = "" + (i + 1) + ". ";
            String nameStr = this.myHighscore[i].getName();
            String scoreStr = " " + this.myHighscore[i].getScore();
            String str = nameStr + "........." + scoreStr;
            g.setColor(0xFFFFFF);
            fontWidth = font.stringWidth(scoreStr);
            int xNameStart = font.stringWidth("10. ") + 5;
            int xScoreStart = w - fontWidth - 5 - this.upArrow.getWidth() - 2;
            g.drawString(numberStr, x + 5, yStart + 1 + (i - currentMsgLine + 1) * fontHeight, 20);
            g.drawString(nameStr, xNameStart, yStart + 1 + (i - currentMsgLine + 1) * fontHeight, 20);
            g.drawString(scoreStr, xScoreStart, yStart + 1 + (i - currentMsgLine + 1) * fontHeight, 20);
        }
        if (this.myBoard.getStatus() == 7) {
            String str = this.rm.getString(7);
            fontWidth = font.stringWidth(str);
            g.setColor(0);
            g.fillRect((w - x) / 2 - fontWidth / 2 - 5, (h - y) / 2 - fontHeight - 5, fontWidth + 10, fontHeight * 2 + 10);
            g.setColor(0xFFFFFF);
            g.drawString(str, (w - x) / 2 - fontWidth / 2, (h - y) / 2, 20);
            str = this.rm.getString(6);
            g.drawString(str, (w - x) / 2 - fontWidth / 2, (h - y) / 2 - fontHeight, 20);
        }
    }

    public void paintDialog(Graphics g) {
        int x = 0;
        int y = 0;
        int w = width;
        int h = height;
        Font font = Font.getFont((int)0, (int)1, (int)fontSize);
        int fontHeight = font.getHeight();
        g.setFont(Font.getFont((int)0, (int)1, (int)0));
        g.setColor(0);
        g.fillRect(x, y, w, h);
        g.drawImage(this.imageItem, x + w / 2 - this.imageItem.getWidth() / 2, y, 0);
        int yStart = y + this.imageItem.getHeight();
        g.setColor(8040228);
        g.fillRect(x, yStart, width, 1 + (maxLinesInMessage + 2) * fontHeight);
        if (currentMsgLine > 0) {
            g.drawImage(this.upArrow, width - this.upArrow.getWidth() - 2, yStart + fontHeight + 2, 0);
        }
        if (currentMsgLine <= msgLines - maxLinesInMessage - 2) {
            g.drawImage(this.downArrow, width - this.downArrow.getWidth() - 2, yStart + fontHeight * (maxLinesInMessage + 2) + 2 - this.downArrow.getHeight(), 0);
        }
        g.setColor(0);
        g.fillRect(x + 1, yStart + 1, width - 2, fontHeight + 2);
        g.setColor(0xFFFFFF);
        g.drawString(this.msgTitle, x + 5, yStart + 2, 20);
        for (int i = currentMsgLine; i < currentMsgLine + maxLinesInMessage + 1 && i < msgLines; ++i) {
            g.drawString(msgLine[i], x + 5, yStart + 1 + (i - currentMsgLine + 1) * fontHeight, 20);
        }
    }

    public void advance() {
        if (!this.myBoard.getWav().equals("")) {
            this.playWav(this.myBoard.getWav());
            this.myBoard.resetWav();
        }
        switch (this.myBoard.getStatus()) {
            case 1: {
                this.myBoard.move();
                this.repaint();
                break;
            }
            case 2: {
                this.myBoard.move();
                this.repaint();
                ++this.gameClockTicks;
                break;
            }
            case 22: {
                this.myBoard.move();
                this.repaint();
                ++this.gameClockTicks;
                break;
            }
            case 23: {
                this.myBoard.move();
                this.repaint();
                ++this.gameClockTicks;
                break;
            }
            case 4: {
                if (this.pointerClick) {
                    this.pointerClick = false;
                    this.pointerClickKey = true;
                    this.checkKeys();
                    this.pointerClickKey = false;
                }
                this.repaint();
                break;
            }
            case 5: {
                if (this.pointerClick) {
                    this.pointerClick = false;
                    this.pointerClickKey = true;
                    this.checkKeys();
                    this.pointerClickKey = false;
                }
                this.repaint();
                break;
            }
            case 6: {
                this.myBoard.move();
                this.repaint();
                break;
            }
            case 7: {
                this.repaint();
                break;
            }
            case 8: {
                this.repaint();
            }
        }
    }

    public void checkKeys() {
        int keyState;
        if (this.myBoard.getStatus() == 2 || this.myBoard.getStatus() == 22 || this.myBoard.getStatus() == 23) {
            keyState = this.getKeyStates();
            if (prevKeyState == keyState && !this.pointerClickKey) {
                prevKeyState = keyState;
                return;
            }
            prevKeyState = keyState;
            if ((keyState & 0x20) != 0) {
                this.myBoard.setHumanDirection(1);
                this.gameClockTicks = 0;
            }
            if ((keyState & 4) != 0) {
                this.myBoard.setHumanDirection(2);
                this.gameClockTicks = 0;
            }
            if ((keyState & 2) != 0) {
                this.myBoard.setHumanDirection(3);
                this.gameClockTicks = 0;
            }
            if ((keyState & 0x40) != 0) {
                this.myBoard.setHumanDirection(4);
                this.gameClockTicks = 0;
            }
            if ((keyState & 0x100) != 0 || this.pointerClickKey) {
                this.myBoard.setHumanDirection(10);
                this.gameClockTicks = 0;
            }
        }
        if (this.myBoard.getStatus() == 13) {
            keyState = this.getKeyStates();
            if (prevKeyState == keyState && !this.pointerClickKey) {
                prevKeyState = keyState;
                return;
            }
            prevKeyState = keyState;
            if ((keyState & 0x100) != 0 || this.pointerClickKey) {
                this.setStatus(1);
                this.flushKeys();
            }
        }
        if (this.myBoard.getStatus() == 5) {
            keyState = this.getKeyStates();
            if (prevKeyState == keyState && !this.pointerClickKey) {
                prevKeyState = keyState;
                return;
            }
            prevKeyState = keyState;
            if ((keyState & 0x100) != 0 || this.pointerClickKey) {
                this.setStatus(13);
                this.flushKeys();
            }
        }
        if (this.myBoard.getStatus() == 1) {
            keyState = this.getKeyStates();
            if (prevKeyState == keyState && !this.pointerClickKey) {
                prevKeyState = keyState;
                return;
            }
            prevKeyState = keyState;
            if ((keyState & 2) != 0) {
                this.playWav(this.MENUSOUND);
                this.myGameMenu.menuUp();
            }
            if ((keyState & 0x40) != 0) {
                this.playWav(this.MENUSOUND);
                this.myGameMenu.menuDown();
            }
            if ((keyState & 0x100) != 0 || this.pointerClickKey) {
                this.playWav(this.MENUSOUND);
                switch (this.myGameMenu.getSelected()) {
                    case 0: {
                        this.removeMenu();
                        this.myBoard.setSpeed(50);
                        if (this.checkRegistration()) {
                            this.newGame();
                            break;
                        }
                        this.setStatus(16);
                        break;
                    }
                    case 1: {
                        this.setStatus(9);
                        break;
                    }
                    case 2: {
                        if (adSet) {
                            this.setStatus(20);
                            break;
                        }
                        this.setStatus(10);
                        break;
                    }
                    case 3: {
                        this.displayHallOfFame();
                        break;
                    }
                    case 4: {
                        sound = 1 - sound;
                        this.saveOptions();
                        this.setOptions();
                        break;
                    }
                    case 5: {
                        this.displayHelp();
                        break;
                    }
                    case 6: {
                        this.setStatus(3);
                        this.myBoard.setSpeed(0);
                        break;
                    }
                }
            }
        }
        if (this.myBoard.getStatus() == 4) {
            keyState = this.getKeyStates();
            if (prevKeyState == keyState && !this.pointerClickKey) {
                prevKeyState = keyState;
                return;
            }
            prevKeyState = keyState;
            if ((keyState & 0x100) != 0 || this.pointerClickKey) {
                this.myBoard.setStatus(1);
                this.myBoard.setSpeed(50);
            }
        }
        if (this.myBoard.getStatus() == 8 || this.myBoard.getStatus() == 6) {
            keyState = this.getKeyStates();
            if (prevKeyState == keyState) {
                prevKeyState = keyState;
                return;
            }
            prevKeyState = keyState;
            if ((keyState & 2) != 0) {
                currentMsgLine -= currentMsgLine > 0 ? 1 : 0;
            }
            if ((keyState & 0x40) != 0) {
                currentMsgLine += currentMsgLine <= msgLines - maxLinesInMessage - 2 ? 1 : 0;
            }
        }
        if (prevKeyState == (keyState = this.getKeyStates()) && !this.pointerClickKey) {
            prevKeyState = keyState;
            return;
        }
        prevKeyState = keyState;
    }

    public int getKeyStates() {
        int key = super.getKeyStates();
        switch (this.checkKeyCode) {
            case 50: {
                key = 2;
                break;
            }
            case 52: {
                key = 4;
                break;
            }
            case 53: {
                key = 256;
                break;
            }
            case 54: {
                key = 32;
                break;
            }
            case 56: {
                key = 64;
            }
        }
        this.checkKeyCode = -1;
        return key;
    }

    protected void keyPressed(int keyCode) {
        this.checkKeyCode = keyCode;
        if (this.myBoard.getStatus() == 2) {
            String string = this.getKeyName(keyCode).toUpperCase();
        }
        if (this.myBoard.getStatus() == 12) {
            this.pointerClick = false;
            this.pointerClickKey = true;
            this.checkKeys();
            this.pointerClickKey = false;
        }
        if (this.myBoard.getStatus() == 13) {
            this.pointerClick = false;
            this.pointerClickKey = true;
            this.checkKeys();
            this.pointerClickKey = false;
        }
        if (this.myBoard.getStatus() == 4) {
            this.pointerClick = false;
            this.pointerClickKey = true;
            this.checkKeys();
            this.pointerClickKey = false;
        }
        if (this.myBoard.getStatus() == 5) {
            this.pointerClick = false;
            this.pointerClickKey = true;
            this.checkKeys();
            this.pointerClickKey = false;
        }
    }

    public void flushKeys() {
    }

    public void reset() {
    }

    public int getSpeed() {
        return this.myBoard.getSpeed();
    }

    public boolean isGameOver() {
        return this.myBoard.isGameOver();
    }

    public void initGameOver() {
    }

    void runMenuItem() {
    }

    public int getCash() {
        return this.myBoard.getScore();
    }

    public int getStatus() {
        return this.myBoard.getStatus();
    }

    public void setStatus(int s) {
        this.myBoard.setStatus(s);
    }

    public void displayMenu() {
        this.setStatus(1);
        this.addCommand(this.myPlayCommand);
        if (!this.isRegistered) {
            this.addCommand(this.myRegisterMemberCommand);
        }
    }

    public void removeMenu() {
        this.removeCommand(this.myPlayCommand);
        if (!this.isRegistered) {
            this.removeCommand(this.myRegisterMemberCommand);
        }
    }

    public void displayHallOfFame() {
        this.removeMenu();
        this.setStatus(6);
        msgLines = 10;
        currentMsgLine = 0;
        this.addCommand(this.myHighscoreOkCommand);
        this.addCommand(this.myHighscoreSubmitCommand);
        this.addCommand(this.myHighscoreResetCommand);
        this.addCommand(this.myAboutBrowseCommand);
        this.addCommand(this.myFBFanBrowseCommand);
    }

    public void removeHallOfFame() {
        this.displayMenu();
        this.removeCommand(this.myHighscoreOkCommand);
        this.removeCommand(this.myHighscoreSubmitCommand);
        this.removeCommand(this.myHighscoreResetCommand);
        this.removeCommand(this.myAboutBrowseCommand);
        this.removeCommand(this.myFBFanBrowseCommand);
    }

    public void displayResetHighscore() {
        this.removeMenu();
        this.setStatus(7);
        this.addCommand(this.myResetOkCommand);
        this.addCommand(this.myCancelCommand);
    }

    public void removeResetHighscore() {
        this.removeCommand(this.myResetOkCommand);
        this.removeCommand(this.myCancelCommand);
    }

    public void setHighscore(Highscore[] h) {
        for (int i = 0; i < 10; ++i) {
            this.myHighscore[i].setName(h[i].getName());
            this.myHighscore[i].setScore(h[i].getScore());
        }
    }

    public void newGame() {
        this.addCommand(this.myQuitCommand);
        this.addCommand(this.myPauseCommand);
        this.myBoard.setSpeed(50);
        this.myBoard.reset();
        this.myBoard.newGame();
    }

    public void removeInGameCommands() {
        this.removeCommand(this.myQuitCommand);
        this.removeCommand(this.myPauseCommand);
    }

    public void displayHelp() {
        this.removeMenu();
        this.msgTitle = this.rm.getString(8);
        this.prepareMessage(this.rm.getString(9));
        this.setStatus(8);
        this.addCommand(this.myOkCommand);
        if (!this.isRegistered) {
            this.addCommand(this.myRegisterMemberCommand);
        }
        this.addCommand(this.myAboutCommand);
        this.addCommand(this.myAboutBrowseCommand);
        this.addCommand(this.myFBFanBrowseCommand);
    }

    public void removeHelp() {
        this.displayMenu();
        this.removeCommand(this.myOkCommand);
        if (!this.isRegistered) {
            this.removeCommand(this.myRegisterMemberCommand);
        }
        this.removeCommand(this.myAboutCommand);
        this.removeCommand(this.myAboutBrowseCommand);
        this.removeCommand(this.myFBFanBrowseCommand);
    }

    public void displayAbout() {
        this.removeHelp();
        this.removeMenu();
        this.msgTitle = this.rm.getString(10);
        this.prepareMessage(this.configParameters.get("game") + "\nVersion " + this.configParameters.get("version") + "\nDeveloped by wapfrog.com");
        this.setStatus(8);
        this.addCommand(this.myAboutOkCommand);
        this.addCommand(this.myAboutBrowseCommand);
        this.addCommand(this.myFBFanBrowseCommand);
    }

    public void removeAbout() {
        this.displayMenu();
        this.removeCommand(this.myAboutOkCommand);
        this.removeCommand(this.myAboutBrowseCommand);
        this.removeCommand(this.myFBFanBrowseCommand);
    }

    public void displayHighscoreSubmitResults(String str) {
        this.msgTitle = this.rm.getString(12);
        this.prepareMessage(str);
        prevStatus = this.getStatus();
        this.setStatus(8);
    }

    public void removeHighscoreSubmitResults() {
        this.setStatus(prevStatus);
    }

    private int lastIndexOf(String str, String source) {
        int i;
        for (i = source.length() - str.length(); i > 0; --i) {
            if (!source.substring(i, str.length()).equals(str)) continue;
            return i;
        }
        return i;
    }

    private void prepareMessage(String msg) {
        int i = 0;
        int row = 0;
        int newLine = 0;
        int last = 0;
        for (i = 0; i < msg.length(); ++i) {
            if (msg.substring(i, i + 1).equals(" ")) {
                last = i;
            }
            if (msg.substring(i, i + 1).equals("\n")) {
                last = i;
            }
            if (i - newLine > maxLettersInLine || msg.substring(i, i + 1).equals("\n") || i == msg.length() - 1) {
                if (msg.substring(i, i + 1).equals("\n")) {
                    ++i;
                }
                if (i == msg.length() - 1) {
                    last = i + 1;
                }
                MyGameCanvas.msgLine[row] = msg.substring(newLine, last);
                newLine = ++last;
                i = last;
                ++row;
            }
            if (row >= msgLine.length) break;
        }
        msgLines = row;
        currentMsgLine = 0;
    }

    public void playWav(String fileName) {
        if (sound == 0) {
            return;
        }
        final String fn = fileName;
        new Thread(new Runnable(){

            public void run() {
                Player player = null;
                try {
                    InputStream is = this.getClass().getResourceAsStream(fn);
                    player = Manager.createPlayer((InputStream)is, (String)"audio/X-wav");
                    player.realize();
                    player.prefetch();
                    player.setLoopCount(1);
                    player.start();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    is.close();
                    player.close();
                }
                catch (IOException ioe) {
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
            }
        }).start();
    }

    public void playFile(String fileName) {
        if (sound == 0) {
            return;
        }
        try {
            Player p = Manager.createPlayer((String)fileName);
            p.setLoopCount(1);
            p.start();
        }
        catch (IOException ioe) {
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void resetOptions() {
        String options = "1";
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"options", (boolean)true);
            byte[] bytes = options.getBytes();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(bytes, 0, bytes.length);
            } else {
                recordStore.setRecord(1, bytes, 0, bytes.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        this.readOptions();
    }

    public void readOptions() {
        boolean index = false;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"options", (boolean)false);
            byte[] bytes = recordStore.getRecord(1);
            String options = new String(bytes);
            sound = Integer.parseInt(options);
            this.setOptions();
        }
        catch (RecordStoreException e) {
            this.resetOptions();
        }
    }

    public void saveOptions() {
        String options = "" + sound;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"options", (boolean)true);
            byte[] bytes = options.getBytes();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(bytes, 0, bytes.length);
            } else {
                recordStore.setRecord(1, bytes, 0, bytes.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void setOptions() {
        this.myGameMenu.setItem(4, sound == 1 ? this.rm.getString(13) : this.rm.getString(14));
    }

    public void setGameOver() {
        this.myBoard.setGameOver();
    }

    public void pointerPressed(int x, int y) {
        this.pointerX = x;
        this.pointerY = y;
        this.pointerDisplay = true;
    }

    public void pointerDragged(int x, int y) {
        this.pointerX = x;
        this.pointerY = y;
        this.pointerDisplay = true;
    }

    public void pointerReleased(int x, int y) {
        this.pointerX = x;
        this.pointerY = y;
        this.pointerDisplay = false;
        this.pointerClick = true;
        this.pointerClickKey = false;
    }

    public void setRegistered(boolean r) {
        this.isRegistered = r;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    private boolean checkRegistration() {
        if (!this.isRegistered) {
            if (this.configParameters.get("shareware").equals("no")) {
                return true;
            }
            return this.registrationCounter > 0;
        }
        return true;
    }

    public String getParameter(String s) {
        return this.configParameters.get(s);
    }

    public void setRegistrationCounter(int i) {
        this.registrationCounter = i;
    }

    public void setNewAd(String text, String link) {
        adSet = true;
        adText = text;
        adLink = link;
        if (adText.equals("") || adLink.equals("")) {
            adSet = false;
        } else {
            this.myGameMenu.setItem(2, adText);
        }
    }

    public String getAdURL() {
        return adLink;
    }

    static {
        maxLettersInLine = 0;
        msgLines = 0;
        maxLinesInMessage = 4;
        currentMsgLine = 0;
        prevStatus = 0;
        sound = 1;
        adSet = false;
        adText = "";
        adLink = "";
    }
}

