/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;

class ResourceManager {
    private String[] lines = null;
    private int lines_i;

    public ResourceManager(String file, String locale) {
        String unicodeStr;
        String original = unicodeStr = this.readUnicodeFileUTF8(locale + "." + file + ".txt");
        String separator = "\r\n";
        int count_sep = 1;
        String temp = original;
        while (temp.indexOf(separator) > -1) {
            ++count_sep;
            temp = temp.substring(temp.indexOf(separator) + 1);
        }
        this.lines = new String[count_sep];
        this.lines_i = 0;
        int index = original.indexOf(separator);
        while (index >= 0) {
            this.lines[this.lines_i] = original.substring(0, index);
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
            ++this.lines_i;
        }
        this.lines[this.lines_i] = original;
        ++this.lines_i;
    }

    public String getString(int i) {
        String ret = "";
        try {
            if (i - 1 < this.lines.length) {
                ret = this.lines[i - 1];
            }
        }
        catch (Exception e) {
            System.out.println("exception on getString: " + e.toString());
        }
        return ret;
    }

    private final String readUnicodeFileUTF8(String filename) {
        StringBuffer sb = new StringBuffer(256);
        try {
            int[] surrogatePair = new int[2];
            InputStream is = this.getClass().getResourceAsStream(filename);
            int val = 0;
            int unicharCount = 0;
            while ((val = ResourceManager.readNextCharFromStreamUTF8(is)) != -1) {
                ++unicharCount;
                if (val <= 65535) {
                    if (unicharCount == 1 && val == 65279) continue;
                    sb.append((char)val);
                    continue;
                }
                ResourceManager.supplementCodePointToSurrogatePair(val, surrogatePair);
                sb.append((char)surrogatePair[0]);
                sb.append((char)surrogatePair[1]);
            }
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String(sb);
    }

    private static final int readNextCharFromStreamUTF8(InputStream is) {
        int c = -1;
        if (is == null) {
            return c;
        }
        boolean complete = false;
        try {
            int byteVal;
            int expecting = 0;
            int composedVal = 0;
            while (!complete && (byteVal = is.read()) != -1) {
                if (expecting > 0 && (byteVal & 0xC0) == 128) {
                    composedVal |= (byteVal & 0x3F) << --expecting * 6;
                    if (expecting != 0) continue;
                    c = composedVal;
                    complete = true;
                    continue;
                }
                composedVal = 0;
                expecting = 0;
                if ((byteVal & 0x80) == 0) {
                    c = byteVal;
                    complete = true;
                    continue;
                }
                if ((byteVal & 0xE0) == 192) {
                    expecting = 1;
                    composedVal = (byteVal & 0x1F) << 6;
                    continue;
                }
                if ((byteVal & 0xF0) == 224) {
                    expecting = 2;
                    composedVal = (byteVal & 0xF) << 12;
                    continue;
                }
                if ((byteVal & 0xF8) != 240) continue;
                expecting = 3;
                composedVal = (byteVal & 7) << 18;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return c;
    }

    private static final void supplementCodePointToSurrogatePair(int codePoint, int[] surrogatePair) {
        int high4 = (codePoint >> 16 & 0x1F) - 1;
        int mid6 = codePoint >> 10 & 0x3F;
        int low10 = codePoint & 0x3FF;
        surrogatePair[0] = 0xD800 | high4 << 6 | mid6;
        surrogatePair[1] = 0xDC00 | low10;
    }

    public int getLength() {
        return this.lines_i;
    }
}

