/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl.migration;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.RecordStoreManager;
import net.sourceforge.floggy.persistence.impl.Utils;
import net.sourceforge.floggy.persistence.impl.migration.AbstractEnumerationImpl;
import net.sourceforge.floggy.persistence.impl.migration.HashtableValueNullable;

public class JoinedStrategyEnumerationImpl
extends AbstractEnumerationImpl {
    protected Hashtable superClassesIDs = new Hashtable();

    public JoinedStrategyEnumerationImpl(PersistableMetadata persistableMetadata, PersistableMetadata persistableMetadata2, RecordEnumeration recordEnumeration, RecordStore recordStore, boolean bl, boolean bl2) {
        super(persistableMetadata, persistableMetadata2, recordEnumeration, recordStore, bl, bl2);
    }

    public int delete() {
        if (this.recordId != -1) {
            try {
                this.deleteSuperClassesRegisters();
                this.recordStore.deleteRecord(this.recordId);
                int n2 = this.recordId;
                this.recordId = -1;
                return n2;
            }
            catch (RecordStoreException recordStoreException) {
                RecordStoreException recordStoreException2 = recordStoreException;
                throw Utils.handleException((Exception)((Object)recordStoreException));
            }
        }
        throw new FloggyException("There isn't a register to delete. You have to iterate over the enumeration before call delete.");
    }

    public Hashtable nextElement() {
        if (this.recordId != -1 && !this.iterationMode) {
            throw new FloggyException("You should delete or update the current register before step into the next one.");
        }
        this.superClassesIDs.clear();
        HashtableValueNullable hashtableValueNullable = new HashtableValueNullable();
        try {
            this.recordId = this.enumeration.nextRecordId();
            byte[] byArray = this.recordStore.getRecord(this.recordId);
            this.buildPersistable(this.rmsBasedMetadata, byArray, hashtableValueNullable);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            throw Utils.handleException(exception2);
        }
        return hashtableValueNullable;
    }

    public int update(Persistable object) {
        if (this.recordId != -1) {
            object = Utils.checkArgumentAndCast(object);
            try {
                object.__setId(this.recordId);
                this.deleteSuperClassesRegisters();
                int n2 = this.manager.save((Persistable)object);
                this.recordId = -1;
                return n2;
            }
            catch (RecordStoreException recordStoreException) {
                object = recordStoreException;
                throw Utils.handleException((Exception)((Object)recordStoreException));
            }
        }
        throw new FloggyException("There isn't a register to update. You have to iterate over the enumeration before call update.");
    }

    protected void buildPersistable(PersistableMetadata object, byte[] object2, Hashtable hashtable) {
        String[] stringArray = ((PersistableMetadata)object).getFieldNames();
        int[] nArray = ((PersistableMetadata)object).getFieldTypes();
        if (object2 != null) {
            Object object3;
            int n2;
            object2 = new DataInputStream(new ByteArrayInputStream((byte[])object2));
            if (PersistableMetadataManager.getRMSVersion().equals("1.4.0")) {
                ((DataInputStream)object2).skipBytes(4);
            }
            if ((object = ((PersistableMetadata)object).getSuperClassName()) != null) {
                n2 = ((DataInputStream)object2).readInt();
                PersistableMetadata persistableMetadata = PersistableMetadataManager.getRMSBasedMetadata((String)object);
                if (persistableMetadata == null) {
                    persistableMetadata = PersistableMetadataManager.getClassBasedMetadata((String)object);
                }
                object3 = RecordStoreManager.getRecordStore(persistableMetadata.getRecordStoreName(), persistableMetadata);
                byte[] byArray = object3.getRecord(n2);
                this.buildPersistable(persistableMetadata, byArray, hashtable);
                this.superClassesIDs.put(object, new Integer(n2));
                RecordStoreManager.closeRecordStore(object3);
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                int n3 = nArray[n2];
                if (this.lazy) {
                    if ((n3 & 0x400) == 1024) continue;
                    object3 = (n3 & 0x20000) == 131072 ? this.readArray(n3 &= 0xFFFDFFFF, stringArray[n2], (DataInputStream)object2) : ((n3 & 0x40000) == 262144 ? this.readPrimitive(n3 &= 0xFFFBFFFF, (DataInputStream)object2) : this.readObject(n3, stringArray[n2], (DataInputStream)object2));
                    hashtable.put(stringArray[n2], object3);
                    continue;
                }
                object3 = (n3 & 0x20000) == 131072 ? this.readArray(n3 &= 0xFFFDFFFF, stringArray[n2], (DataInputStream)object2) : ((n3 & 0x40000) == 262144 ? this.readPrimitive(n3 &= 0xFFFBFFFF, (DataInputStream)object2) : this.readObject(n3, stringArray[n2], (DataInputStream)object2));
                hashtable.put(stringArray[n2], object3);
            }
        }
    }

    protected void deleteSuperClassesRegisters() {
        if (!this.superClassesIDs.isEmpty()) {
            Enumeration enumeration = this.superClassesIDs.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                PersistableMetadata persistableMetadata = PersistableMetadataManager.getRMSBasedMetadata(string);
                if (persistableMetadata == null) continue;
                persistableMetadata = RecordStoreManager.getRecordStore(persistableMetadata.getRecordStoreName(), persistableMetadata);
                persistableMetadata.deleteRecord((Integer)this.superClassesIDs.get(string));
                RecordStoreManager.closeRecordStore((RecordStore)persistableMetadata);
            }
        }
    }
}

