/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DeviceImage {
    public static final boolean USE_CLIPPING = true;
    public static final byte FLIP_HORIZONTAL = 1;
    public static final byte FLIP_VERTICAL = 2;
    public static final byte ROTATE_90 = 4;
    public static final byte ROTATE_180 = 8;
    public static final byte ROTATE_270 = 16;
    public Image tileImage;
    public int tileX;
    public int tileY;
    public int width;
    public int height;

    public DeviceImage(DeviceImage deviceImage, int n, int n2, int n3, int n4) {
        this.tileImage = deviceImage.tileImage;
        this.width = n3;
        this.height = n4;
        this.tileX = n;
        this.tileY = n2;
    }

    public DeviceImage(Image image) {
        this.tileImage = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public DeviceImage(byte[] byArray) {
        this.createImage(byArray);
    }

    private void createImage(byte[] byArray) {
        try {
            this.tileImage = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            this.width = (short)this.tileImage.getWidth();
            this.height = (short)this.tileImage.getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DeviceImage(DeviceImage deviceImage, int n) {
        this.tileImage = deviceImage.tileImage;
        this.tileX = deviceImage.tileX;
        this.tileY = deviceImage.tileY;
        this.width = deviceImage.width;
        this.height = deviceImage.height;
    }

    public DeviceImage(String string) throws Exception {
        byte[] byArray = ResourceMaster.getResource(string);
        this.tileImage = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        this.width = this.tileImage.getWidth();
        this.height = this.tileImage.getHeight();
        byArray = null;
    }

    public void drawImage(Graphics graphics, int n, int n2) {
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        graphics.clipRect(n, n2, this.width, this.height);
        graphics.drawImage(this.tileImage, n - this.tileX, n2 - this.tileY, 20);
        graphics.setClip(n3, n4, n5, n6);
    }

    public void drawImage(Graphics graphics, int n, int n2, int n3) {
        graphics.clipRect(n, n2, this.width, this.height);
        graphics.drawImage(this.tileImage, n - this.tileX, n2 - this.tileY, n3);
        graphics.setClip(0, 0, 240, 320);
    }

    public void drawImageNoClipping(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.tileImage, n - this.tileX, n2 - this.tileY, 20);
    }

    public DeviceImage[] divide(int n) {
        int n2 = this.width / n;
        int n3 = this.height;
        return this.divide(n2, n3);
    }

    public DeviceImage[] divide(int n, int n2) {
        int n3 = this.width / n;
        int n4 = this.height / n2;
        DeviceImage[] deviceImageArray = new DeviceImage[n4 * n3];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                deviceImageArray[n5++] = new DeviceImage(this, j * n, i * n2, n, n2);
            }
        }
        return deviceImageArray;
    }
}

