/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class S3dPrimitiveTriStrip {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 3;
    public static final int BOTTOM_RIGHT = 6;
    public static final int BOTTOM_LEFT = 9;
    static VertexBuffer[] cacheVertexBuffers;
    static IndexBuffer[] cacheIndexBuffers;
    static boolean[] cacheInUseVB;
    static boolean[] cacheInUseIB;
    static int lockedVertexBufferHandle;
    static int lockedIndexBufferHandle;
    static VertexArray lockedVBQuadVertices;
    static VertexArray lockedVBQuadUVCoordinates;
    static int lockedVBCurrentVertexIndex;
    static byte[] lockedVBQuadUVCoordinateData;
    static short[] lockedVBVertexData;
    static int nextFreeSlotVB;
    static int nextFreeSlotIB;
    static float repeat;
    static S3dResource vtxTexture;
    static int currentUVIndex;
    static int lx;
    static int ly;
    static int lz;
    static int lx2;
    static int ly2;
    static int lz2;

    public static void createCache(int n) {
        cacheVertexBuffers = new VertexBuffer[n];
        cacheIndexBuffers = new IndexBuffer[n];
        cacheInUseVB = new boolean[n];
        cacheInUseIB = new boolean[n];
    }

    public static void release() {
        int n;
        for (n = 0; n < cacheInUseVB.length; ++n) {
            if (!cacheInUseVB[n]) continue;
            S3dPrimitiveTriStrip.releaseDynamicVB(n);
        }
        for (n = 0; n < cacheInUseIB.length; ++n) {
            if (!cacheInUseIB[n]) continue;
            S3dPrimitiveTriStrip.releaseDynamicIB(n);
        }
        nextFreeSlotVB = 0;
        nextFreeSlotIB = 0;
        cacheVertexBuffers = null;
        cacheIndexBuffers = null;
        cacheInUseVB = null;
        cacheInUseIB = null;
    }

    public static String getReportStats() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < cacheInUseVB.length; ++n) {
            if (!cacheInUseVB[n]) continue;
            ++n2;
        }
        for (n = 0; n < cacheInUseIB.length; ++n) {
            if (!cacheInUseIB[n]) continue;
            ++n3;
        }
        return "Tri:vb=" + n2 + " ib=" + n3;
    }

    private static IndexBuffer buildDynamicIB(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 4;
        }
        return new TriangleStripArray(0, nArray);
    }

    public static VertexBuffer buildDynamicVB() {
        return new VertexBuffer();
    }

    protected static int getNextFreeVB() {
        int n;
        for (n = nextFreeSlotVB; n < cacheInUseVB.length; ++n) {
            if (cacheInUseVB[n]) continue;
            return n;
        }
        for (n = 0; n < nextFreeSlotVB; ++n) {
            if (cacheInUseVB[n]) continue;
            return n;
        }
        return -1;
    }

    protected static int getNextFreeIB() {
        int n;
        for (n = nextFreeSlotIB; n < cacheInUseIB.length; ++n) {
            if (cacheInUseIB[n]) continue;
            return n;
        }
        for (n = 0; n < nextFreeSlotIB; ++n) {
            if (cacheInUseIB[n]) continue;
            return n;
        }
        return -1;
    }

    public static int createDynamicVB() {
        int n = S3dPrimitiveTriStrip.getNextFreeVB();
        if (n != -1) {
            S3dPrimitiveTriStrip.cacheInUseVB[n] = true;
            nextFreeSlotVB = n;
            return nextFreeSlotVB;
        }
        return -1;
    }

    public static int createDynamicIB() {
        int n = S3dPrimitiveTriStrip.getNextFreeIB();
        if (n != -1) {
            S3dPrimitiveTriStrip.cacheInUseIB[n] = true;
            nextFreeSlotIB = n;
            return nextFreeSlotIB;
        }
        return -1;
    }

    public static boolean isVBValid(int n) {
        return n >= 0 && n < cacheInUseVB.length ? cacheInUseVB[n] : false;
    }

    public static VertexBuffer getVertexBuffer(int n) {
        return cacheVertexBuffers[n];
    }

    public static IndexBuffer getIndexBuffer(int n) {
        return cacheIndexBuffers[n];
    }

    public static int begin(S3dResource s3dResource, int n) {
        lockedVertexBufferHandle = S3dPrimitiveTriStrip.createDynamicVB();
        lockedIndexBufferHandle = S3dPrimitiveTriStrip.createDynamicIB();
        lockedVBCurrentVertexIndex = 0;
        currentUVIndex = 0;
        vtxTexture = s3dResource;
        repeat = 1.0f;
        int n2 = n * 4;
        S3dPrimitiveTriStrip.cacheVertexBuffers[S3dPrimitiveTriStrip.lockedVertexBufferHandle] = S3dPrimitiveTriStrip.buildDynamicVB();
        S3dPrimitiveTriStrip.cacheIndexBuffers[S3dPrimitiveTriStrip.lockedIndexBufferHandle] = S3dPrimitiveTriStrip.buildDynamicIB(n);
        lockedVBQuadVertices = new VertexArray(n2, 3, 2);
        lockedVBQuadUVCoordinates = new VertexArray(n2, 2, 1);
        lockedVBQuadUVCoordinateData = new byte[n2 * 2];
        lockedVBVertexData = new short[n2 * 3];
        return lockedVertexBufferHandle;
    }

    public static void startNewRow(int n, int n2, int n3, int n4, int n5, int n6) {
        lx = n;
        ly = n2;
        lz = n3;
        lx2 = n4;
        ly2 = n5;
        lz2 = n6;
    }

    public static void addTriStripSplit(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        if (n3 > n2) {
            repeat = 1.0f * (float)n3 / (float)n2;
        }
        if (n2 == 1 && n4 == 1) {
            S3dPrimitiveTriStrip.add(n, 1, 1, 1, 1, 1, false, n6, n7, n8, n9, n10, n11);
            return;
        }
        int n12 = lx;
        int n13 = ly;
        int n14 = lz;
        int n15 = lx2;
        int n16 = ly2;
        int n17 = lz2;
        for (int i = 0; i < n4; ++i) {
            int n18 = GluInt.rescale(i, 0, n4, n12, n15);
            int n19 = GluInt.rescale(i, 0, n4, n13, n16);
            int n20 = GluInt.rescale(i, 0, n4, n14, n17);
            int n21 = GluInt.rescale(i + 1, 0, n4, n12, n15);
            int n22 = GluInt.rescale(i + 1, 0, n4, n13, n16);
            int n23 = GluInt.rescale(i + 1, 0, n4, n14, n17);
            int n24 = GluInt.rescale(i, 0, n4, n6, n9);
            int n25 = GluInt.rescale(i, 0, n4, n7, n10);
            int n26 = GluInt.rescale(i, 0, n4, n8, n11);
            int n27 = GluInt.rescale(i + 1, 0, n4, n6, n9);
            int n28 = GluInt.rescale(i + 1, 0, n4, n7, n10);
            int n29 = GluInt.rescale(i + 1, 0, n4, n8, n11);
            S3dPrimitiveTriStrip.startNewRow(n18, n19, n20, n21, n22, n23);
            for (int j = 1; j <= n2; ++j) {
                int n30 = GluInt.rescale(j, 0, n2, n18, n24);
                int n31 = GluInt.rescale(j, 0, n2, n19, n25);
                int n32 = GluInt.rescale(j, 0, n2, n20, n26);
                int n33 = GluInt.rescale(j, 0, n2, n21, n27);
                int n34 = GluInt.rescale(j, 0, n2, n22, n28);
                int n35 = GluInt.rescale(j, 0, n2, n23, n29);
                S3dPrimitiveTriStrip.add(n, i * n2 + j, n2, n3, n4, n5, false, n30, n31, n32, n33, n34, n35);
            }
        }
        lx = n6;
        ly = n7;
        lz = n8;
        lx2 = n9;
        ly2 = n10;
        lz2 = n11;
    }

    public static void add(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, int n8, int n9, int n10, int n11, int n12) {
        S3dPrimitiveTriStrip.lockedVBVertexData[S3dPrimitiveTriStrip.lockedVBCurrentVertexIndex++] = (short)lx;
        S3dPrimitiveTriStrip.lockedVBVertexData[S3dPrimitiveTriStrip.lockedVBCurrentVertexIndex++] = (short)ly;
        S3dPrimitiveTriStrip.lockedVBVertexData[S3dPrimitiveTriStrip.lockedVBCurrentVertexIndex++] = (short)lz;
        S3dPrimitiveTriStrip.lockedVBVertexData[S3dPrimitiveTriStrip.lockedVBCurrentVertexIndex++] = (short)lx2;
        S3dPrimitiveTriStrip.lockedVBVertexData[S3dPrimitiveTriStrip.lockedVBCurrentVertexIndex++] = (short)ly2;
        S3dPrimitiveTriStrip.lockedVBVertexData[S3dPrimitiveTriStrip.lockedVBCurrentVertexIndex++] = (short)lz2;
        S3dPrimitiveTriStrip.lockedVBVertexData[S3dPrimitiveTriStrip.lockedVBCurrentVertexIndex++] = (short)n7;
        S3dPrimitiveTriStrip.lockedVBVertexData[S3dPrimitiveTriStrip.lockedVBCurrentVertexIndex++] = (short)n8;
        S3dPrimitiveTriStrip.lockedVBVertexData[S3dPrimitiveTriStrip.lockedVBCurrentVertexIndex++] = (short)n9;
        S3dPrimitiveTriStrip.lockedVBVertexData[S3dPrimitiveTriStrip.lockedVBCurrentVertexIndex++] = (short)n10;
        S3dPrimitiveTriStrip.lockedVBVertexData[S3dPrimitiveTriStrip.lockedVBCurrentVertexIndex++] = (short)n11;
        S3dPrimitiveTriStrip.lockedVBVertexData[S3dPrimitiveTriStrip.lockedVBCurrentVertexIndex++] = (short)n12;
        lx = n7;
        ly = n8;
        lz = n9;
        lx2 = n10;
        ly2 = n11;
        lz2 = n12;
        int n13 = (n2 - 1) % n3 + 1;
        int n14 = (n2 - 1) / n3 + 1;
        if (vtxTexture != null) {
            vtxTexture.fillRegionData(n, lockedVBQuadUVCoordinateData, currentUVIndex);
            if (bl) {
                int n15;
                byte by = lockedVBQuadUVCoordinateData[currentUVIndex + 1];
                byte by2 = lockedVBQuadUVCoordinateData[currentUVIndex + 5];
                int[] nArray = new int[]{1, 3};
                int[] nArray2 = new int[]{5, 7};
                for (n15 = 0; n15 < 2; ++n15) {
                    S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + nArray[n15]] = (byte)(by + (by2 - by) * (n13 - 1) / n3);
                    S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + nArray2[n15]] = (byte)(by + (by2 - by) * n13 / n3);
                }
                n15 = lockedVBQuadUVCoordinateData[currentUVIndex + 6];
                byte by3 = lockedVBQuadUVCoordinateData[currentUVIndex + 7];
                int[] nArray3 = new int[]{6, 0, 0, 2, 2, 4};
                for (int i = 0; i < nArray3.length; i += 2) {
                    S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + nArray3[i]] = lockedVBQuadUVCoordinateData[currentUVIndex + nArray3[i + 1]];
                    S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + nArray3[i] + 1] = lockedVBQuadUVCoordinateData[currentUVIndex + nArray3[i + 1] + 1];
                }
                S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + 4] = n15;
                S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + 5] = by3;
            } else if (n3 > n4 && n3 != 1) {
                n13 = (n13 - 1) % (n3 / n4) + 1;
                n14 = (n14 - 1) % (n5 / n6) + 1;
                byte by = lockedVBQuadUVCoordinateData[currentUVIndex + 0];
                byte by4 = lockedVBQuadUVCoordinateData[currentUVIndex + 4];
                byte by5 = lockedVBQuadUVCoordinateData[currentUVIndex + 1];
                byte by6 = lockedVBQuadUVCoordinateData[currentUVIndex + 3];
                byte by7 = (byte)(by + (by4 - by) * (n13 - 1) * n4 / n3);
                S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + 2] = by7;
                S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + 0] = by7;
                byte by8 = (byte)(by + (by4 - by) * n13 * n4 / n3);
                S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + 6] = by8;
                S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + 4] = by8;
                byte by9 = (byte)(by5 + (by6 - by5) * (n14 - 1) * n6 / n5);
                S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + 5] = by9;
                S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + 1] = by9;
                byte by10 = (byte)(by5 + (by6 - by5) * n14 * n6 / n5);
                S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + 7] = by10;
                S3dPrimitiveTriStrip.lockedVBQuadUVCoordinateData[S3dPrimitiveTriStrip.currentUVIndex + 3] = by10;
            }
            currentUVIndex += 8;
        }
    }

    public static void end() {
        VertexBuffer vertexBuffer = S3dPrimitiveTriStrip.getVertexBuffer(lockedVertexBufferHandle);
        lockedVBQuadVertices.set(0, lockedVBCurrentVertexIndex / 3, lockedVBVertexData);
        vertexBuffer.setPositions(lockedVBQuadVertices, 1.0f, null);
        if (vtxTexture != null) {
            lockedVBQuadUVCoordinates.set(0, currentUVIndex / 2, lockedVBQuadUVCoordinateData);
            float[] fArray = new float[]{0.5019608f, 0.5019608f};
            float f = repeat / 255.0f;
            vertexBuffer.setTexCoords(0, lockedVBQuadUVCoordinates, f, fArray);
        }
    }

    public static void setVertexColours(int n, byte[] byArray) {
        VertexArray vertexArray = new VertexArray(byArray.length / 4, 4, 1);
        vertexArray.set(0, byArray.length / 4, byArray);
        if (n < 0) {
            n = lockedVertexBufferHandle;
        }
        VertexBuffer vertexBuffer = S3dPrimitiveTriStrip.getVertexBuffer(n);
        vertexBuffer.setColors(vertexArray);
    }

    public static void setDefaultColor(int n) {
        cacheVertexBuffers[lockedVertexBufferHandle].setDefaultColor(n);
    }

    public static void releaseDynamicVB(int n) {
        S3dPrimitiveTriStrip.cacheInUseVB[n] = false;
    }

    public static void releaseDynamicVB(VertexBuffer vertexBuffer) {
        for (int i = 0; i < cacheInUseVB.length; ++i) {
            if (cacheVertexBuffers[i] != vertexBuffer) continue;
            S3dPrimitiveTriStrip.releaseDynamicVB(i);
            return;
        }
    }

    public static void releaseDynamicIB(int n) {
        S3dPrimitiveTriStrip.cacheInUseIB[n] = false;
    }

    public static void releaseDynamicIB(IndexBuffer indexBuffer) {
        for (int i = 0; i < cacheInUseIB.length; ++i) {
            if (cacheIndexBuffers[i] != indexBuffer) continue;
            S3dPrimitiveTriStrip.releaseDynamicIB(i);
            return;
        }
    }

    protected static int vtxOffset(int n, int n2) {
        return n * 4 * 3 + n2;
    }

    public static S3dResource createResource(S3dAppearance s3dAppearance) {
        VertexBuffer vertexBuffer = S3dPrimitiveTriStrip.getVertexBuffer(lockedVertexBufferHandle);
        IndexBuffer indexBuffer = S3dPrimitiveTriStrip.getIndexBuffer(lockedIndexBufferHandle);
        S3dResource s3dResource = S3dResource.create(false);
        s3dResource.createStaticMesh(vertexBuffer, indexBuffer, s3dAppearance);
        return s3dResource;
    }

    public static void render(int n, int n2, S3dAppearance s3dAppearance, Transform transform) {
        S3dGfxDriver.g3d.render(cacheVertexBuffers[n], cacheIndexBuffers[n2], s3dAppearance.app, transform);
    }

    static {
        nextFreeSlotVB = 0;
        nextFreeSlotIB = 0;
        repeat = 0.0f;
    }
}

