/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.screens;

import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.util.KeyCodeAdapter;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class SoundConfigScreen
extends Canvas
implements Runnable {
    public static final byte DIALOG_RESULT__NO = 0;
    public static final byte DIALOG_RESULT__YES = 1;
    private MIDlet midlet;
    private Displayable previousScreen;
    private Thread thread;
    private boolean exit = false;
    private byte dialogResult;
    private final Image enableSounds;
    private final Image yes;
    private final Image no;

    public SoundConfigScreen(MIDlet midlet) {
        this.midlet = midlet;
        this.previousScreen = Display.getDisplay((MIDlet)midlet).getCurrent();
        this.setFullScreenMode(true);
        this.enableSounds = JBManager.getInstance().getTextImage("ENABLE SOUNDS?", "10x10");
        if (KeyCodeAdapter.getInstance().getPlatformName().equals("blackberry")) {
            this.yes = JBManager.getInstance().getTextImage("YES (q)", "10x10");
            this.no = JBManager.getInstance().getTextImage("NO (p)", "10x10");
        } else {
            this.yes = JBManager.getInstance().getTextImage("YES", "10x10");
            this.no = JBManager.getInstance().getTextImage("NO", "10x10");
        }
    }

    public byte getDialogResult() {
        return this.dialogResult;
    }

    public void show() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void waitForClose() {
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    protected void keyPressed(int keyCode) {
        keyCode = KeyCodeAdapter.getInstance().adoptKeyCode(keyCode);
        switch (keyCode) {
            case -201: {
                this.dialogResult = 1;
                this.exit = true;
                break;
            }
            case -202: {
                this.dialogResult = 0;
                this.exit = true;
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        if (x < 50 && y > this.getHeight() - 50) {
            this.dialogResult = 1;
            this.exit = true;
        } else if (x > this.getWidth() - 50 && y > this.getHeight() - 50) {
            this.dialogResult = 0;
            this.exit = true;
        }
    }

    protected void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.enableSounds, this.getWidth() / 2, this.getHeight() / 2, 3);
        g.drawImage(this.yes, 0, this.getHeight(), 36);
        g.drawImage(this.no, this.getWidth(), this.getHeight(), 40);
    }

    public void run() {
        while (!this.exit) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent(this.previousScreen);
    }
}

