/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.tools;

import com.jarbull.mgs.game.ingame.Ball;
import com.jarbull.mgs.game.ingame.GolfCourse;
import com.jarbull.mgs.game.ingame.Hole;
import com.jarbull.mgs.game.ingame.Nail;
import com.jarbull.mgs.game.ingame.Sand;
import com.jarbull.mgs.game.ingame.SpecialSod;
import com.jarbull.mgs.game.ingame.Wall;
import com.jarbull.mgs.game.ingame.WormHole;
import com.jarbull.mgs.math.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class LevelLoader {
    public static final int COLOR_TOLERANCE = 16;
    private static final int COLOR_CODE_ORDER__EMPTY = 0;
    private static final int COLOR_CODE_ORDER__BORDER = 2;
    private static final int COLOR_CODE_ORDER__WALL = 3;
    private static final int COLOR_CODE_ORDER__NAIL = 4;
    private static final int COLOR_CODE_ORDER__BALL = 5;
    private static final int COLOR_CODE_ORDER__HOLE = 6;
    private static final int COLOR_CODE_ORDER__SAND = 7;
    private static final int COLOR_CODE_ORDER__SOD_RIGHT = 8;
    private static final int COLOR_CODE_ORDER__SOD_DOWN = 11;
    private static final int COLOR_CODE_ORDER__WORM_HOLE_RIGHT = 12;
    private static final int COLOR_CODE_ORDER__WORM_HOLE_DOWN = 15;
    private static final int COLOR_CODE_ORDER__EXTRA_FLOWER_PINK = 16;
    private static final int COLOR_CODE_ORDER__EXTRA_WATER = 26;
    private int level;
    private int[] colorCodes;
    private int[] levelMapPixels;
    private int LEVEL_COLUMNS;
    private int LEVEL_ROWS;
    private static LevelLoader instance = new LevelLoader();

    public static LevelLoader getInstance() {
        return instance;
    }

    private LevelLoader() {
        try {
            Image colorCodeImage = Image.createImage((String)"/res/image/level/colorcodes.png");
            this.colorCodes = new int[colorCodeImage.getWidth() * colorCodeImage.getHeight()];
            colorCodeImage.getRGB(this.colorCodes, 0, colorCodeImage.getWidth(), 0, 0, colorCodeImage.getWidth(), colorCodeImage.getHeight());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setLevel(int level) throws IOException {
        this.level = level;
        this.prepareLevelImageArray();
    }

    public int getPar() {
        return this.getPar(this.level);
    }

    public int getPar(int level) {
        StringBuffer fileContent = new StringBuffer();
        try {
            InputStream in = this.getClass().getResourceAsStream("/res/text/level/par.txt");
            byte[] buffer = new byte[18];
            in.read(buffer, 0, buffer.length);
            fileContent.append(new String(buffer));
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Integer.parseInt(fileContent.toString().substring(level - 1, level));
    }

    private int getColorCode(int colorCodeOrder) throws IOException {
        return this.colorCodes[colorCodeOrder] & 0xFFFFFF;
    }

    private void prepareLevelImageArray() throws IOException {
        this.levelMapPixels = null;
        Image levelMap = Image.createImage((String)("/res/image/level/" + this.level + ".png"));
        this.levelMapPixels = new int[levelMap.getWidth() * levelMap.getHeight()];
        levelMap.getRGB(this.levelMapPixels, 0, levelMap.getWidth(), 0, 0, levelMap.getWidth(), levelMap.getHeight());
        this.LEVEL_COLUMNS = levelMap.getWidth();
        this.LEVEL_ROWS = levelMap.getHeight();
    }

    public Rectangle getMapSize() throws IOException {
        Image levelMap = Image.createImage((String)("/res/image/level/" + this.level + ".png"));
        Rectangle rectangle = new Rectangle();
        rectangle.width = levelMap.getWidth() * 10;
        rectangle.height = levelMap.getHeight() * 10;
        return rectangle;
    }

    private boolean checkColorEquality(int color1, int color2) {
        int redPart1 = color1 >> 16 & 0xFF;
        int greenPart1 = color1 >> 8 & 0xFF;
        int bluePart1 = color1 & 0xFF;
        int redPart2 = color2 >> 16 & 0xFF;
        int greenPart2 = color2 >> 8 & 0xFF;
        int bluePart2 = color2 & 0xFF;
        return redPart1 > redPart2 - 16 && redPart1 < redPart2 + 16 && greenPart1 > greenPart2 - 16 && greenPart1 < greenPart2 + 16 && bluePart1 > bluePart2 - 16 && bluePart1 < bluePart2 + 16;
    }

    public int[] loadMap() throws IOException {
        int row;
        int column;
        int i;
        int borderColor = this.getColorCode(2);
        int emptyColor = this.getColorCode(0);
        int[] levelTiles = new int[this.LEVEL_COLUMNS * this.LEVEL_ROWS];
        for (i = 0; i < levelTiles.length; ++i) {
            column = i % this.LEVEL_COLUMNS;
            row = (i - column) / this.LEVEL_COLUMNS;
            int color = this.levelMapPixels[i] & 0xFFFFFF;
            if (this.checkColorEquality(color, borderColor)) {
                levelTiles[row * this.LEVEL_COLUMNS + column] = 1;
                continue;
            }
            if (this.checkColorEquality(color, emptyColor) || levelTiles[row * this.LEVEL_COLUMNS + column - 1] == 0) continue;
            if (levelTiles[row * this.LEVEL_COLUMNS + column - 1] > 2) {
                if (levelTiles[(row - 1) * this.LEVEL_COLUMNS + column] > 2 && levelTiles[(row - 1) * this.LEVEL_COLUMNS + column] < 13) {
                    levelTiles[row * this.LEVEL_COLUMNS + column] = 4 + levelTiles[(row - 1) * this.LEVEL_COLUMNS + column];
                    continue;
                }
                levelTiles[row * this.LEVEL_COLUMNS + column] = 3 + (levelTiles[row * this.LEVEL_COLUMNS + column - 1] - 2) % 4;
                continue;
            }
            levelTiles[row * this.LEVEL_COLUMNS + column] = 3;
        }
        for (i = 0; i < levelTiles.length; ++i) {
            column = i % this.LEVEL_COLUMNS;
            row = (i - column) / this.LEVEL_COLUMNS;
            int up = (row - 1) * this.LEVEL_COLUMNS + column;
            int left = row * this.LEVEL_COLUMNS + column - 1;
            int right = row * this.LEVEL_COLUMNS + column + 1;
            int down = (row + 1) * this.LEVEL_COLUMNS + column;
            up = up < 0 ? -1 : up;
            left = left < 0 ? -1 : left;
            right = right >= (row + 1) * this.LEVEL_COLUMNS ? -1 : right;
            int n = down = down >= this.LEVEL_ROWS * this.LEVEL_COLUMNS ? -1 : down;
            if (levelTiles[i] != 1 || !(down != -1 && (levelTiles[down] == 1 || levelTiles[down] == 2) && levelTiles[down] != 0 || up != -1 && levelTiles[up] > 2 && (left != -1 && levelTiles[left] > 2 || right != -1 && levelTiles[right] > 2)) && (up == -1 || levelTiles[up] != 1 || down == -1 || levelTiles[down] <= 2 || levelTiles[down] == 0)) continue;
            levelTiles[left + 1] = 2;
        }
        return levelTiles;
    }

    private Vector loadObjects(int color) {
        Vector<Rectangle> vector = new Vector<Rectangle>();
        for (int i = 0; i < this.LEVEL_COLUMNS * this.LEVEL_ROWS; ++i) {
            if (!this.checkColorEquality(this.levelMapPixels[i] & 0xFFFFFF, color) || this.checkColorEquality(this.levelMapPixels[i - 1] & 0xFFFFFF, color) || this.checkColorEquality(this.levelMapPixels[i - this.LEVEL_COLUMNS] & 0xFFFFFF, color)) continue;
            int column = i % this.LEVEL_COLUMNS;
            int row = (i - column) / this.LEVEL_COLUMNS;
            Rectangle rectangle = new Rectangle();
            rectangle.x = column * 10;
            rectangle.y = row * 10;
            int j = i;
            while (true) {
                if (!this.checkColorEquality(this.levelMapPixels[j] & 0xFFFFFF, color)) break;
                ++j;
            }
            rectangle.width = (j - i) * 10;
            j = i;
            while (true) {
                if (!this.checkColorEquality(this.levelMapPixels[j] & 0xFFFFFF, color)) break;
                j += this.LEVEL_COLUMNS;
            }
            rectangle.height = (j - i) / this.LEVEL_COLUMNS * 10;
            vector.addElement(rectangle);
        }
        return vector;
    }

    public Wall[] loadWalls(GolfCourse golfCourse) throws IOException {
        Vector wallRectangles = this.loadObjects(this.getColorCode(3));
        Wall[] walls = new Wall[wallRectangles.size()];
        for (int i = 0; i < walls.length; ++i) {
            Rectangle wallRectangle = (Rectangle)wallRectangles.elementAt(i);
            walls[i] = new Wall(golfCourse, wallRectangle.width, wallRectangle.height, wallRectangle.x, wallRectangle.y);
        }
        return walls;
    }

    public WormHole[] loadWormHoles(GolfCourse golfCourse) throws IOException {
        Vector singleWormHoleRectangles = new Vector();
        Vector<Integer> singleWormHoleDirections = new Vector<Integer>();
        for (int j = 12; j <= 15; ++j) {
            Vector wormHoleRectangles = this.loadObjects(this.getColorCode(j));
            for (int i = 0; i < wormHoleRectangles.size(); ++i) {
                singleWormHoleRectangles.addElement(wormHoleRectangles.elementAt(i));
                singleWormHoleDirections.addElement(new Integer(j));
            }
        }
        WormHole[] wormHoles = new WormHole[singleWormHoleRectangles.size() / 2];
        for (int j = 0; j < singleWormHoleRectangles.size(); j += 2) {
            Rectangle wormHoleRectangle1 = (Rectangle)singleWormHoleRectangles.elementAt(j);
            Rectangle wormHoleRectangle2 = (Rectangle)singleWormHoleRectangles.elementAt(j + 1);
            wormHoles[j / 2] = new WormHole(golfCourse, wormHoleRectangle1.x, wormHoleRectangle1.y, (Integer)singleWormHoleDirections.elementAt(j) - 11, wormHoleRectangle2.x, wormHoleRectangle2.y, (Integer)singleWormHoleDirections.elementAt(j + 1) - 11);
        }
        return wormHoles;
    }

    public Nail[] loadNails(GolfCourse golfCourse) throws IOException {
        Vector nailRectangles = this.loadObjects(this.getColorCode(4));
        Nail[] nails = new Nail[nailRectangles.size()];
        for (int i = 0; i < nails.length; ++i) {
            Rectangle nailRectangle = (Rectangle)nailRectangles.elementAt(i);
            nails[i] = new Nail(golfCourse, nailRectangle.x, nailRectangle.y);
        }
        return nails;
    }

    public Ball loadBall(GolfCourse golfCourse) throws IOException {
        Vector ballRectangles = this.loadObjects(this.getColorCode(5));
        Rectangle ballRectangle = (Rectangle)ballRectangles.elementAt(0);
        return new Ball(golfCourse, ballRectangle.x, ballRectangle.y);
    }

    public Hole loadHole(GolfCourse golfCourse) throws IOException {
        Vector holeRectangles = this.loadObjects(this.getColorCode(6));
        Rectangle holeRectangle = (Rectangle)holeRectangles.elementAt(0);
        return new Hole(golfCourse, holeRectangle.x, holeRectangle.y, true);
    }

    public Sand[] loadSands(GolfCourse golfCourse) throws IOException {
        Vector sandRectangles = this.loadObjects(this.getColorCode(7));
        Sand[] sands = new Sand[sandRectangles.size()];
        for (int i = 0; i < sands.length; ++i) {
            Rectangle sandRectangle = (Rectangle)sandRectangles.elementAt(i);
            sands[i] = new Sand(golfCourse, sandRectangle.width, sandRectangle.height, sandRectangle.x, sandRectangle.y);
        }
        return sands;
    }

    public SpecialSod[] loadSpecialSods(GolfCourse golfCourse) throws IOException {
        Vector allSpecialSodRectangles = new Vector();
        Vector<Integer> allSpecialSodDirections = new Vector<Integer>();
        for (int i = 8; i <= 11; ++i) {
            Vector specialSodRectangles = this.loadObjects(this.getColorCode(i));
            for (int j = 0; j < specialSodRectangles.size(); ++j) {
                allSpecialSodRectangles.addElement(specialSodRectangles.elementAt(j));
                allSpecialSodDirections.addElement(new Integer(i));
            }
        }
        SpecialSod[] specialSods = new SpecialSod[allSpecialSodRectangles.size()];
        for (int i = 0; i < specialSods.length; ++i) {
            Rectangle specialSodRectangle = (Rectangle)allSpecialSodRectangles.elementAt(i);
            specialSods[i] = new SpecialSod(golfCourse, specialSodRectangle.width, specialSodRectangle.height, specialSodRectangle.x, specialSodRectangle.y, (Integer)allSpecialSodDirections.elementAt(i) - 7);
        }
        return specialSods;
    }

    public Rectangle[] loadDecorations() throws IOException {
        Vector<Rectangle> allDecorations = new Vector<Rectangle>();
        for (int i = 16; i <= 26; ++i) {
            Vector decoration = this.loadObjects(this.getColorCode(i));
            for (int j = 0; j < decoration.size(); ++j) {
                Rectangle decorationRectangle = (Rectangle)decoration.elementAt(j);
                decorationRectangle.image = Image.createImage((String)("/res/image/ingame/" + i + ".png"));
                allDecorations.addElement(decorationRectangle);
            }
        }
        Object[] decorations = new Rectangle[allDecorations.size()];
        allDecorations.copyInto(decorations);
        return decorations;
    }
}

