/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.game.Actor;

public class ActorPool {
    private Actor firstFree;
    private Actor lastFree;
    private Actor firstUsed;
    private Actor oldestUsed;
    private Actor lastUsed;

    public ActorPool(Actor[] initObjects) {
        if (initObjects == null || initObjects.length < 2) {
            return;
        }
        this.firstFree = initObjects[0];
        this.lastFree = initObjects[initObjects.length - 1];
        for (int i = 0; i < initObjects.length; ++i) {
            if (i < initObjects.length - 1) {
                initObjects[i].setNextLinked(initObjects[i + 1]);
            } else {
                initObjects[i].setNextLinked(null);
            }
            if (i > 0) {
                initObjects[i].setPrevLinked(initObjects[i - 1]);
                continue;
            }
            initObjects[i].setPrevLinked(null);
        }
    }

    public Actor getNextFree() {
        if (this.firstFree != null) {
            if (this.firstFree.getNextLinked() != null) {
                this.firstFree.getNextLinked().setPrevLinked(null);
            }
            Actor newFirstFree = this.firstFree.getNextLinked();
            this.firstFree.setNextLinked(null);
            if (this.lastUsed != null) {
                this.firstFree.setPrevLinked(this.lastUsed);
                this.lastUsed.setNextLinked(this.firstFree);
            }
            this.lastUsed = this.firstFree;
            if (this.oldestUsed == null) {
                this.oldestUsed = this.firstFree;
            }
            if (this.firstUsed == null) {
                this.firstUsed = this.firstFree;
            }
            if (this.lastFree == this.firstFree) {
                this.lastFree = null;
            }
            Actor actorToReturn = this.firstFree;
            this.firstFree = newFirstFree;
            return actorToReturn;
        }
        Actor actorToReturn = this.oldestUsed;
        if (this.oldestUsed == null) {
            actorToReturn = this.oldestUsed = this.firstUsed;
        }
        this.oldestUsed = this.oldestUsed.getNextLinked();
        return actorToReturn;
    }

    public void release(Actor actorToRelease) {
        if (actorToRelease.getPrevLinked() != null) {
            actorToRelease.getPrevLinked().setNextLinked(actorToRelease.getNextLinked());
        }
        if (actorToRelease.getNextLinked() != null) {
            actorToRelease.getNextLinked().setPrevLinked(actorToRelease.getPrevLinked());
        }
        if (this.oldestUsed == actorToRelease) {
            this.oldestUsed = actorToRelease.getNextLinked();
        }
        if (this.firstUsed == actorToRelease) {
            this.firstUsed = actorToRelease.getNextLinked();
        }
        if (this.lastUsed == actorToRelease) {
            this.lastUsed = actorToRelease.getPrevLinked();
        }
        actorToRelease.setNextLinked(null);
        if (this.firstFree == null) {
            this.firstFree = actorToRelease;
            actorToRelease.setPrevLinked(null);
        }
        if (this.lastFree != null) {
            actorToRelease.setPrevLinked(this.lastFree);
            this.lastFree.setNextLinked(actorToRelease);
        } else {
            actorToRelease.setPrevLinked(null);
        }
        this.lastFree = actorToRelease;
    }

    public Actor getFirstUsed() {
        return this.firstUsed;
    }
}

