/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.constants.Constants;
import com.manthanstudio.game.GameMenu;
import com.manthanstudio.game.GameWorld;
import com.manthanstudio.game.TextArea;
import com.manthanstudio.locale.Locale;
import com.manthanstudio.resource.ResManager;
import com.manthanstudio.tools.ImageSet;
import com.manthanstudio.tools.MathFP;
import com.manthanstudio.tools.SoundUtils;
import com.manthanstudio.tools.Sprite;
import com.manthanstudio.tools.UIFont;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends Canvas
implements Constants,
Runnable {
    private boolean isHideNotify = true;
    private int cps;
    private int cyclesThisSecond;
    private long lastCPSTime = 0L;
    private long cycleStartTime;
    private long timeSinceStart;
    private long lastCycleTime;
    private long msSinceLastCycle;
    private long logoStartTime = 0L;
    Sprite buttonSprite = null;
    Thread gameThread;
    boolean isDoubleBuffered;
    public static boolean hasPointerEvent;
    Graphics osg;
    Image osb;
    public static int keysPressed;
    public static int keysHold;
    public static int keysReleased;
    TextArea textArea;
    String lskSoftKey;
    String rskSoftKey;
    public static int canvasState;
    public int canvasPrevState = 0;
    String sizeChangeMsg = "";
    public Locale locale;
    private Image logo;
    Image splash;
    Image imgEyes = null;
    Sprite eyesSprite;
    private Image imgYes;
    private Image imgNo;
    SoundUtils soundUtils;
    public static boolean isSound;
    public static boolean isVibrate;
    GameMenu gameMenu;
    GameWorld gameWorld;
    boolean isSizeChange;
    public static int gameMode;
    public static boolean isLoading;
    public static int loadingPer;
    int keyCode;
    int row;
    int col;
    int tileNo = 0;
    int logo_ticks;
    int logo_fluff;
    private long fluff;
    private boolean isBlink;
    Image splashImage;

    public GameCanvas() {
        this.setFullScreenMode(true);
        MathFP.setPrecision(16);
        hasPointerEvent = this.hasPointerEvents();
        this.locale = Locale.getInstance();
        this.locale.init();
        this.isDoubleBuffered = false;
        if (!this.isDoubleBuffered) {
            this.osb = Image.createImage((int)240, (int)320);
            this.osg = this.osb.getGraphics();
        }
        UIFont.initFonts();
        this.soundUtils = new SoundUtils();
        this.textArea = new TextArea(this.locale.getMessage(33), 1, 240);
        this.lskSoftKey = this.locale.getMessage(20);
        this.rskSoftKey = this.locale.getMessage(21);
        this.textArea.setPostion((240 - this.textArea.getWidth()) / 2, (320 - this.textArea.getHeight()) / 2);
        this.imgYes = ResManager.getImage(7, 1);
        this.imgNo = ResManager.getImage(8, 1);
        gameMode = 0;
        if (gameMode == 1) {
            this.isDoubleBuffered = false;
            this.sizeChangeMsg = this.locale.getMessage(46);
        } else {
            this.isDoubleBuffered = this.isDoubleBuffered();
            this.sizeChangeMsg = this.locale.getMessage(45);
        }
        if (!this.isDoubleBuffered) {
            this.osb = Image.createImage((int)240, (int)320);
            this.osg = this.osb.getGraphics();
        }
        this.init();
        isLoading = false;
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        while (currentThread == this.gameThread) {
            try {
                this.cycleStartTime = System.currentTimeMillis();
                this.msSinceLastCycle = System.currentTimeMillis() - this.lastCycleTime;
                this.processKey(this.msSinceLastCycle);
                this.cycle(this.msSinceLastCycle);
                this.repaint();
                if (System.currentTimeMillis() - this.lastCPSTime > 1000L) {
                    this.lastCPSTime = System.currentTimeMillis();
                    this.cps = this.cyclesThisSecond;
                    this.cyclesThisSecond = 0;
                } else {
                    ++this.cyclesThisSecond;
                }
                this.lastCycleTime = System.currentTimeMillis();
                this.timeSinceStart = this.cycleStartTime - System.currentTimeMillis();
                Thread.sleep(10L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void processKey(long deltaMS) {
        switch (canvasState) {
            case 0: {
                if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
                    isSound = true;
                    this.logo = ResManager.getImage(0, 0);
                    canvasState = 1;
                    this.logoStartTime = System.currentTimeMillis();
                    this.textArea.destroy();
                    this.textArea = null;
                } else if (GameCanvas.keyWasPressed(262144)) {
                    isSound = false;
                    this.logo = ResManager.getImage(0, 0);
                    canvasState = 1;
                    this.logoStartTime = System.currentTimeMillis();
                    this.textArea.destroy();
                    this.textArea = null;
                }
                GameCanvas.resetKeys();
                break;
            }
            case 1: {
                GameCanvas.resetKeys();
                break;
            }
            case 2: {
                if (isSound && !this.soundUtils.isPlaying() && !this.isHideNotify) {
                    this.soundUtils.stopSound((byte)0);
                    this.soundUtils.loadSound((byte)0);
                    this.soundUtils.playSound((byte)0, -1);
                }
                if (!(!GameCanvas.keyWasPressed(Integer.MIN_VALUE) || GameCanvas.keyWasPressed(0x200000) || GameCanvas.keyWasPressed(0x400000) || GameCanvas.keyWasPressed(0x800000) || GameCanvas.keyWasPressed(0x1000000) || GameCanvas.keyWasPressed(524288) || !GameCanvas.keyWasPressed(Integer.MIN_VALUE))) {
                    canvasState = 3;
                    this.loadMenu();
                    this.soundUtils.stopSound((byte)0);
                    ResManager.releaseImagesByCat(0);
                    ResManager.releaseImage(0, 1);
                }
                GameCanvas.resetKeys();
                break;
            }
            case 3: {
                this.gameMenu.processKeys();
                break;
            }
            case 4: {
                this.gameWorld.processKey();
                break;
            }
            case 5: {
                GameCanvas.resetKeys();
            }
        }
    }

    public void cycle(long deltaMS) {
        switch (canvasState) {
            case 0: {
                break;
            }
            case 1: {
                this.cycleCompanyLogo(deltaMS);
                if (System.currentTimeMillis() - this.logoStartTime <= 3000L) break;
                this.logo = null;
                ResManager.releaseImage(0, 0);
                this.splash = ResManager.getImage(0, 1);
                canvasState = 2;
                this.soundUtils.loadSound((byte)0);
                this.soundUtils.playSound((byte)0, -1);
                break;
            }
            case 2: {
                this.cycleTitleSplash(deltaMS);
                break;
            }
            case 3: {
                this.gameMenu.cycle(deltaMS);
                break;
            }
            case 4: {
                this.gameWorld.cycle(deltaMS);
                break;
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.isSizeChange) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            UIFont.drawString(graphics, this.sizeChangeMsg, (this.getWidth() - UIFont.stringWidth(this.sizeChangeMsg, (byte)1)) / 2, (this.getHeight() - UIFont.getHeight(1)) / 2, 1);
            return;
        }
        try {
            if (gameMode == 1) {
                if (this.isDoubleBuffered) {
                    this.renderer(graphics);
                } else {
                    this.renderer(this.osg);
                    graphics.drawImage(this.osb, 0, 0, 0);
                }
            } else if (this.isDoubleBuffered) {
                this.renderer(graphics);
            } else {
                this.renderer(this.osg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void renderer(Graphics g) {
        switch (canvasState) {
            case 0: {
                g.setColor(0);
                g.fillRect(0, 0, 240, 320);
                this.textArea.renderer(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 1: {
                this.drawCompanyLogo(g, 22, 113);
                break;
            }
            case 2: {
                this.renderTitleSplash(g);
                break;
            }
            case 3: {
                this.gameMenu.renderer(g);
                break;
            }
            case 4: {
                this.gameWorld.renderer(g);
                break;
            }
        }
    }

    public void loadMenu() {
        canvasState = 3;
        this.gameMenu = new GameMenu(this);
        this.gameMenu.loadMenu();
    }

    public void resumeMenu() {
        if (this.gameMenu != null) {
            this.gameMenu.reInit();
            this.gameMenu.resume();
            this.gameMenu.setScreenState(7);
        }
        canvasState = 3;
    }

    public void loadGame() {
        canvasState = 4;
        this.gameWorld = new GameWorld(this);
        this.gameWorld.loadGame();
    }

    public void unloadGame() {
        if (this.gameWorld != null) {
            // empty if block
        }
        this.gameWorld = null;
        System.gc();
    }

    public void pauseGame() {
        if (this.gameWorld != null) {
            this.gameWorld.pause();
            this.gameWorld.free();
        }
        if (this.gameMenu != null) {
            this.gameMenu.setScreenState(7);
            canvasState = 3;
        }
        System.gc();
    }

    public void resumeGame() {
        if (this.gameWorld != null) {
            this.gameWorld.reInit();
            this.gameWorld.resume();
        }
        canvasState = 4;
    }

    public void gameOver() {
        GameCanvas.resetKeys();
        if (isSound) {
            this.soundUtils.stopSound((byte)2);
            this.soundUtils.stopSound();
        }
        this.gameMenu.setScreenState(11);
        canvasState = 3;
        this.gameWorld.free();
    }

    protected void hideNotify() {
        this.isHideNotify = true;
        if (canvasState == 4) {
            if (this.soundUtils != null && this.soundUtils.isPlaying()) {
                this.soundUtils.stopSound();
                this.soundUtils.unloadSound();
            }
            this.pauseGame();
            this.resumeMenu();
        }
        this.stop();
        Thread.yield();
    }

    protected void showNotify() {
        Thread.yield();
        this.start();
        this.isHideNotify = false;
    }

    public void start() {
        if (this.gameThread == null) {
            this.gameThread = new Thread(this);
            this.lastCycleTime = System.currentTimeMillis();
            this.lastCPSTime = 0L;
            this.gameThread.start();
        }
        if (!isSound || canvasState != 2 || this.soundUtils != null) {
            // empty if block
        }
        GameCanvas.resetKeys();
    }

    public void stop() {
        if (isSound && this.soundUtils != null && this.soundUtils.player != null) {
            this.soundUtils.stopSound();
        }
        if (canvasState != 2) {
            this.gameThread = null;
        }
    }

    public void sizeChanged(int width, int height) {
        if (gameMode == 0) {
            if (width != 240) {
                this.isSizeChange = true;
                if (this.gameWorld != null && this.gameWorld.getState() != GameWorld.GAME_OVER && canvasState == 4) {
                    this.pauseGame();
                }
            } else {
                this.isSizeChange = false;
            }
        } else if (width == 240) {
            this.isSizeChange = true;
            if (this.gameWorld != null && this.gameWorld.getState() != GameWorld.GAME_OVER && canvasState == 4) {
                this.pauseGame();
            }
        } else {
            this.isSizeChange = false;
        }
    }

    public static boolean keyIsHeld(int key) {
        return (keysHold & key) != 0;
    }

    public static boolean keyWasPressed(int key) {
        return (keysPressed & key) != 0;
    }

    public static void resetKey(int key) {
        keysPressed &= ~key;
    }

    public static void resetKeys() {
        keysPressed = 0;
        keysHold = 0;
        keysReleased = 0;
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -22) {
            return;
        }
        this.keyCode = keyCode;
        keysPressed = GameCanvas.getKeyState(keyCode);
        keysHold |= keysPressed;
    }

    public void keyReleased(int keyCode) {
        if (keyCode == -22) {
            return;
        }
        keysReleased = GameCanvas.getKeyState(keyCode);
        keysHold &= ~keysReleased;
    }

    public static int getKeyState(int keyCode) {
        int key_state = 0;
        switch (keyCode) {
            case -1: {
                key_state = 1;
                break;
            }
            case -2: {
                key_state = 2;
                break;
            }
            case -4: {
                key_state = 4;
                break;
            }
            case -3: {
                key_state = 8;
                break;
            }
            case -5: {
                key_state = 16;
                break;
            }
            case 48: {
                key_state = 32;
                break;
            }
            case 49: {
                key_state = 64;
                break;
            }
            case 50: {
                key_state = 128;
                break;
            }
            case 51: {
                key_state = 256;
                break;
            }
            case 52: {
                key_state = 512;
                break;
            }
            case 53: {
                key_state = 1024;
                break;
            }
            case 54: {
                key_state = 2048;
                break;
            }
            case 55: {
                key_state = 4096;
                break;
            }
            case 56: {
                key_state = 8192;
                break;
            }
            case 57: {
                key_state = 16384;
                break;
            }
            case 42: {
                key_state = 32768;
                break;
            }
            case 35: {
                key_state = 65536;
                break;
            }
            case -6: {
                key_state = 131072;
                break;
            }
            case -7: {
                key_state = 262144;
                break;
            }
            case -22: {
                key_state = 524288;
                break;
            }
            case -11: {
                key_state = 0x100000;
                break;
            }
            case -36: {
                key_state = 0x200000;
                break;
            }
            case -37: {
                key_state = 0x400000;
                break;
            }
            case -44: {
                key_state = 0x800000;
                break;
            }
            case -43: {
                key_state = 0x1000000;
            }
        }
        return key_state |= Integer.MIN_VALUE;
    }

    public void paintLSK(Graphics g) {
        if (this.imgYes == null) {
            UIFont.drawString(g, this.lskSoftKey, 2, 320 - UIFont.getHeight(4), 4);
        } else {
            g.drawImage(this.imgYes, 2, 320 - this.imgYes.getHeight(), 0);
        }
    }

    public void paintRSK(Graphics g) {
        if (this.imgNo == null) {
            UIFont.drawString(g, this.rskSoftKey, 240 - UIFont.stringWidth(this.rskSoftKey, (byte)4) - 2, 320 - UIFont.getHeight(4), 4);
        } else {
            g.drawImage(this.imgNo, 240 - this.imgNo.getWidth() - 2, 320 - this.imgNo.getHeight(), 0);
        }
    }

    public void cycleCompanyLogo(long deltaMS) {
        this.logo_ticks = (int)(deltaMS + (long)this.logo_fluff) / 200;
        this.logo_fluff = (int)((long)this.logo_fluff + (deltaMS - (long)(this.logo_ticks * 200)));
        if (this.logo_ticks > 0 && this.tileNo < 5) {
            ++this.tileNo;
        }
    }

    public void drawCompanyLogo(Graphics g, int targetX, int targetY) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, 240, 320);
        this.row = this.logo.getHeight() / 94;
        this.col = this.logo.getWidth() / 209;
        g.setClip(targetX, targetY, 209, 94);
        g.drawImage(this.logo, targetX - this.tileNo % this.col * 209, targetY - this.tileNo / this.col % this.row * 94, 0);
        g.setClip(0, 0, 240, 320);
    }

    public void initTitleSplash() {
        this.imgEyes = ResManager.getImage(10, 1);
        int frameWidth = this.imgEyes.getWidth() / 9;
        int frameHeight = this.imgEyes.getHeight();
        ImageSet imageSet = new ImageSet(1);
        imageSet.addState(this.imgEyes, new int[]{150, 150, 150, 150, 150, 150, 150, 150, 150}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8});
        this.eyesSprite = new Sprite(imageSet, 0, 0);
        this.eyesSprite.setState(0, true);
        this.imgEyes = null;
        imageSet = null;
    }

    public void cycleTitleSplash(long deltaMS) {
        this.eyesSprite.cycle(deltaMS);
        long ticks = (deltaMS + this.fluff) / 300L;
        this.fluff += deltaMS - ticks * 300L;
        if (ticks > 0L) {
            this.isBlink = !this.isBlink;
        }
    }

    public void renderTitleSplash(Graphics g) {
        this.splashImage = ResManager.getImage(0, 1);
        if (this.splashImage != null) {
            g.drawImage(this.splashImage, 0, 320 - this.splashImage.getHeight(), 0);
            this.eyesSprite.draw(g, 163, 47);
            if (this.isBlink) {
                UIFont.drawString(g, this.locale.getMessage(1), 120 - UIFont.stringWidth(this.locale.getMessage(1), (byte)1) / 2, 290, 1);
            }
        }
    }

    public void init() {
        this.initTitleSplash();
    }

    public static final void debugMsg(String msg, Exception e) {
        if (msg != null) {
            // empty if block
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    static {
        canvasState = 0;
        isLoading = false;
        loadingPer = 0;
    }
}

