/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.constants.Constants;
import com.manthanstudio.game.Actor;
import com.manthanstudio.game.GameWorld;
import com.manthanstudio.resource.ResManager;
import com.manthanstudio.tools.ImageSet;
import com.manthanstudio.tools.Sprite;
import com.manthanstudio.tools.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Mouse
extends Actor {
    public int mouseState;
    public int[] mouseWeakPosX = new int[]{70, 105, 141, 54, 101, 146, 35, 95, 157};
    public int[] mouseWeakPosY = new int[]{183, 183, 183, 205, 205, 205, 232, 233, 233};
    public int[] mouseHealthyPosX = new int[]{66, 101, 135, 49, 94, 136, 29, 90, 151};
    public int[] mouseHealthyPosY = new int[]{182, 182, 182, 196, 196, 196, 227, 227, 227};
    private int randomMousePos;
    private long timeStateChanged;
    Image imgWeakMouse = null;
    Image imgHealthyMouse = null;
    Sprite weakMouseSpriteFirst;
    Sprite weakMouseSpriteSecond;
    Sprite weakMouseSpriteThird;
    Sprite healthyMouseSpriteFirst;
    Sprite healthyMouseSpriteSecond;
    Sprite healthyMouseSpriteThird;
    private long timeMouseShow;
    private long timeSinceMouseShow;
    private int mouseRandomDelay;
    public int strength = 1;

    public Mouse(GameWorld gameWorld, int type) {
        super(gameWorld, type);
    }

    public void init() {
        this.imgWeakMouse = ResManager.getImage(ResManager.IMAGE_MOUSE_SPRITE_CELL_FIRST, 2);
        int frameWidth = this.imgWeakMouse.getWidth() / 3;
        int frameHeight = this.imgWeakMouse.getHeight();
        ImageSet imageSet = new ImageSet(1);
        imageSet.addState(this.imgWeakMouse, new int[]{450, 450, 450}, new int[]{frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight}, new int[]{0, 2});
        imageSet.addState(this.imgWeakMouse, new int[]{450, 450, 450}, new int[]{frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight}, new int[]{0, 2});
        imageSet.addState(this.imgWeakMouse, new int[]{450, 450, 450}, new int[]{frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight}, new int[]{1});
        this.weakMouseSpriteFirst = new Sprite(imageSet, this.mouseState, 0);
        this.setState(0);
        this.imgWeakMouse = null;
        imageSet = null;
        this.imgWeakMouse = ResManager.getImage(ResManager.IMAGE_MOUSE_SPRITE_CELL_SECOND, 2);
        frameWidth = this.imgWeakMouse.getWidth() / 3;
        frameHeight = this.imgWeakMouse.getHeight();
        imageSet = new ImageSet(1);
        imageSet.addState(this.imgWeakMouse, new int[]{450, 450, 450}, new int[]{frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight}, new int[]{0, 2});
        imageSet.addState(this.imgWeakMouse, new int[]{450, 450, 450}, new int[]{frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight}, new int[]{0, 2});
        imageSet.addState(this.imgWeakMouse, new int[]{450, 450, 450}, new int[]{frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight}, new int[]{1});
        this.weakMouseSpriteSecond = new Sprite(imageSet, this.mouseState, 0);
        this.setState(0);
        this.imgWeakMouse = null;
        imageSet = null;
        this.imgWeakMouse = ResManager.getImage(ResManager.IMAGE_MOUSE_SPRITE_CELL_THIRD, 2);
        frameWidth = this.imgWeakMouse.getWidth() / 3;
        frameHeight = this.imgWeakMouse.getHeight();
        imageSet = new ImageSet(1);
        imageSet.addState(this.imgWeakMouse, new int[]{450, 450, 450}, new int[]{frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight}, new int[]{0, 2});
        imageSet.addState(this.imgWeakMouse, new int[]{450, 450, 450}, new int[]{frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight}, new int[]{0, 2});
        imageSet.addState(this.imgWeakMouse, new int[]{450, 450, 450}, new int[]{frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight}, new int[]{1});
        this.weakMouseSpriteThird = new Sprite(imageSet, this.mouseState, 0);
        this.setState(2);
        this.imgWeakMouse = null;
        imageSet = null;
        this.imgHealthyMouse = ResManager.getImage(ResManager.IMAGE_HEALTHY_MOUSE_SPRITE_ROW_FIRST, 2);
        frameWidth = this.imgHealthyMouse.getWidth() / 6;
        frameHeight = this.imgHealthyMouse.getHeight();
        imageSet = new ImageSet(1);
        imageSet.addState(this.imgHealthyMouse, new int[]{250, 250, 250, 250, 250, 250}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{0, 1, 2, 1, 0});
        imageSet.addState(this.imgHealthyMouse, new int[]{250, 250, 250, 250, 250, 250}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{4});
        imageSet.addState(this.imgHealthyMouse, new int[]{250, 250, 250, 250, 250, 250}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{5});
        this.healthyMouseSpriteFirst = new Sprite(imageSet, this.mouseState, 0);
        this.setState(0);
        this.imgHealthyMouse = null;
        imageSet = null;
        this.imgHealthyMouse = ResManager.getImage(ResManager.IMAGE_HEALTHY_MOUSE_SPRITE_ROW_SECOND, 2);
        frameWidth = this.imgHealthyMouse.getWidth() / 6;
        frameHeight = this.imgHealthyMouse.getHeight();
        imageSet = new ImageSet(1);
        imageSet.addState(this.imgHealthyMouse, new int[]{250, 250, 250, 250, 250, 250}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{0, 1, 2, 1, 0});
        imageSet.addState(this.imgHealthyMouse, new int[]{250, 250, 250, 250, 250, 250}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{4});
        imageSet.addState(this.imgHealthyMouse, new int[]{250, 250, 250, 250, 250, 250}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{5});
        this.healthyMouseSpriteSecond = new Sprite(imageSet, this.mouseState, 0);
        this.setState(0);
        this.imgHealthyMouse = null;
        imageSet = null;
        this.imgHealthyMouse = ResManager.getImage(ResManager.IMAGE_HEALTHY_MOUSE_SPRITE_ROW_THIRD, 2);
        frameWidth = this.imgHealthyMouse.getWidth() / 6;
        frameHeight = this.imgHealthyMouse.getHeight();
        imageSet = new ImageSet(1);
        imageSet.addState(this.imgHealthyMouse, new int[]{250, 250, 250, 250, 250, 250}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{0, 1, 2, 1, 0});
        imageSet.addState(this.imgHealthyMouse, new int[]{250, 250, 250, 250, 250, 250}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{4});
        imageSet.addState(this.imgHealthyMouse, new int[]{250, 250, 250, 250, 250, 250}, new int[]{frameWidth, frameWidth, frameWidth, frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight, frameHeight, frameHeight, frameHeight}, new int[]{5});
        this.healthyMouseSpriteThird = new Sprite(imageSet, this.mouseState, 0);
        this.setState(0);
        this.imgWeakMouse = null;
        imageSet = null;
        this.setVisible(true);
    }

    public void renderer(Graphics g) {
        if (this.isVisible()) {
            switch (this.type) {
                case 0: {
                    if (this.randomMousePos == 0 || this.randomMousePos == 1 || this.randomMousePos == 2) {
                        this.weakMouseSpriteFirst.draw(g, this.mouseWeakPosX[this.randomMousePos], this.mouseWeakPosY[this.randomMousePos]);
                        break;
                    }
                    if (this.randomMousePos == 3 || this.randomMousePos == 4 || this.randomMousePos == 5) {
                        this.weakMouseSpriteSecond.draw(g, this.mouseWeakPosX[this.randomMousePos], this.mouseWeakPosY[this.randomMousePos]);
                        break;
                    }
                    if (this.randomMousePos != 6 && this.randomMousePos != 7 && this.randomMousePos != 8) break;
                    this.weakMouseSpriteThird.draw(g, this.mouseWeakPosX[this.randomMousePos], this.mouseWeakPosY[this.randomMousePos]);
                    break;
                }
                case 1: {
                    if (this.randomMousePos == 0 || this.randomMousePos == 1 || this.randomMousePos == 2) {
                        this.healthyMouseSpriteFirst.draw(g, this.mouseHealthyPosX[this.randomMousePos], this.mouseHealthyPosY[this.randomMousePos]);
                        break;
                    }
                    if (this.randomMousePos == 3 || this.randomMousePos == 4 || this.randomMousePos == 5) {
                        this.healthyMouseSpriteSecond.draw(g, this.mouseHealthyPosX[this.randomMousePos], this.mouseHealthyPosY[this.randomMousePos]);
                        break;
                    }
                    if (this.randomMousePos != 6 && this.randomMousePos != 7 && this.randomMousePos != 8) break;
                    this.healthyMouseSpriteThird.draw(g, this.mouseHealthyPosX[this.randomMousePos], this.mouseHealthyPosY[this.randomMousePos]);
                }
            }
        }
    }

    public void cycle(long deltaMS) {
        switch (this.type) {
            case 0: {
                if (this.randomMousePos == 0 || this.randomMousePos == 1 || this.randomMousePos == 2) {
                    this.weakMouseSpriteFirst.cycle(deltaMS);
                    break;
                }
                if (this.randomMousePos == 3 || this.randomMousePos == 4 || this.randomMousePos == 5) {
                    this.weakMouseSpriteSecond.cycle(deltaMS);
                    break;
                }
                if (this.randomMousePos != 6 && this.randomMousePos != 7 && this.randomMousePos != 8) break;
                this.weakMouseSpriteThird.cycle(deltaMS);
                break;
            }
            case 1: {
                if (this.randomMousePos == 0 || this.randomMousePos == 1 || this.randomMousePos == 2) {
                    this.healthyMouseSpriteFirst.cycle(deltaMS);
                    break;
                }
                if (this.randomMousePos == 3 || this.randomMousePos == 4 || this.randomMousePos == 5) {
                    this.healthyMouseSpriteSecond.cycle(deltaMS);
                    break;
                }
                if (this.randomMousePos != 6 && this.randomMousePos != 7 && this.randomMousePos != 8) break;
                this.healthyMouseSpriteThird.cycle(deltaMS);
            }
        }
        this.timeSinceMouseShow = System.currentTimeMillis() - this.timeStateChanged;
        if (this.timeSinceMouseShow > (long)this.mouseRandomDelay) {
            if (this.mouseState == 0) {
                this.gameWorld.resetCount = 0;
                this.gameWorld.counterHits = 0;
            }
            this.gameWorld.releaseMouse(this);
        }
        if (this.mouseState == 0 || this.mouseState == 2) {
            // empty if block
        }
    }

    public void resetSprite() {
        this.weakMouseSpriteFirst.reset();
        this.weakMouseSpriteFirst.setState(0, true);
        this.healthyMouseSpriteFirst.reset();
        this.healthyMouseSpriteFirst.setState(0, true);
        this.weakMouseSpriteSecond.reset();
        this.weakMouseSpriteSecond.setState(0, true);
        this.healthyMouseSpriteSecond.reset();
        this.healthyMouseSpriteSecond.setState(0, true);
        this.weakMouseSpriteThird.reset();
        this.weakMouseSpriteThird.setState(0, true);
        this.healthyMouseSpriteThird.reset();
        this.healthyMouseSpriteThird.setState(0, true);
        this.setState(0);
    }

    public void setType(int type) {
        this.type = type;
        this.strength = type == 1 ? 2 : 1;
        this.setState(2 - this.strength);
        this.mouseRandomDelay = Tools.getRand(Constants.MIN_RANDOM_DELAY[this.gameWorld.level - 1], Constants.MAX_RANDOM_DELAY[this.gameWorld.level - 1]);
        this.timeMouseShow = System.currentTimeMillis();
        this.resetSprite();
    }

    public int getRandomMousePos() {
        return this.randomMousePos;
    }

    public void setRandomMousePos(int randomMousePos) {
        this.randomMousePos = randomMousePos;
    }

    public void setState(int state) {
        this.mouseState = state;
        switch (this.type) {
            case 0: {
                if (this.randomMousePos == 0 || this.randomMousePos == 1 || this.randomMousePos == 2) {
                    this.weakMouseSpriteFirst.setState(this.mouseState, true);
                    break;
                }
                if (this.randomMousePos == 3 || this.randomMousePos == 4 || this.randomMousePos == 5) {
                    this.weakMouseSpriteSecond.setState(this.mouseState, true);
                    break;
                }
                if (this.randomMousePos != 6 && this.randomMousePos != 7 && this.randomMousePos != 8) break;
                this.weakMouseSpriteThird.setState(this.mouseState, true);
                break;
            }
            case 1: {
                if (this.randomMousePos == 0 || this.randomMousePos == 1 || this.randomMousePos == 2) {
                    this.healthyMouseSpriteFirst.setState(this.mouseState, true);
                    break;
                }
                if (this.randomMousePos == 3 || this.randomMousePos == 4 || this.randomMousePos == 5) {
                    this.healthyMouseSpriteSecond.setState(this.mouseState, true);
                    break;
                }
                if (this.randomMousePos != 6 && this.randomMousePos != 7 && this.randomMousePos != 8) break;
                this.healthyMouseSpriteThird.setState(this.mouseState, true);
            }
        }
        this.timeStateChanged = System.currentTimeMillis();
    }
}

