/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.constants.Constants;
import com.manthanstudio.game.GameCanvas;
import com.manthanstudio.game.GameWorld;
import com.manthanstudio.game.Hammer;
import com.manthanstudio.game.TextArea;
import com.manthanstudio.locale.Locale;
import com.manthanstudio.midlet.GameMIDlet;
import com.manthanstudio.resource.ResManager;
import com.manthanstudio.tools.Bounds;
import com.manthanstudio.tools.ImageSet;
import com.manthanstudio.tools.Sprite;
import com.manthanstudio.tools.Tools;
import com.manthanstudio.tools.UIFont;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class GameMenu {
    GameCanvas gameCanvas;
    String[] strMainMenu = null;
    String[] strSettingMenu = null;
    String[] strPauseMenu = null;
    String[] strOptionSelection = null;
    Image imgMenuBg = null;
    Image imgOtherBg = null;
    Image imgMenuTitle = null;
    Image imgHighlighter = null;
    Image imgleftArrow = null;
    Image imgrightArrow = null;
    Image imgMainMenu = null;
    Image imgLoadingBg = null;
    Image imgStatisticeScreen = null;
    private Image imgSmallArrowUp;
    private Image imgSmallArrowDown;
    private Image imgYes;
    private Image imgNo;
    private Image imgBack;
    public static String soundOnOff;
    public static String vibrationOnOff;
    private String screenTitle = "";
    private int lskId;
    private int rskId;
    TextArea textArea;
    public Locale locale;
    public int screenState = -1;
    int prevState = -1;
    int itemYPadding = 8;
    int otherMenuIndex = 0;
    int mainMenuIndex = 0;
    int tempMenuIndex = 0;
    int numOfItems;
    int scrBottomItem;
    int menuStyle = 1001;
    int itemYPos;
    int numOfVisibleItems;
    int scrTopItem = 0;
    Bounds bounds;
    private int scoreYPadding;
    public static String playerName;
    private String strScore;
    public String[] playersName = Constants.PLAYERS_NAME;
    public int[] playersScores = Constants.PLAYERS_SCORE;
    Image imgStatCatGreat = null;
    Image imgStatCatAwesome = null;
    Image imgStatCatUncool = null;
    Sprite catSpriteGreat;
    Sprite catSpriteAwesome;
    Sprite catSpriteUncool;
    int moveStarY = 0;
    long starTicks = 0L;
    long starFluff = 0L;
    StringBuffer bufferEditBox;
    int cursorIndex;
    StringBuffer alphabets = new StringBuffer("_ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    int[] charIndexes = new int[6];
    TextArea msgBox_1;
    TextArea msgBox_2;
    int textBoxX;
    int textBoxY;
    int prevIndex = 0;
    int nextIndex = 0;
    int alignX = 0;
    byte menuFont;
    int menuTempIndex;

    public GameMenu(GameCanvas gameCanvas) {
        this.gameCanvas = gameCanvas;
        this.locale = Locale.getInstance();
        soundOnOff = this.locale.getMessage(35);
        vibrationOnOff = this.locale.getMessage(36);
        this.init();
        this.setScreenState(0);
    }

    public void loadMenu() {
        this.init();
        this.setScreenState(0);
    }

    public void init() {
        try {
            this.strMainMenu = new String[6];
            this.strMainMenu[0] = this.locale.getMessage(8);
            this.strMainMenu[1] = this.locale.getMessage(9);
            this.strMainMenu[2] = this.locale.getMessage(7);
            this.strMainMenu[3] = this.locale.getMessage(10);
            this.strMainMenu[4] = this.locale.getMessage(12);
            this.strMainMenu[5] = this.locale.getMessage(13);
            this.strSettingMenu = new String[3];
            soundOnOff = GameCanvas.isSound ? this.locale.getMessage(35) : this.locale.getMessage(36);
            GameCanvas.isVibrate = true;
            vibrationOnOff = this.locale.getMessage(37);
            this.strSettingMenu[0] = soundOnOff;
            this.strSettingMenu[1] = vibrationOnOff;
            this.strSettingMenu[2] = this.locale.getMessage(60);
            this.strPauseMenu = new String[4];
            this.strPauseMenu[0] = this.locale.getMessage(16);
            this.strPauseMenu[1] = soundOnOff;
            this.strPauseMenu[2] = vibrationOnOff;
            this.strPauseMenu[3] = this.locale.getMessage(17);
            this.reInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reInit() {
        try {
            this.imgMenuBg = ResManager.getImage(4, 1);
            this.imgOtherBg = ResManager.getImage(3, 1);
            this.imgStatisticeScreen = ResManager.getImage(9, 1);
            this.imgSmallArrowDown = ResManager.getImage(1, 1);
            this.imgSmallArrowUp = ResManager.getImage(2, 1);
            this.imgYes = ResManager.getImage(7, 1);
            this.imgNo = ResManager.getImage(8, 1);
            this.imgBack = ResManager.getImage(5, 1);
            this.imgStatCatGreat = ResManager.getImage(11, 1);
            int frameWidth = this.imgStatCatGreat.getWidth() / 3;
            int frameHeight = this.imgStatCatGreat.getHeight();
            ImageSet imageSet = new ImageSet(1);
            imageSet.addState(this.imgStatCatGreat, new int[]{300, 300, 1000}, new int[]{frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight}, new int[]{0, 1, 2});
            this.catSpriteGreat = new Sprite(imageSet, 0, 0);
            this.catSpriteGreat.setState(0, true);
            this.imgStatCatGreat = null;
            imageSet = null;
            this.imgStatCatAwesome = ResManager.getImage(12, 1);
            frameWidth = this.imgStatCatAwesome.getWidth() / 3;
            frameHeight = this.imgStatCatAwesome.getHeight();
            imageSet = new ImageSet(1);
            imageSet.addState(this.imgStatCatAwesome, new int[]{300, 300, 1000}, new int[]{frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight}, new int[]{0, 1, 2});
            this.catSpriteAwesome = new Sprite(imageSet, 0, 0);
            this.catSpriteAwesome.setState(0, true);
            this.imgStatCatAwesome = null;
            imageSet = null;
            this.imgStatCatUncool = ResManager.getImage(13, 1);
            frameWidth = this.imgStatCatUncool.getWidth() / 3;
            frameHeight = this.imgStatCatUncool.getHeight();
            imageSet = new ImageSet(1);
            imageSet.addState(this.imgStatCatUncool, new int[]{300, 300, 1000}, new int[]{frameWidth, frameWidth, frameWidth}, new int[]{frameHeight, frameHeight, frameHeight}, new int[]{0, 1, 2});
            this.catSpriteUncool = new Sprite(imageSet, 0, 0);
            this.catSpriteUncool.setState(0, true);
            this.imgStatCatUncool = null;
            Object var3_4 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cycle(long deltaMS) {
        switch (this.screenState) {
            case 0: {
                this.cycleMainMenu(deltaMS);
                break;
            }
            case 1: {
                this.cycleHelp(deltaMS);
                break;
            }
            case 2: {
                this.cycleHighScore(deltaMS);
                break;
            }
            case 3: {
                this.cycleSetting(deltaMS);
                break;
            }
            case 4: {
                this.cycleAbout(deltaMS);
                break;
            }
            case 5: {
                this.cycleCredit(deltaMS);
                break;
            }
            case 6: {
                this.cycleExit(deltaMS);
                break;
            }
            case 7: {
                this.cyclePauseMenu(deltaMS);
                break;
            }
            case 8: {
                this.cycleQuitToMenu(deltaMS);
                break;
            }
            case 9: {
                this.cycleAfterExit(deltaMS);
                break;
            }
            case 10: {
                this.cycleTips(deltaMS);
                break;
            }
            case 11: {
                this.cycleStatisticsScreen(deltaMS);
                break;
            }
            case 12: {
                this.cycleEnterUserName(deltaMS);
                break;
            }
            case 13: {
                this.cycleHighScoreMsg(deltaMS);
                break;
            }
            case 14: {
                this.cycleResetScore(deltaMS);
            }
        }
    }

    public void processKeys() {
        switch (this.screenState) {
            case 0: {
                this.processKeyMainMenu();
                GameCanvas.resetKeys();
                break;
            }
            case 2: {
                this.processKeyHighScore();
                GameCanvas.resetKeys();
                break;
            }
            case 1: {
                this.processKeyHelp();
                break;
            }
            case 3: {
                this.processKeySetting();
                GameCanvas.resetKeys();
                break;
            }
            case 4: {
                this.processKeyAbout();
                break;
            }
            case 5: {
                this.processKeyCredit();
                break;
            }
            case 6: {
                this.processKeyExit();
                GameCanvas.resetKeys();
                break;
            }
            case 7: {
                this.processKeyPauseMenu();
                break;
            }
            case 8: {
                this.processKeyQuitToMenu();
                break;
            }
            case 9: {
                this.processKeyAfterExit();
                break;
            }
            case 10: {
                this.processKeyTips();
                break;
            }
            case 11: {
                this.processKeyStatisticsScreen();
                GameCanvas.resetKeys();
                break;
            }
            case 12: {
                this.processKeysEnterUserName();
                GameCanvas.resetKeys();
                break;
            }
            case 13: {
                this.processKeyHighScoreMsg();
                GameCanvas.resetKeys();
                break;
            }
            case 14: {
                this.processKeyResetScore();
            }
        }
    }

    public void renderer(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        switch (this.screenState) {
            case 0: {
                this.paintMainMenu(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 1: {
                this.paintHelp(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 2: {
                this.paintHighScore(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 3: {
                this.paintSettingMenu(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 4: {
                this.paintAbout(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 5: {
                this.paintCredit(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 6: {
                this.paintExit(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 7: {
                this.paintPauseMenu(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 8: {
                this.paintQuitToMenu(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 9: {
                this.paintAfterExit(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 10: {
                this.paintTips(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 11: {
                this.paintStatisticsScreen(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 12: {
                this.paintEnterUserName(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 13: {
                this.paintHighScoreMsg(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 14: {
                this.paintResetScore(g);
                this.paintLSK(g);
                this.paintRSK(g);
            }
        }
    }

    public void paintMainMenu(Graphics g) {
        g.drawImage(ResManager.getImage(0, 1), 0, 0, 0);
        g.drawImage(ResManager.getImage(4, 1), 0, 0, 0);
        this.renderList(g, this.strMainMenu, this.menuStyle, 2, this.bounds, this.mainMenuIndex);
    }

    public void cycleMainMenu(long deltaMS) {
    }

    public void processKeyMainMenu() {
        if (this.menuStyle == 1001) {
            if (GameCanvas.keyWasPressed(1) || GameCanvas.keyWasPressed(128)) {
                if (this.mainMenuIndex > 0) {
                    --this.mainMenuIndex;
                    this.traverse(this.mainMenuIndex);
                } else {
                    this.mainMenuIndex = this.numOfItems - 1;
                    this.traverse(this.mainMenuIndex);
                }
            } else if (GameCanvas.keyWasPressed(2) || GameCanvas.keyWasPressed(8192)) {
                if (this.mainMenuIndex < this.numOfItems - 1) {
                    ++this.mainMenuIndex;
                    this.traverse(this.mainMenuIndex);
                } else {
                    this.mainMenuIndex = 0;
                    this.traverse(this.mainMenuIndex);
                }
            } else if (GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(1024)) {
                switch (this.mainMenuIndex) {
                    case 0: {
                        GameWorld.strScore = "0";
                        GameWorld.strCountHammerCollision = "0";
                        Hammer.strCountTotalHits = "0";
                        Hammer.countTotalHits = 0;
                        GameWorld.countScore = 0;
                        GameWorld.countHammerCollision = 0;
                        this.setScreenState(10);
                        this.bounds = Constants.TIPS_BOUND;
                        this.textArea = new TextArea(this.locale.getMessage(48), 7, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                        this.textArea.align = 0;
                        this.screenTitle = this.locale.getMessage(49);
                        GameCanvas.resetKey(131072);
                        GameCanvas.resetKey(16);
                        GameCanvas.resetKey(1024);
                        break;
                    }
                    case 1: {
                        this.setScreenState(1);
                        break;
                    }
                    case 2: {
                        this.setScreenState(2);
                        this.lskId = -1;
                        this.rskId = 2;
                        break;
                    }
                    case 3: {
                        this.setScreenState(3);
                        break;
                    }
                    case 4: {
                        this.setScreenState(4);
                        break;
                    }
                    case 5: {
                        this.setScreenState(6);
                        break;
                    }
                    case 9: {
                        this.setScreenState(9);
                    }
                }
            }
        }
        GameCanvas.resetKeys();
    }

    public void paintHighScore(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        UIFont.drawString(g, this.screenTitle, (240 - UIFont.stringWidth(this.screenTitle, (byte)2)) / 2, 10, 2);
        UIFont.drawString(g, this.screenTitle, (240 - UIFont.stringWidth(this.screenTitle, (byte)2)) / 2, 10, 2);
        this.scoreYPadding = 60;
        for (int i = 0; i < 5; ++i) {
            UIFont.drawString(g, this.playersName[i], 30, this.scoreYPadding, 7);
            this.strScore = "";
            this.strScore = this.strScore + this.playersScores[i];
            UIFont.drawString(g, this.strScore, 210 - UIFont.stringWidth(this.strScore, (byte)7), this.scoreYPadding, 7);
            this.scoreYPadding += UIFont.getHeight(7) + 10;
        }
    }

    public void cycleHighScore(long deltaMS) {
    }

    public void processKeyHighScore() {
        if (this.lskId != -1 && (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024))) {
            this.setScreenState(0);
        }
        if (this.rskId != -1 && GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(0);
        }
    }

    public void paintTips(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
        UIFont.drawString(g, this.screenTitle, (240 - UIFont.stringWidth(this.screenTitle, (byte)2)) / 2, 10, 2);
    }

    public void cycleTips(long deltaMS) {
        if (this.textArea != null) {
            this.textArea.cycle(deltaMS);
        }
    }

    public void processKeyTips() {
        this.textArea.processKeys();
        if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            this.gameCanvas.loadGame();
            GameCanvas.resetKeys();
        }
    }

    public void paintHelp(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
        UIFont.drawString(g, this.screenTitle, (240 - UIFont.stringWidth(this.screenTitle, (byte)2)) / 2, 10, 2);
    }

    public void cycleHelp(long deltaMS) {
        if (this.textArea != null) {
            this.textArea.cycle(deltaMS);
        }
    }

    public void processKeyHelp() {
        if (GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(0);
            this.textArea.destroy();
            GameCanvas.resetKey(262144);
        }
        this.textArea.processKeys();
    }

    public void paintSettingMenu(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        UIFont.drawString(g, this.screenTitle, (240 - UIFont.stringWidth(this.screenTitle, (byte)2)) / 2, 10, 2);
        this.renderList(g, this.strSettingMenu, this.menuStyle, 2, this.bounds, this.otherMenuIndex);
    }

    public void cycleSetting(long deltaMS) {
    }

    public void processKeySetting() {
        if (GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(0);
        } else if (this.menuStyle == 1000) {
            if (GameCanvas.keyWasPressed(1) || GameCanvas.keyWasPressed(128)) {
                if (this.otherMenuIndex > 0) {
                    --this.otherMenuIndex;
                    this.traverse(this.otherMenuIndex);
                } else {
                    this.otherMenuIndex = this.numOfItems - 1;
                    this.traverse(this.otherMenuIndex);
                }
            } else if (GameCanvas.keyWasPressed(2) || GameCanvas.keyWasPressed(8192)) {
                if (this.otherMenuIndex < this.numOfItems - 1) {
                    ++this.otherMenuIndex;
                    this.traverse(this.otherMenuIndex);
                } else {
                    this.otherMenuIndex = 0;
                    this.traverse(this.otherMenuIndex);
                }
            } else if (GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(1024)) {
                switch (this.otherMenuIndex) {
                    case 0: {
                        if (GameCanvas.isSound) {
                            GameCanvas.isSound = false;
                            this.strSettingMenu[0] = soundOnOff = this.locale.getMessage(36);
                            break;
                        }
                        GameCanvas.isSound = true;
                        this.strSettingMenu[0] = soundOnOff = this.locale.getMessage(35);
                        this.gameCanvas.soundUtils.playSound((byte)1, 1);
                        break;
                    }
                    case 1: {
                        if (GameCanvas.isVibrate) {
                            GameCanvas.isVibrate = false;
                            this.strSettingMenu[1] = vibrationOnOff = this.locale.getMessage(38);
                            break;
                        }
                        GameCanvas.isVibrate = true;
                        this.strSettingMenu[1] = vibrationOnOff = this.locale.getMessage(37);
                        Tools.vibrate(300, 60);
                        break;
                    }
                    case 2: {
                        this.textArea = new TextArea(this.locale.getMessage(61), 1, 0, 30, 240, 80);
                        this.textArea.setPostion((240 - this.textArea.getWidth()) / 2, (320 - this.textArea.getHeight()) / 2);
                        this.lskId = 0;
                        this.rskId = 1;
                        this.setScreenState(14);
                    }
                }
            }
        }
        GameCanvas.resetKeys();
    }

    public void paintPauseMenu(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        UIFont.drawString(g, this.screenTitle, (240 - UIFont.stringWidth(this.screenTitle, (byte)2)) / 2, 10, 2);
        this.renderList(g, this.strPauseMenu, this.menuStyle, 2, this.bounds, this.otherMenuIndex);
    }

    public void cyclePauseMenu(long deltaMS) {
        try {
            if (GameCanvas.isSound && this.gameCanvas.soundUtils.isPlaying()) {
                this.gameCanvas.soundUtils.stopSound();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processKeyPauseMenu() {
        if (!GameCanvas.keyWasPressed(262144) && this.menuStyle == 1000) {
            if (GameCanvas.keyWasPressed(1) || GameCanvas.keyWasPressed(128)) {
                if (this.otherMenuIndex > 0) {
                    --this.otherMenuIndex;
                    this.traverse(this.otherMenuIndex);
                } else {
                    this.otherMenuIndex = this.numOfItems - 1;
                    this.traverse(this.otherMenuIndex);
                }
            } else if (GameCanvas.keyWasPressed(2) || GameCanvas.keyWasPressed(8192)) {
                if (this.otherMenuIndex < this.numOfItems - 1) {
                    ++this.otherMenuIndex;
                    this.traverse(this.otherMenuIndex);
                } else {
                    this.otherMenuIndex = 0;
                    this.traverse(this.otherMenuIndex);
                }
            } else if (GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(1024)) {
                switch (this.otherMenuIndex) {
                    case 0: {
                        this.gameCanvas.resumeGame();
                        break;
                    }
                    case 1: {
                        if (GameCanvas.isSound) {
                            GameCanvas.isSound = false;
                            this.strPauseMenu[1] = soundOnOff = this.locale.getMessage(36);
                            break;
                        }
                        GameCanvas.isSound = true;
                        this.strPauseMenu[1] = soundOnOff = this.locale.getMessage(35);
                        this.gameCanvas.soundUtils.playSound((byte)1, 1);
                        break;
                    }
                    case 2: {
                        if (GameCanvas.isVibrate) {
                            GameCanvas.isVibrate = false;
                            this.strPauseMenu[2] = vibrationOnOff = this.locale.getMessage(38);
                            break;
                        }
                        GameCanvas.isVibrate = true;
                        this.strPauseMenu[2] = vibrationOnOff = this.locale.getMessage(37);
                        Tools.vibrate(300, 60);
                        break;
                    }
                    case 3: {
                        this.textArea = new TextArea(this.locale.getMessage(41), 1, 240);
                        this.textArea.setPostion((240 - this.textArea.getWidth()) / 2, (320 - this.textArea.getHeight()) / 2);
                        this.lskId = 0;
                        this.rskId = 1;
                        this.setScreenState(8);
                    }
                }
            }
        }
        GameCanvas.resetKeys();
    }

    public void paintQuitToMenu(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
    }

    public void cycleQuitToMenu(long deltaMS) {
    }

    public void processKeyQuitToMenu() {
        if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            this.strSettingMenu[0] = soundOnOff;
            this.strSettingMenu[1] = vibrationOnOff;
            this.setScreenState(0);
            this.gameCanvas.unloadGame();
        }
        if (GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(7);
        }
        GameCanvas.resetKeys();
    }

    public void paintAbout(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        try {
            this.textArea.renderer(g);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UIFont.drawString(g, this.screenTitle, (240 - UIFont.stringWidth(this.screenTitle, (byte)2)) / 2, 10, 2);
    }

    public void cycleAbout(long deltaMS) {
        if (this.textArea != null) {
            this.textArea.cycle(deltaMS);
        }
    }

    public void processKeyAbout() {
        this.textArea.processKeys();
        if (GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(0);
            this.textArea.destroy();
        }
    }

    public void paintCredit(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
        UIFont.drawString(g, this.screenTitle, (240 - UIFont.stringWidth(this.screenTitle, (byte)2)) / 2, 10, 2);
    }

    public void cycleCredit(long deltaMS) {
        if (this.textArea != null) {
            this.textArea.cycle(deltaMS);
        }
    }

    public void processKeyCredit() {
        this.textArea.processKeys();
        if (GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(0);
            this.textArea.destroy();
            GameCanvas.resetKey(262144);
        }
    }

    public void paintExit(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
    }

    public void cycleExit(long deltaMS) {
    }

    public void processKeyExit() {
        if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            this.initAfterExit();
            this.setScreenState(9);
        }
        if (GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(0);
        }
    }

    private void cycleAfterExit(long deltaMS) {
        this.textArea.cycle(deltaMS);
    }

    public void initAfterExit() {
        this.bounds = Constants.AFTER_EXIT_BOUND;
        String text = this.locale.getMessage(42);
        text = text + "|v";
        text = text + GameMIDlet.midlet.getAppProperty("MIDlet-Version");
        text = text + this.locale.getMessage(43);
        this.screenTitle = "";
        this.textArea = new TextArea(text, 7, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        this.textArea.setSpecialLineFont((byte)0);
        this.lskId = 0;
        this.rskId = -1;
    }

    private void cycleResetScore(long deltaMS) {
    }

    private void paintAfterExit(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
        UIFont.drawString(g, this.screenTitle, (240 - UIFont.stringWidth(this.screenTitle, (byte)2)) / 2, 10, 2);
    }

    private void processKeyAfterExit() {
        this.textArea.processKeys();
        if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            GameMIDlet.midlet.close();
        }
    }

    private void paintStatisticsScreen(Graphics g) {
        g.drawImage(this.imgStatisticeScreen, 0, 0, 0);
        UIFont.drawString(g, this.screenTitle, (240 - UIFont.stringWidth(this.screenTitle, (byte)2)) / 2, 10, 2);
        UIFont.drawString(g, this.locale.getMessage(62), 15, 70, 7);
        UIFont.drawString(g, this.locale.getMessage(58), 15, 100, 7);
        UIFont.drawString(g, this.locale.getMessage(59), 15, 130, 7);
        UIFont.drawString(g, Hammer.strCountTotalHits, 175, 70, 7);
        UIFont.drawString(g, GameWorld.strCountHammerCollision, 175, 100, 7);
        UIFont.drawString(g, GameWorld.strScore, 175, 130, 7);
        if (GameWorld.countHammerCollision < 40) {
            this.catSpriteUncool.draw(g, 136, 195);
        } else if (GameWorld.countHammerCollision >= 40 && GameWorld.countHammerCollision < 75) {
            this.catSpriteGreat.draw(g, 136, 195);
        } else if (GameWorld.countHammerCollision >= 75) {
            this.catSpriteAwesome.draw(g, 136, 195);
        }
    }

    private void cycleStatisticsScreen(long deltaMS) {
        this.catSpriteGreat.cycle(deltaMS);
        this.catSpriteAwesome.cycle(deltaMS);
        this.catSpriteUncool.cycle(deltaMS);
    }

    private void paintResetScore(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
    }

    private void processKeyResetScore() {
        if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            this.resetScoreRMS();
            this.setScreenState(2);
        }
        if (GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(3);
            this.lskId = 0;
            this.rskId = 2;
        }
        GameCanvas.resetKeys();
    }

    private void processKeyStatisticsScreen() {
        if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            this.loadScore();
            if (this.playersScores[4] < GameWorld.countScore) {
                this.setScreenState(12);
            } else {
                this.setScreenState(13);
            }
            this.strSettingMenu[0] = soundOnOff;
            this.strSettingMenu[1] = vibrationOnOff;
        }
    }

    private void paintHighScoreMsg(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
    }

    private void processKeyHighScoreMsg() {
        if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            this.setScreenState(0);
        }
        GameCanvas.resetKeys();
    }

    private void cycleHighScoreMsg(long deltaMS) {
    }

    public void initEnterUserName() {
        this.alphabets = new StringBuffer("_ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        this.charIndexes = new int[6];
        this.msgBox_1 = new TextArea(this.locale.getMessage(52), 2, 240);
        this.msgBox_1.setPostion(120 - this.msgBox_1.getWidth() / 2, 10);
        this.msgBox_2 = new TextArea(this.locale.getMessage(53), 3, 240);
        this.msgBox_2.setPostion(120 - this.msgBox_1.getWidth() / 2, 214);
        this.bufferEditBox = new StringBuffer(6);
        this.bufferEditBox.append("______");
        this.cursorIndex = 0;
    }

    private void paintEnterUserName(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.msgBox_1.renderer(g);
        this.msgBox_2.renderer(g);
        this.textBoxX = (240 - this.imgSmallArrowDown.getWidth() * 6) / 2;
        this.textBoxY = 160 - this.imgSmallArrowDown.getHeight();
        g.drawImage(this.imgSmallArrowDown, this.textBoxX + this.cursorIndex * this.imgSmallArrowDown.getWidth(), this.textBoxY - 3, 0);
        g.drawImage(this.imgSmallArrowUp, this.textBoxX + this.cursorIndex * this.imgSmallArrowUp.getWidth(), 160 + UIFont.getHeight(3) + 3, 0);
        g.setColor(0xFFFFFF);
        g.fillRect(this.textBoxX, 160, this.imgSmallArrowDown.getWidth() * 6 + 2, UIFont.getHeight(3));
        for (int i = 0; i < this.bufferEditBox.length(); ++i) {
            UIFont.drawFontCode(this.bufferEditBox.charAt(i), (byte)3, this.textBoxX + (this.imgSmallArrowDown.getWidth() - UIFont.charWidth(this.bufferEditBox.charAt(i), (byte)3)) / 2 + i * this.imgSmallArrowDown.getWidth(), 160);
        }
    }

    private void cycleEnterUserName(long deltaMS) {
    }

    private void processKeysEnterUserName() {
        if (GameCanvas.keyIsHeld(129)) {
            if (this.bufferEditBox.charAt(this.cursorIndex) == ' ') {
                this.charIndexes[this.cursorIndex] = this.alphabets.length() - 1;
                this.bufferEditBox.setCharAt(this.cursorIndex, this.alphabets.charAt(this.charIndexes[this.cursorIndex]));
            } else {
                int n = this.cursorIndex;
                this.charIndexes[n] = this.charIndexes[n] - 1;
                if (this.charIndexes[this.cursorIndex] < 0) {
                    this.charIndexes[this.cursorIndex] = this.alphabets.length() - 1;
                }
                this.bufferEditBox.setCharAt(this.cursorIndex, this.alphabets.charAt(this.charIndexes[this.cursorIndex]));
            }
        } else if (GameCanvas.keyIsHeld(8194)) {
            if (this.bufferEditBox.charAt(this.cursorIndex) == ' ') {
                this.charIndexes[this.cursorIndex] = 0;
                this.bufferEditBox.setCharAt(this.cursorIndex, this.alphabets.charAt(this.charIndexes[this.cursorIndex]));
            } else {
                int n = this.cursorIndex;
                this.charIndexes[n] = this.charIndexes[n] + 1;
                if (this.charIndexes[this.cursorIndex] >= this.alphabets.length()) {
                    this.charIndexes[this.cursorIndex] = 0;
                }
                this.bufferEditBox.setCharAt(this.cursorIndex, this.alphabets.charAt(this.charIndexes[this.cursorIndex]));
            }
        } else if (GameCanvas.keyWasPressed(520)) {
            --this.cursorIndex;
            if (this.cursorIndex < 0) {
                this.cursorIndex = 0;
            }
        } else if (GameCanvas.keyWasPressed(2052)) {
            if (this.bufferEditBox.charAt(this.cursorIndex) != ' ') {
                ++this.cursorIndex;
                if (this.cursorIndex >= 6) {
                    this.cursorIndex = 5;
                }
            }
        } else if (GameCanvas.keyWasPressed(32768)) {
            this.bufferEditBox.setCharAt(this.cursorIndex, '_');
            --this.cursorIndex;
            if (this.cursorIndex < 0) {
                this.cursorIndex = 0;
            }
        } else if (!GameCanvas.keyWasPressed(262144) && (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024))) {
            if (this.bufferEditBox != null && this.bufferEditBox.capacity() > 0) {
                for (int i = 0; i < 6; ++i) {
                    if (this.bufferEditBox.charAt(i) != '_') continue;
                    this.bufferEditBox.deleteCharAt(i);
                    this.bufferEditBox.insert(i, ' ');
                }
                playerName = this.bufferEditBox.toString().trim();
            }
            if (playerName == null || playerName.equals("") || playerName.equals(" ")) {
                playerName = "PLAYER";
            }
            this.addScore(playerName, GameWorld.countScore);
            this.setScreenState(2);
        }
        GameCanvas.resetKeys();
    }

    public void addScore(String playerName, int score) {
        this.loadScore();
        this.sortScore();
        try {
            for (int i = 0; i < 5; ++i) {
                if (this.playersScores[i] >= score) continue;
                for (int j = 3; j >= i; --j) {
                    this.playersScores[j + 1] = this.playersScores[j];
                    this.playersName[j + 1] = this.playersName[j];
                }
                this.playersScores[i] = score;
                this.playersName[i] = playerName;
                break;
            }
            this.saveScore(this.playersName, this.playersScores);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        playerName = "";
        score = 0;
    }

    public void resetScoreRMS() {
        this.playersName = new String[]{"BRIAN", "LISA", "BRINDA", "YOSHIAKI", "ANDREW"};
        this.playersScores = new int[]{10250, 8400, 6550, 3000, 1500};
        try {
            this.saveScore(this.playersName, this.playersScores);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sortScore() {
        for (int i = 3; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (this.playersScores[i] >= this.playersScores[i + 1]) continue;
                int temp = this.playersScores[i];
                this.playersScores[i] = this.playersScores[i + 1];
                this.playersScores[i + 1] = temp;
                String strTemp = this.playersName[i];
                this.playersName[i] = this.playersName[i + 1];
                this.playersName[i + 1] = strTemp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveScore(String[] playerName, int[] score) throws Exception {
        RecordStore scoreRms = null;
        try {
            try {
                RecordStore.deleteRecordStore((String)"score_rms");
            }
            catch (RecordStoreNotFoundException rse) {
                // empty catch block
            }
            scoreRms = RecordStore.openRecordStore((String)"score_rms", (boolean)true);
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteOutputStream);
            for (int i = 0; i < playerName.length; ++i) {
                dataOutputStream.writeUTF(playerName[i]);
                dataOutputStream.writeInt(score[i]);
            }
            dataOutputStream.flush();
            byte[] recordOut = byteOutputStream.toByteArray();
            try {
                scoreRms.setRecord(1, recordOut, 0, recordOut.length);
            }
            catch (InvalidRecordIDException ir) {
                scoreRms.addRecord(recordOut, 0, recordOut.length);
            }
            dataOutputStream.close();
            byteOutputStream.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException io) {
            boolean bl = false;
            return bl;
        }
        catch (RecordStoreException rse) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (scoreRms != null) {
                    scoreRms.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadScore() {
        RecordStore scoreRms = null;
        try {
            int i;
            scoreRms = RecordStore.openRecordStore((String)"score_rms", (boolean)true);
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(scoreRms.getRecord(1));
            DataInputStream dataInputStream = new DataInputStream(byteInputStream);
            for (i = 0; i < this.playersName.length; ++i) {
                this.playersName[i] = dataInputStream.readUTF();
                this.playersScores[i] = dataInputStream.readInt();
            }
            dataInputStream.close();
            byteInputStream.close();
            i = 1;
            return i != 0;
        }
        catch (IOException io) {
            boolean bl = false;
            return bl;
        }
        catch (RecordStoreException rse) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (scoreRms != null) {
                    scoreRms.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException e) {}
        }
    }

    public void traverse(int selectedIndex) {
        if (this.scrBottomItem < this.numOfItems - 1 && (GameCanvas.keyWasPressed(2) || GameCanvas.keyWasPressed(8192))) {
            if (selectedIndex == this.scrBottomItem + 1) {
                ++this.scrTopItem;
                ++this.scrBottomItem;
            }
        } else if (this.scrTopItem > 0 && (GameCanvas.keyWasPressed(1) || GameCanvas.keyWasPressed(128)) && selectedIndex == this.scrTopItem - 1) {
            --this.scrTopItem;
            --this.scrBottomItem;
        }
        if (selectedIndex == 0 && (GameCanvas.keyWasPressed(2) || GameCanvas.keyWasPressed(8192))) {
            this.scrTopItem = 0;
            this.scrBottomItem = this.numOfVisibleItems;
        } else if (selectedIndex == this.numOfItems - 1 && (GameCanvas.keyWasPressed(1) || GameCanvas.keyWasPressed(128))) {
            this.scrBottomItem = this.numOfItems - 1;
            this.scrTopItem = this.scrBottomItem - this.numOfVisibleItems;
        }
    }

    public void renderList(Graphics g, String[] items, int style, int align, Bounds bounds, int selectedIndex) {
        if (items != null) {
            try {
                int itemX = 0;
                int itemY = 0;
                this.itemYPos = bounds.y;
                if (style == 1000) {
                    for (int currentIndex = this.scrTopItem; currentIndex <= this.scrTopItem + this.numOfVisibleItems; ++currentIndex) {
                        this.alignX = 0;
                        this.menuFont = currentIndex == selectedIndex ? (byte)2 : (byte)3;
                        if (align == 2) {
                            this.alignX = bounds.width - UIFont.stringWidth(items[currentIndex], this.menuFont);
                            this.alignX /= 2;
                        } else if (align == 3) {
                            this.alignX = bounds.width - UIFont.stringWidth(items[currentIndex], this.menuFont);
                        }
                        if (currentIndex != selectedIndex || this.imgHighlighter == null || !GameCanvas.hasPointerEvent) {
                            // empty if block
                        }
                        if (this.imgHighlighter != null) {
                            this.itemYPos += Math.max(this.imgHighlighter.getHeight(), UIFont.getHeight(3)) + this.itemYPadding;
                            itemX = bounds.x + this.alignX;
                            itemY = this.itemYPos - (Math.max(this.imgHighlighter.getHeight(), UIFont.getHeight(3)) + this.itemYPadding);
                            UIFont.drawString(g, items[currentIndex], itemX, itemY, this.menuFont);
                            continue;
                        }
                        this.itemYPos += UIFont.getHeight(3) + this.itemYPadding;
                        itemX = bounds.x + this.alignX;
                        itemY = this.itemYPos;
                        UIFont.drawString(g, items[currentIndex], itemX, itemY, this.menuFont);
                    }
                } else if (style == 1001) {
                    this.menuTempIndex = selectedIndex - 1;
                    if (this.menuTempIndex < 0) {
                        this.menuTempIndex = items.length - 1;
                    }
                    UIFont.drawString(g, items[this.menuTempIndex], bounds.x + (bounds.width - UIFont.stringWidth(items[this.menuTempIndex], (byte)3)) / 2, bounds.y, 3);
                    UIFont.drawString(g, items[selectedIndex], bounds.x + (bounds.width - UIFont.stringWidth(items[selectedIndex], (byte)2)) / 2, bounds.y + (bounds.height - UIFont.getHeight(2)) / 2, 2);
                    this.menuTempIndex = selectedIndex + 1;
                    if (this.menuTempIndex > items.length - 1) {
                        this.menuTempIndex = 0;
                    }
                    UIFont.drawString(g, items[this.menuTempIndex], bounds.x + (bounds.width - UIFont.stringWidth(items[this.menuTempIndex], (byte)3)) / 2, bounds.y + bounds.height - UIFont.getHeight(3), 3);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setList(String[] items, Bounds bounds) {
        int totalHeight = 0;
        this.scrTopItem = 0;
        for (int currentIndex = 0; currentIndex < items.length; ++currentIndex) {
            totalHeight = this.imgHighlighter != null ? (totalHeight += Math.max(this.imgHighlighter.getHeight(), UIFont.getHeight(3)) + this.itemYPadding) : (totalHeight += UIFont.getHeight(3) + this.itemYPadding);
            if (totalHeight > bounds.height) continue;
            this.scrBottomItem = currentIndex;
            this.numOfVisibleItems = currentIndex;
        }
    }

    public void setScreenState(int n) {
        this.otherMenuIndex = 0;
        this.screenState = n;
        switch (this.screenState) {
            case 0: {
                this.menuStyle = 1001;
                this.bounds = Constants.MAIN_MENU_BOUND;
                this.setList(this.strMainMenu, this.bounds);
                this.numOfItems = this.strMainMenu.length;
                this.lskId = 0;
                this.rskId = -1;
                this.screenTitle = "";
                break;
            }
            case 7: {
                this.menuStyle = 1000;
                this.bounds = Constants.PAUSE_MENU_BOUND;
                this.setList(this.strPauseMenu, this.bounds);
                this.strPauseMenu[1] = soundOnOff;
                this.strPauseMenu[2] = vibrationOnOff;
                this.otherMenuIndex = 0;
                this.numOfItems = this.strPauseMenu.length;
                this.imgYes = ResManager.getImage(7, 1);
                this.lskId = 0;
                this.rskId = -1;
                this.screenTitle = "";
                break;
            }
            case 1: {
                this.bounds = Constants.HELP_BOUND;
                this.textArea = new TextArea(this.locale.getMessage(28), 7, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                this.textArea.align = 1;
                this.screenTitle = this.locale.getMessage(9);
                this.rskId = 2;
                this.lskId = -1;
                break;
            }
            case 3: {
                this.menuStyle = 1000;
                this.bounds = Constants.SETTING_MENU_BOUND;
                this.setList(this.strSettingMenu, this.bounds);
                this.otherMenuIndex = 0;
                this.numOfItems = this.strSettingMenu.length;
                this.lskId = 0;
                this.rskId = 2;
                this.screenTitle = this.locale.getMessage(10);
                break;
            }
            case 4: {
                this.bounds = Constants.HELP_BOUND;
                String string = "" + this.locale.getMessage(0);
                String string2 = GameMIDlet.midlet.getAppProperty("MIDlet-Version");
                String string3 = string + " |v" + string2;
                string3 = string3 + this.locale.getMessage(29);
                this.textArea = new TextArea(string3, 7, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                this.textArea.setSpecialLineFont((byte)0);
                this.screenTitle = this.locale.getMessage(12);
                this.lskId = -1;
                this.rskId = 2;
                break;
            }
            case 5: {
                this.bounds = Constants.HELP_BOUND;
                this.textArea = new TextArea(this.locale.getMessage(27), 7, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                this.textArea.align = 1;
                this.textArea.setSpecialLineFont((byte)0);
                this.screenTitle = this.locale.getMessage(11);
                this.lskId = -1;
                this.rskId = 2;
                break;
            }
            case 9: {
                this.initAfterExit();
                break;
            }
            case 6: {
                this.bounds = Constants.EXIT_BOUND;
                this.textArea = new TextArea(this.locale.getMessage(34), 1, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                this.textArea.setSpecialLineFont((byte)0);
                this.screenTitle = this.locale.getMessage(13);
                this.lskId = 0;
                this.rskId = 1;
                break;
            }
            case 2: {
                this.screenTitle = this.locale.getMessage(50);
                this.lskId = 0;
                this.rskId = -1;
                this.loadScore();
                break;
            }
            case 11: {
                this.screenTitle = this.locale.getMessage(51);
                this.lskId = 0;
                this.rskId = -1;
                break;
            }
            case 12: {
                this.initEnterUserName();
                this.lskId = 0;
                this.rskId = -1;
                break;
            }
            case 13: {
                this.textArea = new TextArea(this.locale.getMessage(54), 1, 240);
                this.textArea.setPostion((240 - this.textArea.getWidth()) / 2, (320 - this.textArea.getHeight()) / 2);
                this.lskId = 0;
                this.rskId = -1;
                break;
            }
            case 14: {
                this.textArea = new TextArea(this.locale.getMessage(61), 1, 0, 30, 240, 80);
                this.textArea.setPostion((240 - this.textArea.getWidth()) / 2, (320 - this.textArea.getHeight()) / 2);
                this.lskId = 0;
                this.rskId = 1;
                break;
            }
            case 10: {
                this.bounds = Constants.TIPS_BOUND;
                this.textArea = new TextArea(this.locale.getMessage(48), 7, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                this.textArea.align = 0;
                this.screenTitle = this.locale.getMessage(49);
                this.rskId = -1;
                this.lskId = 0;
                GameCanvas.resetKey(131072);
                GameCanvas.resetKey(16);
                GameCanvas.resetKey(1024);
            }
        }
    }

    public void paintLSK(Graphics g) {
        switch (this.lskId) {
            case -1: {
                return;
            }
            case 0: {
                if (this.imgYes == null) break;
                g.drawImage(this.imgYes, 2, 320 - this.imgYes.getHeight(), 0);
                break;
            }
            case 1: {
                if (this.imgNo == null) break;
                g.drawImage(this.imgNo, 2, 320 - this.imgNo.getHeight(), 0);
                break;
            }
            case 2: {
                if (this.imgBack == null) break;
                g.drawImage(this.imgBack, 2, 320 - this.imgBack.getHeight(), 0);
            }
        }
    }

    public void paintRSK(Graphics g) {
        switch (this.rskId) {
            case -1: {
                return;
            }
            case 0: {
                if (this.imgBack == null) break;
                g.drawImage(this.imgYes, 240 - this.imgYes.getWidth() - 2, 320 - this.imgYes.getHeight(), 0);
                break;
            }
            case 1: {
                if (this.imgBack == null) break;
                g.drawImage(this.imgNo, 240 - this.imgNo.getWidth() - 2, 320 - this.imgNo.getHeight(), 0);
                break;
            }
            case 2: {
                if (this.imgBack == null) break;
                g.drawImage(this.imgBack, 240 - this.imgBack.getWidth() - 2, 320 - this.imgBack.getHeight(), 0);
            }
        }
    }

    public void resume() {
    }
}

