/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.constants.Constants;
import com.manthanstudio.game.Actor;
import com.manthanstudio.game.ActorPool;
import com.manthanstudio.game.FloatingScore;
import com.manthanstudio.game.GameCanvas;
import com.manthanstudio.game.Hammer;
import com.manthanstudio.game.Mouse;
import com.manthanstudio.game.TextArea;
import com.manthanstudio.locale.Locale;
import com.manthanstudio.resource.ResManager;
import com.manthanstudio.tools.ImageSet;
import com.manthanstudio.tools.MathFP;
import com.manthanstudio.tools.Sprite;
import com.manthanstudio.tools.Tools;
import com.manthanstudio.tools.UIFont;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameWorld {
    private static int t = 0;
    public static final int NOT_STARTED = t++;
    public static final int STARTING_UP = t++;
    public static final int PLAYING = t++;
    public static final int PAUSED = t++;
    public static final int GAME_OVER = t++;
    public static final int GAME_RESET = t++;
    public static final int STATE_OPTION = t++;
    public static final int STATE_CHANGE_LEVEL = t++;
    TextArea textArea;
    private int gameState;
    private int statePriorToPause;
    private long timeStateChanged;
    private long timeSinceStateChange;
    GameCanvas gameCanvas;
    String gameMsg = "";
    public int catState = 0;
    private int frameWidth;
    private int frameHeight;
    public int pointValue = 100;
    Image smallHammer = null;
    public int[] board;
    private int row = 0;
    private int col = 0;
    public boolean isCountLeft = true;
    Hammer hammer;
    Image imgGamePlayBg = null;
    public Image animateCat = null;
    Image animateButterFly = null;
    Sprite butterFlySprite;
    Sprite catSprite;
    public static int countScore = 0;
    public static int countTotalHits = 0;
    public int level = 1;
    public int counterHits = 0;
    public int resetCount = 0;
    public int[] countBeatScore = new int[]{20, 45, 75, Integer.MAX_VALUE};
    public int countLives = 5;
    public static int countHammerCollision = 0;
    public static String strCountHammerCollision = "0";
    private String strCountLives = "5";
    public static String strScore = "0";
    private ActorPool scorePool;
    private ActorPool mousePool;
    private Mouse currMouse;
    public int butterflyPosX;
    long timeMousePopUp;
    long timeSinceMousePopUp;
    private int panPixelsToMoveFP;
    private int floatingVal = 0;
    boolean isPower = false;
    int moveMsPerSecond = 2000;
    private int pixelsPerMSFP = MathFP.div(30, 1000);
    boolean isCollideWithMouse = false;
    int[] randomNumStack = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    int rand;
    int tryCount;
    public long timeWhenGameStarted;
    public long timeSinceGamePause;
    public long timeGamePause;

    public GameWorld() {
    }

    public GameWorld(GameCanvas gameCanvas) {
        this.gameCanvas = gameCanvas;
        this.imgGamePlayBg = ResManager.getImage(ResManager.IMAGE_BG_GAME_PLAY, 2);
        this.setState(NOT_STARTED);
    }

    public void loadGame() {
        try {
            this.setState(NOT_STARTED);
            this.startNewGame();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startNewGame() {
        this.init();
        if (GameCanvas.isSound) {
            this.gameCanvas.soundUtils.loadSound((byte)2);
            this.gameCanvas.soundUtils.playSound((byte)2, -1);
        }
        System.gc();
        this.setState(STARTING_UP);
    }

    public void restart() {
        try {
            this.reInit();
            if (GameCanvas.isSound && !this.gameCanvas.soundUtils.isPlaying()) {
                this.gameCanvas.soundUtils.stopSound((byte)2);
                this.gameCanvas.soundUtils.loadSound((byte)2);
                this.gameCanvas.soundUtils.playSound((byte)2, -1);
            }
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setState(STARTING_UP);
    }

    public void init() {
        Actor[] mouse = new Mouse[5];
        for (int i = 0; i < mouse.length; ++i) {
            mouse[i] = new Mouse(this, 0);
            ((Mouse)mouse[i]).init();
        }
        this.mousePool = new ActorPool(mouse);
        this.hammer = new Hammer(this, 2);
        this.hammer.init();
        this.board = new int[9];
        this.smallHammer = ResManager.getImage(ResManager.IMAGE_SMALL_HAMMER, 2);
        this.animateCat = ResManager.getImage(ResManager.IMAGE_CAT_SPRITE, 2);
        this.frameWidth = this.animateCat.getWidth() / 20;
        this.frameHeight = this.animateCat.getHeight();
        ImageSet imageSet = new ImageSet(1);
        imageSet.addState(this.animateCat, new int[]{100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100}, new int[]{this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth}, new int[]{this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight}, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19});
        this.catSprite = new Sprite(imageSet, 0, 0);
        this.catSprite.setState(0, true);
        this.animateCat = null;
        imageSet = null;
        this.animateButterFly = ResManager.getImage(ResManager.IMAGE_ANIMATE_BUTTERFLY_SPRITE, 2);
        this.frameWidth = this.animateButterFly.getWidth() / 24;
        this.frameHeight = this.animateButterFly.getHeight();
        imageSet = new ImageSet(1);
        imageSet.addState(this.animateButterFly, new int[]{100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100}, new int[]{this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth, this.frameWidth}, new int[]{this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight, this.frameHeight}, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23});
        this.butterFlySprite = new Sprite(imageSet, 0, 0);
        this.butterFlySprite.setState(0, true);
        Actor[] scores = new FloatingScore[50];
        for (int i = 0; i < scores.length; ++i) {
            scores[i] = new FloatingScore(this, 1);
            ((FloatingScore)scores[i]).init();
        }
        this.scorePool = new ActorPool(scores);
        this.textArea = new TextArea(this.gameMsg, 1, 0, 0, 240, 320);
        this.reInit();
    }

    public void reInit() {
        for (int i = 0; i < 9; ++i) {
            this.board[i] = i;
        }
    }

    public void renderer(Graphics g) {
        g.drawImage(ResManager.getImage(ResManager.IMAGE_BG_GAME_PLAY, 2), 0, 0, 0);
        g.drawImage(this.smallHammer, 165, 3, 0);
        if (this.gameState != PAUSED && this.gameState != STARTING_UP && this.gameState != GAME_RESET && this.gameState != STATE_OPTION) {
            if (this.gameState == PLAYING) {
                this.catSprite.draw(g, 169, 132);
                this.butterFlySprite.draw(g, this.butterflyPosX, 100);
                this.currMouse = (Mouse)this.mousePool.getFirstUsed();
                while (this.currMouse != null) {
                    this.currMouse.renderer(g);
                    this.currMouse = (Mouse)this.currMouse.getNextLinked();
                }
                this.hammer.renderer(g);
                for (Actor a = this.scorePool.getFirstUsed(); a != null; a = a.getNextLinked()) {
                    a.renderer(g);
                }
                g.setColor(0, 200, 0);
                UIFont.drawString(g, strScore, 70, 7, 5);
                UIFont.drawString(g, strCountHammerCollision, 70, 42, 5);
                UIFont.drawString(g, this.strCountLives, 189, 7, 5);
            } else if (this.gameState != STATE_CHANGE_LEVEL && this.gameState == GAME_OVER) {
                this.textArea.renderer(g);
                this.hammer.renderer(g);
            }
        }
    }

    public void cycle(long deltaMS) {
        if (this.gameState == NOT_STARTED) {
            this.setState(STARTING_UP);
        } else if (this.gameState == STARTING_UP) {
            this.setState(PLAYING);
            this.mousePopUpNext();
        } else if (this.gameState == PLAYING) {
            this.catSprite.cycle(deltaMS);
            this.butterFlySprite.cycle(deltaMS);
            this.panPixelsToMoveFP += MathFP.mul(this.pixelsPerMSFP, MathFP.toFP((int)deltaMS));
            int wholePixels = MathFP.toInt(this.panPixelsToMoveFP);
            if (wholePixels > 0) {
                this.butterflyPosX = this.butterflyPosX < 240 ? (this.butterflyPosX += wholePixels) : -120;
                this.panPixelsToMoveFP = MathFP.sub(this.panPixelsToMoveFP, MathFP.toFP(wholePixels));
            }
            this.timeSinceMousePopUp = System.currentTimeMillis() - this.timeMousePopUp;
            if (this.timeSinceMousePopUp > (long)Constants.MOUSE_POP_UP_DELAY[this.level - 1]) {
                this.mousePopUpNext();
            }
            for (Actor score = this.scorePool.getFirstUsed(); score != null; score = score.getNextLinked()) {
                score.cycle(deltaMS);
            }
            this.currMouse = (Mouse)this.mousePool.getFirstUsed();
            while (this.currMouse != null) {
                this.currMouse.cycle(deltaMS);
                this.currMouse = (Mouse)this.currMouse.getNextLinked();
            }
            this.isCollideWithMouse = true;
            this.currMouse = (Mouse)this.mousePool.getFirstUsed();
            if (this.currMouse == null) {
                this.isCollideWithMouse = this.mouseHammerCollision(this.currMouse);
            }
            while (this.currMouse != null) {
                this.isCollideWithMouse = this.mouseHammerCollision(this.currMouse);
                if (this.isCollideWithMouse) break;
                this.currMouse = (Mouse)this.currMouse.getNextLinked();
            }
            if (!this.isCollideWithMouse && this.hammer.isCollidable()) {
                this.isCollideWithMouse = true;
                this.hammer.setCollidable(false);
                this.looseLife();
            }
            this.hammer.setCollidable(false);
            this.hammer.cycle(deltaMS);
        } else if (this.gameState == STATE_CHANGE_LEVEL) {
            this.setState(GAME_RESET);
        } else if (this.gameState == GAME_OVER) {
            this.hammer.cycle(deltaMS);
            this.textArea.cycle(deltaMS);
            this.timeSinceStateChange = System.currentTimeMillis() - this.timeStateChanged;
            if (this.timeSinceStateChange >= 3000L) {
                this.gameCanvas.gameOver();
            }
        } else if (this.gameState == GAME_RESET) {
            this.timeSinceStateChange = System.currentTimeMillis() - this.timeStateChanged;
            if (this.timeSinceStateChange >= 2000L) {
                this.restart();
            }
        }
    }

    public void mousePopUpNext() {
        this.currMouse = (Mouse)this.getMouseFromPool();
        if (this.level == 1) {
            this.currMouse.setType(0);
        } else if (this.level == 2) {
            this.currMouse.setType(0);
        } else if (this.level == 3) {
            this.currMouse.setType(Tools.getRand(0, 1));
        } else if (this.level == 4) {
            this.currMouse.setType(Tools.getRand(1, 1));
        }
        this.tryCount = 0;
        while (this.tryCount < 50) {
            this.rand = Tools.getRand(this.board[0], this.board[this.board.length - 1]);
            if (this.rand != this.randomNumStack[this.rand]) break;
            ++this.tryCount;
        }
        this.randomNumStack[this.rand] = this.rand;
        this.currMouse.setRandomMousePos(this.rand);
        this.timeMousePopUp = System.currentTimeMillis();
    }

    public boolean mouseHammerCollision(Mouse currMouse) {
        boolean isCollide = false;
        if (this.hammer.isCollidable()) {
            if (currMouse == null) {
                isCollide = false;
            }
            if (currMouse != null && currMouse.getRandomMousePos() == this.hammer.num) {
                --currMouse.strength;
                isCollide = true;
                if (currMouse.strength >= 0) {
                    currMouse.setState(2 - currMouse.strength);
                }
                if (currMouse.strength == 0) {
                    ++this.counterHits;
                    ++this.resetCount;
                    strCountHammerCollision = "";
                    strCountHammerCollision = strCountHammerCollision + ++countHammerCollision;
                    this.floatingVal = this.pointValue * this.counterHits;
                    strScore = "";
                    strScore = strScore + (countScore += this.floatingVal);
                    FloatingScore floatingScore = this.getScoreFromPool();
                    floatingScore.setXY(this.hammer.drawPopUpHammerPopX, this.hammer.drawPopUpHammerPopY);
                    floatingScore.floatingDirection(this.floatingVal, 0, -1);
                    floatingScore.setImgFloating(null);
                    if (this.resetCount == 5) {
                        FloatingScore floatHammer = this.getScoreFromPool();
                        floatHammer.setXY(this.hammer.drawPopUpHammerPopX, this.hammer.drawPopUpHammerPopY - this.smallHammer.getHeight());
                        floatHammer.floatingHammer(this.smallHammer, 0, -1);
                        ++this.countLives;
                        this.strCountLives = "";
                        this.strCountLives = this.strCountLives + this.countLives;
                        this.resetCount = 0;
                    }
                    if (countHammerCollision > this.countBeatScore[this.level - 1]) {
                        ++this.level;
                    }
                    isCollide = true;
                } else if (currMouse != null && currMouse.strength < 0) {
                    isCollide = false;
                }
            } else if (currMouse != null) {
                isCollide = false;
            }
        }
        return isCollide;
    }

    public void looseLife() {
        --this.countLives;
        this.counterHits = 0;
        this.resetCount = 0;
        Tools.vibrate(300, 60);
        this.strCountLives = "";
        this.strCountLives = this.strCountLives + this.countLives;
        if (this.countLives == 0) {
            this.setState(GAME_OVER);
            if (countHammerCollision <= 40) {
                this.gameMsg = Locale.getInstance().getMessage(55);
                this.textArea = new TextArea(this.gameMsg, 1, 240);
                this.textArea.setPostion((240 - this.textArea.getWidth()) / 2, (320 - this.textArea.getHeight()) / 2);
            } else if (countHammerCollision > 40 && countHammerCollision <= 75) {
                this.gameMsg = Locale.getInstance().getMessage(56);
                this.textArea = new TextArea(this.gameMsg, 1, 240);
                this.textArea.setPostion((240 - this.textArea.getWidth()) / 2, (320 - this.textArea.getHeight()) / 2);
            } else if (countHammerCollision > 75) {
                this.gameMsg = Locale.getInstance().getMessage(57);
                this.textArea = new TextArea(this.gameMsg, 1, 240);
                this.textArea.setPostion((240 - this.textArea.getWidth()) / 2, (320 - this.textArea.getHeight()) / 2);
            }
        }
    }

    public void processKey() {
        if (this.gameState == PLAYING) {
            if (GameCanvas.keyWasPressed(64)) {
                this.hammer.popUpHammer(0);
            } else if (GameCanvas.keyWasPressed(128)) {
                this.hammer.popUpHammer(1);
            } else if (GameCanvas.keyWasPressed(256)) {
                this.hammer.popUpHammer(2);
            } else if (GameCanvas.keyWasPressed(512)) {
                this.hammer.popUpHammer(3);
            } else if (GameCanvas.keyWasPressed(1024)) {
                this.hammer.popUpHammer(4);
            } else if (GameCanvas.keyWasPressed(2048)) {
                this.hammer.popUpHammer(5);
            } else if (GameCanvas.keyWasPressed(4096)) {
                this.hammer.popUpHammer(6);
            } else if (GameCanvas.keyWasPressed(8192)) {
                this.hammer.popUpHammer(7);
            } else if (GameCanvas.keyWasPressed(16384)) {
                this.hammer.popUpHammer(8);
            }
        }
        if (GameCanvas.keyWasPressed(262144)) {
            this.gameCanvas.pauseGame();
            GameCanvas.resetKey(262144);
        } else if (this.gameState == GAME_OVER && (GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024))) {
            this.gameCanvas.gameOver();
        }
        GameCanvas.resetKeys();
    }

    public void setState(int state) {
        if (state == GAME_OVER) {
            // empty if block
        }
        this.gameState = state;
        this.timeStateChanged = System.currentTimeMillis();
        GameCanvas.resetKeys();
    }

    public int getState() {
        return this.gameState;
    }

    public void pause() {
        if (this.gameState == PAUSED) {
            return;
        }
        this.statePriorToPause = this.gameState;
        this.setState(PAUSED);
        if (GameCanvas.isSound && this.gameCanvas.soundUtils.player != null) {
            this.gameCanvas.soundUtils.stopSound((byte)2);
        }
        this.timeGamePause = System.currentTimeMillis();
    }

    public void resume() {
        if (this.gameState != PAUSED) {
            return;
        }
        this.setState(this.statePriorToPause);
        if (GameCanvas.isSound) {
            this.gameCanvas.soundUtils.loadSound((byte)2);
            this.gameCanvas.soundUtils.playSound((byte)2, -1);
        }
        this.timeSinceGamePause = System.currentTimeMillis() - this.timeGamePause;
        this.timeWhenGameStarted += this.timeSinceGamePause;
    }

    public final Actor getMouseFromPool() {
        this.currMouse = (Mouse)this.mousePool.getNextFree();
        this.currMouse.activate();
        this.currMouse.resetSprite();
        return this.currMouse;
    }

    public final void releaseMouse(Actor b) {
        this.randomNumStack[((Mouse)b).getRandomMousePos()] = -1;
        b.deactivate();
        this.mousePool.release(b);
    }

    public void free() {
        ResManager.releaseImagesByCat(2);
    }

    public final FloatingScore getScoreFromPool() {
        return (FloatingScore)this.scorePool.getNextFree();
    }

    public final void releaseScore(FloatingScore score) {
        score.deactivate();
        this.scorePool.release(score);
    }
}

