/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.tools;

import com.manthanstudio.game.GameCanvas;
import com.manthanstudio.midlet.GameMIDlet;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class SoundUtils
implements PlayerListener {
    byte soundId;
    int soundLoop;
    public Player player;
    public String[] soundsName = new String[]{"/sounds/title.mid", "/sounds/beep.amr", "/sounds/bg_sound.mid"};
    public String[] soundsType = new String[]{"audio/midi", "audio/amr", "audio/midi"};
    byte[][] data = new byte[3][];

    public void loadSound(byte id) {
        this.soundId = id;
        try {
            if (this.player != null) {
                this.unloadSound();
            }
            this.player = Manager.createPlayer((InputStream)((Object)((Object)GameMIDlet.midlet)).getClass().getResourceAsStream(this.soundsName[id]), (String)this.soundsType[id]);
            this.player.addPlayerListener((PlayerListener)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unloadSound() {
        try {
            if (this.player != null) {
                this.player.stop();
                this.player.deallocate();
                this.player.removePlayerListener((PlayerListener)this);
                this.player.close();
                this.player = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopSound(byte id) {
        try {
            if (this.player != null) {
                this.player.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopSound() {
        try {
            if (this.player != null) {
                this.player.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playSound(byte id, int loop) {
        this.soundLoop = loop;
        this.loadSound(id);
        try {
            this.stopSound(id);
            if (GameCanvas.isSound) {
                this.player.setLoopCount(loop);
                this.player.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isPlaying() {
        return this.player != null && this.player.getState() == 400;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.compareTo("deviceAvailable") == 0) {
            if (GameCanvas.canvasState == 2 || GameCanvas.canvasState == 4) {
                this.loadSound(this.soundId);
                this.playSound(this.soundId, -1);
            }
        } else if (event.compareTo("deviceUnavailable") == 0) {
            // empty if block
        }
    }
}

