/*
 * Decompiled with CFR 0.152.
 */
package com.alienfactory.javamappy.viewer;

import com.alienfactory.javamappy.AnimBlock;
import com.alienfactory.javamappy.Block;
import com.alienfactory.javamappy.Layer;
import com.alienfactory.javamappy.MapHeader;
import com.alienfactory.javamappy.util.Logger;
import com.alienfactory.javamappy.util.ParameterChecker;
import com.alienfactory.javamappy.viewer.Viewer;
import com.alienfactory.javamappy.viewer.render.Renderer;

public class LayerViewer
extends Viewer {
    private final Logger j = Logger.createLogger(super.getClass());
    private final Layer k;
    private final int l;
    private final int m;
    private final int n;
    private final int o;
    private final int p;
    private final int q;

    public LayerViewer(Layer layer, MapHeader mapHeader, Renderer renderer, int n, int n2) {
        this(layer, mapHeader, renderer, n, n2, 0, 0);
    }

    public LayerViewer(Layer layer, MapHeader mapHeader, Renderer renderer, int n, int n2, int n3, int n4) {
        super(mapHeader, renderer, n, n2, n3, n4);
        ParameterChecker.checkNotNull(layer, "layer");
        this.k = layer;
        this.l = mapHeader.getBlockGapX();
        this.m = mapHeader.getBlockGapY();
        this.n = mapHeader.getBlockStaggerX();
        this.o = mapHeader.getBlockStaggerY();
        this.q = mapHeader.getMapBlockHeight();
        this.p = this.calculateTallestPillar();
    }

    public int calculateTallestPillar() {
        int n = 0;
        int n2 = this.a.getBlockHeight();
        Block[] blockArray = this.k.getBlocks();
        for (int i = 0; i < blockArray.length; ++i) {
            Block block = blockArray[i];
            int n3 = 0;
            int n4 = 0;
            if (block.getImageIndex(0) != 0) {
                n4 = n2;
            }
            if (block.getImageIndex(1) != 0) {
                n4 = n2;
            }
            if (block.getImageIndex(2) != 0) {
                n4 = n2 << 1;
            }
            if (block.getImageIndex(3) != 0) {
                n4 = n2 * 3;
            }
            while (blockArray[i].getFlag(1) && i++ < blockArray.length) {
                block = blockArray[i];
                int n5 = 0;
                if (block.getImageIndex(0) != 0) {
                    n5 = 1;
                }
                if (block.getImageIndex(1) != 0) {
                    n5 = 2;
                }
                if (block.getImageIndex(2) != 0) {
                    n5 = 3;
                }
                if (block.getImageIndex(3) != 0) {
                    n5 = 4;
                }
                n3 += 4;
                if (n5 <= 0) continue;
                n4 = (n3 + n5 - 1) * n2;
            }
            if (n >= n4) continue;
            n = n4;
        }
        this.j.debug("tallestPiller=[" + this.p + "]");
        return n;
    }

    public void drawBackground(Object object, boolean bl) {
        this.a(object, bl, true, false, false, false, 0, 0, this.c, this.d);
    }

    public void drawBackground(Object object, boolean bl, int n, int n2, int n3, int n4) {
        this.a(object, bl, true, false, false, false, n, n2, n3, n4);
    }

    public void drawForeground(Object object, int n) {
        ParameterChecker.checkMinMax(n, "blockLayer", 1, 3);
        boolean bl = n == 1;
        boolean bl2 = n == 2;
        n = n == 3 ? 1 : 0;
        this.a(object, true, false, bl, bl2, n != 0, 0, 0, this.c, this.d);
    }

    public void drawForeground(Object object, int n, int n2, int n3, int n4, int n5) {
        ParameterChecker.checkMinMax(n, "blockLayer", 1, 3);
        boolean bl = n == 1;
        boolean bl2 = n == 2;
        n = n == 3 ? 1 : 0;
        this.a(object, true, false, bl, bl2, n != 0, n2, n3, n4, n5);
    }

    public void draw(Object object, boolean bl) {
        this.a(object, bl, true, true, true, true, 0, 0, this.c, this.d);
    }

    public void draw(Object object, boolean bl, int n, int n2, int n3, int n4) {
        this.a(object, bl, true, true, true, true, n, n2, n3, n4);
    }

    public Layer getLayer() {
        return this.k;
    }

    private void a(Object object, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n + this.g;
        int n7 = n2 + this.h;
        int n8 = n6 / this.l;
        int n9 = n7 / this.m;
        n3 += (n += this.e);
        n4 += (n2 += this.f);
        int n10 = this.a.getBlockHeight();
        this.b.setClip(object, this.e, this.f, this.c, this.d);
        n -= n6 % this.l;
        n2 -= n7 % this.m;
        boolean bl6 = this.n != 0 || this.o != 0;
        if (bl6) {
            bl = true;
            n -= this.n;
            n2 -= this.o;
            n9 <<= 1;
            bl2 = true;
            bl3 = true;
            bl4 = true;
            bl5 = true;
        }
        n6 = n8;
        n7 = n;
        short[][] sArray = this.k.getLayerData();
        Block[] blockArray = this.k.getBlocks();
        AnimBlock[] animBlockArray = this.k.getAnimBlocks();
        int n11 = 0;
        int n12 = 0;
        boolean bl7 = bl;
        int n13 = n5 = this.i ? n10 : 0;
        if (this.i) {
            n4 += this.p;
        }
        while (n2 < n4) {
            Block block;
            int n14;
            int n15;
            n8 = n6;
            for (n = n7; n < n3; n += this.l) {
                if (!this.i || n9 < this.q) {
                    n15 = sArray[n9][n8];
                    if (n15 < 0) {
                        n15 = animBlockArray[-n15 - 1].getCurrentFrame();
                    }
                } else {
                    n15 = 0;
                }
                n14 = n2;
                --n15;
                do {
                    block = blockArray[++n15];
                    if (this.i) {
                        n12 = block.getFlag(2) ? 1 : (block.getFlag(3) ? 2 : 0);
                        if (n14 == n2) {
                            n11 = 0;
                            bl7 = bl;
                        } else {
                            n11 = n12;
                            bl7 = true;
                        }
                    }
                    if (bl2) {
                        n10 = block.getImageIndex(0);
                        if (!bl7 || n10 != 0) {
                            this.b.drawImage(object, n10, n, n14, bl7, n11);
                        }
                    }
                    n14 -= n5;
                    if (bl3 && (n10 = block.getImageIndex(1)) != 0) {
                        this.b.drawImage(object, n10, n, n14, true, n12);
                    }
                    n14 -= n5;
                    if (bl4 && (n10 = block.getImageIndex(2)) != 0) {
                        this.b.drawImage(object, n10, n, n14, true, n12);
                    }
                    n14 -= n5;
                    if (bl5 && (n10 = block.getImageIndex(3)) != 0) {
                        this.b.drawImage(object, n10, n, n14, true, n12);
                    }
                    n14 -= n5;
                } while (this.i && block.getFlag(1));
                ++n8;
            }
            if (bl6) {
                n8 = n6;
                ++n9;
                n2 += this.o;
                for (n = n7 + this.n; n < n3; n += this.l) {
                    if (!this.i || n9 < this.q) {
                        n15 = sArray[n9][n8];
                        if (n15 < 0) {
                            n15 = animBlockArray[-n15 - 1].getCurrentFrame();
                        }
                    } else {
                        n15 = 0;
                    }
                    n14 = n2;
                    --n15;
                    do {
                        block = blockArray[++n15];
                        if (this.i) {
                            n12 = block.getFlag(2) ? 1 : (block.getFlag(3) ? 2 : 0);
                            if (n14 == n2) {
                                n11 = 0;
                                bl7 = bl;
                            } else {
                                n11 = n12;
                                bl7 = true;
                            }
                        }
                        if (bl2) {
                            n10 = block.getImageIndex(0);
                            if (!bl7 || n10 != 0) {
                                this.b.drawImage(object, n10, n, n14, bl7, n11);
                            }
                        }
                        n14 -= n5;
                        if (bl3 && (n10 = block.getImageIndex(1)) != 0) {
                            this.b.drawImage(object, n10, n, n14, true, n12);
                        }
                        n14 -= n5;
                        if (bl4 && (n10 = block.getImageIndex(2)) != 0) {
                            this.b.drawImage(object, n10, n, n14, true, n12);
                        }
                        n14 -= n5;
                        if (bl5 && (n10 = block.getImageIndex(3)) != 0) {
                            this.b.drawImage(object, n10, n, n14, true, n12);
                        }
                        n14 -= n5;
                    } while (this.i && block.getFlag(1));
                    ++n8;
                }
                n2 -= this.o;
            }
            ++n9;
            n2 += this.m;
        }
        this.b.restoreClip(object);
    }
}

