/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.controller;

import com.jarbull.efw.controller.Animation;
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.game.ISprite;
import com.jarbull.efw.ui.Component;
import com.jarbull.efw.util.ColorEx;
import com.jarbull.efw.util.FP;
import com.jarbull.efw.util.ImageEx;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class AnimationHolder {
    private static final AnimationHolder INSTANCE = new AnimationHolder();
    Hashtable animations = new Hashtable();
    Hashtable suspended = new Hashtable();
    int worldTimeLimit = 1;
    int lastWorldTime = 0;
    boolean enabled = true;

    public static AnimationHolder getInstance() {
        return INSTANCE;
    }

    private AnimationHolder() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getLastWorldTime() {
        return this.lastWorldTime;
    }

    public int getWorldTimeLimit() {
        return this.worldTimeLimit;
    }

    public void setWorldTimeLimit(int worldTimeLimit) {
        this.worldTimeLimit = worldTimeLimit;
    }

    public void addAnimation(Animation anim) {
        this.animations.put(anim.id, anim);
    }

    public void removeAnimation(String id) {
        this.animations.remove(id);
    }

    public int getSize() {
        return this.animations.size();
    }

    public Animation getAnimation(String id) {
        return (Animation)this.animations.get(id);
    }

    public void suspendAnimations() {
        this.enabled = false;
        Enumeration animEnum = this.animations.keys();
        while (animEnum.hasMoreElements()) {
            String key = (String)animEnum.nextElement();
            this.suspended.put(key, this.animations.get(key));
        }
        this.animations.clear();
    }

    public void restoreSuspended() {
        Enumeration animEnum = this.suspended.keys();
        while (animEnum.hasMoreElements()) {
            String key = (String)animEnum.nextElement();
            this.animations.put(key, this.suspended.get(key));
        }
        this.suspended.clear();
        this.enabled = true;
    }

    public void removeAllAnimations() {
        this.animations.clear();
    }

    public Animation[] getAllAnimations() {
        Animation[] result = new Animation[this.animations.size()];
        Enumeration animEnum = this.animations.elements();
        int i = 0;
        while (animEnum.hasMoreElements()) {
            result[i++] = (Animation)animEnum.nextElement();
        }
        return result;
    }

    public Animation[] getAnimations(Graphics g) {
        Vector<Animation> anims = new Vector<Animation>();
        Enumeration animEnum = anims.elements();
        while (animEnum.hasMoreElements()) {
            Animation animation = (Animation)animEnum.nextElement();
            if (!g.equals(animation.g)) continue;
            anims.addElement(animation);
        }
        Object[] result = new Animation[anims.size()];
        anims.copyInto(result);
        return result;
    }

    public Animation[] getAnimations(ISprite gameObject) {
        Vector<Animation> anims = new Vector<Animation>();
        Enumeration animEnum = anims.elements();
        while (animEnum.hasMoreElements()) {
            Animation animation = (Animation)animEnum.nextElement();
            if (!gameObject.equals(animation.gameObject)) continue;
            anims.addElement(animation);
        }
        Object[] result = new Animation[anims.size()];
        anims.copyInto(result);
        return result;
    }

    public Animation[] getAnimations(Component component) {
        Vector<Animation> anims = new Vector<Animation>();
        Enumeration animEnum = anims.elements();
        while (animEnum.hasMoreElements()) {
            Animation animation = (Animation)animEnum.nextElement();
            if (!component.equals(animation.component)) continue;
            anims.addElement(animation);
        }
        Object[] result = new Animation[anims.size()];
        anims.copyInto(result);
        return result;
    }

    public void animate(int time) {
        if (!this.enabled) {
            return;
        }
        if (time > this.worldTimeLimit) {
            time %= this.worldTimeLimit;
        }
        Enumeration animEnum = this.animations.elements();
        while (animEnum.hasMoreElements()) {
            Animation animation = (Animation)animEnum.nextElement();
            if (!animation.enabled) continue;
            int animTime = time - animation.startTime;
            int animEndTime = animation.endTime - animation.startTime;
            if (animation.repeatMode == 1) {
                if (animTime <= 0) continue;
                animTime %= animEndTime + animation.loopDelay;
            }
            if (this.lastWorldTime <= animation.endTime && time >= animation.endTime) {
                animation.onAnimationFinished();
                animTime = animEndTime - 1;
            } else if (animTime < 0) continue;
            switch (animation.getType()) {
                case 0: {
                    ISprite sprite = animation.gameObject;
                    sprite.setFrameSequence(animation.frameSequence);
                    int f = animTime * sprite.getFrameSequenceLength() / animEndTime;
                    sprite.setFrame(f);
                    break;
                }
                case 1: {
                    int sx = animation.typeParameters[0];
                    int sy = animation.typeParameters[1];
                    int ex = animation.typeParameters[2];
                    int ey = animation.typeParameters[3];
                    int x = animTime * (ex - sx) / animEndTime + sx;
                    int y = animTime * (ey - sy) / animEndTime + sy;
                    if (animation.gameObject != null) {
                        animation.gameObject.setPosition(x, y);
                        break;
                    }
                    animation.component.setPosition(x, y);
                    break;
                }
                case 2: {
                    int sa = animation.typeParameters[0];
                    int ea = animation.typeParameters[1];
                    int cx = FP.intToFP(animation.typeParameters[2]);
                    int cy = FP.intToFP(animation.typeParameters[3]);
                    int angle = FP.toRadians(FP.intToFP(animation.typeParameters[4]));
                    int a = animation.typeParameters[5];
                    int b = animation.typeParameters[6];
                    int t = FP.toRadians(FP.Div(FP.intToFP(animTime * (ea - sa)), FP.intToFP(animEndTime + sa)));
                    int x = FP.toInt(cx + FP.Mul(FP.Mul(a, FP.Cos(t)), FP.Cos(angle)) - FP.Mul(FP.Mul(b, FP.Sin(t)), FP.Sin(angle)));
                    int y = FP.toInt(cy - FP.Mul(FP.Mul(a, FP.Cos(t)), FP.Sin(angle)) - FP.Mul(FP.Mul(b, FP.Sin(t)), FP.Cos(angle)));
                    if (animation.gameObject != null) {
                        animation.gameObject.setPosition(x, y);
                        break;
                    }
                    animation.component.setPosition(x, y);
                    break;
                }
                case 3: {
                    int sa = animation.typeParameters[0];
                    int ea = animation.typeParameters[1];
                    int a = animTime * (ea - sa) / animEndTime + sa;
                    ImageHandler.getInstance().setImage(animation.gameObject.getImageId(), ImageEx.setImageAlpha(animation.originalImageId, a));
                    break;
                }
                case 4: {
                    int sa = animation.typeParameters[0];
                    int ea = animation.typeParameters[1];
                    int a = animTime * (ea - sa) / animEndTime + sa;
                    ImageHandler.getInstance().setImage(animation.gameObject.getImageId(), ImageEx.rotateImage(ImageHandler.getInstance().getImage(animation.originalImageId), a));
                    break;
                }
                case 5: {
                    int sc = animation.typeParameters[0];
                    int ec = animation.typeParameters[1];
                    animation.g.setColor(ColorEx.getMidColor(sc, ec, animEndTime * (animEndTime - animTime - 1) / (animEndTime - 1), animEndTime));
                    break;
                }
                case 6: {
                    int y;
                    int x;
                    int sx = animation.typeParameters[0];
                    int sy = animation.typeParameters[1];
                    if (animation.gameObject != null) {
                        x = animTime * sx * 2 / animEndTime + animation.gameObject.getX() - sx;
                        y = animTime * sy * 2 / animEndTime + animation.gameObject.getY() - sy;
                        animation.gameObject.setPosition(x, y);
                        break;
                    }
                    x = animTime * sx * 2 / animEndTime + animation.component.getX() - sx;
                    y = animTime * sy * 2 / animEndTime + animation.component.getY() - sy;
                    animation.component.setPosition(x, y);
                    break;
                }
                case 7: {
                    int sw = animation.typeParameters[0];
                    int sh = animation.typeParameters[1];
                    int ew = animation.typeParameters[2];
                    int eh = animation.typeParameters[3];
                    int w = animTime * (ew - sw) / animEndTime + sw;
                    int h = animTime * (eh - sh) / animEndTime + sh;
                    ImageHandler.getInstance().setImage(animation.gameObject.getImageId(), ImageEx.resizeImage(ImageHandler.getInstance().getImage(animation.originalImageId), w, h, true));
                    animation.gameObject.setImage(animation.gameObject.getImageId(), ImageHandler.getInstance().getImage(animation.gameObject.getImageId()).getWidth(), ImageHandler.getInstance().getImage(animation.gameObject.getImageId()).getHeight());
                    break;
                }
                case 8: {
                    int sx = animation.typeParameters[0];
                    int sy = animation.typeParameters[1];
                    int sw = animation.typeParameters[2];
                    int sh = animation.typeParameters[3];
                    int ex = animation.typeParameters[4];
                    int ey = animation.typeParameters[5];
                    int ew = animation.typeParameters[6];
                    int eh = animation.typeParameters[7];
                    int x = animTime * (ex - sx) / animEndTime + sx;
                    int y = animTime * (ey - sy) / animEndTime + sy;
                    int width = animTime * (ew - sw) / animEndTime + sw;
                    int height = animTime * (eh - sh) / animEndTime + sh;
                    animation.g.setClip(x, y, width, height);
                    break;
                }
                case 9: {
                    boolean visible;
                    boolean bl = visible = animation.typeParameters[0] != 0;
                    if (animTime > animEndTime) {
                        boolean bl2 = visible = !visible;
                    }
                    if (animation.gameObject != null) {
                        animation.gameObject.setVisible(visible);
                        break;
                    }
                    animation.component.setVisible(visible);
                }
            }
        }
        this.lastWorldTime = time;
    }
}

