/*
 * Decompiled with CFR 0.152.
 */
package subjects;

import com.jarbull.efw.game.EFSprite;
import com.jarbull.efw.game.TimerHolder;
import java.util.Timer;
import java.util.TimerTask;
import subjects.Hero;
import utilities.MyMath;

public class Charge
extends EFSprite {
    Timer timer;
    private int lifeTime = 0;
    private int startID = 0;
    private boolean flagActivity = false;
    private int speed = 0;
    private int id = 0;
    private int chargeID;
    private int radius;
    private boolean visible;
    private int[] frames = new int[]{8, 9, 10, 11};

    public Charge(String ImagePath) {
        super(ImagePath, 8, 8);
        this.setFrameSequence(this.frames);
        this.switchOnChargeMainTimer();
    }

    public void setChargePosition(int enemy_x, int enemy_y) {
        if (!this.flagActivity) {
            this.setVisible(false);
            this.visible = false;
            this.setPosition(enemy_x - this.getWidth() / 2, enemy_y - this.getHeight() / 2);
        }
    }

    public void moveCharge(int hero_x, int hero_y, int charge_x, int charge_y) {
        if (this.id != 0 && this.flagActivity) {
            if (this.getChargeRadius() > 25) {
                this.setVisible(true);
                this.visible = true;
            }
            int vx = MyMath.getVXMove(hero_x, hero_y, this.getX(), this.getY(), this.speed);
            int vy = MyMath.getVYMove(hero_x, hero_y, this.getX(), this.getY(), this.speed);
            this.move(vx, vy);
        }
    }

    public void setSpeed(int new_speed) {
        this.speed = new_speed;
    }

    public int getSpeed(int new_speed) {
        return this.speed;
    }

    public void setActivity(boolean flag) {
        this.flagActivity = flag;
    }

    public boolean getActivity() {
        return this.flagActivity;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public void setChargeID(int id) {
        this.chargeID = id;
    }

    public int getChargeID() {
        return this.chargeID;
    }

    public void setChargeRadius(int x_enemy, int y_enemy) {
        this.radius = (int)MyMath.getDist(x_enemy, this.getX(), y_enemy, this.getY());
    }

    private int getChargeRadius() {
        return this.radius;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public boolean collisionWithHero(Hero hero) {
        boolean collision = false;
        if (this.collidesWith(hero, false)) {
            this.setActivity(false);
            this.lifeTime = 0;
            collision = true;
        }
        return collision;
    }

    private void switchOnChargeMainTimer() {
        this.timer = new Timer();
        TimerHolder.getInstance().addTimer(this.timer);
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (Charge.this.startID == Charge.this.id * 1) {
                    Charge.this.switchOnChargeTimer();
                }
                Charge.this.startID++;
            }
        }, 0L, 1000L);
    }

    private void switchOnChargeTimer() {
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (Charge.this.flagActivity) {
                    Charge.this.lifeTime++;
                }
                if (Charge.this.lifeTime == 5) {
                    Charge.this.flagActivity = false;
                    Charge.this.lifeTime = 0;
                }
            }
        }, 0L, 1000L);
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (Charge.this.getChargeID() == 1) {
                    Charge.this.flagActivity = true;
                }
            }
        }, 500L, 500L);
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (Charge.this.getChargeID() == 2) {
                    Charge.this.flagActivity = true;
                }
            }
        }, 1000L, 500L);
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (Charge.this.getChargeID() == 3) {
                    Charge.this.flagActivity = true;
                }
            }
        }, 1500L, 500L);
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (Charge.this.getChargeID() == 4) {
                    Charge.this.flagActivity = true;
                }
            }
        }, 2000L, 500L);
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (Charge.this.getChargeID() == 5) {
                    Charge.this.flagActivity = true;
                }
            }
        }, 2500L, 500L);
    }

    public void switchOffChargeTimer() {
        this.timer.cancel();
    }
}

