/*
 * Decompiled with CFR 0.152.
 */
package utilities;

public class MyMath {
    public MyMath() {
        System.out.println("Initialization class MyMath!");
        System.out.println("");
    }

    private static double arcsin(double x0) {
        double x = x0;
        if (x0 < 0.0) {
            x = -x0;
        }
        double y = x;
        int n = 1;
        double sn = x;
        while (sn > 0.1) {
            sn = sn * (2.0 + 1.0 / (double)n) * 0.5 * x * x;
            y += sn / (double)(2 * n + 1) / (double)(2 * n + 1);
            ++n;
        }
        if (x0 < 0.0) {
            y = -y;
        }
        return y;
    }

    public static double getAngle360(int x1, int y1, int x2, int y2) {
        double y = MyMath.getDist(0, 0, y1, y2);
        double c = MyMath.getDist(x1, x2, y1, y2);
        double x = y / c;
        double arcsin = 0.0;
        if (Math.abs(x) >= 0.97) {
            x = 0.95;
        }
        if (x2 < x1 && y2 > y1) {
            arcsin = MyMath.arcsin(x);
        } else if (x2 > x1 && y2 > y1) {
            arcsin = Math.PI - MyMath.arcsin(x);
        } else if (x2 > x1 && y2 < y1) {
            arcsin = Math.PI + MyMath.arcsin(x);
        } else if (x2 < x1 && y2 < y1) {
            arcsin = Math.PI * 2 - MyMath.arcsin(x);
        } else if (x2 == x1 && y2 < y1) {
            arcsin = 4.71238898038469;
        } else if (x2 == x1 && y2 > y1) {
            arcsin = 1.5707963267948966;
        } else if (x2 > x1 && y2 == y1) {
            arcsin = Math.PI;
        } else if (x2 < x1 && y2 == y1) {
            arcsin = Math.PI * 2;
        } else if (y1 < y2) {
            arcsin = 1.5707963267948966;
        } else if (y1 > y2) {
            arcsin = -1.5707963267948966;
        }
        return arcsin;
    }

    public static int getAngleInDegrees(int x1, int y1, int x2, int y2) {
        return (int)Math.toDegrees(MyMath.getAngle360(x1, y1, x2, y2));
    }

    public static double getDist(int x1, int x2, int y1, int y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static int getXCoordinate(int x0, int l, double alpha) {
        double x = (double)x0 + (double)l * Math.cos(alpha);
        return (int)x;
    }

    public static int getYCoordinate(int y0, int l, double alpha) {
        double y = (double)y0 - (double)l * Math.sin(alpha);
        return (int)y;
    }

    public static int getVXMove(int x1, int y1, int x2, int y2, int speed) {
        return (int)((double)((x1 - x2) * speed) / Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2)));
    }

    public static int getVYMove(int x1, int y1, int x2, int y2, int speed) {
        return (int)((double)((y1 - y2) * speed) / Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2)));
    }

    public static int move_vx(int speed, double angle) {
        int _vx = (int)(Math.cos(Math.toRadians(angle)) * (double)speed);
        return _vx;
    }

    public static int move_vy(int speed, double angle) {
        int _vy = (int)(Math.sin(Math.toRadians(angle)) * (double)speed);
        return _vy;
    }
}

