/*
 * Decompiled with CFR 0.152.
 */
public final class cMath {
    private static final short[] sf_a_i16Sine = new short[]{0, 6, 13, 19, 25, 31, 38, 44, 50, 56, 62, 68, 74, 80, 86, 92, 98, 104, 109, 115, 121, 126, 132, 137, 142, 147, 152, 157, 162, 167, 172, 177, 181, 185, 190, 194, 198, 202, 206, 209, 213, 216, 220, 223, 226, 229, 231, 234, 237, 239, 241, 243, 245, 247, 248, 250, 251, 252, 253, 254, 255, 255, 256, 256, 256, 256, 256, 255, 255, 254, 253, 252, 251, 250, 248, 247, 245, 243, 241, 239, 237, 234, 231, 229, 226, 223, 220, 216, 213, 209, 206, 202, 198, 194, 190, 185, 181, 177, 172, 167, 162, 157, 152, 147, 142, 137, 132, 126, 121, 115, 109, 104, 98, 92, 86, 80, 74, 68, 62, 56, 50, 44, 38, 31, 25, 19, 13, 6, 0, -6, -13, -19, -25, -31, -38, -44, -50, -56, -62, -68, -74, -80, -86, -92, -98, -104, -109, -115, -121, -126, -132, -137, -142, -147, -152, -157, -162, -167, -172, -177, -181, -185, -190, -194, -198, -202, -206, -209, -213, -216, -220, -223, -226, -229, -231, -234, -237, -239, -241, -243, -245, -247, -248, -250, -251, -252, -253, -254, -255, -255, -256, -256, -256, -256, -256, -255, -255, -254, -253, -252, -251, -250, -248, -247, -245, -243, -241, -239, -237, -234, -231, -229, -226, -223, -220, -216, -213, -209, -206, -202, -198, -194, -190, -185, -181, -177, -172, -167, -162, -157, -152, -147, -142, -137, -132, -126, -121, -115, -109, -104, -98, -92, -86, -80, -74, -68, -62, -56, -50, -44, -38, -31, -25, -19, -13, -6};
    private static long[] s_a_lRandomSeed;

    public static final int sAbs(int n) {
        if (n >= 0) {
            return n;
        }
        return -n;
    }

    public static final int sMax(int n, int n2) {
        if (n >= n2) {
            return n;
        }
        return n2;
    }

    public static final int sMin(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    public static final void sRandInitialize(int n) {
        s_a_lRandomSeed = new long[2];
        long l = System.currentTimeMillis();
        while (n-- > 0) {
            ++l;
        }
    }

    public static final void sRandSeed$255f656(long l) {
        cMath.s_a_lRandomSeed[0] = l;
    }

    public static final int sRand(int n, int n2) {
        long l;
        cMath.s_a_lRandomSeed[n] = l = s_a_lRandomSeed[n] * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(l >>> 17) % n2;
    }

    public static final int sSin(int n) {
        return sf_a_i16Sine[n &= 0xFF];
    }

    public static final int sCos(int n) {
        n = n + 64 & 0xFF;
        return sf_a_i16Sine[n];
    }

    public static final int sArcSin(int n) {
        boolean bl;
        int n2 = 0;
        int n3 = 32;
        int n4 = 64;
        if (n > 0) {
            bl = false;
        } else {
            n = -n;
            bl = true;
        }
        do {
            if (sf_a_i16Sine[n3] >= n) {
                n4 = n3;
                continue;
            }
            n2 = n3;
        } while ((n3 = n2 + n4 >> 1) != n2);
        if (bl) {
            return 256 - n3;
        }
        return n3;
    }

    public static final int sAngle(int n, int n2) {
        int n3 = cMath.sNorm(n, n2);
        if (n3 == 0) {
            return 0;
        }
        n2 = cMath.sArcSin((n2 << 9) / n3 + 1 >> 1);
        if (n >= 0) {
            return n2;
        }
        return 128 - n2;
    }

    public static final int sAngleFast(int n, int n2) {
        int n3;
        int n4;
        if (n2 > 0 ^ n > 0) {
            n4 = n2 > 0 ? 96 : 224;
            n3 = n + n2;
            n -= n2;
        } else {
            n4 = n2 > 0 ? 32 : 160;
            n3 = n2 - n;
            n = n2 + n;
        }
        if (n == 0) {
            return n4;
        }
        return n4 + (n3 << 5) / n & 0xFF;
    }

    public static final int sSqrt(int n) {
        int n2;
        if (n >= 0x40000000) {
            n -= 0x40000000;
            n2 = 65536;
        } else {
            n2 = 0;
        }
        int n3 = (n2 | 0x4000) << 14;
        if (n >= n3) {
            n -= n3;
            n2 |= 0x8000;
        }
        if (n >= (n3 = (n2 | 0x2000) << 13)) {
            n -= n3;
            n2 |= 0x4000;
        }
        if (n >= (n3 = (n2 | 0x1000) << 12)) {
            n -= n3;
            n2 |= 0x2000;
        }
        if (n >= (n3 = (n2 | 0x800) << 11)) {
            n -= n3;
            n2 |= 0x1000;
        }
        if (n >= (n3 = (n2 | 0x400) << 10)) {
            n -= n3;
            n2 |= 0x800;
        }
        if (n >= (n3 = (n2 | 0x200) << 9)) {
            n -= n3;
            n2 |= 0x400;
        }
        if (n >= (n3 = (n2 | 0x100) << 8)) {
            n -= n3;
            n2 |= 0x200;
        }
        if (n >= (n3 = (n2 | 0x80) << 7)) {
            n -= n3;
            n2 |= 0x100;
        }
        if (n >= (n3 = (n2 | 0x40) << 6)) {
            n -= n3;
            n2 |= 0x80;
        }
        if (n >= (n3 = (n2 | 0x20) << 5)) {
            n -= n3;
            n2 |= 0x40;
        }
        if (n >= (n3 = (n2 | 0x10) << 4)) {
            n -= n3;
            n2 |= 0x20;
        }
        if (n >= (n3 = (n2 | 8) << 3)) {
            n -= n3;
            n2 |= 0x10;
        }
        if (n >= (n3 = (n2 | 4) << 2)) {
            n -= n3;
            n2 |= 8;
        }
        if (n >= (n3 = (n2 | 2) << 1)) {
            n -= n3;
            n2 |= 4;
        }
        if (n >= (n2 | 1)) {
            n2 |= 2;
        }
        return n2 >> 1;
    }

    public static final long sSqrt(long l) {
        int n = 0;
        long l2 = l;
        while (l2 > 3L) {
            l2 >>= 2;
            ++n;
        }
        l2 = 0L;
        while (n >= 0) {
            long l3 = (l2 | (long)(1 << n)) << n;
            if (l >= l3) {
                l -= l3;
                l2 |= (long)(2 << n);
            }
            --n;
        }
        return l2 >> 1;
    }

    public static final int sNorm(int n, int n2) {
        return cMath.sSqrt(n * n + n2 * n2);
    }

    public static final int sNorm(int n, int n2, int n3) {
        return cMath.sSqrt(n * n + n2 * n2 + n3 * n3);
    }

    public static final int sNormChessboard(int n, int n2) {
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n > n2) {
            return n;
        }
        return n2;
    }

    public static final int sNormFast(int n, int n2) {
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n > n2) {
            return n * 123 + n2 * 51 >> 7;
        }
        return n2 * 123 + n * 51 >> 7;
    }

    public static final int sNormFast(int n, int n2, int n3) {
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n3 > (n = n > n2 ? n * 123 + n2 * 51 >> 7 : n2 * 123 + n * 51 >> 7)) {
            return n3 * 123 + n * 51 >> 7;
        }
        return n * 123 + n3 * 51 >> 7;
    }

    public static final boolean sSegmentSegmentIntersectionCheck(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n4 - n2;
        int n10 = n - n3;
        int n11 = n9 * n + n10 * n2;
        int n12 = n9 * n5 + n10 * n6 - n11;
        if (n12 != 0 && (n9 = n9 * n7 + n10 * n8 - n11) != 0 && n12 < 0 ^ n9 > 0) {
            return false;
        }
        n9 = n8 - n6;
        n10 = n5 - n7;
        n11 = n9 * n5 + n10 * n6;
        n12 = n9 * n + n10 * n2 - n11;
        return n12 == 0 || (n9 = n9 * n3 + n10 * n4 - n11) == 0 || !(n12 < 0 ^ n9 > 0);
    }

    public static final boolean sSegmentLineIntersectionCheck(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n5 = n7 * (n2 - n6) - n8 * (n - n5)) & Integer.MIN_VALUE) == ((n = n8 * (n3 - n) - n7 * (n4 - n2)) & Integer.MIN_VALUE) && cMath.sAbs(n5) < cMath.sAbs(n);
    }

    public static final boolean sSegmentCloseToPointCheck(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n = n5 - n3;
        n7 = n4 - n6;
        n3 = 13440 - n3;
        n4 = n2 - n4;
        if (n == 0 && n7 == 0) {
            return cMath.sNormFast(n3, n4) < 62;
        }
        if (n * n3 < n7 * n4 || n * (13440 - n5) > n7 * (n2 - n6)) {
            return false;
        }
        return cMath.sAbs(n * n4 + n7 * n3) < 62 * cMath.sNormFast(n, n7);
    }

    public static final boolean sSegment3DCloseToPointCheck(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        n -= n4;
        return (n8 = (n4 -= n7) * n4 + (n5 -= n8) * n5 + (n6 -= n9) * n6 >> 8) * (n7 = n * n + (n2 -= n5) * n2 + (n3 -= n6) * n3 >> 8) - (n = n * n4 + n2 * n5 + n3 * n6 >> 8) * n < n7 * (n10 * n10 >> 8);
    }

    public static final int[] sSegmentSegmentIntersectionFind(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = (n3 -= n) * (n8 -= n6) >> 8;
        int n10 = (n7 -= n5) * (n4 -= n2) >> 8;
        int n11 = n10 - n9;
        int[] nArray = new int[2];
        if (n11 != 0) {
            nArray[0] = (n10 * n - n9 * n5 + (n3 * n7 >> 8) * (n6 - n2)) / n11;
            nArray[1] = (n10 * n6 - n9 * n2 + (n4 * n8 >> 8) * (n5 - n)) / n11;
        }
        return nArray;
    }
}

