/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Game {
    Main mGR;
    int Counter = 0;

    Game(Main m) throws IOException {
        this.mGR = m;
    }

    float floatHeight(int Height) {
        return (float)Height / M.TY * 2.0f;
    }

    float floatWidth(int Width) {
        return (float)Width / M.TX * 2.0f;
    }

    void DrawTexture(Graphics gl, Image img, float x, float y) {
        gl.drawImage(img, this.XPos(x), this.YPos(y), 3);
    }

    void DrawTextureS(Graphics gl, Image img, float x, float y, float scal) {
        gl.drawImage(Main.rescaleImage(img, scal, scal), this.XPos(x), this.YPos(y), 3);
    }

    void DrawTextureSS(Graphics gl, Image img, float x, float y, float scalx, float scaly) {
        gl.drawImage(Main.rescaleImage(img, scalx, scaly), this.XPos(x), this.YPos(y), 3);
    }

    void DrawTextureR(Graphics gl, Image img, float x, float y, float ang) {
        gl.drawImage(this.mGR.rotateImage(img, ang), this.XPos(x), this.YPos(y), 3);
    }

    void DrawTextureInt(Graphics gl, Image img, int x, int y) {
        gl.drawImage(img, x, y, 3);
    }

    public void draw(Graphics gl) {
        ++this.Counter;
        switch (M.GameScreen) {
            case 0: {
                this.DrawTexture(gl, this.mGR.mTex_Logo, 0.0f, 0.0f);
                if (this.Counter <= 80) break;
                M.GameScreen = 1;
                break;
            }
            case 1: {
                this.DrawMenu(gl);
                break;
            }
            case 3: {
                this.Draw_GamePlay(gl);
                break;
            }
            case 8: 
            case 9: {
                this.DrawPauseOrGover(gl);
                break;
            }
            case 7: 
            case 10: {
                this.DrawHelpInfo(gl);
                break;
            }
            case 2: {
                this.DrawHighScore(gl);
            }
        }
    }

    public boolean TouchEvent(int event, int x, int y) {
        switch (M.GameScreen) {
            case 0: {
                break;
            }
            case 1: {
                this.HandleMenu(event, x, y);
                break;
            }
            case 3: {
                this.Handle_GamePlay(event, x, y);
                break;
            }
            case 8: 
            case 9: {
                this.HandlePauseOrGameover(event, x, y);
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                this.HandleHelpInfo(event, x, y);
            }
        }
        return true;
    }

    void DrawMenu(Graphics gl) {
        float x = -0.6f;
        float x1 = 0.75f;
        this.DrawTexture(gl, this.mGR.mTex_Splash, 0.0f, 0.0f);
        this.DrawTexture(gl, this.mGR.mTex_NewGameBtn, x, -0.15f);
        this.DrawTexture(gl, this.mGR.mTex_HelpBtn, x, -0.33f);
        this.DrawTexture(gl, this.mGR.mTex_AbtUsBtn, x, -0.51f);
        this.DrawTexture(gl, this.mGR.mTex_HighScoreBtn, x, -0.69f);
        if (M.setValue) {
            this.DrawTexture(gl, this.mGR.mTex_SoundBtn[0], -x1, -0.92f);
        } else {
            this.DrawTexture(gl, this.mGR.mTex_SoundBtn[1], -x1, -0.92f);
        }
        this.DrawTexture(gl, this.mGR.mTex_Exit, x1, -0.92f);
        switch (this.mGR.mSel) {
            case 1: {
                this.DrawTexture(gl, this.mGR.mTex_Selector, x, -0.15f);
                break;
            }
            case 2: {
                this.DrawTexture(gl, this.mGR.mTex_Selector, x, -0.33f);
                break;
            }
            case 3: {
                this.DrawTexture(gl, this.mGR.mTex_Selector, x, -0.51f);
                break;
            }
            case 4: {
                this.DrawTexture(gl, this.mGR.mTex_Selector, x, -0.69f);
                break;
            }
            case 5: {
                this.DrawTexture(gl, this.mGR.mTex_SmallSel, -x1, -0.92f);
                break;
            }
            case 6: {
                this.DrawTexture(gl, this.mGR.mTex_SmallSel, x1, -0.92f);
            }
        }
    }

    boolean HandleMenu(int event, int x, int y) {
        this.mGR.mSel = 0;
        float xx = -0.6f;
        float x1 = 0.75f;
        float dx = this.mGR.mTex_NewGameBtn.getWidth() / 2;
        float dy = this.mGR.mTex_NewGameBtn.getHeight() / 2;
        if (this.CircRectsOverlap(this.XPos(xx), this.YPos(-0.15f), dx, dy, x, y, 5.0f)) {
            this.mGR.mSel = 1;
        }
        if (this.CircRectsOverlap(this.XPos(xx), this.YPos(-0.33f), dx, dy, x, y, 5.0f)) {
            this.mGR.mSel = 2;
        }
        if (this.CircRectsOverlap(this.XPos(xx), this.YPos(-0.51f), dx, dy, x, y, 5.0f)) {
            this.mGR.mSel = 3;
        }
        if (this.CircRectsOverlap(this.XPos(xx), this.YPos(-0.69f), dx, dy, x, y, 5.0f)) {
            this.mGR.mSel = 4;
        }
        if (this.CircRectsOverlap(this.XPos(-x1), this.YPos(-0.92f), dx / 2.0f, dy, x, y, 5.0f)) {
            this.mGR.mSel = 5;
        }
        if (this.CircRectsOverlap(this.XPos(x1), this.YPos(-0.92f), dx / 2.0f, dy, x, y, 5.0f)) {
            this.mGR.mSel = 6;
        }
        if (event == 2) {
            switch (this.mGR.mSel) {
                case 1: {
                    M.GameScreen = 3;
                    this.mGR.gameReset();
                    break;
                }
                case 2: {
                    M.GameScreen = 7;
                    break;
                }
                case 3: {
                    M.GameScreen = 10;
                    break;
                }
                case 4: {
                    M.GameScreen = 2;
                    break;
                }
                case 5: {
                    M.setValue = !M.setValue;
                    break;
                }
                case 6: {
                    this.mGR.closeApp();
                }
            }
            this.mGR.mSel = 0;
        }
        return true;
    }

    void DrawHelpInfo(Graphics gl) {
        this.DrawTexture(gl, this.mGR.mTex_StarBG, 0.0f, 0.0f);
        this.DrawTexture(gl, this.mGR.mTex_PopUp, 0.0f, 0.0f);
        if (M.GameScreen == 7) {
            this.DrawTexture(gl, this.mGR.mTex_HelpTitle, 0.0f, 0.425f);
            this.DrawTexture(gl, this.mGR.mTex_HelpTxt, 0.0f, 0.0f);
        }
        if (M.GameScreen == 10) {
            this.DrawTexture(gl, this.mGR.mTex_AbtTitle, 0.0f, 0.425f);
            this.DrawTexture(gl, this.mGR.mTex_AbtUsTxt, 0.0f, 0.0f);
        }
        this.DrawBackBtn(gl);
    }

    void DrawHighScore(Graphics gl) {
        this.DrawTexture(gl, this.mGR.mTex_StarBG, 0.0f, 0.0f);
        this.DrawTexture(gl, this.mGR.mTex_PopUp, 0.0f, 0.0f);
        this.DrawTexture(gl, this.mGR.mTex_HighScoreBtn, 0.0f, 0.425f);
        String str1 = this.mGR.mHScore + "";
        float dx1 = (float)str1.length() * this.floatWidth(this.mGR.mTex_Font[0].getWidth() / 2) / 2.0f;
        this.drawNumber(gl, this.mGR.mHScore, -dx1, 0.0f);
        this.DrawBackBtn(gl);
    }

    boolean HandleHelpInfo(int event, int x, int y) {
        this.mGR.mSel = 0;
        if (this.CircRectsOverlap(this.XPos(0.75f), this.YPos(-0.9f), this.mGR.mTex_backBtn.getWidth() / 2, this.mGR.mTex_backBtn.getHeight() / 2, x, y, 5.0f)) {
            this.mGR.mSel = 100;
        }
        if (event == 2) {
            if (this.mGR.mSel == 100) {
                M.GameScreen = 1;
            }
            this.mGR.mSel = 0;
        }
        return true;
    }

    void DrawPauseOrGover(Graphics gl) {
        this.DrawTexture(gl, this.mGR.mTex_StarBG, 0.0f, 0.0f);
        this.DrawTexture(gl, this.mGR.mTex_PopUp, 0.0f, 0.0f);
        if (M.GameScreen == 9) {
            this.DrawTexture(gl, this.mGR.mTex_GamePauseTitle, 0.0f, 0.425f);
        } else {
            this.DrawTexture(gl, this.mGR.mTex_GameOverTitle, 0.0f, 0.425f);
        }
        this.DrawTexture(gl, this.mGR.mTex_NewScore, -0.45f, 0.21f);
        this.DrawTexture(gl, this.mGR.mTex_ScoreBox, 0.35f, 0.2f);
        String str = this.mGR.mScore + "";
        float dx = (float)str.length() * this.floatWidth(this.mGR.mTex_Font[0].getWidth() / 2) / 2.0f;
        this.drawNumber(gl, this.mGR.mScore, 0.35f - dx, 0.2f);
        this.DrawTexture(gl, this.mGR.mTex_BestScore, -0.45f, 0.01f);
        this.DrawTexture(gl, this.mGR.mTex_ScoreBox, 0.35f, 0.0f);
        String str1 = this.mGR.mHScore + "";
        float dx1 = (float)str1.length() * this.floatWidth(this.mGR.mTex_Font[0].getWidth() / 2) / 2.0f;
        this.drawNumber(gl, this.mGR.mHScore, 0.35f - dx1, 0.0f);
        float y = -0.38f;
        float x = 0.65f;
        if (M.setValue) {
            this.DrawTexture(gl, this.mGR.mTex_SoundBtn[0], -x, y);
        } else {
            this.DrawTexture(gl, this.mGR.mTex_SoundBtn[1], -x, y);
        }
        this.DrawTexture(gl, this.mGR.mTex_MenuBtn, 0.0f, y);
        if (M.GameScreen == 9) {
            this.DrawTexture(gl, this.mGR.mTex_Continue, x, y);
        } else {
            this.DrawTexture(gl, this.mGR.mTex_Replay, x, y);
        }
        switch (this.mGR.mSel) {
            case 1: {
                this.DrawTexture(gl, this.mGR.mTex_SmallSel, -x, y);
                break;
            }
            case 2: {
                this.DrawTexture(gl, this.mGR.mTex_SmallSel, 0.0f, y);
                break;
            }
            case 3: {
                this.DrawTexture(gl, this.mGR.mTex_SmallSel, x, y);
            }
        }
    }

    boolean HandlePauseOrGameover(int event, int x, int y) {
        this.mGR.mSel = 0;
        float yy = -0.38f;
        float xx = 0.65f;
        float dx = this.mGR.mTex_HighScoreBtn.getWidth() / 2;
        float dy = this.mGR.mTex_HighScoreBtn.getHeight() / 2;
        if (this.CircRectsOverlap(this.XPos(-xx), this.YPos(yy), dx / 2.0f, dy, x, y, 5.0f)) {
            this.mGR.mSel = 1;
        }
        if (this.CircRectsOverlap(this.XPos(0.0f), this.YPos(yy), dx / 2.0f, dy, x, y, 5.0f)) {
            this.mGR.mSel = 2;
        }
        if (this.CircRectsOverlap(this.XPos(xx), this.YPos(yy), dx / 2.0f, dy, x, y, 5.0f)) {
            this.mGR.mSel = 3;
        }
        if (event == 2) {
            switch (this.mGR.mSel) {
                case 1: {
                    M.setValue = !M.setValue;
                    break;
                }
                case 2: {
                    M.GameScreen = 1;
                    break;
                }
                case 3: {
                    if (M.GameScreen == 9) {
                        M.GameScreen = 3;
                        break;
                    }
                    this.mGR.gameReset();
                    M.GameScreen = 3;
                }
            }
            this.mGR.mSel = 0;
        }
        return true;
    }

    void setAnimation(float x, float y) {
        int j = 0;
        for (int i = 0; i < this.mGR.mAni.length && j < 30; ++i) {
            if (!(this.mGR.mAni[i].x < -10.0f)) continue;
            this.mGR.mAni[i].set(x, y, 1.0f, (this.randomBoolean() ? M.mRand.nextFloat() : -M.mRand.nextFloat()) * 0.01f, (this.randomBoolean() ? M.mRand.nextFloat() : -M.mRand.nextFloat()) * 0.01f, 1.0f);
            ++j;
        }
    }

    void GameLogic() {
        int i;
        ++this.mGR.mPlayer.mtap;
        this.mGR.mPlayer.y += this.mGR.mPlayer.vy;
        this.mGR.mPlayer.x += this.mGR.mPlayer.vx;
        if (this.mGR.mPlayer.x >= 0.95f) {
            this.mGR.mPlayer.x = 0.94f;
        }
        if (this.mGR.mPlayer.x <= -0.95f) {
            this.mGR.mPlayer.x = -0.94f;
        }
        if (this.mGR.mPlayer.vy < 0.06f) {
            this.mGR.mPlayer.vy += 0.002f;
        }
        for (i = 0; i < this.mGR.mPad.length; ++i) {
            this.mGR.mPad[i].Update();
            if (this.mGR.mPad[i].Gift == -3 || !this.CircRectsOverlap(this.XPos(this.mGR.mPad[i].x), (float)this.YPos(this.mGR.mPad[i].y) - (float)this.mGR.mTex_Pad.getHeight() * 0.1f, (float)this.mGR.mTex_Pad.getWidth() * 0.5f, (float)this.mGR.mTex_Pad.getHeight() * 0.4f, this.XPos(this.mGR.mPlayer.x), this.YPos(this.mGR.mPlayer.y), (float)this.mGR.mTex_Ball[3].getHeight() * 0.5f)) continue;
            if ((double)this.mGR.mPlayer.vy > 0.007) {
                this.mGR.mPlayer.mtap = 0;
                this.mGR.mPlayer.vy = -0.03f;
                this.mGR.mPlayer.y = this.mGR.mPad[i].y - this.floatHeight(this.mGR.mTex_Pad.getHeight()) * 1.6f;
                if (this.mGR.mPad[i].Gift == -1) {
                    this.mGR.mScore += 5;
                    this.mGR.mPad[i].Gift = -2;
                    if (this.mGR.mScore > this.mGR.mHScore) {
                        this.mGR.mHScore = this.mGR.mScore;
                        this.mGR.updateScore(this.mGR.mHScore, 0);
                    }
                    this.mGR.SoundPlay(1);
                }
            } else {
                this.mGR.mPlayer.y = this.mGR.mPad[i].y - this.floatHeight(this.mGR.mTex_Pad.getHeight()) * 1.0f;
                this.mGR.mPlayer.vy = 0.0f;
            }
            if (this.mGR.mPad[i].Gift == 8) {
                this.mGR.mPad[i].Gift = -3;
            }
            if (!(this.mGR.mPad[i].x > this.mGR.mPlayer.x - 0.25f) || !(this.mGR.mPad[i].x < this.mGR.mPlayer.x + 0.25f) || this.mGR.mPad[i].Gift <= -1) continue;
            for (int j = 0; j < this.mGR.mPoint.length && this.mGR.mPad[i].Gift > -1 && this.mGR.mPad[i].Gift < 7; ++j) {
                if (!((double)this.mGR.mPoint[j].y > 1.0)) continue;
                this.mGR.mPoint[j].set(this.mGR.mPad[i].x, this.mGR.mPad[i].y, -0.01f, this.mGR.mPad[i].Gift);
                if (this.mGR.mPad[i].Gift < 3) {
                    this.mGR.mScore += (this.mGR.mPad[i].Gift + 1) * 50;
                    this.mGR.SoundPlay(0);
                } else if (this.mGR.mPad[i].Gift < 6) {
                    this.mGR.mScore += (this.mGR.mPad[i].Gift + 1) * 100 - 50;
                    if (this.mGR.mPad[i].Gift == 5) {
                        this.mGR.mSpeedC = 300;
                        this.mGR.mSpeedN = 0;
                    }
                    this.mGR.SoundPlay(0);
                } else {
                    this.mGR.mScore += (this.mGR.mPad[i].Gift + 1) * 100;
                    this.mGR.mSpeedC = 300;
                    this.mGR.mSpeedN = 1;
                    this.mGR.SoundPlay(0);
                }
                System.out.println(this.mGR.mPad[i].x + " ~~~~~~~~~ " + this.mGR.mPad[i].y + "   " + this.mGR.mPoint[j].x + " ~~~ " + this.mGR.mPoint[j].y);
                break;
            }
            if (this.mGR.mPad[i].Gift == 7) {
                this.setAnimation(this.mGR.mPad[i].x, this.mGR.mPad[i].y);
                --this.mGR.mPlayer.mLife;
                this.mGR.SoundPlay(2);
            }
            if (this.mGR.mScore > this.mGR.mHScore) {
                this.mGR.mHScore = this.mGR.mScore;
                this.mGR.updateScore(this.mGR.mHScore, 0);
            }
            this.mGR.mPad[i].Gift = -2;
        }
        for (i = 0; i < this.mGR.mPad.length; ++i) {
            if (!(this.mGR.mPad[i].y < -1.5f)) continue;
            if (i == 0) {
                this.mGR.mPad[i].set((float)(M.mRand.nextInt() % 80) / 100.0f, this.mGR.mPad[this.mGR.mPad.length - 1].y + 0.6f);
            } else {
                this.mGR.mPad[i].set((float)(M.mRand.nextInt() % 80) / 100.0f, this.mGR.mPad[i - 1].y + 0.6f);
            }
            if (M.mRand.nextInt(4) == 0) {
                this.mGR.mPad[i].Gift = M.mRand.nextInt(8);
            }
            if (M.mRand.nextInt(5) != 0 || !(this.mGR.mBGY < -7.0f)) continue;
            this.mGR.mPad[i].Gift = 8;
        }
        this.mGR.mBGY += -0.001f;
        if (1 + Math.abs((int)this.mGR.mBGY) > this.mGR.mLevel) {
            ++this.mGR.mLevel;
            this.mGR.levelUp = 100;
        }
        if (this.mGR.mBGY < -7.0f) {
            this.mGR.mBGSY1 += -5.0E-4f;
            this.mGR.mBGSY2 += -5.0E-4f;
            if (this.mGR.mBGSY2 < -2.0f) {
                this.mGR.mBGSY2 = this.mGR.mBGSY1 + 2.0f;
            }
            if (this.mGR.mBGSY1 < -2.0f) {
                this.mGR.mBGSY1 = this.mGR.mBGSY2 + 2.0f;
            }
        }
        for (i = 0; i < this.mGR.mObject.length; ++i) {
            this.mGR.mObject[i].update();
        }
        for (i = 0; i < this.mGR.mPoint.length; ++i) {
            if (!((double)this.mGR.mPoint[i].y < 1.1)) continue;
            this.mGR.mPoint[i].update();
        }
        for (i = 0; i < this.mGR.mAni.length; ++i) {
            if (!(this.mGR.mAni[i].y > -1.5f) || !(this.mGR.mAni[i].y < 1.5f) || !(this.mGR.mAni[i].x > -1.5f) || !(this.mGR.mAni[i].x < 1.5f)) continue;
            this.mGR.mAni[i].update();
        }
        if (this.mGR.mSpeedC > -1) {
            --this.mGR.mSpeedC;
        }
        if (this.mGR.levelUp > -1) {
            --this.mGR.levelUp;
        }
        if (this.mGR.mSpeedC > 0 && this.mGR.mSpeedN == 0) {
            M.SPEED = -0.01f;
        }
        if (this.mGR.mSpeedC > 0 && this.mGR.mSpeedN == 1) {
            M.SPEED = -0.03f;
        }
        if (this.mGR.mSpeedC <= 0) {
            M.SPEED = -0.02f;
        }
        if (this.mGR.mPlayer.mLife < 1 || this.mGR.mPlayer.y < -1.2f || (double)this.mGR.mPlayer.y > 1.2) {
            M.GameScreen = 8;
            this.mGR.mSel = 3;
        }
    }

    void Draw_GamePlay(Graphics gl) {
        int i = 0;
        for (i = 0; i < this.mGR.mTex_BG.length; ++i) {
            if (!((double)((float)(i * 2) + this.mGR.mBGY) > -2.1) || !((double)((float)(i * 2) + this.mGR.mBGY) < 2.1)) continue;
            if (i == 0) {
                this.DrawTexture(gl, this.mGR.mTex_BG[i], 0.0f, (float)(i * 2) + this.mGR.mBGY);
                continue;
            }
            this.DrawTexture(gl, this.mGR.mTex_BG[i], 0.0f, (float)(i * 2) + this.mGR.mBGY);
        }
        if (this.mGR.mBGSY1 < 2.0f) {
            this.DrawTexture(gl, this.mGR.mTex_StarBG, 0.0f, this.mGR.mBGSY1);
        }
        if (this.mGR.mBGSY2 < 2.0f) {
            this.DrawTexture(gl, this.mGR.mTex_StarBG, 0.0f, this.mGR.mBGSY2);
        }
        for (i = 0; i < this.mGR.mObject.length; ++i) {
            if (!(this.mGR.mObject[i].y > -1.5f) || !(this.mGR.mObject[i].y < 1.5f)) continue;
            this.DrawTexture(gl, this.mGR.mTex_Object[i], this.mGR.mObject[i].x, this.mGR.mObject[i].y);
        }
        for (i = 0; i < this.mGR.mPad.length; ++i) {
            if (this.mGR.mPad[i].Gift > -3 && this.mGR.mPad[i].Gift != 8) {
                this.DrawTexture(gl, this.mGR.mTex_Pad, this.mGR.mPad[i].x, this.mGR.mPad[i].y);
            }
            if (this.mGR.mPad[i].Gift == 8) {
                this.DrawTexture(gl, this.mGR.mTex_PadTrans, this.mGR.mPad[i].x, this.mGR.mPad[i].y);
            }
            if (this.mGR.mPad[i].Gift < 0 || this.mGR.mPad[i].Gift >= 8) continue;
            this.DrawTexture(gl, this.mGR.mTex_Gift[this.mGR.mPad[i].Gift], this.mGR.mPad[i].x, this.mGR.mPad[i].y - 0.09f);
        }
        if (this.mGR.mPlayer.mtap / 3 < 3) {
            this.DrawTexture(gl, this.mGR.mTex_Ball[this.mGR.mPlayer.mtap / 3], this.mGR.mPlayer.x, this.mGR.mPlayer.y);
        } else {
            this.DrawTexture(gl, this.mGR.mTex_Ball[3], this.mGR.mPlayer.x, this.mGR.mPlayer.y);
        }
        for (i = 0; i < this.mGR.mPoint.length; ++i) {
            if (!((double)this.mGR.mPoint[i].y < 1.1)) continue;
            this.DrawTexture(gl, this.mGR.mTex_Point[this.mGR.mPoint[i].mPoint], this.mGR.mPoint[i].x, this.mGR.mPoint[i].y);
        }
        for (i = 0; i < this.mGR.mAni.length; ++i) {
            if (!((double)this.mGR.mAni[i].x > -1.5) || !((double)this.mGR.mAni[i].x < 1.5) || !((double)this.mGR.mAni[i].y > -1.5) || !((double)this.mGR.mAni[i].y < 1.5)) continue;
            this.DrawTexture(gl, this.mGR.mTex_Smok[this.mGR.mAni[i].cl], this.mGR.mAni[i].x, this.mGR.mAni[i].y);
        }
        if (this.mGR.mSpeedC > 200) {
            this.DrawTexture(gl, this.mGR.mTex_Speed[this.mGR.mSpeedN], 0.0f, 0.0f);
        }
        if (this.mGR.levelUp > 0) {
            this.DrawTexture(gl, this.mGR.mTex_LevelUp, 0.0f, 0.2f);
        }
        for (i = 0; i < 5; ++i) {
            this.DrawTexture(gl, this.mGR.mTex_Life[0], 0.19f + (float)i * 0.18f, 0.95f);
            if (this.mGR.mPlayer.mLife <= i) continue;
            this.DrawTexture(gl, this.mGR.mTex_Life[1], 0.19f + (float)i * 0.18f, 0.95f);
        }
        this.DrawTexture(gl, this.mGR.mTex_Score, -0.82f, 0.95f);
        this.drawNumber(gl, this.mGR.mScore, -0.6f, 0.95f);
        this.DrawTexture(gl, this.mGR.mTex_Level, -0.82f, 0.8f);
        this.drawNumber(gl, this.mGR.mLevel, -0.6f, 0.8f);
        if (this.mGR.mContinue) {
            this.DrawTexture(gl, this.mGR.mTex_Pause, 0.78f, -0.92f);
            if (this.mGR.mSel == 1) {
                this.DrawTexture(gl, this.mGR.mTex_SmallSel, 0.78f, -0.92f);
            }
            this.GameLogic();
        } else {
            this.DrawTexture(gl, this.mGR.mTex_Continue, 0.0f, 0.0f);
        }
    }

    boolean Handle_GamePlay(int event, int x, int y) {
        this.mGR.mSel = 0;
        if (this.CircRectsOverlap(this.XPos(0.78f), this.YPos(-0.92f), (float)this.mGR.mTex_Pause.getWidth() * 0.4f, (float)this.mGR.mTex_Pause.getHeight() * 0.4f, x, y, 5.0f)) {
            this.mGR.mSel = 1;
        }
        if (this.CircRectsOverlap(this.XPos(0.5f), this.YPos(0.0f), M.mMaxX / 4, M.mMaxY / 2, x, y, 10.0f)) {
            this.mGR.mPlayer.vx = 0.04f;
        }
        if (this.CircRectsOverlap(this.XPos(-0.5f), this.YPos(0.0f), M.mMaxX / 4, M.mMaxY / 2, x, y, 10.0f)) {
            this.mGR.mPlayer.vx = -0.04f;
        }
        if (event == 2) {
            this.mGR.mContinue = true;
            switch (this.mGR.mSel) {
                case 1: {
                    M.GameScreen = 9;
                    break;
                }
                case 10: {
                    this.mGR.mPlayer.vx = -0.04f;
                    break;
                }
                case 20: {
                    this.mGR.mPlayer.vx = 0.04f;
                }
            }
            this.mGR.mSel = 0;
        }
        return true;
    }

    void drawNumber(Graphics gl, int no, float x, float y) {
        float dx = this.floatWidth(this.mGR.mTex_Font[0].getWidth());
        String strs = "" + no;
        for (int i = 0; i < strs.length(); ++i) {
            int k = strs.charAt(i) - 48;
            if (k < 0 || k >= this.mGR.mTex_Font.length) continue;
            this.DrawTexture(gl, this.mGR.mTex_Font[k], x + (float)i * dx, y);
        }
    }

    void DrawBackBtn(Graphics gl) {
        this.DrawTexture(gl, this.mGR.mTex_backBtn, 0.75f, -0.9f);
        if (this.mGR.mSel == 100) {
            this.DrawTexture(gl, this.mGR.mTex_SmallSel, 0.75f, -0.9f);
        }
    }

    boolean intersectCircleRect(int centerX, int centerY, int radius, int RectX, int RectY, int RectDX, int RectDY) {
        return this.abs(centerX - (RectX + RectDX / 2)) <= RectDX / 2 + radius && this.abs(centerY - (RectY + RectDY / 2)) <= RectDY / 2 + radius;
    }

    int abs(int x) {
        return x > 0 ? x : -x;
    }

    boolean cirInrSect(int x1, int y1, int r1, int x2, int y2, int r2) {
        int d = this.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        return d < r1 + r2;
    }

    int sqrt(int x) {
        if (x < 3) {
            return 1;
        }
        for (int i = 2; i <= x / 2 + 1; ++i) {
            if (x == i * i) {
                return i;
            }
            if (x >= i * i) continue;
            return i - 1;
        }
        return x;
    }

    boolean CircRectsOverlap(float CRX, float CRY, float CRDX, float CRDY, float centerX, float centerY, float radius) {
        return Math.abs(centerX - CRX) <= CRDX + radius && Math.abs(centerY - CRY) <= CRDY + radius;
    }

    public boolean randomBoolean() {
        Random rand = new Random();
        int r = Math.abs(rand.nextInt() % 2);
        return r >= 1;
    }

    int XPos(float x) {
        return (int)((1.0f + x) * M.TX / 2.0f);
    }

    int YPos(float y) {
        return (int)((1.0f - y) * M.TY / 2.0f);
    }

    float screen2worldX(float a) {
        float c = (a / M.TX - 0.5f) * 2.0f;
        return c;
    }

    float screen2worldY(float a) {
        float c = (a / M.TY - 0.5f) * -2.0f;
        return c;
    }

    boolean Rect2RectIntersection(float ax, float ay, float adx, float ady, float bx, float by, float bdx, float bdy) {
        return ax + adx > bx && ay + ady > by && bx + bdx > ax && by + bdy > ay;
    }

    boolean CirCir(double cx1, double cy1, double r1, double cx2, double cy2, double r2) {
        float bVectMag = (float)Math.sqrt((cx1 - cx2) * (cx1 - cx2) + (cy1 - cy2) * (cy1 - cy2));
        return (double)bVectMag < r1 + r2;
    }
}

