/*
 * Decompiled with CFR 0.152.
 */
package Basic;

import Basic.Main;
import Basic.Model;
import Managers.LevelManager;
import Objects.Bonuses;
import Objects.Lanes;
import Objects.Lawnmower;
import Objects.Man;
import Objects.Trans;
import Utils.LEDbonuses;
import Utils.LEDlife;
import Utils.LEDtime;
import Utils.MoveOnMap;
import Utils.Util;
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.game.EFLayerManager;
import com.jarbull.efw.game.EFSprite;
import com.jarbull.efw.game.EFTiledLayer;
import com.jarbull.efw.game.LevelHolder;
import com.jarbull.efw.game.TimerHolder;
import com.jarbull.efw.io.KeyValuePair;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.Action;
import com.jarbull.efw.ui.EGameCanvas;
import com.jarbull.efw.ui.EMidlet;
import com.jarbull.efw.ui.GameModeHandler;
import com.jarbull.efw.ui.Settings;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.midlet.MIDlet;

public class MIDPCanvas
extends EGameCanvas {
    private int score;
    private int levelCursor;
    private boolean finishedLoading;
    public static int lvl = 0;
    public MIDlet midlet;
    private final byte LED_TILE_WIDTH = (byte)15;
    private final byte LED_TILE_HEIGHT = (byte)15;
    private final byte TILE_WIDTH = (byte)15;
    private final byte TILE_HEIGHT = (byte)15;
    private final byte totalLife = (byte)5;
    private final byte totalLevel = (byte)12;
    private TiledLayer background;
    private EFTiledLayer tlDecor;
    private EFSprite levelNum;
    private Lawnmower Lawnmower;
    private MoveOnMap moveOnMap;
    private Man man;
    private Lanes road;
    private Lanes river;
    private Lanes rails;
    private Bonuses bonuses;
    private Bonuses heart;
    private LEDlife ledLife;
    private LEDtime ledTime;
    private LEDbonuses ledBonuses;
    private LevelManager levelManager;
    private EFLayerManager lmBonuses;
    private LayerManager lmBackground;
    private Image img;
    private EFLayerManager lmLED;
    private EFLayerManager lmCarAndMan;
    private EFLayerManager lmRaft;
    private EFLayerManager lmDecor;
    private Vector vecLawnmowers;
    private Vector vecRoad;
    private Vector vecRiver;
    private Vector vecRails;
    private Vector vecBonuses;
    private Vector vecHealth;
    private int screenWidth;
    private int screenHeight;
    private int bgrWidth;
    private int bgrHeight;
    private int startTime;
    private int speedMan;
    private int xManPos;
    private int yManPos;
    private int xViewWin;
    private int yViewWin;
    private int levelNumX;
    private int levelNumY;
    private int numberLevel;
    private int leftLife;
    private boolean blnGame;
    private boolean bPress;
    private int[] arrFinishTile = new int[]{39, 40, 41};
    private int[] arrSlideTile = new int[]{67, 68, 69, 70, 71, 72, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307};
    private int[] arrManFrRight = new int[]{6, 7, 8};
    private int[] arrManFrLeft = new int[]{9, 10, 11};
    private int[] arrManFrUp = new int[]{3, 4, 5};
    private int[] arrManFrDown = new int[]{0, 1, 2};
    private int[] arrBonusesFr = new int[]{0, 1, 2, 3};
    private int[] arrHealthFr = new int[]{0, 1, 2};
    private int[] arrTile = new int[]{1, 2, 3, 42, 43, 44, 45, 46, 47, 54, 55, 56, 57, 58, 59, 60, 61, 62, 73, 74, 75, 76, 154, 156, 155, 157, 158, 168, 169, 170, 171};
    private int[] arrCrash = new int[]{12, 13, 14};
    private int[] arrHeartFr = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 2, 2, 2};
    private int[] arrManholeTile = new int[]{49};
    private int[][] arrCarFrRight;
    private int[][] arrRaftFrame;
    private int[][] arrTramFrRight;
    private int[][] arrTramFrLeft;
    private int[][] arrMap;
    private int[][] arrDecor;
    private int[][] arrBonusesPos;
    private int[][] arrHealthPos;
    private int[][] arrCarPos;
    private int[][] arrRaftPos;
    private int[][] arrLawnmowerPos;
    private int[][] arrTramPos;
    private int[] arrRiverTile = new int[]{178, 179, 268, 269};
    private int[] arrSeqRiver = new int[]{178, 178, 178, 178, 178, 179, 179, 179, 179, 179};
    private int[] arrSeqDuckweed = new int[]{268, 268, 268, 268, 268, 268, 268, 268, 268, 269, 269, 269, 269, 269, 269, 269, 269, 269};
    private int[] arrSeqLilyClean = new int[]{258, 258, 258, 258, 258, 258, 258, 258, 258, 258, 259, 259, 259, 259, 259, 259, 259, 259, 259, 259};
    private int[] arrSeqLilyFlower = new int[]{260, 260, 260, 260, 260, 260, 260, 260, 260, 260, 261, 261, 261, 261, 261, 261, 261, 261, 261, 261};
    private int[] arrSeqLilyCleanRound = new int[]{262, 262, 262, 262, 262, 262, 262, 262, 263, 263, 263, 263, 263, 263, 263, 263};
    private int[] arrSeqLilyBlossoming = new int[]{264, 264, 264, 264, 264, 264, 264, 264, 264, 265, 265, 265, 265, 265, 265, 265, 265, 265};
    private int[] arrSeqLilyDouble = new int[]{266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267};
    private int[] arrSeqSandyLeft = new int[]{271, 271, 271, 271, 271, 271, 271, 271, 271, 271, 283, 283, 283, 283, 283, 283, 283, 283, 283, 283};
    private int[] arrSeqSandyRight = new int[]{272, 272, 272, 272, 272, 272, 272, 272, 272, 272, 284, 284, 284, 284, 284, 284, 284, 284, 284, 284};
    private int[] arrSeqSandyBottom = new int[]{273, 273, 273, 273, 273, 273, 273, 273, 273, 273, 285, 285, 285, 285, 285, 285, 285, 285, 285, 285};
    private int[] arrSeqSandyTop = new int[]{274, 274, 274, 274, 274, 274, 274, 274, 274, 274, 286, 286, 286, 286, 286, 286, 286, 286, 286, 286};
    private int[] arrSeqSandyTopLeft = new int[]{275, 275, 275, 275, 275, 275, 275, 275, 275, 275, 287, 287, 287, 287, 287, 287, 287, 287, 287, 287};
    private int[] arrSeqSandyTopRight = new int[]{276, 276, 276, 276, 276, 276, 276, 276, 276, 276, 288, 288, 288, 288, 288, 288, 288, 288, 288, 288};
    private int[] arrSeqSandyBottomLeft = new int[]{277, 277, 277, 277, 277, 277, 277, 277, 277, 277, 289, 289, 289, 289, 289, 289, 289, 289, 289, 289};
    private int[] arrSeqSandyBottomRight = new int[]{278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 290, 290, 290, 290, 290, 290, 290, 290, 290, 290};
    private int[] arrSeqSandyBottomLeftIn = new int[]{279, 279, 279, 279, 279, 279, 279, 279, 279, 279, 291, 291, 291, 291, 291, 291, 291, 291, 291, 291};
    private int[] arrSeqSandyBottomRightIn = new int[]{280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 292, 292, 292, 292, 292, 292, 292, 292, 292, 292};
    private int[] arrSeqSandyTopLeftIn = new int[]{281, 281, 281, 281, 281, 281, 281, 281, 281, 281, 293, 293, 293, 293, 293, 293, 293, 293, 293, 293};
    private int[] arrSeqSandyTopRightIn = new int[]{282, 282, 282, 282, 282, 282, 282, 282, 282, 282, 294, 294, 294, 294, 294, 294, 294, 294, 294, 294};
    private int[][] arrAnimSeq = new int[][]{this.arrSeqRiver, this.arrSeqDuckweed, this.arrSeqLilyBlossoming, this.arrSeqLilyClean, this.arrSeqLilyCleanRound, this.arrSeqLilyDouble, this.arrSeqLilyFlower, this.arrSeqSandyLeft, this.arrSeqSandyRight, this.arrSeqSandyBottom, this.arrSeqSandyTop, this.arrSeqSandyTopLeft, this.arrSeqSandyTopRight, this.arrSeqSandyBottomLeft, this.arrSeqSandyBottomRight, this.arrSeqSandyBottomLeftIn, this.arrSeqSandyBottomRightIn, this.arrSeqSandyTopLeftIn, this.arrSeqSandyTopRightIn};
    private int[] arrAnimTiles = new int[this.arrAnimSeq.length];
    private int[] arrInd = new int[this.arrAnimSeq.length];
    int incForLevelSelect = 130;

    public MIDPCanvas(MIDlet midlet) {
        this.midlet = midlet;
    }

    public void levelChanged(int newLevel) {
        this.screenWidth = ResolutionHandler.getInstance().getCurrentWidth();
        this.screenHeight = ResolutionHandler.getInstance().getCurrentHeight();
        if (newLevel == 1) {
            this.score = 0;
            this.numberLevel = this.levelCursor + 1;
            this.levelNumX = 175;
            this.levelNumY = 280;
            this.levelManager = new LevelManager();
            this.levelManager.setLevel(this.numberLevel);
            Lanes.vecTransMan.removeAllElements();
            try {
                this.img = Image.createImage((String)"/image/background.png");
                this.init();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void init() throws IOException {
        this.levelManager();
        Model.looping = true;
        Model.isPlay = true;
        Model.isPaused = false;
        this.blnGame = true;
        this.bPress = false;
        this.speedMan = 3;
        this.lmBonuses = new EFLayerManager();
        this.lmBackground = new LayerManager();
        this.lmLED = new EFLayerManager();
        this.lmCarAndMan = new EFLayerManager();
        this.lmRaft = new EFLayerManager();
        this.lmDecor = new EFLayerManager();
        this.levelNum = null;
        this.createMan();
        this.vecLawnmowers = new Vector();
        this.createLawnmower();
        this.vecHealth = new Vector();
        this.createLife();
        this.vecBonuses = new Vector();
        this.createCoins();
        this.createBackground();
        this.man.setBoardSize(this.bgrWidth, this.bgrHeight);
        this.vecRoad = new Vector();
        this.createRoad();
        this.vecRiver = new Vector();
        this.createRiver();
        this.vecRails = new Vector();
        this.createRails();
        this.moveOnMap = new MoveOnMap(this.man, this.background, this.screenWidth, this.screenHeight);
        this.moveOnMap.tuningView();
        this.createDecor();
        if (this.ledLife != null) {
            this.lmLED.remove(this.ledLife.getTlLEDlife());
        }
        this.ledLife = new LEDlife(5, 1, 15, 15, this.leftLife, 1, this.arrHeartFr, this.screenWidth);
        this.lmLED.append(this.ledLife.getTlLEDlife());
        if (this.ledTime != null) {
            this.lmLED.remove(this.ledTime.getTlLEDdigit());
        }
        this.ledTime = new LEDtime(4, 1, 15, 15, this.startTime);
        this.ledTime.setCountDown(true);
        this.lmLED.append(this.ledTime.getSpLEDtime());
        this.lmLED.append(this.ledTime.getTlLEDdigit());
        if (this.ledBonuses != null) {
            this.lmLED.remove(this.ledBonuses.getTlLEDdigit());
        }
        this.ledBonuses = new LEDbonuses(7, 1, 15, 15, this.screenHeight);
        this.lmLED.append(this.ledBonuses.getTlLEDdigit());
        this.ledBonuses.viewLEDbonuses(this.man.getAccCoins(), this.arrBonusesPos.length);
    }

    private void restart() {
        if (!Model.isPlay && this.blnGame) {
            TimerHolder.getInstance().clearAll();
            ImageHandler.getInstance().clear("/image/endscreen.png");
            ImageHandler.getInstance().clear("/image/LEVEL_Numbers.png");
            EMidlet.getInstance().getSettings().add(new KeyValuePair("lastlevel", Integer.toString(lvl)));
            if (this.numberLevel > 3 && GameModeHandler.getInstance().getMode() == 0) {
                GameModeHandler.getInstance().showBuyGame();
                return;
            }
            try {
                this.init();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void createMan() {
        this.man = new Man("/image/man.png", ImageHandler.getInstance().getImage("/image/man.png").getWidth() >> 4, ImageHandler.getInstance().getImage("/image/man.png").getHeight(), this.speedMan);
        this.man.setter(this.arrMap, this.arrDecor, this.arrBonusesPos, this.arrTile, this.arrFinishTile, 15, 15, this.arrManFrRight, this.arrManFrLeft, this.arrManFrUp, this.arrManFrDown, this.arrCrash, this.arrSlideTile);
        this.man.setPos(this.xManPos, this.yManPos);
        if (this.numberLevel > 1) {
            this.man.setAccLife(this.leftLife);
        }
        this.man.defineCollisionRectangle(5, 15, 14, 10);
        this.lmCarAndMan.append(this.man);
        Lanes.addElement(this.man);
    }

    public void createLife() {
        if (this.arrHealthPos != null) {
            int i2;
            for (i2 = 0; i2 < this.arrHealthPos.length; ++i2) {
                this.heart = new Bonuses("/image/heart.png", ImageHandler.getInstance().getImage("/image/heart.png").getWidth() / 3, ImageHandler.getInstance().getImage("/image/heart.png").getHeight());
                this.heart.setPosition(this.arrHealthPos[i2][0], this.arrHealthPos[i2][1]);
                this.heart.setter(this.arrHealthFr);
                this.vecHealth.addElement(this.heart);
            }
            for (i2 = 0; i2 < this.vecHealth.size(); ++i2) {
                this.lmBonuses.append((Bonuses)this.vecHealth.elementAt(i2));
            }
        }
    }

    public void createBackground() {
        int i2;
        this.background = new TiledLayer(this.arrMap[0].length, this.arrMap.length, this.img, 15, 15);
        for (i2 = 0; i2 < this.arrMap.length; ++i2) {
            for (int j2 = 0; j2 < this.arrMap[i2].length; ++j2) {
                this.background.setCell(j2, i2, this.arrMap[i2][j2]);
            }
        }
        for (i2 = 0; i2 < this.arrAnimTiles.length; ++i2) {
            this.arrAnimTiles[i2] = this.background.createAnimatedTile(this.arrAnimSeq[i2][0]);
        }
        this.setAnimTiles(this.arrAnimTiles);
        this.bgrWidth = this.background.getWidth();
        this.bgrHeight = this.background.getHeight();
        this.lmBackground.append((Layer)this.background);
    }

    public void createDecor() {
        if (this.arrDecor != null) {
            this.tlDecor = new EFTiledLayer(this.arrDecor[0].length, this.arrDecor.length, "/image/background.png", 15, 15);
            for (int i2 = 0; i2 < this.arrDecor.length; ++i2) {
                for (int j2 = 0; j2 < this.arrDecor[i2].length; ++j2) {
                    this.tlDecor.setCell(j2, i2, this.arrDecor[i2][j2]);
                }
            }
            this.lmDecor.append(this.tlDecor);
        }
    }

    public void createCoins() {
        int i2;
        for (i2 = 0; i2 < this.arrBonusesPos.length; ++i2) {
            this.bonuses = new Bonuses("/image/bonuses.png", ImageHandler.getInstance().getImage("/image/bonuses.png").getWidth() >> 2, ImageHandler.getInstance().getImage("/image/bonuses.png").getHeight());
            this.bonuses.setPosition(this.arrBonusesPos[i2][0], this.arrBonusesPos[i2][1]);
            this.bonuses.setter(this.arrBonusesFr);
            this.vecBonuses.addElement(this.bonuses);
        }
        for (i2 = 0; i2 < this.vecBonuses.size(); ++i2) {
            this.lmBonuses.append((Bonuses)this.vecBonuses.elementAt(i2));
            this.lmBonuses.insert((Bonuses)this.vecBonuses.elementAt(i2), 0);
        }
    }

    public void removeAllCoins() {
        for (int i2 = this.vecBonuses.size() - 1; i2 >= 0; --i2) {
            Bonuses object = (Bonuses)this.vecBonuses.elementAt(i2);
            object.deleteTimer();
            this.vecBonuses.removeElement(object);
            this.lmBonuses.remove(object);
        }
    }

    public void createRails() {
        if (this.arrTramPos != null) {
            for (int i2 = 0; i2 < this.arrTramPos[0].length; ++i2) {
                if (this.arrTramPos[0][i2] <= 0) continue;
                this.rails = new Lanes(this, this.lmCarAndMan, i2, this.arrTramPos, this.arrTramFrRight, this.arrTramFrLeft, this.arrTramPos[3][i2], this.arrTramPos[4][i2], this.bgrWidth, this.bgrHeight);
                this.rails.setMovieObjectType(2);
                this.vecRails.addElement(this.rails);
            }
        }
    }

    public void removeRails() {
        for (int i2 = this.vecRails.size() - 1; i2 >= 0; --i2) {
            Lanes object = (Lanes)this.vecRails.elementAt(i2);
            object.deleteTimer();
            object.getVecTrans().removeAllElements();
            object.clearLM();
        }
    }

    public void createRiver() {
        if (this.arrRaftPos != null) {
            for (int i2 = 0; i2 < this.arrRaftPos[0].length; ++i2) {
                if (this.arrRaftPos[0][i2] <= 0) continue;
                this.river = new Lanes(this, this.lmRaft, i2, this.arrRaftPos, this.arrRaftFrame, this.arrRaftFrame, this.arrRaftPos[3][i2], this.arrRaftPos[4][i2], this.bgrWidth, this.bgrHeight);
                this.river.setMovieObjectType(1);
                this.vecRiver.addElement(this.river);
            }
        }
    }

    public void removeRiver() {
        for (int i2 = this.vecRiver.size() - 1; i2 >= 0; --i2) {
            Lanes object = (Lanes)this.vecRiver.elementAt(i2);
            object.deleteTimer();
            object.getVecTrans().removeAllElements();
            object.clearLM();
        }
    }

    public void createRoad() {
        if (this.arrCarPos != null) {
            for (int i2 = 0; i2 < this.arrCarPos[0].length; ++i2) {
                if (this.arrCarPos[0][i2] <= 0) continue;
                this.road = new Lanes(this, this.lmCarAndMan, i2, this.arrCarPos, this.arrCarFrRight, this.arrCarFrRight, this.arrCarPos[3][i2], this.arrCarPos[4][i2], this.bgrWidth, this.bgrHeight);
                this.road.setMovieObjectType(0);
                this.vecRoad.addElement(this.road);
            }
        }
    }

    public void removeRoad() {
        for (int i2 = this.vecRoad.size() - 1; i2 >= 0; --i2) {
            Lanes object = (Lanes)this.vecRoad.elementAt(i2);
            object.deleteTimer();
            object.clearLM();
            object.getVecTrans().removeAllElements();
        }
    }

    public void raftMovement() {
        this.recovery();
        for (int i2 = this.vecRiver.size() - 1; i2 >= 0; --i2) {
            Lanes lanes = (Lanes)this.vecRiver.elementAt(i2);
            lanes.createTrans();
            Vector vec = lanes.getVecTrans();
            for (int j2 = vec.size() - 1; j2 >= 0; --j2) {
                Trans object = (Trans)vec.elementAt(j2);
                object.movement();
                if (!object.flagRemove) continue;
                vec.removeElement(object);
                this.lmRaft.remove(object);
                object = null;
            }
        }
    }

    public void createLawnmower() {
        if (this.arrLawnmowerPos != null) {
            for (int i2 = 0; i2 < this.arrLawnmowerPos[0].length; ++i2) {
                this.Lawnmower = new Lawnmower("/image/lawnmower.png", ImageHandler.getInstance().getImage("/image/lawnmower.png").getWidth() / 6, ImageHandler.getInstance().getImage("/image/lawnmower.png").getHeight());
                this.Lawnmower.setter(this.arrLawnmowerPos, i2);
                this.vecLawnmowers.addElement(this.Lawnmower);
                this.lmCarAndMan.append(this.Lawnmower);
                Lanes.addElement(this.Lawnmower);
            }
        }
    }

    public void removeLawnmower() {
        for (int i2 = this.vecLawnmowers.size() - 1; i2 >= 0; --i2) {
            Lawnmower object = (Lawnmower)this.vecLawnmowers.elementAt(i2);
            this.vecLawnmowers.removeElement(object);
            this.lmCarAndMan.remove(object);
        }
    }

    public void levelManager() throws IOException {
        this.arrMap = this.levelManager.getArrMap();
        this.arrDecor = this.levelManager.getArrDecor();
        this.arrCarPos = this.levelManager.getArrCarPos();
        this.arrCarFrRight = this.levelManager.getArrCarFrRight();
        this.arrLawnmowerPos = this.levelManager.getArrLawnmowerPos();
        this.arrRaftPos = this.levelManager.getArrRaftPos();
        this.arrRaftFrame = this.levelManager.getArrRaftFrame();
        this.arrTramPos = this.levelManager.getArrTramPos();
        this.arrTramFrRight = this.levelManager.getArrTramFrRight();
        this.arrTramFrLeft = this.levelManager.getArrTramFrLeft();
        this.arrBonusesPos = this.levelManager.getArrBonusesPos();
        this.arrHealthPos = this.levelManager.getArrHealthPos();
        this.xManPos = this.levelManager.getXManPos();
        this.yManPos = this.levelManager.getYManPos();
    }

    private void setAnimTiles(int[] arrAnimTiles) {
        for (int k2 = 0; k2 < arrAnimTiles.length; ++k2) {
            for (int i2 = 0; i2 < this.arrMap.length; ++i2) {
                for (int j2 = 0; j2 < this.arrMap[0].length; ++j2) {
                    if (this.arrMap[i2][j2] != this.arrAnimSeq[k2][0]) continue;
                    this.background.setCell(j2, i2, arrAnimTiles[k2]);
                }
            }
        }
    }

    private void animTile() {
        for (int i2 = 0; i2 < this.arrAnimSeq.length; ++i2) {
            int n2 = i2;
            this.arrInd[n2] = this.arrInd[n2] + 1;
            if (this.arrInd[i2] > this.arrAnimSeq[i2].length - 1) {
                this.arrInd[i2] = 0;
            }
            this.background.setAnimatedTile(this.arrAnimTiles[i2], this.arrAnimSeq[i2][this.arrInd[i2]]);
        }
    }

    public void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        if (LevelHolder.getInstance().getCurrentLevel() == 0) {
            switch (keyCode) {
                case 202: 
                case 221: {
                    if (--this.levelCursor >= 0) break;
                    this.levelCursor = ((Main)Main.getInstance()).lastLevelValue - 1;
                    break;
                }
                case 208: 
                case 222: {
                    if (++this.levelCursor <= ((Main)Main.getInstance()).lastLevelValue - 1) break;
                    this.levelCursor = 0;
                    break;
                }
                case -203: 
                case 205: 
                case 225: {
                    if (this.levelCursor > 2 && GameModeHandler.getInstance().getMode() == 0) {
                        GameModeHandler.getInstance().showBuyGame();
                        break;
                    }
                    Action action = new Action(this, "SETCURRENTLEVEL", "next");
                    action.doAction();
                }
            }
        } else if (LevelHolder.getInstance().getCurrentLevel() != 0) {
            this.bPress = true;
            this.ledTime.launchCountDown();
            this.restart();
        }
    }

    public void checkKeys() {
        if (this.man.getIsKeyLock() || Model.isPaused || !this.bPress) {
            return;
        }
        int keyStates = this.getKeyStates();
        if (keyStates == 0) {
            this.man.animate = false;
        }
        if ((keyStates & 2) != 0) {
            this.man.moveUp(2);
            this.moveOnMap.tuningView();
        } else if ((keyStates & 0x40) != 0) {
            this.man.moveDown(64);
            this.moveOnMap.tuningView();
        } else if ((keyStates & 4) != 0) {
            if (keyStates == 4) {
                this.man.moveLeft(4);
            }
            this.moveOnMap.tuningView();
        } else if ((keyStates & 0x20) != 0) {
            if (keyStates == 32) {
                this.man.moveRight(32);
            }
            this.moveOnMap.tuningView();
        }
    }

    public void manCrash() {
        this.man.crashPlay();
        this.man.setIsCrash(true);
    }

    public void manWithCar() {
        this.recovery();
        for (int i2 = this.vecRoad.size() - 1; i2 >= 0; --i2) {
            Lanes lanes = (Lanes)this.vecRoad.elementAt(i2);
            lanes.createTrans();
            Vector vec = lanes.getVecTrans();
            for (int j2 = vec.size() - 1; j2 >= 0; --j2) {
                Trans object = (Trans)vec.elementAt(j2);
                if (this.man.collidesWith(object, true) && !this.man.getIsCrash()) {
                    this.play();
                    this.manCrash();
                }
                object.movement();
                if (!object.flagRemove) continue;
                vec.removeElement(object);
                this.lmCarAndMan.remove(object);
                Lanes.removeElement(object);
                object = null;
            }
        }
    }

    public void manWithTram() {
        this.recovery();
        for (int i2 = this.vecRails.size() - 1; i2 >= 0; --i2) {
            Lanes lanes = (Lanes)this.vecRails.elementAt(i2);
            lanes.createTrans();
            Vector vec = lanes.getVecTrans();
            for (int j2 = vec.size() - 1; j2 >= 0; --j2) {
                Trans object = (Trans)vec.elementAt(j2);
                if (this.man.collidesWith(object, true) && !this.man.getIsCrash()) {
                    this.play();
                    this.manCrash();
                }
                object.movement();
                if (!object.flagRemove) continue;
                lanes.getVecTrans().removeElement(object);
                this.lmCarAndMan.remove(object);
                Lanes.removeElement(object);
                object = null;
            }
        }
    }

    public boolean manWithRaft() {
        boolean onRaft = false;
        int xMan = this.man.getX();
        for (int i2 = this.vecRiver.size() - 1; i2 >= 0; --i2) {
            Lanes lanes = (Lanes)this.vecRiver.elementAt(i2);
            Vector vec = lanes.getVecTrans();
            for (int j2 = vec.size() - 1; j2 >= 0; --j2) {
                Trans object = (Trans)vec.elementAt(j2);
                int raftVX = object.getTransVX();
                int raftVY = object.getTransVY();
                if (!this.man.collidesWith(object, true)) continue;
                onRaft = true;
                boolean blnColDecor = false;
                if (this.arrDecor != null) {
                    blnColDecor = Util.tileCollide(xMan + 5, this.man.getY() + 15, 14, 10, raftVX, raftVY, 15, 15, this.arrTile, this.arrDecor);
                }
                if (Util.tileCollide(xMan + 5, this.man.getY() + 15, 14, 10, raftVX, raftVY, 15, 15, this.arrTile, this.arrMap) || blnColDecor) {
                    raftVX = 0;
                    raftVY = 0;
                } else if (xMan + raftVX < 0 || xMan + this.man.getWidth() + raftVX > this.bgrWidth - (this.speedMan + 3)) {
                    raftVX = 0;
                }
                this.man.move(raftVX, raftVY);
                this.moveOnMap.tuningView();
            }
        }
        return onRaft;
    }

    public void manWithBonuse() {
        for (int i2 = this.vecBonuses.size() - 1; i2 >= 0; --i2) {
            Bonuses object = (Bonuses)this.vecBonuses.elementAt(i2);
            if (!this.man.collidesWith(object, true)) continue;
            this.man.incCoins();
            this.ledBonuses.viewLEDbonuses(this.man.getAccCoins(), this.arrBonusesPos.length);
            object.deleteTimer();
            this.vecBonuses.removeElement(object);
            this.lmBonuses.remove(object);
        }
    }

    public void manWithHeart() {
        for (int i2 = this.vecHealth.size() - 1; i2 >= 0; --i2) {
            Bonuses object = (Bonuses)this.vecHealth.elementAt(i2);
            if (!this.man.collidesWith(object, true)) continue;
            if (this.man.getAccLife() < 5) {
                this.man.incHealth();
                this.leftLife = this.man.getAccLife();
                this.ledLife.fillingArray(this.leftLife);
            }
            object.deleteTimer();
            this.vecHealth.removeElement(object);
            this.lmBonuses.remove(object);
        }
    }

    public void manWithManhole() {
        if (Util.tileCollide(this.man.getX() + 12, this.man.getY() + 16, 1, 1, this.man.getVX(), this.man.getVY(), 15, 15, this.arrManholeTile, this.arrMap)) {
            if (!this.man.getIsCrash()) {
                this.play();
                this.manCrash();
            }
            this.recovery();
        }
    }

    public void manWithRiver() {
        if (Util.tileCollide(this.man.getX() + (this.man.getWidth() >> 1), this.man.getY() + this.man.getHeight() - 5, 1, 1, this.man.getVX(), this.man.getVY(), 15, 15, this.arrRiverTile, this.arrMap)) {
            if (!this.man.getIsCrash()) {
                this.play();
                this.manCrash();
            }
            this.recovery();
        }
    }

    public void manWithLawnmower() {
        this.recovery();
        for (int i2 = this.vecLawnmowers.size() - 1; i2 >= 0; --i2) {
            Lawnmower object = (Lawnmower)this.vecLawnmowers.elementAt(i2);
            if (this.man.collidesWith(object, true) && !this.man.getIsCrash()) {
                this.play();
                this.manCrash();
            }
            object.movement();
        }
    }

    private void recovery() {
        if (this.man.isTimerCancel() && this.man.getIsCrash()) {
            this.man.decHealth();
            this.moveOnMap.tuningView();
            if (this.man.isLife()) {
                this.leftLife = this.man.getAccLife();
                this.ledLife.fillingArray(this.leftLife);
            }
            this.blnGame = this.man.isLife();
        }
    }

    private void clearAll() {
        this.removeRoad();
        this.removeRiver();
        this.removeRails();
        this.man.deleteTimer();
    }

    public void play() {
        Display.getDisplay((MIDlet)this.midlet).vibrate(400);
    }

    public void Pause() {
        Model.isPaused = true;
    }

    public void Resume() {
        Model.isPaused = false;
    }

    public void Quit() {
        Model.looping = false;
    }

    public void paint(Graphics g2) {
        int screenOffsetX = this.getWidth() - ResolutionHandler.getInstance().getCurrentWidth() >> 1;
        int screenOffsetY = this.getHeight() - ResolutionHandler.getInstance().getCurrentHeight() >> 1;
        g2.translate(screenOffsetX, screenOffsetY);
        if (LevelHolder.getInstance().getCurrentLevel() == 0) {
            g2.setColor(0);
            g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
            int posY = 0;
            int imageHeight = ImageHandler.getInstance().getImage("/image/1.png").getHeight() + (ImageHandler.getInstance().getImage("/image/1.png").getHeight() >> 1);
            int offsetX = this.screenWidth - 3 * ImageHandler.getInstance().getImage("/image/1.png").getWidth() - TextWriter.getInstance().getTextWidth("Level N - 0") - 5 >> 1;
            int offsetY = this.incForLevelSelect;
            if (offsetY + this.levelCursor * imageHeight > (this.screenHeight >> 1) + 7 && offsetY + 12 * imageHeight > this.screenHeight) {
                this.incForLevelSelect -= 7;
            } else if (offsetY < 120 && offsetY + this.levelCursor * imageHeight < (this.screenHeight >> 1) - 7) {
                this.incForLevelSelect += 7;
            }
            g2.drawImage(ImageHandler.getInstance().getImage("/image/lvlBg.png"), 0, 0, 20);
            for (int j2 = 0; j2 < 12; ++j2) {
                Image image = null;
                Image image1 = null;
                Image image2 = null;
                StringBuffer buffer = new StringBuffer("Level ").append(j2 + 1);
                if (GameModeHandler.getInstance().getMode() == 0 && j2 > 2) {
                    buffer.append(" - ").append("BUY");
                } else {
                    buffer.append(" - ").append(this.getScore(j2 + 1));
                }
                if (j2 >= ((Main)Main.getInstance()).lastLevelValue) {
                    image = ImageHandler.getInstance().getImage("/image/1.png");
                    image1 = ImageHandler.getInstance().getImage("/image/4.png");
                    image2 = ImageHandler.getInstance().getImage("/image/4.png");
                    TextWriter.getInstance().setFont(TextWriter.getInstance().getFont("locked_font"));
                } else if (this.levelCursor == j2) {
                    image = ImageHandler.getInstance().getImage("/image/4.png");
                    image1 = ImageHandler.getInstance().getImage("/image/3.png");
                    image2 = ImageHandler.getInstance().getImage("/image/4.png");
                    TextWriter.getInstance().setFont(TextWriter.getInstance().getFont("select_font"));
                } else {
                    image = ImageHandler.getInstance().getImage("/image/4.png");
                    image1 = ImageHandler.getInstance().getImage("/image/4.png");
                    image2 = ImageHandler.getInstance().getImage("/image/2.png");
                    TextWriter.getInstance().setFont(TextWriter.getInstance().getFont("passed_font"));
                }
                g2.drawImage(image, offsetX, offsetY + posY, 0);
                g2.drawImage(image1, offsetX + image.getWidth(), offsetY + posY, 0);
                g2.drawImage(image2, offsetX + image.getWidth() + image1.getWidth(), offsetY + posY, 0);
                if (this.levelCursor == j2) {
                    g2.setColor(0xFF0000);
                    g2.drawRect(offsetX, offsetY + posY, image.getWidth() + image.getWidth() + image.getWidth(), image.getHeight());
                }
                TextWriter.getInstance().drawText(g2, buffer.toString(), offsetX + image.getWidth() + image.getWidth() + image.getWidth() + 5, offsetY + posY + 4);
                posY += image.getHeight() + (image.getHeight() >> 1);
            }
            g2.setColor(0xFFFFFF);
            return;
        }
        if (Model.isPaused) {
            return;
        }
        if (Model.isPlay) {
            this.xViewWin = this.moveOnMap.getXViewWin();
            this.yViewWin = this.moveOnMap.getYViewWin();
            this.lmBackground.setViewWindow(this.xViewWin, this.yViewWin, this.screenWidth, this.screenHeight);
            this.lmBackground.paint(g2, 0, 0);
            this.lmBonuses.setViewWindow(this.xViewWin, this.yViewWin, this.screenWidth, this.screenHeight);
            this.lmCarAndMan.setViewWindow(this.xViewWin, this.yViewWin, this.screenWidth, this.screenHeight);
            this.lmDecor.setViewWindow(this.xViewWin, this.yViewWin, this.screenWidth, this.screenHeight);
            this.lmRaft.setViewWindow(this.xViewWin, this.yViewWin, this.screenWidth, this.screenHeight);
            this.lmDecor.paint(g2, 0, 0);
            this.lmRaft.paint(g2, 0, 0);
            this.lmBonuses.paint(g2, 0, 0);
            this.lmCarAndMan.paint(g2, 0, 0);
            this.lmLED.paint(g2, 0, 0);
            this.manWithBonuse();
            this.manWithHeart();
            this.checkKeys();
            if (this.man.getIsSlide()) {
                this.man.movement();
                this.moveOnMap.tuningView();
            }
            Lanes.setCorrectDepth(this.lmCarAndMan);
            this.raftMovement();
            this.manWithLawnmower();
            this.manWithCar();
            this.manWithTram();
            this.manWithManhole();
            if (!this.manWithRaft()) {
                this.manWithRiver();
            }
            this.ledLife.animateTiles();
            this.animTile();
            if (this.man.finish() && this.numberLevel != 13) {
                int scr = this.numberLevel * 1000 - this.ledTime.getPassTime() * 10;
                this.score = scr < 0 ? 0 : scr;
                this.putScore(this.numberLevel, this.score);
                this.leftLife = this.man.getAccLife();
                this.removeRoad();
                this.removeRiver();
                this.removeRails();
                this.man.deleteTimer();
                this.ledTime.removePassTimer();
                Lanes.removeElement(this.man);
                this.lmCarAndMan.removeAllLayers();
                ++this.numberLevel;
                if (lvl < this.numberLevel) {
                    lvl = this.numberLevel;
                }
                this.levelManager.setLevel(this.numberLevel);
            }
            if (!this.blnGame || this.man.finish()) {
                Model.isPlay = false;
            }
        } else {
            TextWriter.getInstance().setFont(TextWriter.getInstance().getFont("lao"));
            if (!this.blnGame) {
                this.clearAll();
                int levelId = LevelHolder.getInstance().getCurrentLevel();
                LevelHolder.getInstance().getLevel(levelId).setCurrentScore(this.getTotalScore());
                LevelHolder.getInstance().getLevel(levelId).setBestScore();
                Action gameOver = new Action(this, "OPENMENU", "gameoverscreen");
                gameOver.doAction();
            }
            if (this.man.finish()) {
                if (this.numberLevel != 13 && this.levelNum == null) {
                    if (ImageHandler.getInstance().getImage("/image/endscreen.png") == null) {
                        ImageHandler.getInstance().load("/image/endscreen.png");
                        ImageHandler.getInstance().load("/image/LEVEL_Numbers.png");
                    }
                    g2.drawImage(ImageHandler.getInstance().getImage("/image/endscreen.png"), this.screenWidth >> 1, 0, 17);
                    this.levelNum = new EFSprite("/image/LEVEL_Numbers.png", ImageHandler.getInstance().getImage("/image/LEVEL_Numbers.png").getWidth() / 15, ImageHandler.getInstance().getImage("/image/LEVEL_Numbers.png").getHeight());
                    this.levelNum.setFrame(this.numberLevel - 2);
                    this.levelNum.setPosition(ImageHandler.getInstance().getImage("/image/endscreen.png").getWidth() - this.levelNumX, ImageHandler.getInstance().getImage("/image/endscreen.png").getHeight() - this.levelNumY);
                    this.levelNum.paint(g2);
                    TextWriter.getInstance().drawText(g2, "press any key", this.screenWidth - ImageHandler.getInstance().getImage("/image/endscreen.png").getWidth() >> 1, this.screenHeight - 30);
                } else if (this.numberLevel == 13) {
                    this.clearAll();
                    int levelId1 = LevelHolder.getInstance().getCurrentLevel();
                    LevelHolder.getInstance().getLevel(levelId1).setCurrentScore(this.getTotalScore());
                    LevelHolder.getInstance().getLevel(levelId1).setBestScore();
                    Action win = new Action(this, "OPENMENU", "youwinscreen");
                    win.doAction();
                }
            }
        }
    }

    public void tick() {
        if (LevelHolder.getInstance().getCurrentLevel() == 0 || !this.finishedLoading) {
            return;
        }
    }

    private void putScore(int level, int score) {
        Settings settings = EMidlet.getInstance().getSettings();
        String id = "scorelevel" + level;
        int lastBest = 0;
        try {
            lastBest = Integer.parseInt(settings.get(id));
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (score > lastBest) {
            settings.add(new KeyValuePair(id, Integer.toString(score)));
        }
    }

    private int getTotalScore() {
        Settings settings = EMidlet.getInstance().getSettings();
        int totalScore = 0;
        for (int j2 = 1; j2 <= 12; ++j2) {
            try {
                totalScore += Integer.parseInt(settings.get("scorelevel" + j2));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return totalScore;
    }

    private int getScore(int level) {
        int score = 0;
        try {
            score = Integer.parseInt(EMidlet.getInstance().getSettings().get("scorelevel" + level));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return score;
    }
}

