/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.controller;

import com.jarbull.efw.controller.Animation;
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.game.ISprite;
import com.jarbull.efw.ui.Component;
import com.jarbull.efw.util.ColorEx;
import com.jarbull.efw.util.FP;
import com.jarbull.efw.util.ImageEx;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AnimationHolder {
    private static final AnimationHolder a = new AnimationHolder();
    private Hashtable a;
    private Hashtable b;
    private int a;
    private int b = 0;
    private boolean a = true;

    public static AnimationHolder getInstance() {
        return a;
    }

    private AnimationHolder() {
        this.b = new Hashtable();
    }

    public boolean isEnabled() {
        return this.a;
    }

    public void setEnabled(boolean bl) {
        this.a = bl;
    }

    public int getLastWorldTime() {
        return this.b;
    }

    public int getWorldTimeLimit() {
        return this.a;
    }

    public void setWorldTimeLimit(int n2) {
        this.a = n2;
    }

    public void addAnimation(Animation animation) {
        this.a.put(animation.a, animation);
    }

    public void removeAnimation(String string) {
        this.a.remove(string);
    }

    public int getSize() {
        return this.a.size();
    }

    public Animation getAnimation(String string) {
        return (Animation)this.a.get(string);
    }

    public void suspendAnimations() {
        this.a = false;
        Enumeration enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.b.put(string, this.a.get(string));
        }
        this.a.clear();
    }

    public void restoreSuspended() {
        Enumeration enumeration = this.b.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.a.put(string, this.b.get(string));
        }
        this.b.clear();
        this.a = true;
    }

    public void removeAllAnimations() {
        this.a.clear();
    }

    public Animation[] getAllAnimations() {
        Animation[] animationArray = new Animation[this.a.size()];
        Enumeration enumeration = this.a.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            animationArray[n2++] = (Animation)enumeration.nextElement();
        }
        return animationArray;
    }

    public Animation[] getAnimations(Graphics graphics) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (!graphics.equals(objectArray.a)) continue;
            vector.addElement(objectArray);
        }
        objectArray = new Animation[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Animation[] getAnimations(ISprite iSprite) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (!iSprite.equals(objectArray.a)) continue;
            vector.addElement(objectArray);
        }
        objectArray = new Animation[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Animation[] getAnimations(Component component) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (!component.equals(objectArray.a)) continue;
            vector.addElement(objectArray);
        }
        objectArray = new Animation[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void animate(int n2) {
        if (!this.a) {
            return;
        }
        if (n2 > this.a) {
            n2 %= this.a;
        }
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Animation animation = (Animation)enumeration.nextElement();
            if (!animation.a) continue;
            int n3 = n2 - animation.b;
            int n4 = animation.c - animation.b;
            if (animation.a == 1) {
                if (n3 <= 0) continue;
                n3 %= n4 + animation.d;
            }
            if (this.b <= animation.c && n2 >= animation.c) {
                animation.onAnimationFinished();
                n3 = n4 - 1;
            } else if (n3 < 0) continue;
            switch (animation.getType()) {
                case 0: {
                    ISprite iSprite = animation.a;
                    iSprite.setFrameSequence(animation.b);
                    int n5 = n3 * iSprite.getFrameSequenceLength() / n4;
                    iSprite.setFrame(n5);
                    break;
                }
                case 1: {
                    int n6 = animation.a[0];
                    int n5 = animation.a[1];
                    int n7 = animation.a[2];
                    int n8 = animation.a[3];
                    int n9 = n3 * (n7 - n6) / n4 + n6;
                    int n10 = n3 * (n8 - n5) / n4 + n5;
                    if (animation.a != null) {
                        animation.a.setPosition(n9, n10);
                        break;
                    }
                    animation.a.setPosition(n9, n10);
                    break;
                }
                case 2: {
                    int n11 = animation.a[0];
                    int n5 = animation.a[1];
                    int n7 = FP.intToFP(animation.a[2]);
                    int n8 = FP.intToFP(animation.a[3]);
                    int n9 = FP.toRadians(FP.intToFP(animation.a[4]));
                    int n10 = animation.a[5];
                    int n12 = animation.a[6];
                    int n13 = FP.toRadians(FP.Div(FP.intToFP(n3 * (n5 - n11)), FP.intToFP(n4 + n11)));
                    n11 = FP.toInt(n7 + FP.Mul(FP.Mul(n10, FP.Cos(n13)), FP.Cos(n9)) - FP.Mul(FP.Mul(n12, FP.Sin(n13)), FP.Sin(n9)));
                    n5 = FP.toInt(n8 - FP.Mul(FP.Mul(n10, FP.Cos(n13)), FP.Sin(n9)) - FP.Mul(FP.Mul(n12, FP.Sin(n13)), FP.Cos(n9)));
                    if (animation.a != null) {
                        animation.a.setPosition(n11, n5);
                        break;
                    }
                    animation.a.setPosition(n11, n5);
                    break;
                }
                case 3: {
                    int n14 = animation.a[0];
                    int n5 = animation.a[1];
                    int n7 = n3 * (n5 - n14) / n4 + n14;
                    ImageHandler.getInstance().a(animation.a.getImageId(), ImageEx.setImageAlpha(animation.b, n7));
                    break;
                }
                case 4: {
                    int n15 = animation.a[0];
                    int n5 = animation.a[1];
                    int n7 = n3 * (n5 - n15) / n4 + n15;
                    ImageHandler.getInstance().a(animation.a.getImageId(), ImageEx.rotateImage(ImageHandler.getInstance().getImage(animation.b), n7));
                    break;
                }
                case 5: {
                    int n16 = animation.a[0];
                    int n5 = animation.a[1];
                    animation.a.setColor(ColorEx.getMidColor(n16, n5, n4 * (n4 - n3 - 1) / (n4 - 1), n4));
                    break;
                }
                case 6: {
                    int n8;
                    int n7;
                    int n17 = animation.a[0];
                    int n5 = animation.a[1];
                    if (animation.a != null) {
                        n7 = (n3 * n17 << 1) / n4 + animation.a.getX() - n17;
                        n8 = (n3 * n5 << 1) / n4 + animation.a.getY() - n5;
                        animation.a.setPosition(n7, n8);
                        break;
                    }
                    n7 = (n3 * n17 << 1) / n4 + animation.a.getX() - n17;
                    n8 = (n3 * n5 << 1) / n4 + animation.a.getY() - n5;
                    animation.a.setPosition(n7, n8);
                    break;
                }
                case 7: {
                    int n18 = animation.a[0];
                    int n5 = animation.a[1];
                    int n7 = animation.a[2];
                    int n8 = animation.a[3];
                    int n9 = n3 * (n7 - n18) / n4 + n18;
                    int n10 = n3 * (n8 - n5) / n4 + n5;
                    ImageHandler.getInstance().a(animation.a.getImageId(), ImageEx.resizeImage(ImageHandler.getInstance().getImage(animation.b), n9, n10, true));
                    animation.a.setImage(animation.a.getImageId(), ImageHandler.getInstance().getImage(animation.a.getImageId()).getWidth(), ImageHandler.getInstance().getImage(animation.a.getImageId()).getHeight());
                    break;
                }
                case 8: {
                    int n19 = animation.a[0];
                    int n5 = animation.a[1];
                    int n7 = animation.a[2];
                    int n8 = animation.a[3];
                    int n9 = animation.a[4];
                    int n10 = animation.a[5];
                    int n12 = animation.a[6];
                    int n13 = animation.a[7];
                    n19 = n3 * (n9 - n19) / n4 + n19;
                    n5 = n3 * (n10 - n5) / n4 + n5;
                    n7 = n3 * (n12 - n7) / n4 + n7;
                    n3 = n3 * (n13 - n8) / n4 + n8;
                    animation.a.setClip(n19, n5, n7, n3);
                    break;
                }
                case 9: {
                    boolean bl;
                    boolean bl2 = bl = animation.a[0] != 0;
                    if (n3 > n4) {
                        boolean bl3 = bl = !bl;
                    }
                    if (animation.a != null) {
                        animation.a.setVisible(bl);
                        break;
                    }
                    animation.a.setVisible(bl);
                }
            }
        }
        this.b = n2;
    }
}

