/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import net.phys2d.raw.collide.Comparator;

public class Arrays {
    private static final int INSERTIONSORT_THRESHOLD = 7;

    public static void sort(String[] a2) {
        String[] aux = new String[a2.length];
        System.arraycopy(a2, 0, aux, 0, a2.length);
        Arrays.mergeSort(aux, a2, 0, a2.length, 0);
    }

    public static void sort(Object[] a2, Comparator c) {
        Object[] aux = new Object[a2.length];
        System.arraycopy(a2, 0, aux, 0, a2.length);
        Arrays.mergeSort(aux, a2, 0, a2.length, 0, c);
    }

    private static void mergeSort(Object[] src, Object[] dest, int low, int high, int off, Comparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Arrays.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        Arrays.mergeSort(dest, src, low, mid, -off, c);
        Arrays.mergeSort(dest, src, mid, high, -off, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = destLow; i < destHigh; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void mergeSort(String[] src, String[] dest, int low, int high, int off) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && dest[j - 1].compareTo(dest[j]) > 0; --j) {
                    Arrays.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        Arrays.mergeSort(dest, src, low, mid, -off);
        Arrays.mergeSort(dest, src, mid, high, -off);
        if (src[mid - 1].compareTo(src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = destLow; i < destHigh; ++i) {
            dest[i] = q >= high || p < mid && src[p].compareTo(src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void swap(Object[] x, int a2, int b) {
        Object t = x[a2];
        x[a2] = x[b];
        x[b] = t;
    }

    public static int binarySearchString(String[] a2, String key) {
        int low = 0;
        int high = a2.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            String midVal = a2[mid];
            int cmp = midVal.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

