/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.auer.pLib.sound_util.SoundObj;
import game.GGameData;
import game.GMain;
import game.GParam;
import game.GameObject;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class GContinue
extends GameObject {
    Image alphaImg_w;
    Image alphaImg_b;
    SoundObj bgmPlayer;
    private GameObject G_obj = null;
    private GGameData gD = null;
    private LayerManager gameLayers;
    private Sprite base_Spr;
    private Sprite continueWord_Spr;
    private Sprite yn_Spr;
    private short selected = 0;
    private Display display;
    private boolean stopping = false;
    private int fadeCount;
    private int temp1 = 0;
    private int temp2 = 1;
    private byte gameFlow = 0;
    private byte nextGameFlow = 0;
    private byte changeMainFlow = 0;
    private final byte GF_CONTINUE;
    private final byte GF_EXIT = (byte)6;
    private final byte GF_FADE_IN_WHITE = (byte)20;
    private final byte GF_FADE_IN_BLACK = (byte)21;
    private final byte GF_FADE_OUT_WHITE = (byte)22;
    private final byte GF_FADE_OUT_BLACK = (byte)23;

    public GContinue(Graphics g, GGameData gData) {
        this.GF_CONTINUE = 1;
        this.gD = gData;
        this.fadeCount = 0;
        this.gameFlow = (byte)21;
        this.nextGameFlow = 1;
        this.gameLayers = new LayerManager();
        this.gameLayers.setViewWindow(0, 0, 240, 274);
        this.preload();
        this.initial();
    }

    private void preload() {
        try {
            this.bgmPlayer = new SoundObj("/sounds/continue.mid", "audio/midi");
            this.alphaImg_w = Image.createImage((String)"/images/alpha_w.png");
            this.alphaImg_b = Image.createImage((String)"/images/alpha_b.png");
            Image tempImg = Image.createImage((String)"/images/again.png");
            this.base_Spr = new Sprite(tempImg, tempImg.getWidth(), tempImg.getHeight());
            tempImg = Image.createImage((String)"/images/continue_w.png");
            this.continueWord_Spr = new Sprite(tempImg, tempImg.getWidth(), tempImg.getHeight());
            tempImg = Image.createImage((String)"/images/yn.png");
            this.yn_Spr = new Sprite(tempImg, tempImg.getWidth() / 2, tempImg.getHeight() / 2);
        }
        catch (IOException e) {
            System.err.println("Failed loading images! 1");
        }
        this.gameLayers.append((Layer)this.base_Spr);
        this.base_Spr.setPosition(0, (274 - this.base_Spr.getHeight()) / 2);
        this.continueWord_Spr.setPosition((int)GParam.Continue_POS[0], (int)GParam.Continue_POS[1]);
        this.bgmPlayer.set_IsRepeat(false);
        this.bgmPlayer.setVolume(this.gD.volume);
        this.bgmPlayer.playSound(1);
    }

    public void initial() {
        switch (this.gameFlow) {
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
        }
    }

    public boolean keyProc(int keyState, int pressKeyCode) {
        if ((keyState & 2) == 0 && (keyState & 0x40) == 0) {
            if ((keyState & 4) != 0) {
                if (this.gameFlow == 1) {
                    this.selected = (short)(this.selected - 1);
                    if (this.selected < 0) {
                        this.selected = 1;
                    }
                }
            } else if ((keyState & 0x20) != 0) {
                if (this.gameFlow == 1) {
                    this.selected = (short)(this.selected + 1);
                    if (this.selected > 1) {
                        this.selected = 0;
                    }
                }
            } else if ((keyState & 0x100) != 0 && this.gameFlow == 1) {
                this.fadeCount = 0;
                this.gameFlow = (byte)23;
                this.nextGameFlow = (byte)6;
                if (this.selected == 1) {
                    this.gD.continueFlag = true;
                    this.changeMainFlow = (byte)6;
                } else {
                    this.gD.continueFlag = false;
                    this.changeMainFlow = (byte)2;
                }
            }
        }
        return false;
    }

    public boolean gameProc(int switching) {
        if (this.gameFlow == 6) {
            this.stop();
        }
        return false;
    }

    public boolean gamePaint(Graphics g) {
        if (this.G_obj != null) {
            this.G_obj.gamePaint(g);
        } else if (this.gameFlow == 22) {
            if (this.fadeCount == 0) {
                this.gameLayers.paint(g, (int)this.gD.X_Shift, (int)this.gD.Y_Shift);
            }
            g.drawImage(this.alphaImg_w, 0, 0, 20);
            GMain.flushGraphic();
            this.fadeCount = this.animeIndexCHG(this.fadeCount, 8);
            if (this.fadeCount == 0) {
                this.gameFlow = this.nextGameFlow;
            }
        } else if (this.gameFlow == 23) {
            if (this.fadeCount == 0) {
                this.gameLayers.paint(g, (int)this.gD.X_Shift, (int)this.gD.Y_Shift);
            }
            g.drawImage(this.alphaImg_b, 0, 0, 20);
            GMain.flushGraphic();
            this.fadeCount = this.animeIndexCHG(this.fadeCount, 5);
            if (this.fadeCount == 0) {
                this.gameFlow = this.nextGameFlow;
            }
        } else if (this.gameFlow == 20) {
            this.gameLayers.paint(g, (int)this.gD.X_Shift, (int)this.gD.Y_Shift);
            int i = 6 - this.fadeCount;
            while (i > 1) {
                g.drawImage(this.alphaImg_w, 0, 0, 20);
                --i;
            }
            this.fadeCount = this.animeIndexCHG(this.fadeCount, 6);
            GMain.flushGraphic();
            if (this.fadeCount == 0) {
                this.gameFlow = this.nextGameFlow;
            }
        } else if (this.gameFlow == 21) {
            this.gameLayers.paint(g, (int)this.gD.X_Shift, (int)this.gD.Y_Shift);
            int i = 6 - this.fadeCount;
            while (i > 1) {
                g.drawImage(this.alphaImg_b, 0, 0, 20);
                --i;
            }
            this.fadeCount = this.animeIndexCHG(this.fadeCount, 6);
            GMain.flushGraphic();
            if (this.fadeCount == 0) {
                this.gameFlow = this.nextGameFlow;
            }
        } else if (this.gameFlow == 1) {
            this.gameLayers.paint(g, (int)this.gD.X_Shift, (int)this.gD.Y_Shift);
            this.continueWord_Spr.paint(g);
            this.yn_Spr.setPosition(this.continueWord_Spr.getX() + 15, this.continueWord_Spr.getY() + this.continueWord_Spr.getHeight() + 5);
            if (this.selected == 1) {
                this.yn_Spr.setFrame(2);
            } else {
                this.yn_Spr.setFrame(0);
            }
            this.yn_Spr.paint(g);
            this.yn_Spr.setPosition(this.continueWord_Spr.getX() + 50, this.continueWord_Spr.getY() + this.continueWord_Spr.getHeight() + 5);
            if (this.selected == 0) {
                this.yn_Spr.setFrame(3);
            } else {
                this.yn_Spr.setFrame(1);
            }
            this.yn_Spr.paint(g);
            GMain.flushGraphic();
        }
        return false;
    }

    public void stop() {
        this.stopping = true;
        this.bgmPlayer.close();
    }

    public boolean isStop() {
        return this.stopping;
    }

    public byte changeFlow() {
        return this.changeMainFlow;
    }

    public void putIn(int data) {
        switch (data) {
            case 10: 
            case 11: {
                this.bgmPlayer.setVolume(this.gD.volume);
            }
        }
    }

    private short animeIndexCHG(int data, int limit) {
        if (++data >= limit) {
            data = 0;
        }
        return (short)data;
    }
}

