/*
 * Decompiled with CFR 0.152.
 */
package map;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import map.m_event.ChgRoleLimit;
import map.m_event.EventUnlock_EClear;
import map.m_event.Finish;
import map.m_event.GameOver;
import map.m_event.MapBackwardLock;
import map.m_event.MapFUnLock_EClear;
import map.m_event.MapForwardLock;
import map.m_event.MapForwardUnLock;
import map.m_event.NewBoss;
import map.m_event.NewEff;
import map.m_event.NewRole;
import map.m_event.PlayMusic;
import map.m_event.ReleasePic;
import map.m_event.Report;
import map.m_event.StageSwitch;
import map.m_event.Talk;

public class Stage {
    private String bgm = "";
    private Sprite[] bg_SprArray;
    private byte[] bg_MapDataArray;
    private Sprite[] mg1_SprArray;
    private byte[] mg1_MapDataArray;
    private Sprite[] mg2_SprArray;
    private byte[] mg2_MapDataArray;
    private Sprite[] fg_SprArray;
    private byte[] fg_MapDataArray;
    private Vector[] event;

    public Stage(String file) {
        this.openfile(file);
    }

    public void openfile(String file) {
        try {
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(file));
            this.dataRead(dis);
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dataRead(DataInputStream dis) {
        int errorFrame = 0;
        try {
            int i;
            this.bgm = dis.readUTF();
            int sprCount = dis.readByte();
            errorFrame = 1;
            if (sprCount > 0) {
                this.bg_SprArray = new Sprite[sprCount];
                i = 0;
                while (i < sprCount) {
                    this.bg_SprArray[i] = new Sprite(Image.createImage((String)("/images/mapimg/" + dis.readUTF())));
                    ++i;
                }
            }
            sprCount = dis.readByte();
            errorFrame = 2;
            if (sprCount > 0) {
                this.mg1_SprArray = new Sprite[sprCount];
                i = 0;
                while (i < sprCount) {
                    this.mg1_SprArray[i] = new Sprite(Image.createImage((String)("/images/mapimg/" + dis.readUTF())));
                    ++i;
                }
            }
            sprCount = dis.readByte();
            errorFrame = 3;
            if (sprCount > 0) {
                this.mg2_SprArray = new Sprite[sprCount];
                i = 0;
                while (i < sprCount) {
                    this.mg2_SprArray[i] = new Sprite(Image.createImage((String)("/images/mapimg/" + dis.readUTF())));
                    ++i;
                }
            }
            errorFrame = 4;
            sprCount = dis.readByte();
            if (sprCount > 0) {
                this.fg_SprArray = new Sprite[sprCount];
                i = 0;
                while (i < sprCount) {
                    this.fg_SprArray[i] = new Sprite(Image.createImage((String)("/images/mapimg/" + dis.readUTF())));
                    ++i;
                }
            }
            int mapFrames = dis.readShort();
            int eventCount = 0;
            boolean mapData = false;
            this.event = new Vector[mapFrames];
            byte[] bg_MapDataTempArray = new byte[mapFrames];
            this.mg1_MapDataArray = new byte[mapFrames];
            byte[] mg2_MapDataTempArray = new byte[mapFrames];
            this.fg_MapDataArray = new byte[mapFrames];
            int i2 = 0;
            while (i2 < mapFrames) {
                errorFrame = i2;
                eventCount = 0;
                bg_MapDataTempArray[i2] = dis.readByte();
                this.mg1_MapDataArray[i2] = dis.readByte();
                mg2_MapDataTempArray[i2] = dis.readByte();
                this.fg_MapDataArray[i2] = dis.readByte();
                eventCount = dis.readByte();
                if (eventCount > 0) {
                    this.event[i2] = new Vector();
                    int j = 0;
                    while (j < eventCount) {
                        short event_ID = dis.readShort();
                        switch (event_ID) {
                            case 1: {
                                this.event[i2].addElement(new NewRole(dis));
                                break;
                            }
                            case 14: {
                                this.event[i2].addElement(new NewBoss(dis));
                                break;
                            }
                            case 2: {
                                this.event[i2].addElement(new ChgRoleLimit(dis));
                                break;
                            }
                            case 3: {
                                this.event[i2].addElement(new Talk(dis));
                                break;
                            }
                            case 4: {
                                this.event[i2].addElement(new Report(dis));
                                break;
                            }
                            case 5: {
                                this.event[i2].addElement(new MapForwardLock(dis));
                                break;
                            }
                            case 6: {
                                this.event[i2].addElement(new MapForwardUnLock(dis));
                                break;
                            }
                            case 7: {
                                this.event[i2].addElement(new MapBackwardLock(dis));
                                break;
                            }
                            case 8: {
                                break;
                            }
                            case 9: {
                                this.event[i2].addElement(new MapFUnLock_EClear(dis));
                                break;
                            }
                            case 10: {
                                this.event[i2].addElement(new Finish(dis));
                                break;
                            }
                            case 11: {
                                this.event[i2].addElement(new EventUnlock_EClear(dis));
                                break;
                            }
                            case 12: {
                                this.event[i2].addElement(new PlayMusic(dis));
                                break;
                            }
                            case 13: {
                                this.event[i2].addElement(new GameOver(dis));
                                break;
                            }
                            case 15: {
                                this.event[i2].addElement(new StageSwitch(dis));
                                break;
                            }
                            case 16: {
                                this.event[i2].addElement(new ReleasePic(dis));
                                break;
                            }
                            case 17: {
                                this.event[i2].addElement(new NewEff(dis));
                            }
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            int bgSize = 0;
            int i3 = 0;
            while (i3 < mapFrames) {
                if (bg_MapDataTempArray[i3] <= -1) break;
                bgSize = (short)(bgSize + 1);
                ++i3;
            }
            this.bg_MapDataArray = new byte[bgSize];
            i3 = 0;
            while (i3 < this.bg_MapDataArray.length) {
                this.bg_MapDataArray[i3] = bg_MapDataTempArray[i3];
                ++i3;
            }
            bg_MapDataTempArray = null;
            int mg2Size = 0;
            int i4 = 0;
            while (i4 < mapFrames) {
                if (mg2_MapDataTempArray[i4] <= -1) break;
                mg2Size = (short)(mg2Size + 1);
                ++i4;
            }
            this.mg2_MapDataArray = new byte[mg2Size];
            i4 = 0;
            while (i4 < this.mg2_MapDataArray.length) {
                this.mg2_MapDataArray[i4] = mg2_MapDataTempArray[i4];
                ++i4;
            }
            mg2_MapDataTempArray = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Map Error at :" + errorFrame);
        }
    }

    public void clrVct() {
        this.bgm = "";
        int i = 0;
        while (i < this.event.length) {
            if (this.event[i] != null) {
                this.event[i].removeAllElements();
            }
            ++i;
        }
    }

    public String getBGM_FileName() {
        return this.bgm;
    }

    public Sprite[] getSprsFromVct(Vector vct) {
        Sprite[] sprArr = null;
        if (vct.size() != 0) {
            sprArr = new Sprite[vct.size()];
            int i = 0;
            while (i < vct.size()) {
                sprArr[i] = (Sprite)vct.elementAt(i);
                ++i;
            }
        } else {
            System.out.println("Spr empty !");
        }
        return sprArr;
    }

    public byte[] getBytesFromVct(Vector vct) {
        byte[] mapArr = null;
        if (vct.size() != 0) {
            mapArr = new byte[vct.size()];
            int i = 0;
            while (i < vct.size()) {
                mapArr[i] = (Byte)vct.elementAt(i);
                ++i;
            }
        } else {
            System.out.println("MapData empty !");
        }
        return mapArr;
    }

    public Sprite[] getBG_Sprs() {
        return this.bg_SprArray;
    }

    public byte[] getBG_MapData() {
        return this.bg_MapDataArray;
    }

    public Sprite[] getMG1_Sprs() {
        return this.mg1_SprArray;
    }

    public byte[] getMG1_MapData() {
        return this.mg1_MapDataArray;
    }

    public Sprite[] getMG2_Sprs() {
        return this.mg2_SprArray;
    }

    public byte[] getMG2_MapData() {
        return this.mg2_MapDataArray;
    }

    public Sprite[] getFG_Sprs() {
        return this.fg_SprArray;
    }

    public byte[] getFG_MapData() {
        return this.fg_MapDataArray;
    }

    public Vector[] getEvents() {
        return this.event;
    }
}

