/*
 * Decompiled with CFR 0.152.
 */
package microengine;

import java.util.Hashtable;
import microengine.MEFont;

public class MEFontCache {
    private static MEFontCache instance;
    private Hashtable fontCache = new Hashtable();

    private MEFontCache() {
    }

    public static MEFontCache getInstance() {
        if (instance == null) {
            instance = new MEFontCache();
        }
        return instance;
    }

    public boolean addFontToCache(MEFont font) {
        if (!this.fontCache.containsKey(font.getFontName())) {
            this.fontCache.put(font.getFontName(), font);
        }
        return true;
    }

    public boolean addFontToCache(String fontPath, String fontName) {
        if (!this.fontCache.containsKey(fontName)) {
            MEFont font = new MEFont(fontPath, fontName);
            this.fontCache.put(fontName, font);
        }
        return true;
    }

    public MEFont getCachedFont(String fontId) {
        return (MEFont)this.fontCache.get(fontId);
    }

    public void removeCachedImage(String fontId) {
        this.fontCache.remove(fontId);
    }
}

