/*
 * Decompiled with CFR 0.152.
 */
package microengine;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import microengine.MEObject;
import microengine.inputEvents.MEInputEvent;
import microengine.inputEvents.MEKeyboardEvent;
import microengine.inputEvents.METouchEvent;
import microengine.utils.MESize;

public class MicroEngine
implements Runnable {
    private GameCanvasProxy canvas = new GameCanvasProxy(6);
    private Graphics graphics;
    private Vector objects;
    private int fps;
    private boolean paused;
    private boolean stoped;
    private long lastFrame;
    int otherKey = -1;

    public MicroEngine(int fps) {
        this.canvas.setFullScreenMode(true);
        this.objects = new Vector();
        this.lastFrame = 0L;
        this.graphics = this.canvas.getGraphics();
        this.stoped = true;
        this.fps = fps;
    }

    public Displayable getDrawingArea() {
        return this.canvas;
    }

    public MESize getScreenSize() {
        return new MESize(this.canvas.getWidth(), this.canvas.getHeight());
    }

    public void start() {
        if (this.stoped) {
            Thread t = new Thread(this);
            t.start();
        }
    }

    public void stop() {
        if (!this.stoped) {
            this.stoped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        MicroEngine microEngine = this;
        synchronized (microEngine) {
            if (this.paused) {
                this.paused = false;
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        MicroEngine microEngine = this;
        synchronized (microEngine) {
            if (!this.paused) {
                this.paused = true;
            }
        }
    }

    public void addObject(MEObject object) {
        if (!this.objects.contains(object)) {
            this.objects.addElement(object);
        }
    }

    public void removeObject(MEObject object) {
        this.objects.removeElement(object);
    }

    public void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        Enumeration enumeration = this.objects.elements();
        while (enumeration.hasMoreElements()) {
            MEObject view = (MEObject)enumeration.nextElement();
            view.render(g);
        }
    }

    public void onUpdate(float interpolation, int input) {
        METouchEvent[] tInputs = this.canvas.getTouchQueue();
        MEInputEvent[] allInputs = new MEInputEvent[tInputs.length];
        allInputs[0] = this.otherKey == 6 || this.otherKey == 7 ? new MEKeyboardEvent(this.otherKey) : new MEKeyboardEvent(input);
        int i = 1;
        while (i < allInputs.length) {
            allInputs[i] = tInputs[i - 1];
            ++i;
        }
        Enumeration enumeration = this.objects.elements();
        while (enumeration.hasMoreElements()) {
            MEObject view = (MEObject)enumeration.nextElement();
            view.update(interpolation, allInputs);
        }
        this.canvas.clearTouchQueue();
    }

    public void onRender() {
        this.paint(this.graphics);
        this.canvas.flushGraphics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.stoped = false;
        while (!this.stoped) {
            try {
                MicroEngine microEngine = this;
                synchronized (microEngine) {
                    if (this.paused) {
                        this.wait();
                    }
                }
                long interval = System.currentTimeMillis();
                int deltaT = (int)(interval - this.lastFrame);
                this.lastFrame = interval;
                this.onUpdate(deltaT, this.canvas.getKeyStates());
                this.onRender();
                interval = System.currentTimeMillis() - interval;
                interval = (long)(1000 / this.fps) - interval;
                Thread.sleep(interval > 0L ? interval : 0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.stoped = true;
    }

    private class GameCanvasProxy
    extends GameCanvas {
        private int eventIndex;
        private METouchEvent[] touchEvents;

        protected GameCanvasProxy(int queueSize) {
            super(false);
            this.touchEvents = new METouchEvent[queueSize];
            int i = 0;
            while (i < this.touchEvents.length) {
                this.touchEvents[i] = new METouchEvent(0, 0, 0);
                ++i;
            }
            this.eventIndex = 0;
        }

        public Graphics getGraphics() {
            return super.getGraphics();
        }

        protected void pointerDragged(int x, int y) {
            super.pointerDragged(x, y);
            if (this.eventIndex < this.touchEvents.length) {
                this.touchEvents[this.eventIndex].reload(2, x, y);
                ++this.eventIndex;
            }
        }

        protected void pointerPressed(int x, int y) {
            super.pointerPressed(x, y);
            if (this.eventIndex < this.touchEvents.length) {
                this.touchEvents[this.eventIndex].reload(1, x, y);
                ++this.eventIndex;
            }
        }

        protected void pointerReleased(int x, int y) {
            super.pointerReleased(x, y);
            if (this.eventIndex < this.touchEvents.length) {
                this.touchEvents[this.eventIndex].reload(3, x, y);
                ++this.eventIndex;
            }
        }

        protected void keyPressed(int keyCode) {
            MicroEngine.this.otherKey = keyCode;
            if (MicroEngine.this.otherKey < 0) {
                MicroEngine.this.otherKey = 0 - MicroEngine.this.otherKey;
            }
        }

        protected void keyReleased(int keyCode) {
            if (MicroEngine.this.otherKey == 0 - keyCode) {
                MicroEngine.this.otherKey = -1;
            }
        }

        public METouchEvent[] getTouchQueue() {
            return this.touchEvents;
        }

        public void clearTouchQueue() {
            int i = 0;
            while (i < this.touchEvents.length) {
                this.touchEvents[i].markAsConsumed();
                ++i;
            }
            this.eventIndex = 0;
        }
    }
}

