/*
 * Decompiled with CFR 0.152.
 */
package microengine.elements;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import microengine.MEObject;
import microengine.inputEvents.MEInputEvent;
import microengine.utils.MEBoundingRect;
import microengine.utils.MEPoint;
import microengine.utils.MESize;

public class MENode
extends MEObject {
    private MENode parent = null;
    protected Vector children = new Vector();
    protected MEPoint position = new MEPoint(0, 0);
    protected MEBoundingRect boundingRect = new MEBoundingRect(this.position, MESize.fromPoint(this.position), true);
    protected boolean visible = true;

    public MEPoint getPosition() {
        return this.position.clone();
    }

    public int getXPosition() {
        return this.position.x;
    }

    public int getYPosition() {
        return this.position.y;
    }

    public void setPosition(int x, int y) {
        this.position.set(x, y);
    }

    public void setPosition(MEPoint position) {
        this.setPosition(position.x, position.y);
    }

    public MENode getParent() {
        return this.parent;
    }

    public void setParent(MENode parent) {
        this.parent = parent;
    }

    public MEBoundingRect getBoundingRect() {
        return this.boundingRect;
    }

    public void setBoundingRect(MEBoundingRect boundingRect) {
        this.boundingRect = boundingRect;
    }

    public void setBoundingRectSize(MESize size) {
        this.boundingRect.setSize(size);
    }

    public void addChild(MENode toAdd) {
        if (!this.children.contains(toAdd)) {
            toAdd.setParent(this);
            this.children.addElement(toAdd);
        }
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public boolean removeChild(MENode toRemove) {
        boolean removed = this.children.removeElement(toRemove);
        if (removed) {
            toRemove.setParent(null);
        }
        return removed;
    }

    public int getIndexOfChild(MENode child) {
        return this.children.indexOf(child);
    }

    public void removeChildAtIndex(int index) {
        this.children.removeElementAt(index);
    }

    public MEObject getChildByTag(int tag) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            MEObject child = (MEObject)enumeration.nextElement();
            if (child.getTag() != tag) continue;
            return child;
        }
        return null;
    }

    public MEObject getChildByName(String name) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            MEObject child = (MEObject)enumeration.nextElement();
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected void onRender(Graphics renderer) {
    }

    protected void onUpdate(float interpolation, MEInputEvent[] inputEvents) {
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void render(Graphics renderer) {
        if (!this.visible) {
            return;
        }
        renderer.translate(this.position.x, this.position.y);
        this.onRender(renderer);
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            MEObject child = (MEObject)enumeration.nextElement();
            child.render(renderer);
        }
        renderer.translate(-this.position.x, -this.position.y);
    }

    public void update(float interpolation, MEInputEvent[] inputEvents) {
        if (this.children.size() > 0) {
            int i = this.children.size() - 1;
            while (i >= 0) {
                MEObject child = (MEObject)this.children.elementAt(i);
                child.update(interpolation, inputEvents);
                --i;
            }
        }
        this.onUpdate(interpolation, inputEvents);
    }
}

