/*
 * Decompiled with CFR 0.152.
 */
package nodes;

import javax.microedition.lcdui.Graphics;
import microengine.MEFont;
import microengine.MERenderableChar;
import microengine.elements.MENode;
import microengine.utils.MESize;

public class MELabelNode
extends MENode {
    private MEFont font;
    private String label;
    private MERenderableChar[] renderableLabel;

    public MELabelNode(String label, MEFont font) {
        this(label, font, 500);
    }

    public MELabelNode(String label, MEFont font, int labelMaxWidth) {
        this.label = label;
        this.font = font;
        this.renderableLabel = new MERenderableChar[label.length()];
        int xOffset = 0;
        int yOffset = 0;
        int row = 1;
        int maxWidth = 0;
        int lastSpace = 0;
        int i = 0;
        while (i < this.renderableLabel.length) {
            int c = label.charAt(i);
            if (c == 32) {
                lastSpace = i;
            }
            this.renderableLabel[i] = font.getRenderableChar((char)c);
            if (this.renderableLabel[i] == null) {
                this.renderableLabel[i] = font.getRenderableChar(' ');
                c = 32;
            }
            if (c == 10) {
                if (xOffset > maxWidth) {
                    maxWidth = xOffset;
                }
                xOffset = 0;
                yOffset += this.font.getFontHeight();
                ++row;
            }
            if (xOffset + this.renderableLabel[i].getCharWidth() > labelMaxWidth) {
                if (xOffset > maxWidth) {
                    maxWidth = xOffset;
                }
                xOffset = 0;
                yOffset += this.font.getFontHeight();
                ++row;
                int j = lastSpace + 1;
                while (j < i) {
                    this.renderableLabel[j].setCharPosX(xOffset);
                    this.renderableLabel[j].setCharPosY(yOffset);
                    xOffset += this.renderableLabel[j].getXAdvance();
                    ++j;
                }
            }
            this.renderableLabel[i].setCharPosX(xOffset);
            this.renderableLabel[i].setCharPosY(yOffset);
            xOffset += this.renderableLabel[i].getXAdvance();
            ++i;
        }
        if (xOffset > maxWidth) {
            maxWidth = xOffset;
        }
        this.setBoundingRectSize(new MESize(maxWidth, this.font.getFontHeight() * row));
    }

    protected void onRender(Graphics renderer) {
        int i = 0;
        while (i < this.renderableLabel.length) {
            this.renderableLabel[i].render(renderer);
            ++i;
        }
    }
}

