/*
 * Decompiled with CFR 0.152.
 */
package SeaWars;

import SeaWars.Boat;
import SeaWars.BoatHypo;
import java.util.Random;
import java.util.Vector;
import microengine.utils.MEPoint;

public class MapStatus {
    int cols;
    int rows;
    Random rand;
    int chargePower = 0;
    int playerTotalBoat = 5;
    int enemyTotalBoat = 5;
    MEPoint lastCpuHit;
    int[][] grid;
    int[][] enemyGrid;
    Boat[] boats;
    Boat[] enemyBoats;
    public static final int WATER = 0;
    public static final int BOAT = 1;
    public static final int WATERHIT = 2;
    public static final int BOATHIT = 3;
    public static final int SUNK = 4;
    public boolean endGame = false;
    public boolean won = false;
    boolean playerTurn;
    BoatHypo currentBoatHyp = null;
    Vector boatHypQueue;

    public MapStatus(int cols, int rows) {
        int x;
        this.cols = cols;
        this.rows = rows;
        this.rand = new Random();
        this.grid = new int[rows][cols];
        this.enemyGrid = new int[rows][cols];
        this.boats = new Boat[5];
        this.enemyBoats = new Boat[5];
        int y = 0;
        while (y < rows) {
            x = 0;
            while (x < cols) {
                this.grid[y][x] = 0;
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < rows) {
            x = 0;
            while (x < cols) {
                this.enemyGrid[y][x] = 0;
                ++x;
            }
            ++y;
        }
        this.playerTurn = this.rand.nextInt(2) > 0;
    }

    public void setMyShips() {
        int[] navi = new int[]{0, 2, 2, 1};
        int b = 0;
        int len = 1;
        while (len < 5) {
            int i = 0;
            while (i < navi[len - 1]) {
                int l;
                int cellY;
                int cellX;
                boolean vertical;
                boolean valid;
                block2: do {
                    valid = true;
                    vertical = this.rand.nextInt(2) > 0;
                    cellX = this.rand.nextInt(this.cols - (vertical ? 0 : len - 1));
                    cellY = this.rand.nextInt(this.rows - (vertical ? len - 1 : 0));
                    if (vertical) {
                        l = 0;
                        while (l < len) {
                            if (this.grid[cellY + l][cellX] != 0) {
                                valid = false;
                                continue block2;
                            }
                            ++l;
                        }
                    } else {
                        l = 0;
                        while (l < len) {
                            if (this.grid[cellY][cellX + l] != 0) {
                                valid = false;
                                continue block2;
                            }
                            ++l;
                        }
                    }
                } while (!valid);
                this.boats[b] = new Boat();
                this.boats[b].vertical = vertical;
                l = 0;
                while (l < len) {
                    if (vertical) {
                        this.setCellStatus(cellX, cellY + l, 1);
                        this.boats[b].addCoord(new MEPoint(cellX, cellY + l));
                    } else {
                        this.setCellStatus(cellX + l, cellY, 1);
                        this.boats[b].addCoord(new MEPoint(cellX + l, cellY));
                    }
                    ++l;
                }
                System.out.println("x: " + this.boats[b].getX() + " y: " + this.boats[b].getY() + " vert: " + this.boats[b].vertical);
                ++b;
                ++i;
            }
            ++len;
        }
    }

    public void setEnemyShip() {
        int[] navi = new int[]{0, 2, 2, 1};
        int b = 0;
        int len = 1;
        while (len < 5) {
            int i = 0;
            while (i < navi[len - 1]) {
                int l;
                int cellY;
                int cellX;
                boolean vertical;
                boolean valid;
                block2: do {
                    valid = true;
                    vertical = this.rand.nextInt(2) > 0;
                    cellX = this.rand.nextInt(this.cols - (vertical ? 0 : len - 1));
                    cellY = this.rand.nextInt(this.rows - (vertical ? len - 1 : 0));
                    if (vertical) {
                        l = 0;
                        while (l < len) {
                            if (this.enemyGrid[cellY + l][cellX] != 0) {
                                valid = false;
                                continue block2;
                            }
                            ++l;
                        }
                    } else {
                        l = 0;
                        while (l < len) {
                            if (this.enemyGrid[cellY][cellX + l] != 0) {
                                valid = false;
                                continue block2;
                            }
                            ++l;
                        }
                    }
                } while (!valid);
                this.enemyBoats[b] = new Boat();
                this.enemyBoats[b].vertical = vertical;
                l = 0;
                while (l < len) {
                    if (vertical) {
                        this.setEnemyCellStatus(cellX, cellY + l, 1);
                        this.enemyBoats[b].addCoord(new MEPoint(cellX, cellY + l));
                    } else {
                        this.setEnemyCellStatus(cellX + l, cellY, 1);
                        this.enemyBoats[b].addCoord(new MEPoint(cellX + l, cellY));
                    }
                    ++l;
                }
                ++b;
                ++i;
            }
            ++len;
        }
    }

    public int getCellStatus(int x, int y) {
        if (x < 0 || y < 0) {
            return 0;
        }
        if (x >= this.cols || y >= this.rows) {
            return 0;
        }
        return this.grid[y][x];
    }

    public void setCellStatus(int x, int y, int s) {
        this.grid[y][x] = s;
    }

    public int getEnemyCellStatus(int x, int y) {
        if (x < 0 || y < 0) {
            return 0;
        }
        if (x >= this.cols || y >= this.rows) {
            return 0;
        }
        return this.enemyGrid[y][x];
    }

    public void setEnemyCellStatus(int x, int y, int s) {
        this.enemyGrid[y][x] = s;
    }

    public int getChargePower() {
        return this.chargePower;
    }

    public void setChargePower(int charge) {
        this.chargePower = charge;
    }

    public void reset() {
        int x;
        this.chargePower = 0;
        this.lastCpuHit = new MEPoint(-1, -1);
        this.enemyTotalBoat = 5;
        this.playerTotalBoat = 5;
        this.boatHypQueue = new Vector();
        int y = 0;
        while (y < this.rows) {
            x = 0;
            while (x < this.cols) {
                this.grid[y][x] = 0;
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < this.rows) {
            x = 0;
            while (x < this.cols) {
                this.enemyGrid[y][x] = 0;
                ++x;
            }
            ++y;
        }
        this.playerTurn = this.rand.nextInt(2) > 0;
    }

    public boolean getPlayerTurn() {
        return this.playerTurn;
    }

    public void setPlayerTurn(boolean turn) {
        this.playerTurn = turn;
    }

    public boolean playerDoShot(MEPoint coord) {
        System.out.println("Hit: " + coord.x + "," + coord.y);
        int i = 0;
        while (i < 5) {
            System.out.println("Nave is on " + this.enemyBoats[i].getX() + " " + this.enemyBoats[i].getY());
            if (this.enemyBoats[i].isOn(coord)) {
                System.out.println("NAVE IS HIT!");
                if (this.enemyGrid[coord.y][coord.x] == 1) {
                    if (this.enemyBoats[i].shot(coord)) {
                        --this.enemyTotalBoat;
                        if (this.enemyTotalBoat <= 0) {
                            this.won = true;
                            this.endGame = true;
                        }
                    }
                    this.enemyGrid[coord.y][coord.x] = 3;
                    return true;
                }
            }
            ++i;
        }
        System.out.println("NAVE IS NOT HIT!");
        return false;
    }

    public boolean cpuDoShot(MEPoint coord) {
        System.out.println("CPU Hit: " + coord.x + "," + coord.y);
        int i = 0;
        while (i < 5) {
            if (this.boats[i].isOn(coord)) {
                System.out.println("NAVE IS HIT!");
                if (this.grid[coord.y][coord.x] == 1) {
                    if (this.boats[i].shot(coord)) {
                        --this.playerTotalBoat;
                        if (this.playerTotalBoat <= 0) {
                            this.won = false;
                            this.endGame = true;
                        }
                        int j = 0;
                        while (j < this.boats[i].getLenght()) {
                            this.grid[this.boats[i].getCoordAt((int)j).y][this.boats[i].getCoordAt((int)j).x] = 4;
                            ++j;
                        }
                        return true;
                    }
                    this.grid[coord.y][coord.x] = 3;
                    return true;
                }
            }
            ++i;
        }
        this.grid[coord.y][coord.x] = 2;
        System.out.println("NAVE IS NOT HIT!");
        return false;
    }

    public MEPoint getNextCpuShot() {
        if (this.getCellStatus(this.lastCpuHit.x, this.lastCpuHit.y) == 4) {
            BoatHypo boatHyp = null;
            int i = 0;
            while (i < this.currentBoatHyp.getCellsNumber()) {
                if (this.getCellStatus(this.currentBoatHyp.getCell((int)i).x, this.currentBoatHyp.getCell((int)i).y) != 4) {
                    if (boatHyp == null) {
                        boatHyp = new BoatHypo(this.currentBoatHyp.getCell((int)i).x, this.currentBoatHyp.getCell((int)i).y, true, true);
                    } else {
                        boatHyp.addHit(this.currentBoatHyp.getCell((int)i).x, this.currentBoatHyp.getCell((int)i).y);
                    }
                }
                ++i;
            }
            if (boatHyp != null) {
                this.boatHypQueue.addElement(boatHyp);
            }
            if (this.currentBoatHyp != null) {
                this.currentBoatHyp = null;
            }
        }
        if (this.getCellStatus(this.lastCpuHit.x, this.lastCpuHit.y) == 3) {
            if (this.currentBoatHyp == null) {
                this.boatHypQueue.addElement(new BoatHypo(this.lastCpuHit.x, this.lastCpuHit.y, true, true));
            } else {
                this.currentBoatHyp.addHit(this.lastCpuHit.x, this.lastCpuHit.y);
            }
        }
        if (this.currentBoatHyp != null) {
            Vector possibleHits = this.currentBoatHyp.getPossibleHits();
            boolean valid = false;
            int i = 0;
            while (i < possibleHits.size()) {
                if (((MEPoint)possibleHits.elementAt((int)i)).x >= 0 && ((MEPoint)possibleHits.elementAt((int)i)).y >= 0 && ((MEPoint)possibleHits.elementAt((int)i)).x <= this.cols && ((MEPoint)possibleHits.elementAt((int)i)).y <= this.rows && (this.getCellStatus(((MEPoint)possibleHits.elementAt((int)i)).x, ((MEPoint)possibleHits.elementAt((int)i)).y) == 0 || this.getCellStatus(((MEPoint)possibleHits.elementAt((int)i)).x, ((MEPoint)possibleHits.elementAt((int)i)).y) == 1)) {
                    valid = true;
                    break;
                }
                ++i;
            }
            if (!valid) {
                i = 0;
                while (i < this.currentBoatHyp.getCellsNumber()) {
                    this.boatHypQueue.addElement(new BoatHypo(this.currentBoatHyp.getCell((int)i).x, this.currentBoatHyp.getCell((int)i).y, true, true));
                    ++i;
                }
                this.currentBoatHyp = null;
            }
        }
        if (this.currentBoatHyp == null && !this.boatHypQueue.isEmpty()) {
            this.currentBoatHyp = (BoatHypo)this.boatHypQueue.elementAt(this.boatHypQueue.size() - 1);
            this.boatHypQueue.removeElementAt(this.boatHypQueue.size() - 1);
        }
        if (this.currentBoatHyp == null) {
            int cellY;
            int cellX;
            while (this.getCellStatus(cellX = this.rand.nextInt(this.cols), cellY = this.rand.nextInt(this.rows)) != 0 && this.getCellStatus(cellX, cellY) != 1) {
            }
            this.lastCpuHit = new MEPoint(cellX, cellY);
        } else {
            do {
                this.lastCpuHit = this.currentBoatHyp.getNextHit();
            } while (this.lastCpuHit.x < 0 || this.lastCpuHit.x >= this.cols || this.lastCpuHit.y < 0 || this.lastCpuHit.y >= this.rows || this.getCellStatus(this.lastCpuHit.x, this.lastCpuHit.y) != 1 && this.getCellStatus(this.lastCpuHit.x, this.lastCpuHit.y) != 0);
        }
        return this.lastCpuHit;
    }

    public int getEnemyBoatX(int i) {
        return this.enemyBoats[i].getX();
    }

    public int getEnemyBoatY(int i) {
        return this.enemyBoats[i].getY();
    }

    public boolean getEnemyBoatVertical(int i) {
        return this.enemyBoats[i].vertical;
    }

    public int getBoatX(int i) {
        return this.boats[i].getX();
    }

    public int getBoatY(int i) {
        return this.boats[i].getY();
    }

    public boolean getBoatVertical(int i) {
        return this.boats[i].vertical;
    }

    public void setPlayerTotalBoat(int tot) {
        this.playerTotalBoat = tot;
    }

    public int getPlayerTotalBoat() {
        return this.playerTotalBoat;
    }

    public void setEnemyTotalBoat(int tot) {
        this.enemyTotalBoat = tot;
    }

    public int getEnemyTotalBoat() {
        return this.enemyTotalBoat;
    }

    public boolean isSunk(int i) {
        return this.boats[i].isSunk();
    }

    public boolean enemyIsSunk(int i) {
        return this.enemyBoats[i].isSunk();
    }
}

