/*
 * Decompiled with CFR 0.152.
 */
package microengine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;
import microengine.MERenderableChar;

public class MEFont {
    private String fontName;
    private Image fontImage;
    private CharInfo[] fontInfo;
    private int fontHeight;

    public MEFont(String fontPath, String fontName) {
        this.fontName = fontName;
        try {
            this.fontImage = Image.createImage((String)(String.valueOf(fontPath) + fontName + ".png"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        InputStream is = this.getClass().getResourceAsStream(String.valueOf(fontPath) + fontName + ".txt");
        String fontsInfo = null;
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int read = is.read();
            while (read >= 0) {
                output.write(read);
                read = is.read();
            }
            byte[] buffer = output.toByteArray();
            is.close();
            output.close();
            fontsInfo = new String(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fontsInfo != null) {
            this.loadFontChars(fontsInfo);
            this.fontHeight = 0;
            int i = 0;
            while (i < this.fontInfo.length) {
                if (this.fontInfo[i].getInfo(3) > this.fontHeight) {
                    this.fontHeight = this.fontInfo[i].getInfo(3);
                }
                ++i;
            }
        }
    }

    private void loadFontChars(String fontsInfo) {
        int parsingState = 0;
        boolean tagIndex = false;
        String parsed = "";
        String charNumTag = "chars count=";
        int charNum = 0;
        int i = 0;
        while (i < fontsInfo.length()) {
            char c = fontsInfo.charAt(i);
            if (parsingState < charNumTag.length()) {
                if (charNumTag.charAt(parsingState) == fontsInfo.charAt(i)) {
                    parsed = String.valueOf(parsed) + fontsInfo.charAt(i);
                    if (++parsingState == charNumTag.length()) {
                        String charNumValue = "";
                        int index = 1;
                        while (fontsInfo.charAt(i + index) != '\n') {
                            charNumValue = String.valueOf(charNumValue) + fontsInfo.charAt(i + index);
                            ++index;
                        }
                        charNum = Integer.parseInt(charNumValue);
                        parsingState = i += index;
                        break;
                    }
                } else {
                    parsed = "";
                    parsingState = 0;
                }
            }
            ++i;
        }
        this.fontInfo = new CharInfo[charNum];
        int infoIndex = 0;
        int matchIndex = 0;
        String charParsed = "";
        String charTag = "char id=";
        int i2 = 0;
        while (i2 < fontsInfo.length()) {
            if (matchIndex < charTag.length() && charTag.charAt(matchIndex) == fontsInfo.charAt(i2)) {
                charParsed = String.valueOf(charParsed) + charTag.charAt(matchIndex);
                if (++matchIndex == charTag.length()) {
                    i2 += this.parseChar(fontsInfo, i2, infoIndex);
                    --i2;
                    ++infoIndex;
                    matchIndex = 0;
                    charParsed = "";
                }
            } else {
                matchIndex = 0;
                charParsed = "";
            }
            ++i2;
        }
    }

    private int parseChar(String fontsInfo, int fontIndex, int infoIndex) {
        String[] tags = new String[]{"x=", "y=", "width=", "height=", "xoffset=", "yoffset=", "xadvance=", "letter=\""};
        boolean tagIndex = false;
        String parsedValue = "";
        int index = 1;
        while (fontsInfo.charAt(fontIndex + index) != ' ') {
            parsedValue = String.valueOf(parsedValue) + fontsInfo.charAt(fontIndex + index);
            ++index;
        }
        this.fontInfo[infoIndex] = new CharInfo(Integer.parseInt(parsedValue));
        parsedValue = "";
        int matchIndex = 0;
        String nextTag = "";
        boolean tagParsed = false;
        int i = 0;
        while (i < tags.length) {
            nextTag = tags[i];
            tagParsed = false;
            while (fontIndex + index < fontsInfo.length() && !tagParsed) {
                if (matchIndex < nextTag.length() && nextTag.charAt(matchIndex) == fontsInfo.charAt(fontIndex + index)) {
                    if (++matchIndex == nextTag.length()) {
                        ++index;
                        while (fontIndex + index < fontsInfo.length() && fontsInfo.charAt(fontIndex + index) != ' ' && fontsInfo.charAt(fontIndex + index) != '\n') {
                            parsedValue = String.valueOf(parsedValue) + fontsInfo.charAt(fontIndex + index);
                            ++index;
                        }
                        this.fontInfo[infoIndex].setNextValue(parsedValue);
                        parsedValue = "";
                        matchIndex = 0;
                        tagParsed = true;
                    }
                } else {
                    matchIndex = 0;
                }
                ++index;
            }
            ++i;
        }
        return index;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public MERenderableChar getRenderableChar(char c) {
        if (c == '\n') {
            return new MERenderableChar(' ', this.fontImage, new int[7]);
        }
        int i = 0;
        while (i < this.fontInfo.length) {
            if (this.fontInfo[i].getID() == c) {
                CharInfo info = this.fontInfo[i];
                int[] charInfo = new int[7];
                int j = 0;
                while (j < charInfo.length) {
                    charInfo[j] = info.getInfo(j);
                    ++j;
                }
                return new MERenderableChar(c, this.fontImage, charInfo);
            }
            ++i;
        }
        return null;
    }

    private class CharInfo {
        public int id;
        private char letter;
        private int[] arrayInfo;
        private int arrayIndex;

        public CharInfo(int id) {
            this.id = id;
            this.arrayInfo = new int[7];
            this.arrayIndex = 0;
        }

        public void setNextValue(String value) {
            if (this.arrayIndex < this.arrayInfo.length) {
                this.arrayInfo[this.arrayIndex] = Integer.parseInt(value);
                ++this.arrayIndex;
            } else if (this.arrayIndex == this.arrayInfo.length && value.length() > 0) {
                this.letter = value.equals("space\"") ? (char)32 : value.charAt(0);
            }
        }

        public char getLetter() {
            return this.letter;
        }

        public int getID() {
            return this.id;
        }

        public int getInfo(int infoIndex) {
            if (infoIndex > this.arrayInfo.length || infoIndex < 0) {
                return -1;
            }
            return this.arrayInfo[infoIndex];
        }
    }
}

