/*
 * Decompiled with CFR 0.152.
 */
package microengine.elements;

import javax.microedition.lcdui.Graphics;
import microengine.MEObject;
import microengine.elements.MENode;
import microengine.inputEvents.MEInputEvent;
import microengine.utils.MEPoint;

public class MEAnimation
extends MEObject {
    protected MEPoint[] points;
    protected int[] milliseconds;
    protected int totPoint;
    protected boolean played = false;
    protected boolean paused = false;
    protected MENode target;
    int index = 0;
    long millisecondsCount = 0L;

    public MEAnimation(MENode target, MEPoint[] points, int[] milliseconds) {
        this.points = points;
        this.target = target;
        this.totPoint = points.length;
        this.milliseconds = new int[this.totPoint];
        int i = 0;
        while (i < this.totPoint) {
            this.milliseconds[i] = i < milliseconds.length ? milliseconds[i] : 0;
            ++i;
        }
    }

    public MEAnimation(MEObject target, MEPoint[] points, int millisecond) {
        this.points = points;
        this.totPoint = points.length;
        this.milliseconds = new int[this.totPoint];
        int i = 0;
        while (i < this.totPoint) {
            this.milliseconds[i] = millisecond;
            ++i;
        }
    }

    public void render(Graphics renderer) {
    }

    public void update(float interpolation, MEInputEvent[] inputEvents) {
        if (!this.played) {
            return;
        }
        this.millisecondsCount += (long)interpolation;
    }

    public void stop() {
        this.played = false;
        this.index = 0;
        this.millisecondsCount = 0L;
    }

    public void pause() {
        if (this.played) {
            this.played = false;
            this.paused = true;
        }
    }

    public void start() {
        this.played = true;
        this.paused = false;
        this.index = 0;
        this.millisecondsCount = 0L;
    }

    public void resume() {
        if (this.paused) {
            this.paused = false;
            this.played = true;
        }
    }
}

