/*
 * Decompiled with CFR 0.152.
 */
package microengine.utils;

import microengine.utils.MEPoint;
import microengine.utils.MESize;

public class MEBoundingRect {
    private MEPoint origin;
    private MESize size;

    public MEBoundingRect(int originX, int originY, int width, int height) {
        this(new MEPoint(originX, originY), new MESize(width, height));
    }

    public MEBoundingRect(MEPoint origin, MESize size) {
        this(origin, size, false);
    }

    public MEBoundingRect(MEPoint origin, MESize size, boolean shared) {
        if (shared) {
            this.origin = origin;
            this.size = size;
        } else {
            this.origin = origin.clone();
            this.size = size.clone();
        }
    }

    public MEBoundingRect() {
        this(0, 0, 0, 0);
    }

    public void setOrigin(MEPoint origin) {
        this.origin = origin.clone();
    }

    public void setSharedOrigin(MEPoint origin) {
        this.origin = origin;
    }

    public void setSize(MESize size) {
        this.size = size.clone();
    }

    public void setSharedSize(MESize size) {
        this.size = size;
    }

    public MEPoint getOrigin() {
        return this.origin.clone();
    }

    public MESize getSize() {
        return this.size.clone();
    }

    public boolean isPointIn(MEPoint point) {
        return point.x > this.origin.x && point.y > this.origin.y && point.x < this.origin.x + this.size.width && point.y < this.origin.y + this.size.height;
    }

    public String toString() {
        return " { " + this.origin.toString() + " | " + this.size.toString() + " }";
    }
}

