/*
 * Decompiled with CFR 0.152.
 */
package nodes;

import java.io.IOException;
import javax.microedition.lcdui.Image;
import microengine.elements.MEFocusable;
import microengine.inputEvents.MEInputEvent;
import microengine.inputEvents.MEKeyboardEvent;
import microengine.inputEvents.METouchEvent;
import microengine.utils.MEPoint;
import nodes.ImageNode;
import nodes.Listener;

public class ButtonNode
extends ImageNode
implements MEFocusable {
    protected boolean selected = false;
    protected Image imageOn;
    protected Image imageOff;
    protected String pathOn;
    protected String pathOff;
    protected Listener listener;
    protected int lastKey;
    protected boolean wannaFocus = false;
    protected MEPoint touchPosition;
    protected int touchType;
    int otherCode = -1;

    public ButtonNode(String path, Listener listener, int otherCode) {
        super(String.valueOf(path) + "OFF.png", true);
        this.listener = listener;
        this.pathOn = String.valueOf(path) + "ON.png";
        this.pathOff = String.valueOf(path) + "OFF.png";
        this.imageOff = this.image;
        this.lastKey = 0;
        try {
            this.imageOn = Image.createImage((String)this.pathOn);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.image = null;
        }
        this.otherCode = otherCode;
    }

    public ButtonNode(String path, Listener listener) {
        super(String.valueOf(path) + "OFF.png", true);
        this.listener = listener;
        this.pathOn = String.valueOf(path) + "ON.png";
        this.pathOff = String.valueOf(path) + "OFF.png";
        this.imageOff = this.image;
        this.lastKey = 0;
        try {
            this.imageOn = Image.createImage((String)this.pathOn);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.image = null;
        }
    }

    public ButtonNode(String path, Listener listener, boolean noSelectedImage) {
        super(String.valueOf(path) + "OFF.png", true);
        if (!noSelectedImage) {
            this.listener = listener;
            this.pathOn = String.valueOf(path) + "ON.png";
            this.pathOff = String.valueOf(path) + "OFF.png";
            this.imageOff = this.image;
            this.lastKey = 0;
            try {
                this.imageOn = Image.createImage((String)this.pathOn);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.imageOn = null;
            }
        } else {
            this.listener = listener;
            this.pathOn = String.valueOf(path) + "OFF.png";
            this.pathOff = String.valueOf(path) + "OFF.png";
            this.imageOff = this.image;
            this.lastKey = 0;
            this.imageOn = this.image;
        }
    }

    protected void onUpdate(float interpolation, MEInputEvent[] inputEvents) {
        if (!this.visible) {
            return;
        }
        if (this.selected && this.imageOn != null) {
            this.image = this.imageOn;
            this.imagePath = this.pathOn;
        } else {
            this.image = this.imageOff;
            this.imagePath = this.pathOff;
        }
        int i = 0;
        while (i < inputEvents.length) {
            if (inputEvents[i].getEventType() == 1 && !inputEvents[i].isConsumed()) {
                int key = ((MEKeyboardEvent)inputEvents[i]).getKeyValues();
                if (key == 0 && this.lastKey == 256 && this.selected) {
                    this.lastKey = 0;
                    inputEvents[i].markAsConsumed();
                    this.listener.onEvent(this);
                }
                if (key == 0 && this.lastKey == this.otherCode) {
                    this.lastKey = 0;
                    inputEvents[i].markAsConsumed();
                    this.listener.onEvent(this);
                }
                this.lastKey = key;
            }
            if (inputEvents[i].getEventType() == 2 && !inputEvents[i].isConsumed()) {
                this.touchType = ((METouchEvent)inputEvents[i]).getTouchType();
                this.touchPosition = ((METouchEvent)inputEvents[i]).getTouchPosition();
                System.out.println("What?");
                if (this.getBoundingRect().isPointIn(this.touchPosition)) {
                    if (this.touchType == 1) {
                        this.wannaFocus = true;
                        inputEvents[i].markAsConsumed();
                    }
                    if (this.touchType == 3 && this.selected) {
                        this.listener.onEvent(this);
                        inputEvents[i].markAsConsumed();
                        this.lastKey = 0;
                    }
                }
            }
            ++i;
        }
        super.onUpdate(interpolation, inputEvents);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public boolean setImageAndReload(String path) {
        super.setImageAndReload(path);
        this.imageOff = this.image;
        return true;
    }

    public boolean getWannaFocus() {
        return this.wannaFocus;
    }

    public void setWannaFocus(boolean wannaFocus) {
        this.wannaFocus = wannaFocus;
    }
}

