/*
 * Decompiled with CFR 0.152.
 */
package nodes;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import microengine.elements.MENode;
import microengine.utils.MESize;

public class ImageNode
extends MENode {
    protected Image image;
    protected String imagePath;
    protected int anchor;

    public ImageNode(String imagePath, boolean load) {
        this.imagePath = imagePath;
        if (load) {
            try {
                this.image = Image.createImage((String)imagePath);
                this.boundingRect.setSize(new MESize(this.image.getWidth(), this.image.getHeight()));
            }
            catch (IOException e) {
                e.printStackTrace();
                this.image = null;
            }
        }
        this.anchor = 20;
    }

    public boolean load() {
        try {
            this.image = Image.createImage((String)this.imagePath);
            this.boundingRect.setSize(new MESize(this.image.getWidth(), this.image.getHeight()));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.image = null;
            return false;
        }
        return true;
    }

    public boolean setImageAndReload(String imagePath) {
        this.imagePath = imagePath;
        try {
            this.image = Image.createImage((String)imagePath);
            this.boundingRect.setSize(new MESize(this.image.getWidth(), this.image.getHeight()));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.image = null;
            return false;
        }
        return true;
    }

    public void setAnchor(int anchor) {
        this.anchor = anchor;
    }

    protected void onRender(Graphics renderer) {
        if (this.image != null) {
            renderer.drawImage(this.image, 0, 0, this.anchor);
        }
    }
}

