/*
 * Decompiled with CFR 0.152.
 */
package nodes;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import microengine.elements.MENode;

public class SpriteNode
extends MENode {
    private Sprite sprite;
    private int frameNum;

    public SpriteNode(String spritePath, int spriteFrameNum, int verse) {
        try {
            this.frameNum = spriteFrameNum;
            Image spriteImage = Image.createImage((String)spritePath);
            int frameHeight = (verse & 1) == 1 ? spriteImage.getHeight() / this.frameNum : spriteImage.getHeight();
            int frameWidth = (verse & 2) == 2 ? spriteImage.getWidth() / this.frameNum : spriteImage.getWidth();
            this.sprite = new Sprite(spriteImage, frameWidth, frameHeight);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sprite = null;
            this.frameNum = 0;
        }
    }

    public void setSpriteFrame(int spriteFrameId) {
        if (spriteFrameId >= this.frameNum) {
            return;
        }
        this.sprite.setFrame(spriteFrameId);
    }

    protected void onRender(Graphics renderer) {
        if (this.sprite != null) {
            this.sprite.paint(renderer);
        }
    }
}

