/*
 * Decompiled with CFR 0.152.
 */
package elventales.avoider.window.title;

import elventales.avoider.Stage;
import elventales.avoider.util.KeyTranslator;
import elventales.avoider.util.PlayerData;
import elventales.avoider.window.Window;
import elventales.avoider.window.component.ButtonBackground;
import elventales.avoider.window.component.LeftButton;
import elventales.avoider.window.component.MiddleButton;
import elventales.avoider.window.component.RightButton;
import elventales.avoider.window.component.TitleBackground;
import elventales.hsalf.display.DisplayObject;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Option
extends Window {
    public boolean isReset = false;
    Sprite sound;
    DisplayObject soundOption;
    DisplayObject cursor;
    DisplayObject option;
    DisplayObject reset;
    RightButton back;
    RightButton no;
    LeftButton yes;
    MiddleButton select;

    public void initialize() {
        try {
            this.sound = new Sprite(Image.createImage((String)"/title/option-sound.png"), 240, 30);
            this.cursor = new DisplayObject(Image.createImage((String)"/splashconfirm/confirm-cursor.png"), 0, 0);
            this.option = new DisplayObject(Image.createImage((String)"/title/option.png"), Stage.Width / 2 - 120, Stage.Height / 2 - 120);
            this.reset = new DisplayObject(Image.createImage((String)"/title/reset-data.png"), Stage.Width / 2 - 120, Stage.Height / 2 - 120);
            this.soundOption = new DisplayObject(this.sound, Stage.Width / 2 - 120, this.option.y + 50);
            this.back = new RightButton(false);
            this.no = new RightButton(true);
            this.yes = new LeftButton(true);
            this.select = new MiddleButton();
            this.addChild(new TitleBackground());
            this.addChild(new DisplayObject(Image.createImage((String)"/title/transparentbg.png"), Stage.Width / 2 - 120, Stage.Height / 2 - 120));
            this.addChild(this.option);
            this.addChild(this.reset);
            this.addChild(this.cursor);
            this.addChild(this.soundOption);
            this.addChild(new ButtonBackground());
            this.addChild(this.back);
            this.addChild(this.no);
            this.addChild(this.yes);
            this.addChild(this.select);
            this.showOption();
            this.cursor.y = this.option.y + 50;
            if (Stage.isEnableSound) {
                this.sound.setFrame(0);
            } else {
                this.sound.setFrame(1);
            }
        }
        catch (IOException ex) {
            System.out.println("Option Initialize IOException :" + ex.getMessage());
        }
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == 51 || keyCode == -7) {
            Stage.soundUtil.play(1);
            if (this.isReset) {
                this.showOption();
                this.isReset = false;
            } else {
                this.parent.removeDisplay(this);
            }
        } else if (keyCode == 49 || keyCode == -6) {
            Stage.soundUtil.play(1);
            if (this.isReset) {
                this.isReset = false;
                this.showOption();
                PlayerData.getInstance().Load();
                PlayerData.getInstance().resetData();
                PlayerData.getInstance().Save();
            }
        } else if (KeyTranslator.getKeyAction(keyCode) == 8 || keyCode == 53) {
            Stage.soundUtil.play(1);
            if (this.cursor.y == this.option.y + 50) {
                if (Stage.isEnableSound) {
                    Stage.isEnableSound = false;
                    this.sound.setFrame(1);
                } else {
                    Stage.isEnableSound = true;
                    this.sound.setFrame(0);
                }
            } else if (this.cursor.y == this.option.y + 90) {
                this.showReset();
                this.isReset = true;
            }
        } else if (KeyTranslator.getKeyAction(keyCode) == 1 || keyCode == 50) {
            Stage.soundUtil.play(1);
            this.cursor.y = this.option.y + 50;
        } else if (KeyTranslator.getKeyAction(keyCode) == 6 || keyCode == 56) {
            Stage.soundUtil.play(1);
            this.cursor.y = this.option.y + 90;
        }
        super.keyPressed(keyCode);
    }

    private void showOption() {
        this.reset.visible = false;
        this.yes.visible = false;
        this.no.visible = false;
        this.soundOption.visible = true;
        this.cursor.visible = true;
        this.option.visible = true;
        this.back.visible = true;
        this.select.visible = true;
    }

    private void showReset() {
        this.reset.visible = true;
        this.yes.visible = true;
        this.no.visible = true;
        this.soundOption.visible = false;
        this.cursor.visible = false;
        this.option.visible = false;
        this.back.visible = false;
        this.select.visible = false;
    }
}

