/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia;

import Snakedelia.BasicCanvas;
import Snakedelia.GameManager;
import Snakedelia.tools.IUpdatable;
import Snakedelia.tools.IntHashtable;
import java.util.Enumeration;
import java.util.Vector;

public final class ApproachEventHandler
implements IUpdatable {
    private static final int NO_APPROACH = 0;
    private static final int APPROACH_START = 1;
    private static final int APPROACH_OCCURING = 2;
    private static final int APPROACH_END = 3;
    private static ApproachEventHandler mInstance = null;
    private GameManager myManager;
    private BasicCanvas myCanvas;
    private static IntHashtable myApproaches;
    private static Vector myChanges;
    private static Vector myEntriesToRemove;
    private static int myTotalTimeElapsed;
    private static final int DISTANCE_INTERVAL_CONST = 100;

    public ApproachEventHandler(BasicCanvas basicCanvas, GameManager gameManager) {
        this.myManager = gameManager;
        this.myCanvas = basicCanvas;
        myApproaches = new IntHashtable();
        myChanges = new Vector();
        myEntriesToRemove = new Vector();
        if (mInstance != null) {
            throw new RuntimeException("Only one instance is allowed");
        }
        mInstance = this;
    }

    public void update(long l) {
        myTotalTimeElapsed = (int)((long)myTotalTimeElapsed + l);
        ApproachEventHandler.cleanCache();
        ApproachEventHandler.applyChanges();
    }

    public static final void cleanCache() {
        if (myEntriesToRemove.size() == 0) {
            return;
        }
        Enumeration enumeration = myEntriesToRemove.elements();
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            myApproaches.remove(n);
        }
        myEntriesToRemove.removeAllElements();
    }

    private static void applyChanges() {
        Enumeration enumeration = myChanges.elements();
        while (enumeration.hasMoreElements()) {
            TestEntry[] testEntryArray;
            AddRemoveEntry addRemoveEntry = (AddRemoveEntry)enumeration.nextElement();
            if (!myApproaches.containsKey(addRemoveEntry.hash)) {
                if (addRemoveEntry.remove) continue;
                testEntryArray = new TestEntry[4];
            } else {
                testEntryArray = (TestEntry[])myApproaches.get(addRemoveEntry.hash);
            }
            TestEntry[] testEntryArray2 = addRemoveEntry.remove ? ApproachEventHandler.removeApproach(testEntryArray, addRemoveEntry.testIndex) : ApproachEventHandler.addApproach(testEntryArray, addRemoveEntry.testIndex);
            myApproaches.put(addRemoveEntry.hash, testEntryArray2);
        }
        myChanges.removeAllElements();
    }

    public void removeSprite(int n) {
        IntHashtable.IntHashtableEnumerator intHashtableEnumerator = myApproaches.keys();
        while (intHashtableEnumerator.hasMoreElements()) {
            int n2 = (Integer)intHashtableEnumerator.nextElement();
            if (ApproachEventHandler.hashToFirstSprite(n2) != n && ApproachEventHandler.hashToSecondSprite(n2) != n) continue;
            myEntriesToRemove.addElement(new Integer(n2));
        }
    }

    private static int hashToFirstSprite(int n) {
        return n >> 16;
    }

    private static int hashToSecondSprite(int n) {
        return n & 0xFFFF;
    }

    private static int hashTwoSprites(int n, int n2) {
        int n3 = Math.max(n, n2);
        int n4 = Math.min(n, n2);
        return (n3 << 0) + (n4 << 16);
    }

    private static int getApproachState(GameManager gameManager, int n, int n2, int n3, int n4, int n5) {
        int n6 = ApproachEventHandler.hashTwoSprites(n, n2);
        boolean bl = ApproachEventHandler.checkCurrentApproach(gameManager, n, n2, n3, n4, n5);
        int n7 = ApproachEventHandler.checkPreviousApproach(n6, n5);
        if (n7 != -1) {
            if (bl) {
                if (myTotalTimeElapsed - n7 >= 100) {
                    n7 += 100;
                    return 2;
                }
                return 0;
            }
            ApproachEventHandler.removeOnNextIteration(n6, n5);
            return 3;
        }
        if (bl) {
            ApproachEventHandler.addOnNextIteration(n6, n5);
            return 1;
        }
        return 0;
    }

    private static void addOnNextIteration(int n, int n2) {
        myChanges.addElement(new AddRemoveEntry(n, n2, false));
    }

    private static void removeOnNextIteration(int n, int n2) {
        myChanges.addElement(new AddRemoveEntry(n, n2, true));
    }

    private static TestEntry[] addApproach(TestEntry[] testEntryArray, int n) {
        for (int i = 0; i < testEntryArray.length; ++i) {
            if (testEntryArray[i] != null) continue;
            testEntryArray[i] = new TestEntry(n, myTotalTimeElapsed);
            return testEntryArray;
        }
        TestEntry[] testEntryArray2 = new TestEntry[Math.max(1, testEntryArray.length) * 2];
        System.arraycopy(testEntryArray, 0, testEntryArray2, 0, testEntryArray.length);
        testEntryArray2[testEntryArray.length] = new TestEntry(n, myTotalTimeElapsed);
        return testEntryArray2;
    }

    private static TestEntry[] removeApproach(TestEntry[] testEntryArray, int n) {
        for (int i = 0; i < testEntryArray.length; ++i) {
            if (testEntryArray[i] == null || testEntryArray[i].TestId != n) continue;
            testEntryArray[i] = null;
        }
        return testEntryArray;
    }

    private static int checkPreviousApproach(int n, int n2) {
        if (!myApproaches.containsKey(n)) {
            return -1;
        }
        TestEntry[] testEntryArray = (TestEntry[])myApproaches.get(n);
        for (int i = 0; i < testEntryArray.length; ++i) {
            if (testEntryArray[i] == null || testEntryArray[i].TestId != n2) continue;
            return testEntryArray[i].LastUpdate;
        }
        return -1;
    }

    private static boolean checkCurrentApproach(GameManager gameManager, int n, int n2, int n3, int n4, int n5) {
        if (n == n2 || gameManager.getSprite((int)n).isDying || gameManager.getSprite((int)n2).isDying) {
            return false;
        }
        return false;
    }

    public static ApproachEventHandler getInstance() {
        return mInstance;
    }

    public final void clearState() {
        if (myApproaches != null) {
            myApproaches.clear();
        }
        if (myEntriesToRemove != null) {
            myEntriesToRemove.removeAllElements();
        }
        if (myChanges != null) {
            myChanges.removeAllElements();
        }
    }

    static {
        myTotalTimeElapsed = 0;
    }

    private static class TestEntry {
        public int TestId;
        public int LastUpdate;

        public TestEntry(int n, int n2) {
            this.TestId = n;
            this.LastUpdate = n2;
        }
    }

    private static class AddRemoveEntry {
        public int hash;
        public int testIndex;
        public boolean remove;

        public AddRemoveEntry(int n, int n2, boolean bl) {
            this.hash = n;
            this.testIndex = n2;
            this.remove = bl;
        }
    }
}

