/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.menus;

import Snakedelia.AbstractCanvas;
import Snakedelia.menus.BasicScreen;
import Snakedelia.menus.MenuItem;
import Snakedelia.tools.GraphicFont;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class BasicMenu
extends BasicScreen {
    public static final int LAYOUT_TOP = 1;
    public static final int LAYOUT_CENTER = 2;
    public static final int LAYOUT_BOTTOM = 3;
    public static final int MULTIPLE_DISPLAY = 1;
    public static final int SINGLE_DISPLAY = 2;
    private final int ITEM_GAP;
    private final int MENU_BORDER_HEIGHT;
    private Vector myMenuItems;
    private int currentIndex;
    private int myLayout;
    private int numSelectable;
    private int myDisplayMode;
    private String mTitle;

    public BasicMenu(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, AbstractCanvas abstractCanvas, GraphicFont graphicFont, String string) {
        super(n, n2, n3, n4, bl, abstractCanvas, graphicFont);
        this.ITEM_GAP = this.myFont.getHeight() / 3;
        this.MENU_BORDER_HEIGHT = this.ITEM_GAP * 2;
        this.myMenuItems = new Vector();
        this.currentIndex = 0;
        this.myLayout = n5;
        this.myDisplayMode = n6;
        this.mTitle = string;
    }

    public void removeItem(MenuItem menuItem) {
        if (this.myMenuItems.contains(menuItem)) {
            this.changeHoveredItem(-1);
            this.myMenuItems.removeElement(menuItem);
            if (menuItem.isSelectable()) {
                --this.numSelectable;
            }
        }
    }

    public void appendItem(MenuItem menuItem) {
        this.myMenuItems.addElement(menuItem);
        if (menuItem.isSelectable()) {
            ++this.numSelectable;
            if (this.numSelectable == 1) {
                menuItem.onHover();
            }
        }
    }

    public MenuItem getHoveredItem() {
        if (this.numSelectable <= 0) {
            return null;
        }
        return (MenuItem)this.myMenuItems.elementAt(this.currentIndex);
    }

    protected void handleKeyState(int n) {
        if ((n & 2) != 0) {
            this.changeHoveredItem(-1);
        } else if ((n & 0x40) != 0) {
            this.changeHoveredItem(1);
        } else {
            MenuItem menuItem = this.getHoveredItem();
            if (menuItem != null) {
                menuItem.handleClick(n);
            }
        }
    }

    private void changeHoveredItem(int n) {
        int n2 = this.getNextSelectable(this.currentIndex, n);
        if (n2 != this.currentIndex && n2 != -1) {
            this.getHoveredItem().onHoverEnded();
            this.currentIndex = n2;
            this.getHoveredItem().onHover();
        }
    }

    public void paint(Graphics graphics) {
        Object object;
        super.paint(graphics);
        if (this.mTitle != null) {
            this.myFont.draw(graphics, this.mTitle, this.getX() + this.getWidth() / 2, this.getY() + this.MENU_BORDER_HEIGHT, this.getWidth(), this.getHeight(), 1, true);
        }
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.setClip(this.getX() + 0, this.getY() + this.ITEM_GAP + 0, this.getWidth(), this.getHeight() - this.ITEM_GAP);
        int n5 = 0;
        if (this.myDisplayMode == 1) {
            Enumeration enumeration = this.myMenuItems.elements();
            while (enumeration.hasMoreElements()) {
                object = (MenuItem)enumeration.nextElement();
                if (n5 != 0) {
                    n5 += this.ITEM_GAP;
                }
                n5 += ((MenuItem)object).getHeight(this.getWidth());
            }
        } else {
            n5 = this.getHoveredItem() != null ? this.getHoveredItem().getHeight(this.getWidth()) + this.ITEM_GAP : 0;
        }
        int n6 = 0;
        switch (this.myLayout) {
            case 3: {
                n6 = this.getY() + this.getHeight() - n5;
                break;
            }
            case 2: {
                n6 = this.getY() + (this.getHeight() - n5) / 2;
                break;
            }
            case 1: {
                n6 = this.getY();
            }
        }
        if (this.myDisplayMode == 1) {
            object = this.myMenuItems.elements();
            while (object.hasMoreElements()) {
                MenuItem menuItem = (MenuItem)object.nextElement();
                n6 = this.drawSingleItem(graphics, n6, menuItem);
            }
        } else if (null != this.getHoveredItem()) {
            this.drawSingleItem(graphics, n6, this.getHoveredItem());
        }
        graphics.setClip(n, n2, n3, n4);
    }

    private int drawSingleItem(Graphics graphics, int n, MenuItem menuItem) {
        menuItem.paint(graphics, this.getX(), n, this.getWidth());
        switch (this.myLayout) {
            case 3: {
                n -= menuItem.getHeight(this.getWidth());
                n = this.ITEM_GAP;
                break;
            }
            default: {
                n += menuItem.getHeight(this.getWidth());
                n += this.ITEM_GAP;
            }
        }
        return n;
    }

    private int getNextSelectable(int n, int n2) {
        if (this.numSelectable == 0) {
            return -1;
        }
        for (int i = n + n2; i != n; i += n2) {
            if (i > this.myMenuItems.size() - 1 || i < 0) {
                int n3 = i = i < 0 ? this.myMenuItems.size() - 1 : 0;
            }
            if (!((MenuItem)this.myMenuItems.elementAt(i)).isSelectable()) continue;
            return i;
        }
        if (!((MenuItem)this.myMenuItems.elementAt(n)).isSelectable()) {
            return -1;
        }
        return n;
    }

    public void doLogic(long l) {
    }
}

