/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.menus;

import Snakedelia.menus.MenuItem;
import Snakedelia.tools.GraphicFont;
import java.util.Enumeration;
import java.util.Vector;

public class ChoiceGroup
extends MenuItem {
    Vector myChoices = new Vector();
    int currentIndex;

    public ChoiceGroup(String string, int n, GraphicFont graphicFont, GraphicFont graphicFont2) {
        super(string, n, true, graphicFont, graphicFont2);
    }

    public void append(String string) {
        if (!this.myChoices.contains(string)) {
            this.myChoices.addElement(string);
        }
    }

    public void remove(String string) {
        if (this.myChoices.contains(string)) {
            this.myChoices.removeElement(string);
        }
    }

    public void clean() {
        this.myChoices.removeAllElements();
    }

    public Enumeration choices() {
        return this.myChoices.elements();
    }

    public String getSelected() {
        if (this.myChoices.size() > 0) {
            return (String)this.myChoices.elementAt(this.currentIndex);
        }
        return null;
    }

    public void handleClick(int n) {
        if ((n & 0x100) != 0 || (n & 0x20) != 0) {
            this.moveForward();
        } else if ((n & 4) != 0) {
            this.moveBackward();
        }
        super.handleClick(n);
    }

    protected String getDisplayedLabel() {
        String string = this.getSelected();
        String string2 = this.getLabel() + ": ";
        if (null != string) {
            string2 = string2 + string;
        }
        return string2;
    }

    public void moveBackward() {
        this.setIndex(this.getIndex() - 1);
    }

    public void moveForward() {
        this.setIndex(this.getIndex() + 1);
    }

    public int getIndex() {
        return this.currentIndex;
    }

    public void setIndex(int n) {
        if (this.myChoices.size() > 0) {
            if (n < 0) {
                n = this.myChoices.size() - Math.abs(n);
            }
            this.currentIndex = n;
            this.currentIndex %= this.myChoices.size();
        } else {
            this.currentIndex = 0;
        }
    }
}

