/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.menus;

import Snakedelia.AbstractCanvas;
import Snakedelia.menus.BasicScreen;
import Snakedelia.tools.GraphicFont;
import javax.microedition.lcdui.Graphics;

public class ProgressBar
extends BasicScreen {
    private int myMinimum;
    private int myMaximum;
    private int myValue;
    private int myStep;
    private String myLabel;
    private final int BORDER_HEIGHT = this.getHeight() / 15;
    private final int PROGRESS_BAR_HEIGHT;
    private static final int foregroundColor = 0xFFFFFF;
    private static final int backgroundColor = 0x555555;
    private static final int fillColor = 0;

    public ProgressBar(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string, boolean bl, AbstractCanvas abstractCanvas, GraphicFont graphicFont) {
        this(n, n2, n3, n4, n5, n6, n7, n5, string, bl, abstractCanvas, graphicFont);
    }

    public ProgressBar(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string, boolean bl, AbstractCanvas abstractCanvas, GraphicFont graphicFont) {
        super(n, n2, n3, n4, bl, abstractCanvas, graphicFont);
        this.PROGRESS_BAR_HEIGHT = 3;
        this.myMaximum = n6;
        this.myMinimum = n5;
        this.myStep = n7;
        this.myLabel = string;
        this.myFont = graphicFont;
        this.setValue(n8);
        this.setFillColor(0);
        this.setShouldFillScreen(true);
    }

    public void performStep() {
        this.myValue += this.myStep;
        if (this.myValue + this.myStep > this.myMaximum) {
            this.myValue = this.myMaximum;
        }
    }

    public int getMinimum() {
        return this.myMinimum;
    }

    public int getMaximum() {
        return this.myMaximum;
    }

    public int getValue() {
        return this.myValue;
    }

    public int getStep() {
        return this.myStep;
    }

    public void setMinimum(int n) {
        this.validate(this.getValue(), n, this.getMaximum());
        this.myMinimum = n;
    }

    public void setMaximum(int n) {
        this.validate(this.getValue(), this.getMinimum(), n);
        this.myMaximum = n;
    }

    public void setStep(int n) {
        this.myStep = n;
    }

    public void setValue(int n) {
        this.validate(n, this.getMinimum(), this.getMaximum());
        this.myValue = n;
    }

    private void validate(int n, int n2, int n3) {
        if (n < n2 || n > n3 || n3 < n2) {
            throw new IllegalArgumentException("value has to be between the maximum and minimum values of the progress bar");
        }
    }

    public void doLogic(long l) {
    }

    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        super.paint(graphics);
        int n = this.getX() + (this.getWidth() - this.myFont.stringWidth(this.myLabel)) / 2;
        int n2 = this.getY() + this.getHeight() - (this.BORDER_HEIGHT + 6) - this.myFont.getHeight();
        int n3 = this.getY() + this.getHeight() - this.BORDER_HEIGHT;
        int n4 = this.myValue * this.getWidth() / this.myMaximum;
        this.myFont.draw(graphics, this.myLabel, n, n2);
        graphics.setColor(0x555555);
        graphics.fillRect(this.getX() + 0, n3 + 0, this.getWidth(), 3);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(this.getX() + 0, n3 + 0, n4, 3);
    }
}

