/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.tools.AnimationManager;
import Snakedelia.tools.CanvasManager;
import Snakedelia.tools.Defines;
import Snakedelia.tools.IUpdatable;
import Snakedelia.tools.MovableSprite;
import Snakedelia.tools.PhysicalSprite;

public final class BasicSprite
implements IUpdatable {
    public short[] myGroups;
    private int myUID;
    public PhysicalSprite myPhysicalSprite;
    public CanvasManager myCanvasManager;
    public MovableSprite myMovableSprite;
    public boolean isDying = false;

    public static BasicSprite CreateNonAnimatable(short[] sArray, short[] sArray2, short[] sArray3, short[] sArray4, short[] sArray5, int n, int n2, int n3, boolean bl) {
        BasicSprite basicSprite = new BasicSprite();
        basicSprite.myGroups = sArray;
        MovableSprite movableSprite = new MovableSprite(sArray2, sArray3, sArray4, sArray5);
        basicSprite.myPhysicalSprite = new PhysicalSprite(null, movableSprite, null, bl);
        basicSprite.myCanvasManager = null;
        basicSprite.myMovableSprite = movableSprite;
        basicSprite.myPhysicalSprite.setPositionPrecise(n, n2);
        basicSprite.myPhysicalSprite.setLogicalZ(n3);
        basicSprite.myPhysicalSprite.setVelocityX(0);
        basicSprite.myPhysicalSprite.setVelocityY(0);
        return basicSprite;
    }

    public static BasicSprite CreateAnimatable(short[] sArray, short[][] sArray2, short[][] sArray3, short[][] sArray4, short[][] sArray5, int n, int n2, int n3, int[][] nArray, int[] nArray2, int n4, int[] nArray3, boolean bl) {
        BasicSprite basicSprite = new BasicSprite();
        basicSprite.myGroups = sArray;
        MovableSprite movableSprite = new MovableSprite(sArray2, sArray3, sArray4, sArray5);
        AnimationManager animationManager = new AnimationManager(nArray, nArray2, basicSprite, movableSprite);
        CanvasManager canvasManager = null;
        canvasManager = nArray3 != null ? new CanvasManager(basicSprite, nArray3) : null;
        basicSprite.myPhysicalSprite = new PhysicalSprite(animationManager, movableSprite, canvasManager, bl);
        basicSprite.myPhysicalSprite.getAnimationManager().setFrameSequence(n4);
        basicSprite.myCanvasManager = canvasManager;
        basicSprite.myMovableSprite = movableSprite;
        basicSprite.myPhysicalSprite.setPositionPrecise(n, n2);
        basicSprite.myPhysicalSprite.setLogicalZ(n3);
        basicSprite.myPhysicalSprite.setVelocityX(0);
        basicSprite.myPhysicalSprite.setVelocityY(0);
        return basicSprite;
    }

    public static BasicSprite CreateController(short[] sArray) {
        BasicSprite basicSprite = new BasicSprite();
        basicSprite.myMovableSprite = null;
        basicSprite.myCanvasManager = null;
        basicSprite.myGroups = sArray;
        basicSprite.myPhysicalSprite = null;
        return basicSprite;
    }

    public static BasicSprite CreateOnlyCanvas(short[] sArray, int n, int n2, int n3, int n4, int n5, int[] nArray, boolean bl) {
        BasicSprite basicSprite = new BasicSprite();
        basicSprite.myGroups = sArray;
        CanvasManager canvasManager = new CanvasManager(basicSprite, nArray);
        basicSprite.myPhysicalSprite = new PhysicalSprite(n * Defines.PRECISION, n2 * Defines.PRECISION, canvasManager, bl);
        basicSprite.myMovableSprite = null;
        basicSprite.myCanvasManager = canvasManager;
        basicSprite.myPhysicalSprite.setPositionPrecise(n3, n4);
        basicSprite.myPhysicalSprite.setLogicalZ(n5);
        basicSprite.myPhysicalSprite.setVelocityX(0);
        basicSprite.myPhysicalSprite.setVelocityY(0);
        return basicSprite;
    }

    private BasicSprite() {
        this.setUID(++Defines.spriteCounter);
    }

    public final boolean isInGroup(short s) {
        for (int i = 0; i < this.myGroups.length; ++i) {
            if (this.myGroups[i] != s) continue;
            return true;
        }
        return false;
    }

    public final short[] getGroups() {
        return this.myGroups;
    }

    public final void update(long l) {
        if (this.myPhysicalSprite != null) {
            this.myPhysicalSprite.update(l);
        }
    }

    public final int getUID() {
        return this.myUID;
    }

    private final void setUID(int n) {
        this.myUID = n;
    }

    public final boolean isPhysical() {
        return this.myPhysicalSprite != null;
    }

    public boolean isAnimatable() {
        if (!this.isPhysical()) {
            return false;
        }
        return this.myPhysicalSprite.isAnimatable();
    }

    public void dispose() {
        if (this.isPhysical()) {
            this.myPhysicalSprite.dispose();
        }
    }
}

