/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.tools.BasicSprite;
import Snakedelia.tools.Defines;
import Snakedelia.tools.GraphicFont;
import Snakedelia.tools.PhysicalSprite;
import Snakedelia.tools.SuperMath;
import javax.microedition.lcdui.Graphics;

public final class CanvasManager {
    private int[][] m_shapes;
    private int[][] m_originalShapes;
    private int[][] m_outlineColors;
    private int[][] m_backgroundColors;
    private GraphicFont[] m_fonts;
    private String[] m_strings;
    private int[][] m_lines;
    private int[][] m_originalLines;
    private BasicSprite m_father;
    private boolean isFirstCoordinateBackup = true;
    private int myCurrentTransformation = 0;
    int mRotationPointX;
    int mRotationPointY;
    private static final int SHAPE_INDEX = 0;
    public static final int XPOS_INDEX = 1;
    public static final int YPOS_INDEX = 2;
    public static final int WIDTH_INDEX = 3;
    public static final int HEIGHT_INDEX = 4;
    public static final int OUTLINE_COLOR_INDEX = 5;
    private static final int POINTS_INDEX = 6;
    public static final int BACKGROUND_COLOR_INDEX = 6;
    public static final int ROUNDED_RECT_RADIUS_INDEX = 7;
    private static final int TEXT_FONT_INDEX = 7;
    private static final int TEXT_INDEX = 8;
    public static final int TEXT_ALIGNMENT_INDEX = 9;
    public static final int TEXT_WRAP_INDEX = 10;
    public static final int ELLIPSE = 0;
    public static final int RECTANGLE = 1;
    public static final int ROUNDED_RECTANGLE = 2;
    public static final int LINE = 3;
    public static final int TEXT_FRAME = 4;
    private static final int ELLIPSE_PARAMS_NUM = 7;
    private static final int RECTANGLE_PARAMS_NUM = 7;
    private static final int ROUNDED_RECTANGLE_PARAMS_NUM = 8;
    private static final int LINE_PARAMS_NUM = 7;
    private static final int TEXT_FRAME_PARAMS_NUM = 11;
    public static final int TRANSPARENT_COLOR = -1;

    public CanvasManager(BasicSprite basicSprite, int[] nArray) {
        this.m_father = basicSprite;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.m_shapes = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            switch (n4) {
                case 0: {
                    this.m_shapes[i] = new int[7];
                    break;
                }
                case 1: {
                    this.m_shapes[i] = new int[7];
                    break;
                }
                case 2: {
                    this.m_shapes[i] = new int[8];
                    break;
                }
                case 3: {
                    this.m_shapes[i] = new int[7];
                    break;
                }
                case 4: {
                    this.m_shapes[i] = new int[11];
                }
            }
            this.m_shapes[i][0] = n4;
            this.m_shapes[i][5] = i;
            this.m_shapes[i][6] = n4 != 3 ? n3++ : n++;
            if (n4 != 4) continue;
            this.m_shapes[i][7] = n2;
            this.m_shapes[i][8] = n2++;
        }
        this.m_outlineColors = new int[this.m_shapes.length][3];
        this.m_backgroundColors = new int[n3][3];
        this.m_fonts = new GraphicFont[n2];
        this.m_strings = new String[n2];
        this.m_lines = new int[n][];
    }

    public void drawCanvas(Graphics graphics) {
        if (this.m_shapes.length <= 0) {
            return;
        }
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipHeight();
        int n4 = graphics.getClipWidth();
        PhysicalSprite physicalSprite = this.m_father.myPhysicalSprite;
        for (int i = 0; i < this.m_shapes.length; ++i) {
            int[] nArray = this.m_shapes[i];
            graphics.clipRect(physicalSprite.getX() + 0, physicalSprite.getY() + 0, physicalSprite.getWidth(), physicalSprite.getHeight());
            graphics.clipRect(Defines.toScreenValueHorz(nArray[1]) + physicalSprite.getX() + 0, Defines.toScreenValueVert(nArray[2]) + physicalSprite.getY() + 0, Defines.toScreenValueHorz(nArray[3]) + (Defines.toScreenValueHorzRemainder(nArray[3]) != 0 ? 1 : 0), Defines.toScreenValueVert(nArray[4]) + (Defines.toScreenValueHorzRemainder(nArray[3]) != 0 ? 1 : 0));
            switch (nArray[0]) {
                case 0: {
                    this.drawElipse(graphics, nArray);
                    break;
                }
                case 1: {
                    this.drawRectangle(graphics, nArray);
                    break;
                }
                case 2: {
                    this.drawRoundedRectangle(graphics, nArray);
                    break;
                }
                case 3: {
                    this.drawLine(graphics, nArray);
                    break;
                }
                case 4: {
                    this.drawTextFrame(graphics, nArray);
                }
            }
            graphics.setClip(n, n2, n4, n3);
        }
    }

    private void drawElipse(Graphics graphics, int[] nArray) {
        int[] nArray2;
        int[] nArray3 = this.m_backgroundColors[nArray[6]];
        if (-1 != nArray3[0]) {
            graphics.setColor(nArray3[0], nArray3[1], nArray3[2]);
            graphics.fillArc(Defines.toScreenValueHorz(nArray[1]) + this.m_father.myPhysicalSprite.getX() + 0, Defines.toScreenValueVert(nArray[2]) + this.m_father.myPhysicalSprite.getY() + 0, Defines.toScreenValueHorz(nArray[3]) - 1, Defines.toScreenValueVert(nArray[4]) - 1, 0, 360);
        }
        if (-1 != (nArray2 = this.m_outlineColors[nArray[5]])[0]) {
            graphics.setColor(nArray2[0], nArray2[1], nArray2[2]);
            graphics.drawArc(Defines.toScreenValueHorz(nArray[1]) + this.m_father.myPhysicalSprite.getX() + 0, Defines.toScreenValueVert(nArray[2]) + this.m_father.myPhysicalSprite.getY() + 0, Defines.toScreenValueHorz(nArray[3]) - 1, Defines.toScreenValueVert(nArray[4]) - 1, 0, 360);
        }
    }

    private void drawRectangle(Graphics graphics, int[] nArray) {
        int[] nArray2;
        int[] nArray3 = this.m_backgroundColors[nArray[6]];
        if (-1 != nArray3[0]) {
            graphics.setColor(nArray3[0], nArray3[1], nArray3[2]);
            graphics.fillRect(Defines.toScreenValueHorz(nArray[1]) + this.m_father.myPhysicalSprite.getX() + 0, Defines.toScreenValueVert(nArray[2]) + this.m_father.myPhysicalSprite.getY() + 0, Defines.toScreenValueHorz(nArray[3]) - 1, Defines.toScreenValueVert(nArray[4]) - 1);
        }
        if (-1 != (nArray2 = this.m_outlineColors[nArray[5]])[0]) {
            graphics.setColor(nArray2[0], nArray2[1], nArray2[2]);
            int n = Defines.toScreenValueHorz(nArray[1]) + this.m_father.myPhysicalSprite.getX() + 0;
            int n2 = Defines.toScreenValueVert(nArray[2]) + this.m_father.myPhysicalSprite.getY() + 0;
            int n3 = Defines.toScreenValueHorz(nArray[3]) - 1;
            int n4 = Defines.toScreenValueVert(nArray[4]) - 1;
            graphics.drawRect(n, n2, n3, n4);
        }
    }

    private void drawRoundedRectangle(Graphics graphics, int[] nArray) {
        int[] nArray2;
        int[] nArray3 = this.m_backgroundColors[nArray[6]];
        if (-1 != nArray3[0]) {
            graphics.setColor(nArray3[0], nArray3[1], nArray3[2]);
            graphics.fillRoundRect(Defines.toScreenValueHorz(nArray[1]) + this.m_father.myPhysicalSprite.getX() + 0, Defines.toScreenValueVert(nArray[2]) + this.m_father.myPhysicalSprite.getY() + 0, Defines.toScreenValueHorz(nArray[3]) - 1, Defines.toScreenValueVert(nArray[4]) - 1, Defines.toScreenValueHorz(nArray[7] * 2), Defines.toScreenValueVert(nArray[7] * 2));
        }
        if (-1 != (nArray2 = this.m_outlineColors[nArray[5]])[0]) {
            graphics.setColor(nArray2[0], nArray2[1], nArray2[2]);
            graphics.drawRoundRect(Defines.toScreenValueHorz(nArray[1]) + this.m_father.myPhysicalSprite.getX() + 0, Defines.toScreenValueVert(nArray[2]) + this.m_father.myPhysicalSprite.getY() + 0, Defines.toScreenValueHorz(nArray[3]) - 1, Defines.toScreenValueVert(nArray[4]) - 1, Defines.toScreenValueHorz(nArray[7] * 2), Defines.toScreenValueVert(nArray[7] * 2));
        }
    }

    private void drawTextFrame(Graphics graphics, int[] nArray) {
        this.drawRectangle(graphics, nArray);
        this.m_fonts[nArray[7]].draw(graphics, this.m_strings[nArray[8]], Defines.toScreenValueHorz(nArray[1]) + this.m_father.myPhysicalSprite.getX(), Defines.toScreenValueVert(nArray[2]) + this.m_father.myPhysicalSprite.getY(), Defines.toScreenValueHorz(nArray[3]) + (Defines.toScreenValueHorzRemainder(nArray[3]) != 0 ? 1 : 0), Defines.toScreenValueVert(nArray[4]) + (Defines.toScreenValueHorzRemainder(nArray[3]) != 0 ? 1 : 0), nArray[9], nArray[10] == 0);
    }

    private void drawLine(Graphics graphics, int[] nArray) {
        int n = this.m_father.myPhysicalSprite.getX() + 0;
        int n2 = this.m_father.myPhysicalSprite.getY() + 0;
        int[] nArray2 = this.m_outlineColors[nArray[5]];
        if (-1 != nArray2[0]) {
            graphics.setColor(nArray2[0], nArray2[1], nArray2[2]);
            int[] nArray3 = this.m_lines[nArray[6]];
            for (int i = 0; i < nArray3.length - 2; i += 2) {
                graphics.drawLine(Defines.toScreenValueHorz(nArray3[i]) + n, Defines.toScreenValueVert(nArray3[i + 1]) + n2, Defines.toScreenValueHorz(nArray3[i + 2]) + n, Defines.toScreenValueVert(nArray3[i + 3]) + n2);
            }
        }
    }

    public void setRect(int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (!bl) {
            this.m_shapes[n][1] = n2;
            this.m_shapes[n][2] = n3;
            this.m_shapes[n][3] = n4;
            this.m_shapes[n][4] = n5;
        } else {
            int[] nArray = this.m_shapes[n];
            nArray[1] = nArray[1] + n2;
            int[] nArray2 = this.m_shapes[n];
            nArray2[2] = nArray2[2] + n3;
            int[] nArray3 = this.m_shapes[n];
            nArray3[3] = nArray3[3] + n4;
            int[] nArray4 = this.m_shapes[n];
            nArray4[4] = nArray4[4] + n5;
        }
    }

    public void setColor(int n, int n2, int n3, int n4, int n5) {
        switch (n2) {
            case 5: {
                int[] nArray = this.m_outlineColors[this.m_shapes[n][5]];
                break;
            }
            case 6: {
                int[] nArray = this.m_backgroundColors[this.m_shapes[n][6]];
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        nArray[0] = n3;
        nArray[1] = n4;
        nArray[2] = n5;
    }

    public void setFont(int n, GraphicFont graphicFont) {
        this.m_fonts[this.m_shapes[n][7]] = graphicFont;
    }

    public void setText(int n, String string) {
        this.m_strings[this.m_shapes[n][8]] = string;
    }

    public void setPoints(int n, int[] nArray) {
        this.m_lines[this.m_shapes[n][6]] = nArray;
    }

    public void initParams(int[][] nArray) {
        for (int i = 1; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; j += 2) {
                int[] nArray2;
                if (nArray[i][j] == 6) {
                    nArray2 = this.m_backgroundColors[this.m_shapes[nArray[0][i - 1]][nArray[i][j]]];
                    if (nArray[i][j + 1] == -1) {
                        nArray2[0] = -1;
                        continue;
                    }
                    nArray2[0] = nArray[i][j + 1];
                    nArray2[1] = nArray[i][j + 3];
                    nArray2[2] = nArray[i][j + 5];
                    j += 4;
                    continue;
                }
                if (nArray[i][j] == 5) {
                    nArray2 = this.m_outlineColors[this.m_shapes[nArray[0][i - 1]][nArray[i][j]]];
                    if (nArray[i][j + 1] == -1) {
                        nArray2[0] = -1;
                        continue;
                    }
                    nArray2[0] = nArray[i][j + 1];
                    nArray2[1] = nArray[i][j + 3];
                    nArray2[2] = nArray[i][j + 5];
                    j += 4;
                    continue;
                }
                this.m_shapes[nArray[0][i - 1]][nArray[i][j]] = nArray[i][j + 1];
            }
        }
    }

    public void setParam(int n, int n2, int n3, boolean bl) {
        if (!bl) {
            this.m_shapes[n][n2] = n3;
        } else {
            int[] nArray = this.m_shapes[n];
            int n4 = n2;
            nArray[n4] = nArray[n4] + n3;
        }
    }

    public void setRectangle(int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (this.isFirstCoordinateBackup) {
            this.isFirstCoordinateBackup = false;
            this.mRotationPointX = this.m_father.myPhysicalSprite.getLogicalWidth() / 2;
            this.mRotationPointY = this.m_father.myPhysicalSprite.getLogicalHeight() / 2;
            this.initOriginalShapes();
        }
        if (!bl) {
            this.m_originalShapes[n][1] = n2;
            this.m_originalShapes[n][2] = n3;
            this.m_originalShapes[n][3] = n4;
            this.m_originalShapes[n][4] = n5;
        } else {
            int[] nArray = this.m_originalShapes[n];
            nArray[1] = nArray[1] + n2;
            int[] nArray2 = this.m_originalShapes[n];
            nArray2[2] = nArray2[2] + n3;
            int[] nArray3 = this.m_originalShapes[n];
            nArray3[3] = nArray3[3] + n4;
            int[] nArray4 = this.m_originalShapes[n];
            nArray4[4] = nArray4[4] + n5;
        }
        if (this.myCurrentTransformation != 0) {
            int n6 = this.myCurrentTransformation;
            this.myCurrentTransformation = 0;
            this.setTransform(n6);
        }
        this.copyAndOverrideArray(this.m_originalShapes, this.m_shapes);
        this.copyAndOverrideArray(this.m_originalLines, this.m_lines);
    }

    public final boolean collidesWith(BasicSprite basicSprite) {
        return false;
    }

    public static boolean isOnSide(int n) {
        return n == 5 || n == 7 || n == 6 || n == 4;
    }

    public static int getNumRotations(int n) {
        if (n == 5 || n == 7) {
            return 1;
        }
        if (n == 3 || n == 1) {
            return 2;
        }
        if (n == 6 || n == 4) {
            return 3;
        }
        return 0;
    }

    public static boolean isMirrored(int n) {
        return n == 2 || n == 1 || n == 4 || n == 7;
    }

    public void setTransform(int n) {
        if (this.myCurrentTransformation == n) {
            return;
        }
        if (this.isFirstCoordinateBackup) {
            this.isFirstCoordinateBackup = false;
            this.mRotationPointX = this.m_father.myPhysicalSprite.getLogicalWidth() / 2;
            this.mRotationPointY = this.m_father.myPhysicalSprite.getLogicalHeight() / 2;
            this.initOriginalShapes();
        }
        this.copyAndOverrideArray(this.m_originalShapes, this.m_shapes);
        this.copyAndOverrideArray(this.m_originalLines, this.m_lines);
        if (n != 0) {
            for (int i = 0; i < this.m_shapes.length; ++i) {
                CanvasManager.transformShape(this.m_shapes[i], n, this.mRotationPointX, this.mRotationPointY, this.m_lines);
            }
        }
        this.myCurrentTransformation = n;
    }

    public static void transformShape(int[] nArray, int n, int n2, int n3, int[][] nArray2) {
        switch (n) {
            case 2: {
                CanvasManager.mirrorShape(nArray, n2, n3, nArray2);
                break;
            }
            case 1: {
                CanvasManager.mirrorShape(nArray, n2, n3, nArray2);
                CanvasManager.rotateShapeCounterclockwise(nArray, 180, n2, n3, nArray2);
                break;
            }
            case 4: {
                CanvasManager.mirrorShape(nArray, n2, n3, nArray2);
                CanvasManager.rotateShapeCounterclockwise(nArray, 270, n2, n3, nArray2);
                break;
            }
            case 7: {
                CanvasManager.mirrorShape(nArray, n2, n3, nArray2);
                CanvasManager.rotateShapeCounterclockwise(nArray, 90, n2, n3, nArray2);
                break;
            }
            case 3: {
                CanvasManager.rotateShapeCounterclockwise(nArray, 180, n2, n3, nArray2);
                break;
            }
            case 6: {
                CanvasManager.rotateShapeCounterclockwise(nArray, 270, n2, n3, nArray2);
                break;
            }
            case 5: {
                CanvasManager.rotateShapeCounterclockwise(nArray, 90, n2, n3, nArray2);
            }
        }
    }

    private static void rotateShapeCounterclockwise(int[] nArray, int n, int n2, int n3, int[][] nArray2) {
        int[] nArray3 = new int[]{nArray[1], nArray[2], nArray[1] + nArray[3], nArray[2], nArray[1], nArray[2] + nArray[4], nArray[1] + nArray[3], nArray[2] + nArray[4]};
        CanvasManager.rotateVertices(nArray3, n, n2, n3);
        if (nArray[0] == 3) {
            CanvasManager.rotateVertices(nArray2[nArray[6]], n, n2, n3);
        }
        nArray[1] = Math.min(Math.min(nArray3[0], nArray3[2]), nArray3[4]);
        nArray[2] = Math.min(Math.min(nArray3[1], nArray3[3]), nArray3[5]);
        nArray[3] = Math.max(Math.max(nArray3[0], nArray3[2]), nArray3[4]) - nArray[1];
        nArray[4] = Math.max(Math.max(nArray3[1], nArray3[3]), nArray3[5]) - nArray[2];
    }

    private static void rotateVertices(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n % 180 == 0) {
            n5 = n2;
            n4 = n3;
        } else {
            n5 = n3;
            n4 = n2;
        }
        for (int i = 0; i < nArray.length; i += 2) {
            int n6 = i;
            nArray[n6] = nArray[n6] - n2;
            int n7 = i + 1;
            nArray[n7] = nArray[n7] - n3;
            int n8 = SuperMath.rotateAndGetX(nArray[i], nArray[i + 1], n);
            int n9 = SuperMath.rotateAndGetY(nArray[i], nArray[i + 1], n);
            nArray[i] = n8 + n5;
            nArray[i + 1] = n9 + n4;
        }
    }

    private static void mirrorShape(int[] nArray, int n, int n2, int[][] nArray2) {
        nArray[1] = n - (nArray[1] + nArray[3]) + n;
        if (nArray[0] == 3) {
            int[] nArray3 = nArray2[nArray[6]];
            for (int i = 0; i < nArray3.length; i += 2) {
                nArray3[i] = n - nArray3[i] + n;
            }
        }
    }

    private void scaleShape(int[] nArray, int n, int n2) {
        nArray[1] = nArray[1] * n / n2;
        nArray[2] = nArray[2] * n / n2;
        nArray[3] = nArray[3] * n / n2;
        nArray[4] = nArray[4] * n / n2;
    }

    private void initOriginalShapes() {
        int n;
        int n2;
        this.m_originalShapes = new int[this.m_shapes.length][];
        for (n2 = 0; n2 < this.m_shapes.length; ++n2) {
            this.m_originalShapes[n2] = new int[this.m_shapes[n2].length];
            for (n = 0; n < this.m_shapes[n2].length; ++n) {
                this.m_originalShapes[n2][n] = this.m_shapes[n2][n];
            }
        }
        this.m_originalLines = new int[this.m_lines.length][];
        for (n2 = 0; n2 < this.m_lines.length; ++n2) {
            this.m_originalLines[n2] = new int[this.m_lines[n2].length];
            for (n = 0; n < this.m_lines[n2].length; ++n) {
                this.m_originalLines[n2][n] = this.m_lines[n2][n];
            }
        }
    }

    private void copyAndOverrideArray(int[][] nArray, int[][] nArray2) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i].length;
            for (int j = 0; j < n2; ++j) {
                nArray2[i][j] = nArray[i][j];
            }
        }
    }
}

