/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public final class Configuration {
    private static boolean configurationAccessed = false;
    private static int myHighscore = 0;
    private static int mySpeed = 5;
    private static final int HIGHSCORE_RECORD = 1;
    private static final int SOUND_RECORD = 2;
    private static final int MUSIC_RECORD = 3;
    private static final int SPEED_RECORD = 4;

    public static boolean isConfigurationExists() {
        boolean bl = true;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"configuration", (boolean)false);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            System.out.println("Received RecordStoreNotFoundException, marking as no config.");
            bl = false;
        }
        catch (RecordStoreFullException recordStoreFullException) {
            System.out.println("Received RecordStoreFullException exception, this should never happen");
            bl = false;
            recordStoreFullException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println("Received RecordStoreException, this should never happen");
            bl = false;
            recordStoreException.printStackTrace();
        }
        return bl;
    }

    private static void createConfiguration() throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException, IOException {
        RecordStore recordStore = RecordStore.openRecordStore((String)"configuration", (boolean)true);
        if (recordStore.getNumRecords() > 0) {
            throw new RecordStoreException();
        }
        byte[] byArray = Configuration.intToByteArray(0);
        recordStore.addRecord(byArray, 0, byArray.length);
        byArray = Configuration.booleanToByteArray(true);
        recordStore.addRecord(byArray, 0, byArray.length);
        recordStore.addRecord(byArray, 0, byArray.length);
        int n = 5;
        byArray = Configuration.intToByteArray(n);
        recordStore.addRecord(byArray, 0, byArray.length);
    }

    public static void loadConfiguration() throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException, IOException {
        if (!Configuration.isConfigurationExists()) {
            Configuration.createConfiguration();
        }
        if (configurationAccessed) {
            return;
        }
        RecordStore recordStore = RecordStore.openRecordStore((String)"configuration", (boolean)false);
        Configuration.setHighScore(Configuration.byteArrayToInt(recordStore.getRecord(1)));
        Configuration.setSpeed(Configuration.byteArrayToInt(recordStore.getRecord(4)));
        recordStore.closeRecordStore();
        configurationAccessed = true;
    }

    public static void deleteConfiguration() throws RecordStoreNotFoundException, RecordStoreException {
        RecordStore.deleteRecordStore((String)"configuration");
    }

    public static void storeConfiguration() throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException, IOException {
        RecordStore recordStore = RecordStore.openRecordStore((String)"configuration", (boolean)true);
        byte[] byArray = Configuration.intToByteArray(myHighscore);
        recordStore.setRecord(1, byArray, 0, byArray.length);
        byArray = Configuration.intToByteArray(mySpeed);
        recordStore.setRecord(4, byArray, 0, byArray.length);
        recordStore.closeRecordStore();
    }

    public static int getHighScore() {
        return myHighscore;
    }

    public static void setHighScore(int n) {
        myHighscore = n;
    }

    public static int getSpeed() {
        return mySpeed;
    }

    public static void setSpeed(int n) {
        mySpeed = n;
    }

    public static boolean isConfigurationAccessed() {
        return configurationAccessed;
    }

    private static byte[] intToByteArray(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(n);
        return byteArrayOutputStream.toByteArray();
    }

    private static int byteArrayToInt(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        return dataInputStream.readInt();
    }

    private static byte[] booleanToByteArray(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeBoolean(bl);
        return byteArrayOutputStream.toByteArray();
    }

    private static boolean byteArrayToBoolean(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        return dataInputStream.readBoolean();
    }
}

