/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.tools.IntHashtable;
import Snakedelia.tools.TextUtils;
import Snakedelia.tools.Variables;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GraphicFont {
    private Image m_image;
    private IntHashtable m_lettersDescriptor;
    private int mySpace;
    private int myTab;
    private int myHeight;
    public static final int menuColor = -10496;
    public static GraphicFont David17_46_25ffffffffBold;
    public static GraphicFont Comic_32_Sans_32_MS36ffffffffRegular;
    public static GraphicFont Comic_32_Sans_32_MS9_46_75OrangeBold;
    public static GraphicFont Comic_32_Sans_32_MS9_46_75DarkOrangeBold;
    public static GraphicFont Comic_32_Sans_32_MS9_46_75YellowBold;
    public static GraphicFont Comic_32_Sans_32_MS9_46_75GoldBold;
    public static GraphicFont Comic_32_Sans_32_MS11_46_25GoldBold;
    public static GraphicFont Comic_32_Sans_32_MS12ff0028ffRegular;
    public static GraphicFont Comic_32_Sans_32_MS12GoldRegular;
    private Hashtable mySplitTextCache = new Hashtable();
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int WRAP = 0;
    public static final int NO_WRAP = 1;
    public static final int CONST_LETTER_POSITION = 0;
    public static final int CONST_LETTER_WIDTH = 1;
    public static final int CONST_LETTER_OFFSET = 2;
    public static final int CONST_LETTER_SPACE = 3;

    public static void initializeFonts() {
        IntHashtable intHashtable = new IntHashtable();
        GraphicFont.initializeFontHashtable(intHashtable, Variables.__arraydataInt2D[6]);
        David17_46_25ffffffffBold = new GraphicFont("/Fonts/David17_46_25ffffffffBold.png", intHashtable, 5, 68, 24);
        IntHashtable intHashtable2 = new IntHashtable();
        GraphicFont.initializeFontHashtable(intHashtable2, Variables.__arraydataInt2D[5]);
        Comic_32_Sans_32_MS36ffffffffRegular = new GraphicFont("/Fonts/Comic_32_Sans_32_MS36ffffffffRegular.png", intHashtable2, 15, 159, 68);
        IntHashtable intHashtable3 = new IntHashtable();
        GraphicFont.initializeFontHashtable(intHashtable3, Variables.__arraydataInt2D[4]);
        Comic_32_Sans_32_MS9_46_75OrangeBold = new GraphicFont("/Fonts/Comic_32_Sans_32_MS9_46_75OrangeBold.png", intHashtable3, 6, 48, 19);
        IntHashtable intHashtable4 = new IntHashtable();
        GraphicFont.initializeFontHashtable(intHashtable4, Variables.__arraydataInt2D[3]);
        Comic_32_Sans_32_MS9_46_75DarkOrangeBold = new GraphicFont("/Fonts/Comic_32_Sans_32_MS9_46_75DarkOrangeBold.png", intHashtable4, 6, 48, 19);
        IntHashtable intHashtable5 = new IntHashtable();
        GraphicFont.initializeFontHashtable(intHashtable5, Variables.__arraydataInt2D[2]);
        Comic_32_Sans_32_MS9_46_75YellowBold = new GraphicFont("/Fonts/Comic_32_Sans_32_MS9_46_75YellowBold.png", intHashtable5, 6, 48, 19);
        IntHashtable intHashtable6 = new IntHashtable();
        GraphicFont.initializeFontHashtable(intHashtable6, Variables.__arraydataInt2D[2]);
        Comic_32_Sans_32_MS9_46_75GoldBold = new GraphicFont("/Fonts/Comic_32_Sans_32_MS9_46_75GoldBold.png", intHashtable6, 6, 48, 19);
        IntHashtable intHashtable7 = new IntHashtable();
        GraphicFont.initializeFontHashtable(intHashtable7, Variables.__arraydataInt2D[1]);
        Comic_32_Sans_32_MS11_46_25GoldBold = new GraphicFont("/Fonts/Comic_32_Sans_32_MS11_46_25GoldBold.png", intHashtable7, 7, 55, 22);
        IntHashtable intHashtable8 = new IntHashtable();
        GraphicFont.initializeFontHashtable(intHashtable8, Variables.__arraydataInt2D[0]);
        Comic_32_Sans_32_MS12ff0028ffRegular = new GraphicFont("/Fonts/Comic_32_Sans_32_MS12ff0028ffRegular.png", intHashtable8, 5, 55, 23);
        IntHashtable intHashtable9 = new IntHashtable();
        GraphicFont.initializeFontHashtable(intHashtable9, Variables.__arraydataInt2D[0]);
        Comic_32_Sans_32_MS12GoldRegular = new GraphicFont("/Fonts/Comic_32_Sans_32_MS12GoldRegular.png", intHashtable9, 5, 55, 23);
    }

    private GraphicFont(String string, IntHashtable intHashtable, int n, int n2, int n3) {
        try {
            this.m_image = Image.createImage((String)string);
        }
        catch (IOException iOException) {
            System.out.println("Could not load image " + string);
            iOException.printStackTrace();
            throw new RuntimeException(iOException.toString() + "could not load image - " + string);
        }
        this.m_lettersDescriptor = intHashtable;
        this.mySpace = n;
        this.myTab = n2;
        this.myHeight = n3;
    }

    public void draw(Graphics graphics, String string, int n, int n2, int n3) {
        if (string.length() == 0) {
            return;
        }
        if ((n3 & 4 & (n3 & 8) & (n3 & 1)) != 0) {
            throw new IllegalArgumentException("Ilegal anchor combination");
        }
        if ((n3 & 0x10 & (n3 & 0x20) & (n3 & 2)) != 0) {
            throw new IllegalArgumentException("Ilegal anchor combination");
        }
        if ((n3 & 0x10 | n3 & 0x20 | n3 & 2) == 0) {
            n3 |= 0x10;
        }
        if ((n3 & 8) != 0) {
            n -= this.stringWidth(string);
        } else if ((n3 & 1) != 0) {
            n -= this.stringWidth(string) / 2;
        }
        if ((n3 & 0x20) != 0) {
            n2 -= this.getHeight();
        } else if ((n3 & 2) != 0) {
            n2 -= this.getHeight() / 2;
        }
        this.draw(graphics, string, n, n2);
    }

    public void draw(Graphics graphics, String string, int n, int n2) {
        if (string.length() == 0) {
            return;
        }
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipHeight();
        int n6 = graphics.getClipWidth();
        n2 += 0;
        int n7 = n += 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int[] nArray = (int[])this.m_lettersDescriptor.get(c);
            if (null != nArray) {
                int n8 = n7 + nArray[2];
                graphics.clipRect(n8, n2, nArray[1], this.getHeight() + 1);
                graphics.drawImage(this.m_image, n8 - nArray[0], n2, 20);
                n7 += nArray[3];
                graphics.setClip(n3, n4, n6, n5);
                continue;
            }
            n7 += this.isSpace(c);
        }
    }

    public void draw(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, boolean bl) {
        n3 -= 2 * this.mySpace;
        int n6 = n += this.mySpace;
        int n7 = n2;
        if (string.length() == 0) {
            return;
        }
        if (n5 != 0 && n5 != 1 && n5 != 2) {
            throw new IllegalArgumentException("Ilegal alignment specification");
        }
        Vector vector = this.getWrappedLines(string, n3, bl);
        for (int i = 0; i < vector.size(); i += 2) {
            String string2 = (String)vector.elementAt(i);
            n7 = n2 + i / 2 * this.getHeight();
            if (n5 == 2) {
                n6 = n + Math.abs(n3 - (Integer)vector.elementAt(i + 1));
            } else if (n5 == 1) {
                n6 = n + Math.abs(n3 - (Integer)vector.elementAt(i + 1)) / 2;
            }
            this.draw(graphics, (String)vector.elementAt(i), n6, n7);
        }
    }

    public int getLineGap() {
        return 0;
    }

    private Vector getWrappedLines(String string, int n, boolean bl) {
        Vector<Object> vector;
        Cloneable cloneable;
        Integer n2 = new Integer(bl ? ~n : n);
        if (this.mySplitTextCache.containsKey(string) && ((Hashtable)(cloneable = (Hashtable)this.mySplitTextCache.get(string))).containsKey(n2)) {
            return (Vector)((Hashtable)cloneable).get(n2);
        }
        cloneable = TextUtils.Split(string, new char[]{'\n'});
        if (bl) {
            vector = new Vector<Object>();
            for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                this.wrapWords((String)((Vector)cloneable).elementAt(i), n, vector);
            }
        } else {
            vector = new Vector();
            for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                String string2 = (String)((Vector)cloneable).elementAt(i);
                vector.addElement(string2);
                vector.addElement(new Integer(this.stringWidth(string2)));
            }
        }
        if (!this.mySplitTextCache.containsKey(string)) {
            this.mySplitTextCache.put(string, new Hashtable());
        }
        ((Hashtable)this.mySplitTextCache.get(string)).put(n2, vector);
        return vector;
    }

    private void wrapWords(String string, int n, Vector vector) {
        int n2 = 0;
        while (n2 <= string.length()) {
            String string2;
            int n3 = this.FindEOLPosition(string, n, n2);
            if (n3 == string.length()) {
                string2 = string.substring(n2, n3);
                vector.addElement(string2);
                vector.addElement(new Integer(this.stringWidth(string2)));
                break;
            }
            if (n3 == -1) {
                string2 = string.substring(n2);
                vector.addElement(string2);
                vector.addElement(new Integer(this.stringWidth(string2)));
                break;
            }
            if (string.charAt(n3) != ' ' && string.charAt(n3) != '\t') {
                string2 = string.substring(n2, n3) + "-";
                vector.addElement(string2);
                vector.addElement(new Integer(this.stringWidth(string2)));
                n2 = n3;
                continue;
            }
            string2 = string.substring(n2, n3);
            vector.addElement(string2);
            vector.addElement(new Integer(this.stringWidth(string2)));
            n2 = n3 + 1;
        }
    }

    private int FindEOLPosition(String string, int n, int n2) {
        int n3 = -1;
        int n4 = n2;
        while (this.stringWidth(string.substring(n2, n4)) < n) {
            n3 = n4;
            if (n4 == string.length()) break;
            if ((n4 = TextUtils.findFirstMatch(string, n4 + 1, new char[]{' ', '\t'})) != -1) continue;
            n4 = string.length();
        }
        if (n3 == n2) {
            n4 = n3;
            while (n4 <= string.length() && this.stringWidth(string.substring(n2, n4) + "-") < n) {
                n3 = n4++;
            }
            if (n3 == n2) {
                return -1;
            }
        }
        return n3;
    }

    public int getHeight() {
        return this.myHeight;
    }

    public int stringWidth(String string) {
        return this.stringWidth(string, 0);
    }

    public int stringWidth(String string, int n, int n2) {
        int n3 = 0;
        Vector vector = this.getWrappedLines(string, n2, true);
        for (int i = 1; i < vector.size(); i += 2) {
            int n4 = (Integer)vector.elementAt(i);
            if (n4 <= n3) continue;
            n3 = n4;
        }
        return n3;
    }

    public int stringWidth(String string, int n) {
        int n2 = 0;
        int n3 = string.length() - n;
        if (n3 == 0) {
            return 0;
        }
        int[] nArray = (int[])this.m_lettersDescriptor.get(string.charAt(n));
        if (null != nArray) {
            n2 += nArray[3];
            n2 += nArray[2];
        } else {
            n2 += this.isSpace(string.charAt(n));
        }
        if (n3 > 1) {
            int[] nArray2 = (int[])this.m_lettersDescriptor.get(string.charAt(n + n3 - 1));
            if (null != nArray2) {
                n2 += nArray2[1];
                n2 += nArray2[2];
            } else {
                n2 += this.isSpace(string.charAt(n + n3 - 1));
            }
        }
        for (int i = n + 1; i < n + n3 - 1; ++i) {
            char c = string.charAt(i);
            int[] nArray3 = (int[])this.m_lettersDescriptor.get(c);
            if (null != nArray3) {
                n2 += nArray3[3];
                continue;
            }
            n2 += this.isSpace(c);
        }
        return n2;
    }

    public int stringHeight(String string, int n, int n2) {
        Vector vector = this.getWrappedLines(string, n2 -= 2 * this.mySpace, true);
        return vector.size() / 2 * (this.getHeight() + this.getLineGap()) - this.getLineGap();
    }

    private int isSpace(char c) {
        switch (c) {
            case ' ': {
                return this.mySpace;
            }
            case '\t': {
                return this.myTab;
            }
        }
        return 0;
    }

    private static void initializeFontHashtable(IntHashtable intHashtable, int[][] nArray) {
        for (int i = 0; i < nArray[0].length; ++i) {
            intHashtable.put(nArray[0][i], nArray[i + 1]);
        }
    }

    public int getSpace() {
        return this.mySpace;
    }
}

