/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.BasicCanvas;
import Snakedelia.GameManager;
import Snakedelia.tools.Defines;
import Snakedelia.tools.PhysicalSprite;
import Snakedelia.tools.SuperMath;
import java.util.Random;

public final class Indicators {
    private static long[] randomSlots = new long[10];
    private static Random mRandom = null;

    public static int genRandomPrecision(int n, long l, long l2) {
        Indicators.randomSlots[n] = Indicators.getRandomInteger(l - (long)(Defines.PRECISION / 2), l2 + (long)(Defines.PRECISION / 2));
        return 0;
    }

    public static int genRandom(int n, long l, long l2) {
        Indicators.randomSlots[n] = Indicators.getRandomInteger(l, l2);
        return 0;
    }

    public static int genRandomPrecision(int n, long l) {
        Indicators.randomSlots[n] = Indicators.getRandomInteger(-Defines.PRECISION / 2, l + (long)(Defines.PRECISION / 2));
        return 0;
    }

    public static int genRandom(int n, long l) {
        return Indicators.genRandom(n, 0L, l);
    }

    public static long getRandomSlot(int n) {
        return randomSlots[n];
    }

    public static int getRandomSlotRounded(int n) {
        return Defines.unPrecise(randomSlots[n]) * Defines.PRECISION;
    }

    public static long getRandomInteger(long l, long l2) {
        if (l == l2) {
            return l;
        }
        if (mRandom == null) {
            mRandom = new Random();
        }
        return (long)Math.abs(mRandom.nextInt()) % (l2 - l) + l;
    }

    public static boolean getRandomBoolean() {
        if (mRandom == null) {
            mRandom = new Random();
        }
        return Math.abs(mRandom.nextInt()) % 2 == 0;
    }

    public static int getTotalTimeElapsed(BasicCanvas basicCanvas) {
        return basicCanvas.getTotalTimeElapsed() * Defines.PRECISION;
    }

    public static int getRoomWidth(BasicCanvas basicCanvas) {
        return basicCanvas.getCurrentRoomLogicalWidth();
    }

    public static int getRoomHeight(BasicCanvas basicCanvas) {
        return basicCanvas.getCurrentRoomLogicalHeight();
    }

    public static int getSpritePositionInPath(GameManager gameManager, int n) {
        return -1;
    }

    public static int getSpritePositionX(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getLogicalX();
    }

    public static int getSpritePositionY(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getLogicalY();
    }

    public static int getSpritePositionZ(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getLogicalZ();
    }

    public static int getSpritePositionXOnScreen(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getLogicalXOnScreen();
    }

    public static int getSpritePositionYOnScreen(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getLogicalYOnScreen();
    }

    public static int getSpriteAccelerationY(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getAccelerationY();
    }

    public static int getSpriteAccelerationX(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getAccelerationX();
    }

    public static int getSpriteVelocityX(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getVelocityX();
    }

    public static int getSpriteVelocityY(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getVelocityY();
    }

    public static int getWorldVelocityX(GameManager gameManager) {
        return gameManager.getWorldVelocityX();
    }

    public static int getWorldVelocityY(GameManager gameManager) {
        return gameManager.getWorldVelocityY();
    }

    public static int getBackgroundVelocityX(GameManager gameManager) {
        if (gameManager.getBackground() != null) {
            return gameManager.getBackground().getVelocityX();
        }
        return 0;
    }

    public static int getBackgroundVelocityY(GameManager gameManager) {
        if (gameManager.getBackground() != null) {
            return gameManager.getBackground().getVelocityY();
        }
        return 0;
    }

    public static int getSpriteWidth(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getLogicalWidth();
    }

    public static int getSpriteHeight(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getLogicalHeight();
    }

    static void print(String string, int n) {
        System.out.print(string);
        System.out.print(":");
        System.out.println(n);
    }

    static void print(String string, long l) {
        System.out.print(string);
        System.out.print(":");
        System.out.println(l);
    }

    public static long getSpriteDistance(GameManager gameManager, int n, int n2) {
        PhysicalSprite physicalSprite = gameManager.getSprite((int)n).myPhysicalSprite;
        PhysicalSprite physicalSprite2 = gameManager.getSprite((int)n2).myPhysicalSprite;
        int n3 = physicalSprite.getLogicalX();
        int n4 = physicalSprite2.getLogicalX();
        int n5 = physicalSprite.getLogicalY();
        int n6 = physicalSprite2.getLogicalY();
        int n7 = n4 - n3;
        int n8 = n6 - n5;
        long l = (long)n7 * (long)n7;
        long l2 = (long)n8 * (long)n8;
        return SuperMath.lsqrt(l + l2);
    }

    public static int getSpriteFrameSequenceLength(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getWrappedSprite().getFrameSequenceLength();
    }

    public static int getSpriteGetCurrentFrame(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getWrappedSprite().getFrame();
    }

    public static int getSpriteFrameSequenceIndex(GameManager gameManager, int n) {
        return gameManager.getSprite((int)n).myPhysicalSprite.getAnimationManager().getFrameSequence();
    }

    public static int getSpriteGroup(GameManager gameManager, int n) {
        return gameManager.getSprite(n).getGroups()[0];
    }

    public static int getNumSpritesInGroup(GameManager gameManager, int n) {
        return gameManager.getGroupElements((int)n).ItemCount;
    }

    public static boolean getSpriteIsAnimatable(GameManager gameManager, int n) {
        return gameManager.getSprite(n).isAnimatable();
    }

    public static boolean getSpriteIsVisible(GameManager gameManager, int n) {
        if (gameManager.getSprite((int)n).myPhysicalSprite == null) {
            return false;
        }
        return gameManager.getSprite((int)n).myPhysicalSprite.isVisible();
    }

    public static int getCanvasWidth(BasicCanvas basicCanvas) {
        basicCanvas.getClass();
        return 691200;
    }

    public static int getCanvasHeight(BasicCanvas basicCanvas) {
        basicCanvas.getClass();
        return 921600;
    }

    public static int getManagerNumDrawnItems(GameManager gameManager) {
        return gameManager.getSize();
    }

    public static boolean getCanvasIsDoubleBuffered(BasicCanvas basicCanvas) {
        return basicCanvas.isDoubleBuffered();
    }

    public static boolean getCanvasIsShown(BasicCanvas basicCanvas) {
        return basicCanvas.isShown();
    }

    public static int getCurrentLevel(BasicCanvas basicCanvas) {
        return basicCanvas.getCurrentLevel();
    }

    public static int getLives() {
        return BasicCanvas.getLives();
    }

    public static int getScore() {
        return BasicCanvas.getScore();
    }
}

