/*
 * Decompiled with CFR 0.152.
 */
package Snakedelia.tools;

import Snakedelia.BasicCanvas;
import Snakedelia.GameManager;
import Snakedelia.tools.Defines;
import Snakedelia.tools.SuperMath;

public abstract class MovableObject {
    private int myLogicalPositionX = 0;
    private int myLogicalPositionY = 0;
    private int myLogicalPositionZ = 0;
    private int myLogicalWidth;
    private int myLogicalHeight;
    private boolean myIsStatic;
    private int myLogicalVelocityX = 0;
    private int myLogicalVelocityY = 0;
    private long myLastMovedTimeX;
    private long myLastMovedTimeY;
    private long myLastAccelerationUpdatedTimeX;
    private long myLastAccelerationUpdatedTimeY;
    private int myAccelerationX;
    private int myAccelerationY;
    protected int myGlitchCorrectionX = 0;
    protected int myGlitchCorrectionY = 0;

    public MovableObject(boolean bl) {
        this.setStatic(bl);
    }

    protected final void initWidthHeight(int n, int n2) {
        this.myLogicalHeight = n2;
        this.myLogicalWidth = n;
    }

    public final int getVelocityX() {
        return this.myLogicalVelocityX;
    }

    public final int getVelocityY() {
        return this.myLogicalVelocityY;
    }

    public final void setVelocityX(int n) {
        this.myLogicalVelocityX = n;
    }

    public final void setVelocityY(int n) {
        this.myLogicalVelocityY = n;
    }

    public final void increaseSpeed(int n) {
        long l = 0L;
        long l2 = 0L;
        if (this.getVelocityX() == 0) {
            if (this.getVelocityY() == 0) {
                return;
            }
            l2 = this.getVelocityY() > 0 ? (long)n : (long)(-n);
        } else if (this.getVelocityY() == 0) {
            if (this.getVelocityX() == 0) {
                return;
            }
            l = this.getVelocityX() > 0 ? (long)n : (long)(-n);
        } else {
            long l3 = (long)this.getVelocityX() * (long)Defines.PRECISION / (long)this.getVelocityY();
            if (l3 < 0L) {
                l3 *= -1L;
            }
            l = l3 * (long)Defines.PRECISION / SuperMath.lsqrt(l3 * l3 + (long)(Defines.PRECISION * Defines.PRECISION));
            l2 = l * (long)Defines.PRECISION / l3;
        }
        if (this.getVelocityX() > 0) {
            this.myLogicalVelocityX = (int)((long)this.getVelocityX() + l * (long)n / (long)Defines.PRECISION);
        } else if (this.getVelocityX() < 0) {
            this.myLogicalVelocityX = (int)((long)this.getVelocityX() - l * (long)n / (long)Defines.PRECISION);
        }
        if (this.getVelocityY() > 0) {
            this.myLogicalVelocityY = (int)((long)this.getVelocityY() + l2 * (long)n / (long)Defines.PRECISION);
        } else if (this.getVelocityY() < 0) {
            this.myLogicalVelocityY = (int)((long)this.getVelocityY() - l2 * (long)n / (long)Defines.PRECISION);
        }
    }

    public final void update(long l) {
        this.updatePosition(l);
    }

    private final long timeToGetToPosition(long l, long l2, long l3) {
        long l4;
        if (l == 0L) {
            return 0L;
        }
        if (l3 == 0L) {
            if (l2 == 0L) {
                return -1L;
            }
            return l * 1000L / l2;
        }
        long l5 = l2 * l2 + 2L * l3 * l;
        if (l5 <= 0L) {
            if (l5 == 0L) {
                long l6 = -l2 * 1000L / l3;
                if (l6 < 0L) {
                    return -1L;
                }
                return l6;
            }
            return -1L;
        }
        long l7 = (-l2 - (l5 = SuperMath.lsqrt(l5))) * 1000L / l3;
        if (l7 < (l4 = (-l2 + l5) * 1000L / l3) && l7 > 0L || l4 < 0L) {
            l4 = l7;
        }
        if (l4 < 0L) {
            return -1L;
        }
        return l4;
    }

    private final void internalUpdatePosition(long l) {
        int n;
        int n2;
        long l2 = 0L;
        long l3 = 0L;
        if (this.getAccelerationY() != 0) {
            this.myLastAccelerationUpdatedTimeY += l;
            n2 = (int)(this.myLastAccelerationUpdatedTimeY * (long)this.myAccelerationY);
            n = this.getVelocityY() + n2 / 1000;
            n2 = (int)((long)this.getVelocityY() * this.myLastAccelerationUpdatedTimeY + (long)this.getAccelerationY() * this.myLastAccelerationUpdatedTimeY * this.myLastAccelerationUpdatedTimeY / 1000L / 2L);
            l3 = n2 / 1000;
            this.myLogicalVelocityY = n;
            this.myLastAccelerationUpdatedTimeY = 0L;
        } else if (this.getVelocityY() != 0) {
            this.myLastMovedTimeY += l;
            n2 = (int)(this.myLastMovedTimeY * (long)this.getVelocityY());
            l3 = n2 / 1000;
            this.myLastMovedTimeY = n2 % 1000 / this.getVelocityY();
        } else {
            this.myLastMovedTimeY = 0L;
        }
        if (this.getAccelerationX() != 0) {
            this.myLastAccelerationUpdatedTimeX += l;
            n2 = (int)(this.myLastAccelerationUpdatedTimeX * (long)this.myAccelerationX);
            n = this.getVelocityX() + n2 / 1000;
            n2 = (int)((long)this.getVelocityX() * this.myLastAccelerationUpdatedTimeX + (long)this.getAccelerationX() * this.myLastAccelerationUpdatedTimeX * this.myLastAccelerationUpdatedTimeX / 1000L / 2L);
            l2 = n2 / 1000;
            this.myLogicalVelocityX = n;
            this.myLastAccelerationUpdatedTimeX = 0L;
        } else if (this.getVelocityX() != 0) {
            this.myLastMovedTimeX += l;
            n2 = (int)(this.myLastMovedTimeX * (long)this.getVelocityX());
            l2 = n2 / 1000;
            this.myLastMovedTimeX = n2 % 1000 / this.getVelocityX();
        } else {
            this.myLastMovedTimeX = 0L;
        }
        if (l2 != 0L || l3 != 0L) {
            this.movePrecise((int)l2, (int)l3);
        }
    }

    private final void handlePathUpdate(long l) {
        this.internalUpdatePosition(l);
    }

    protected final void setGlitchCorrection(int n, int n2) {
        this.myGlitchCorrectionX = n;
        this.myGlitchCorrectionY = n2;
    }

    public void snapToPhysicalGrid() {
        long l = this.getLogicalX();
        BasicCanvas.getInstance().getClass();
        int n = 240;
        BasicCanvas.getInstance().getClass();
        int n2 = 691200;
        l = l * (long)n / (long)n2 * (long)Defines.PRECISION;
        this.myGlitchCorrectionX = (int)(l / (long)n * (long)n2 / (long)Defines.PRECISION - (long)this.getLogicalX());
        long l2 = this.getLogicalY();
        BasicCanvas.getInstance().getClass();
        int n3 = 320;
        BasicCanvas.getInstance().getClass();
        int n4 = 921600;
        l2 = l2 * (long)n3 / (long)n4 * (long)Defines.PRECISION;
        this.myGlitchCorrectionY = (int)(l2 / (long)n3 * (long)n4 / (long)Defines.PRECISION - (long)this.getLogicalY());
    }

    public final void updatePosition(long l) {
        this.internalUpdatePosition(l);
    }

    protected final void setStatic(boolean bl) {
        this.myIsStatic = bl;
    }

    public final boolean isStatic() {
        return this.myIsStatic;
    }

    public final int getLogicalX() {
        if (!this.myIsStatic) {
            return this.myLogicalPositionX;
        }
        return this.myLogicalPositionX + GameManager.WorldPositionX;
    }

    public final int getLogicalY() {
        if (!this.myIsStatic) {
            return this.myLogicalPositionY;
        }
        return this.myLogicalPositionY + GameManager.WorldPositionY;
    }

    public final int getLogicalZ() {
        return this.myLogicalPositionZ;
    }

    protected final void setLogicalX(int n) {
        this.myLogicalPositionX = !this.myIsStatic ? n : n - GameManager.WorldPositionX;
    }

    protected final void setLogicalY(int n) {
        this.myLogicalPositionY = !this.myIsStatic ? n : n - GameManager.WorldPositionY;
    }

    protected void setLogicalZ(int n) {
        this.myLogicalPositionZ = n;
    }

    public final int getLogicalXOnScreen() {
        if (!this.myIsStatic) {
            return this.myLogicalPositionX - GameManager.WorldPositionX;
        }
        return this.myLogicalPositionX;
    }

    public final int getLogicalYOnScreen() {
        if (!this.myIsStatic) {
            return this.myLogicalPositionY - GameManager.WorldPositionY;
        }
        return this.myLogicalPositionY;
    }

    public final int getLogicalWidth() {
        return this.myLogicalWidth;
    }

    public final int getLogicalHeight() {
        return this.myLogicalHeight;
    }

    public final void setAccelerationX(int n) {
        this.myAccelerationX = n;
    }

    public final void setAccelerationY(int n) {
        this.myAccelerationY = n;
    }

    public final int getAccelerationX() {
        return this.myAccelerationX;
    }

    public final int getAccelerationY() {
        return this.myAccelerationY;
    }

    public abstract void setPositionPrecise(int var1, int var2);

    public abstract void movePrecise(int var1, int var2);

    public abstract int getX();

    public abstract int getY();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract boolean isVisible();
}

